#include "mibload.h"
#include "../common/drawer.h"
#include "../common/ui.h"
#include "../common/lang.h"
#include "gvui.h"
#include "interface/MainPanel.mib"

extern Display *dpy;
extern int gwidth;
extern int gheight;
extern UIState uistate;
extern Pixmap geomicon;

/* private methods and variables */
/*****************************************************************************/

static void hide_main(Widget, XtPointer, XmAnyCallbackStruct *);
static void select_object(Widget, XtPointer, XmListCallbackStruct *);
static void select_module(Widget, XtPointer, XmListCallbackStruct *);
static void file_menu_callbacks(Widget, char *);
static void edit_menu_callbacks(Widget, char *);
static void inspect_menu_callbacks(Widget, char *);
static void motion_menu_callbacks(Widget, char *);
static void choose_space(Widget, int);
static void BuildBrowserMenu();
static int id2menuindex(int);

static int *menuindex = NULL;
static int menucount = 0;
static int currentspace = 0, loaded = 0;
static int pos_later = 0, posx = 0, posy = 0;
static char geometry[40];
static Widget shell,
	      ObjectList,
	      EmodList,
	      MotionToggle[3],
	      SpaceRadio[3];
static Geom *clipboard = NULL;

static MenuItem file_menu[] = {
  { "New Camera", &xmPushButtonGadgetClass, 'N', "Ctrl<Key>N","[v+]",
        file_menu_callbacks, "N", (MenuItem *)NULL},
  { "Open            ", &xmPushButtonGadgetClass, 'O', "Ctrl<Key>O","[ < ]",
        file_menu_callbacks, "O", (MenuItem *)NULL},
  { "Save               ", &xmPushButtonGadgetClass, 'S', "Ctrl<Key>S","[ > ]",
        file_menu_callbacks, "S", (MenuItem *)NULL},
  { "_sepr", &xmSeparatorGadgetClass, (char)NULL, (char*)NULL, (char*)NULL,
        (void (*)())NULL, (XtPointer)NULL, (MenuItem *)NULL },
  { "Exit                   ", &xmPushButtonGadgetClass, 'E', "Ctrl<Key>X","[ Q ]",
        file_menu_callbacks, "X", (MenuItem *)NULL},
  NULL,
};

static MenuItem edit_menu[] = {
  { "Copy", &xmPushButtonGadgetClass, 'C', NULL, NULL,
        edit_menu_callbacks, "C", (MenuItem *)NULL},
  { "Delete", &xmPushButtonGadgetClass, 'D', "Ctrl<Key>D", "[dd]",
        edit_menu_callbacks, "D", (MenuItem *)NULL},
  NULL,
};

static MenuItem inspect_menu[] = {
  { "Appearance", &xmPushButtonGadgetClass, 'A', "Ctrl<Key>A", "[Pa]",
        inspect_menu_callbacks, "A", (MenuItem *)NULL},
  { "Material  ", &xmPushButtonGadgetClass, 'M', "Ctrl<Key>M", "[PM]",
        inspect_menu_callbacks, "M", (MenuItem *)NULL},
  { "Lights         ", &xmPushButtonGadgetClass, 'L', "Ctrl<Key>L", "[Pl]",
        inspect_menu_callbacks, "L", (MenuItem *)NULL},
  { "Cameras        ", &xmPushButtonGadgetClass, 'C', "Ctrl<Key>C", "[Pc]",
        inspect_menu_callbacks, "C", (MenuItem *)NULL},
  { "Commands       ", &xmPushButtonGadgetClass, 'O', "Ctrl<Key>P", "[PC]",
        inspect_menu_callbacks, "O", (MenuItem *)NULL},
  { "Credits        ", &xmPushButtonGadgetClass, 'r', NULL, NULL,
        inspect_menu_callbacks, "R", (MenuItem *)NULL},
  NULL,
};

static MenuItem motion_menu[] = {
  { "Tools", &xmPushButtonGadgetClass, 'T', "Ctrl<Key>T", "[Pt]",
        motion_menu_callbacks, "T", (MenuItem *)NULL},
  { "_sepr", &xmSeparatorGadgetClass, (char)NULL, (char*)NULL, (char*)NULL,
        (void (*)())NULL, (XtPointer)NULL, (MenuItem *)NULL },
  { "Inertia", &xmToggleButtonGadgetClass, 'I', "Alt<Key>I", "[ui]",
        motion_menu_callbacks, "1", (MenuItem *)NULL},
  { "Constrain motion", &xmToggleButtonGadgetClass, 'C', "Alt<Key>M", "[uc]",
        motion_menu_callbacks, "2", (MenuItem *)NULL},
  { "Own coordinates", &xmToggleButtonGadgetClass, 'O', "Alt<Key>O", "[uo]",
        motion_menu_callbacks, "3", (MenuItem *)NULL},
  NULL,
};

void ui_refresh_mainpanel(int id)
{
  int newspace, i;

  if (!loaded)
    return;

  newspace = uispace(spaceof(WORLDGEOM));

  if (currentspace != newspace)
  {
    currentspace = newspace;

    for (i = 0; i < 3; i++)
    {
      if (i != currentspace)
	XtVaSetValues(SpaceRadio[i], XmNset, False, NULL);
    }

    XtVaSetValues(SpaceRadio[currentspace], XmNset, True, NULL);
  }

  XtVaSetValues(MotionToggle[0], XmNset, uistate.inertia ? True : False, NULL);
  XtVaSetValues(MotionToggle[1], XmNset, uistate.constrained ? True : False,
			NULL);
  XtVaSetValues(MotionToggle[2], XmNset, uistate.ownmotion ? True : False,
			NULL);

}

static void motion_menu_callbacks(Widget widget, char *text)
{
  int val;

  switch (text[0])
  {
    case 'T':
      ui_showpanel(P_TOOL, 1);
      break;

    case '1':
      val = DRAWER_INERTIA;
      break;

    case '2':
      val = DRAWER_CONSTRAIN;
      break;

    case '3':
    default:
      val = DRAWER_OWNMOTION;
      break;
  }

  drawer_int(GEOMID(uistate.targetgeom), val,
		XmToggleButtonGadgetGetState(widget));
}

static void choose_space(Widget w, int item)
{
  int  space;

  if (item == currentspace)
    return;
 
  currentspace = item;
  switch (currentspace)
  {
    default:
    case EUCLIDEAN:
      space = EUCLIDEAN_KEYWORD;
      break;
    case HYPERBOLIC:
      space = HYPERBOLIC_KEYWORD;
      break;
    case SPHERICAL:
      space = SPHERICAL_KEYWORD;
      break;
  }
  gv_space(space);
}

/*****************************************************************************/

void ui_load_mainpanel()
{
  Arg	     args[20];
  int	     n;

  Widget     mainwindow,
	     mainmenu,
	     mainform,
	     cascade,
	     space,
	     motion,
	     title,
	     HideButton;

  char       buf[40];
  mib_Widget *mainload;
  Atom       AProtocol;
  XmString   str[3];
  XFontStruct *font;
  XmFontList   fontlist;

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Geomview"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNwidth, gwidth); n++;
  XtSetArg(args[n], XmNminWidth, gwidth); n++;
  XtSetArg(args[n], XmNmaxWidth, gwidth); n++;
  XtSetArg(args[n], XmNheight, gheight); n++;
  XtSetArg(args[n], XmNminHeight, gheight); n++;
  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

  if (pos_later)
  {
    sprintf(geometry, "=+%d+%d", posx, posy);
    XtSetArg(args[n], XmNgeometry, geometry); n++;
  }

  shell = XtAppCreateShell("Geomview", "gv", topLevelShellWidgetClass, dpy,
				args, n);

  XtVaSetValues(shell, XmNiconPixmap, geomicon, NULL);

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Geomview"); n++;
  XtSetArg(args[n], XmNwidth, gwidth); n++;
  XtSetArg(args[n], XmNheight, gheight); n++;
  if (pos_later)
  {
    XtSetArg(args[n], XmNgeometry, geometry); n++;
    pos_later = 0;
  }

  mainwindow = XtCreateManagedWidget("Geomview", xmMainWindowWidgetClass,
		  shell, args, n);

/*****************************************************************************/

  n = 0;
  XtSetArg (args[n], XmNrubberPositioning, True); n++;

  mainmenu = XmCreateSimpleMenuBar(mainwindow, "MainMenu", args, n);

  BuildMenu(mainmenu, XmMENU_PULLDOWN, "File", 'F', file_menu);
  BuildMenu(mainmenu, XmMENU_PULLDOWN, "Edit", 'E', edit_menu);
  BuildMenu(mainmenu, XmMENU_PULLDOWN, "Inspect", 'I', inspect_menu);

/*****************************************************************************/

  str[0] = XmStringCreateSimple("Euclidean    [me]");
  str[1] = XmStringCreateSimple("Hyperbolic   [mh]");
  str[2] = XmStringCreateSimple("Spherical     [ms]");
  space = XmVaCreateSimplePulldownMenu(mainmenu, "_pulldown", 3,
	(XtCallbackProc) choose_space,
        XmVaRADIOBUTTON, str[0], '\0', NULL, NULL,
        XmVaRADIOBUTTON, str[1], '\0', NULL, NULL,
        XmVaRADIOBUTTON, str[2], '\0', NULL, NULL,
        XmNradioBehavior, True,
        XmNradioAlwaysOne, True,
        (XtCallbackProc) NULL);
  XmStringFree(str[0]);
  XmStringFree(str[1]);
  XmStringFree(str[2]);

  str[0] = XmStringCreateSimple("Space");
  cascade = XtVaCreateManagedWidget("Space",
	xmCascadeButtonGadgetClass, mainmenu,
	XmNsubMenuId,   space,
	XmNlabelString, str[0],
	XmNmnemonic,    'S',
	NULL);
  XmStringFree(str[0]);

  for (n = 0; n < 3; n++)
  {
    sprintf(buf, "button_%d", n);
    SpaceRadio[n] = XtNameToWidget(space, buf);
  }
  XtVaSetValues(SpaceRadio[0], XmNset, True, NULL);
  currentspace = 0;

/*****************************************************************************/

  motion = BuildMenu(mainmenu, XmMENU_PULLDOWN, "Motion", 'M', motion_menu);

  for (n = 0; n < 3; n++)
  {
    sprintf(buf, "button_%d", n);
    MotionToggle[n] = (Widget) motion_menu[n+2].subitems;
  }

  XtManageChild(mainmenu);

/*****************************************************************************/

  n = 0;
  XtSetArg (args[n], XmNrubberPositioning, True); n++;
  XtSetArg (args[n], XmNtraversalOn, False); n++;

  mainform = XmCreateForm(mainwindow, "Geomview", args, n);
/*mainload = mib_load_interface(mainform, "interface/MainPanel.mib",
		MI_FROMFILE);*/
  mainload = mib_load_interface(mainform, Root,
		MI_FROMSTRING);
 
  XtManageChild(mainform);

/*****************************************************************************/

  HideButton = mib_find_name(mainload, "HideButton")->me;
  ObjectList = mib_find_name(mainload, "ObjectList")->me;
  EmodList   = mib_find_name(mainload, "EmoduleList")->me;

  XtAddCallback(HideButton, XmNactivateCallback, (XtCallbackProc)hide_main,
		(XtPointer)NULL);
  XtAddCallback(ObjectList, XmNbrowseSelectionCallback,
		(XtCallbackProc)select_object, (XtPointer)NULL);
  XtAddCallback(EmodList, XmNbrowseSelectionCallback,
		(XtCallbackProc)select_module, (XtPointer)NULL);

/*****************************************************************************/

  /* set geomview title font */
  title = mib_find_name(mainload, "Title")->me;
  font = XLoadQueryFont(dpy,
        "-adobe-helvetica-bold-r-normal--24-240-75-75-p-138-iso8859-1");
  fontlist = XmFontListCreate(font, "bigger");
  XtVaSetValues(title, XmNfontList, fontlist, NULL);

/*****************************************************************************/

  AProtocol = XmInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol, (XtCallbackProc)hide_main, NULL);

  loaded = 1;
}


/*****************************************************************************/

static void file_menu_callbacks(Widget widget, char *text)
{
  CameraStruct cs;
  DView *dv;

  switch (text[0])
  {
    case 'N':
      dv = (DView *)drawer_get_object(FOCUSID);
      cs.h = NULL;
      cs.cam = dv && dv->cam ? CamCopy(dv->cam, NULL) : NULL;
      gv_new_camera(NULL, &cs);
      break;

    case 'X':
      gv_exit();
      break;

    case 'O':
      ui_showpanel(P_FILEBROWSER, 1);
      break;

    case 'S':
      ui_showpanel(P_SAVE, 1);

    default:
      break;
  }
}

/*****************************************************************************/

static void edit_menu_callbacks(Widget widget, char *text)
{
  switch (text[0])
  {
    case 'U':
      break;
    case 'C':
      gv_copy(uistate.targetid, (char *)NULL);
      break;
    case 'P':
      break;
    case 'D':
      gv_delete(uistate.targetid);
      break;
    default:
      break;
  }
}

/*****************************************************************************/

static void inspect_menu_callbacks(Widget widget, char *text)
{

  switch (text[0])
  {
    case 'A':
        ui_showpanel(P_APPEARANCE, 1);
        break;
    case 'M':
        ui_showpanel(P_MATERIAL, 1);
        break;
    case 'L':
	ui_showpanel(P_LIGHTS, 1);
	break;
    case 'C':
	ui_showpanel(P_CAMERA, 1);
	break;
    case 'O':
	ui_showpanel(P_COMMANDS, 1);
	break;
    case 'R':
	ui_showpanel(P_CREDITS, 1);
	break;
    default:
      break;
  }

}

/*****************************************************************************/

void ui_show_mainpanel()
{
  if (loaded)
  {
    if (pos_later)
    {
      XtMoveWidget(shell, (Position)posx, (Position)posy);
      pos_later = 0;
    }

    XtRealizeWidget(shell);
    XRaiseWindow(dpy, XtWindow(shell));
  }
}

/*****************************************************************************/

void ui_hide_mainpanel()
{
  if (loaded)
    XtUnrealizeWidget(shell);
}

/*****************************************************************************/

void ui_move_mainpanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (shell)
  { 
    sprintf(geometry, "=+%d+%d", posx, posy);
    XtVaSetValues(shell, XmNgeometry, geometry, NULL);
  }

  if (!pos_later)
    XtMoveWidget(shell, (Position)x, (Position)y);
}

/*****************************************************************************/

void ui_adjustpicklist(int id)
{
  if (id == -1)
    BuildBrowserMenu();
  else
    XmListSelectPos(ObjectList, id2menuindex(id)+1, False);
}

/*****************************************************************************/

static void hide_main(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{

  ui_showpanel(P_MAIN, 0);
}

/*****************************************************************************/

static void select_object(Widget w, XtPointer data, XmListCallbackStruct *cbs)
{
  gv_ui_target(menuindex[cbs->item_position - 1], IMMEDIATE);
}

/*****************************************************************************/

static int id2menuindex(int id)
{
  extern int real_id(int);
  int i;

  if (drawer_cam_count() == 1 &&
      (id == TARGETCAMID || id == ALLCAMS || id == FOCUSID))
    id = real_id(id);
  for (i=0; i<menucount; ++i)
    if (menuindex[i] == id) return i;
  return -1;
}

static void BuildObjectMenuList( char ***menulist, int **menuindex,
					int *count )
{
  register int i;
  int n, camcount;
  register DObject *obj, **objs;
  char buf[64];

  if ((camcount = drawer_cam_count()) > 1) {
    /* + 1 for "Current Camera" entry */
    *count = camcount + drawer_geom_count() + 1;

  } else {
    /* don't "Current Camera", just c0 */
    *count = camcount + drawer_geom_count();
  }

  *menulist = OOGLNewNE(char *, *count, "no space for menulist array");
  *menuindex = OOGLNewNE(int, *count, "no space for menuindex array");

  n = 0;
  objs = (DObject**)dgeom;
  for (i=0; i<dgeom_max; ++i) {
    if ( (obj=objs[i]) != NULL && ((DGeom*)obj)->citizenship != ALIEN) {
      if (obj->name[1] != NULL)
        sprintf(buf, "[%s] %s", obj->name[0], obj->name[1]);
      else
        strcpy(buf, obj->name[0]);
      (*menuindex)[n] = obj->id;
      (*menulist)[n] = strdup(buf);
      ++n;
    }
  }
  if (camcount > 1) {
    (*menuindex)[n] = FOCUSID;
    (*menulist)[n] = strdup("[c] Current Camera");
    ++n;
  }
  objs = (DObject **)dview;
  for (i=0; i<dview_max; ++i) {
    if ( (obj=objs[i]) != NULL ) {
      if (obj->name[1] == NULL) obj->name[1] = "Default Camera";
      sprintf(buf, "[%s] %s", obj->name[0], obj->name[1]);
      (*menuindex)[n] = obj->id;
      (*menulist)[n] = strdup(buf);
      ++n;
    }
  }
}

static void DestroyObjectMenuList( char **menulist, int count )
{
  while ( --count >= 0 )
    OOGLFree(menulist[count]);
  OOGLFree(menulist);
}

static void
BuildBrowserMenu()
{
  XmString str;
  register int i;
  char **menulist;

  XmListDeleteAllItems(ObjectList);

  if (menuindex)
    OOGLFree(menuindex);

  BuildObjectMenuList(&menulist, &menuindex, &menucount);

  for (i=0; i<menucount; ++i)
  {
    str = XmStringCreateSimple(menulist[i]);
    XmListAddItemUnselected(ObjectList, str, 0);
    XmStringFree(str);
  }

  DestroyObjectMenuList(menulist, menucount);
}

/*****************************************************************************/

void ui_adjustemodulelist(int interest)
{
  XmString str;
  int i;
  emodule *em;

  XmListDeleteAllItems(EmodList);
  for(i=0, em=VVEC(uistate.emod,emodule); i<VVCOUNT(uistate.emod); i++, em++)
  {
    char line[64];

    sprintf(line, em->pid > 0 ? "%.58s" : "%.63s", em->name);
    str = XmStringCreateSimple(line);
    XmListAddItemUnselected(EmodList, str, 0);
    XmStringFree(str);
  }

}

/*****************************************************************************/

static void select_module(Widget w, XtPointer data, XmListCallbackStruct *cbs)
{
  int i = cbs->item_position - 1;
  gv_ui_emodule_start(VVINDEX(uistate.emod, emodule, i)->name);
}

/*****************************************************************************/
