#include "mibload.h"
#include "../common/drawer.h"
#include "../common/ui.h"
#include "gvui.h"
#include "interface/Material.mib"

extern Display *dpy;
extern Pixmap   geomicon;

/* private methods and variables */
/*****************************************************************************/

static void hide_material(Widget, XtPointer, XmAnyCallbackStruct *);
static void matt_sliders(Widget, XtPointer, XmScaleCallbackStruct *);
static Widget shell, sliderw[4], textw[4];
static int  pos_later = 0, posx = 0, posy = 0;
static char geometry[40];

static struct _slider {
   float min, max;
   long  val;
} sliders[] = {
  { 1.0, 128.0, DRAWER_SHININESS },
  { 0.0, 1.0, DRAWER_KS },
  { 0.0, 1.0, DRAWER_KD },
  { 0.0, 1.0, DRAWER_KA },
};

#define		S_SHINY		0
#define		S_SPECULAR	1
#define		S_DIFFUSE	2
#define		S_AMBIENT	3

/*****************************************************************************/

void ui_load_materialpanel()
{
  Arg	     args[20];
  int	     n, menu, decor;
  Widget     mattform,
	     HideButton;

  mib_Widget *mattload;
  Atom       AProtocol;

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Material"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNwidth, 249); n++;
  XtSetArg(args[n], XmNheight, 231); n++;
  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

  if (pos_later)
  {
    sprintf(geometry, "=+%d+%d", posx, posy);
    XtSetArg(args[n], XmNgeometry, geometry); n++;
    pos_later = 0;
  }

  shell = XtAppCreateShell("Material", "gv", topLevelShellWidgetClass, dpy,
				args, n);
  XtVaSetValues(shell, XmNiconPixmap, geomicon, NULL);

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Material"); n++;

  mattform = XmCreateForm(shell, "Material", args, n);
/*mattload = mib_load_interface(mattform, "interface/Material.mib",
		MI_FROMFILE);*/
  mattload = mib_load_interface(mattform, Root,
		MI_FROMSTRING);
 
  XtManageChild(mattform);

/*****************************************************************************/

  HideButton = mib_find_name(mattload, "HideButton")->me;
  XtAddCallback(HideButton, XmNactivateCallback, (XtCallbackProc) hide_material,
		(XtPointer) shell);

  sliderw[S_DIFFUSE] = mib_find_name(mattload, "DiffuseScale")->me;
  sliderw[S_AMBIENT] = mib_find_name(mattload, "AmbientScale")->me;
  sliderw[S_SHINY] = mib_find_name(mattload, "ShininessScale")->me;
  sliderw[S_SPECULAR] = mib_find_name(mattload, "SpecularScale")->me;

  textw[S_DIFFUSE] = mib_find_name(mattload, "DiffuseText")->me;
  textw[S_AMBIENT] = mib_find_name(mattload, "AmbientText")->me;
  textw[S_SHINY] = mib_find_name(mattload, "ShinyText")->me;
  textw[S_SPECULAR] = mib_find_name(mattload, "SpecularText")->me;

  XtAddCallback(sliderw[S_DIFFUSE], XmNdragCallback,
		(XtCallbackProc) matt_sliders, S_DIFFUSE);
  XtAddCallback(sliderw[S_DIFFUSE], XmNvalueChangedCallback,
		(XtCallbackProc) matt_sliders, S_DIFFUSE);
  XtAddCallback(sliderw[S_AMBIENT], XmNdragCallback,
		(XtCallbackProc) matt_sliders, S_AMBIENT);
  XtAddCallback(sliderw[S_AMBIENT], XmNvalueChangedCallback,
		(XtCallbackProc) matt_sliders, S_AMBIENT);
  XtAddCallback(sliderw[S_SHINY], XmNdragCallback,
		(XtCallbackProc) matt_sliders, S_SHINY);
  XtAddCallback(sliderw[S_SHINY], XmNvalueChangedCallback,
		(XtCallbackProc) matt_sliders, S_SHINY);
  XtAddCallback(sliderw[S_SPECULAR], XmNdragCallback,
		(XtCallbackProc) matt_sliders, S_SPECULAR);
  XtAddCallback(sliderw[S_SPECULAR], XmNvalueChangedCallback,
		(XtCallbackProc) matt_sliders, S_SPECULAR);

  XtVaSetValues(textw[S_DIFFUSE], XmNeditable, False, NULL);
  XtVaSetValues(textw[S_AMBIENT], XmNeditable, False, NULL);
  XtVaSetValues(textw[S_SHINY], XmNeditable, False, NULL);
  XtVaSetValues(textw[S_SPECULAR], XmNeditable, False, NULL);

/*****************************************************************************/

  AProtocol = XmInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol, (XtCallbackProc) hide_material,
		NULL);

  decor = MWM_DECOR_BORDER | MWM_DECOR_TITLE | MWM_DECOR_MENU |
                MWM_DECOR_MINIMIZE;
  menu = MWM_FUNC_MOVE | MWM_FUNC_MINIMIZE | MWM_FUNC_CLOSE;
  XtVaSetValues(shell, XmNmwmDecorations, decor, XmNmwmFunctions, menu, NULL);

}


/*****************************************************************************/

void ui_show_materialpanel()
{

  if (pos_later)
  {
    XtMoveWidget(shell, (Position)posx, (Position)posy);
    pos_later = 0;
  }

  XtRealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
}

/*****************************************************************************/

void ui_hide_materialpanel()
{
  XtUnrealizeWidget(shell);
}

/*****************************************************************************/

void ui_move_materialpanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (!pos_later)
    XtMoveWidget(shell, (Position)x, (Position)y);
}

/*****************************************************************************/

static void hide_material(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_MATERIAL, 0);
}

/*****************************************************************************/

static void matt_sliders(Widget w, XtPointer data, XmScaleCallbackStruct *cbs)
{
  struct _slider *s_pt = &(sliders[(int)data]);
  float val = (float)cbs->value;
  float conv = ((s_pt->max - s_pt->min)/100.0)*val + s_pt->min;

  drawer_float(GEOMID(uistate.targetgeom), s_pt->val, conv);
  ui_set_ftext(textw[(int)data], conv);
}

/*****************************************************************************/

void ui_target_materialpanel(int id)
{
  float       val;
  int         conv;
  DGeom      *dg;
  Appearance *ap;

  if ((dg = (DGeom *)drawer_get_object(id)))
  {
    ap = drawer_get_ap(id);
    if (ap->mat)
    {
      struct _slider *s_pt;

      if (ap->mat->valid & MTF_Ka)
      {
	s_pt = &(sliders[S_AMBIENT]);
	val = ap->mat->ka;
	conv = (int)(100.0*(val - s_pt->min))/(s_pt->max - s_pt->min);
	XmScaleSetValue(sliderw[S_AMBIENT], conv);
	ui_set_ftext(textw[S_AMBIENT], val);
      }
      if (ap->mat->valid & MTF_Kd)
      {
	s_pt = &(sliders[S_DIFFUSE]);
	val = ap->mat->kd;
	conv = (int)(100.0*(val - s_pt->min))/(s_pt->max - s_pt->min);
	XmScaleSetValue(sliderw[S_DIFFUSE], conv);
	ui_set_ftext(textw[S_DIFFUSE], val);
      }
      if (ap->mat->valid & MTF_Ks)
      {
	s_pt = &(sliders[S_SPECULAR]);
	val = ap->mat->ks;
	conv = (int)(100.0*(val - s_pt->min))/(s_pt->max - s_pt->min);
	XmScaleSetValue(sliderw[S_SPECULAR], conv);
	ui_set_ftext(textw[S_SPECULAR], val);
      }
      if (ap->mat->valid & MTF_SHININESS)
      {
	s_pt = &(sliders[S_SHINY]);
	val = ap->mat->shininess;
	conv = (int)(100.0*(val - s_pt->min))/(s_pt->max - s_pt->min);
	XmScaleSetValue(sliderw[S_SHINY], conv);
	ui_set_ftext(textw[S_SHINY], val);
      }
    }
  }
}

/*****************************************************************************/
