#include "mibload.h"
#include <Xm/DialogS.h>
#include "../common/drawer.h"
#include "gvui.h"
#include "interface/LoadPaths.mib"

extern Display *dpy;
extern Widget TopLevel;

/* private methods and variables */
/*****************************************************************************/

static void hide_loadpanel(Widget, XtPointer, XmAnyCallbackStruct *);
static void load_selection(Widget, XtPointer,
			XmFileSelectionBoxCallbackStruct *);
static void select_path(Widget, XtPointer, XmListCallbackStruct *);
static void ui_update_loadpanel();
static Widget shell, pathlist, loadform;
static int loaded = 0, shown = 0;
static char **dirp;
static int    pos_later = 0, posx = 0, posy = 0;
static  int oldstderr;
static char geometry[40];

/*****************************************************************************/

void ui_load_loadpanel()
{
  Arg	     args[20];
  int	     n;
  Widget     pathform,
	     temp;

  mib_Widget *pathload;
  Atom       AProtocol;
  XmString   xname;

/*****************************************************************************/

#ifdef SVR4		/* is this solaris? */
		        /* if so, lets work around a dumb motif bug here */
  n = 0;
  XtSetArg(args[n], XmNtitle, "Load an Object"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNkeyboardFocusPolicy, XmPOINTER); n++;
  XtSetArg(args[n], XmNwidth, 340); n++;
  XtSetArg(args[n], XmNminWidth, 340); n++;
  XtSetArg(args[n], XmNheight, 480); n++;
  XtSetArg(args[n], XmNminHeight, 392); n++;

  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

  shell = XtAppCreateShell("Load", "gv", topLevelShellWidgetClass,
                                dpy, args, n);

#endif

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Load an Object"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNkeyboardFocusPolicy, XmPOINTER); n++;
  XtSetArg(args[n], XmNwidth, 340); n++;
  XtSetArg(args[n], XmNminWidth, 340); n++;
  XtSetArg(args[n], XmNheight, 480); n++;
  XtSetArg(args[n], XmNminHeight, 392); n++;

  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

#ifdef SVR4
  loadform = XmCreateFileSelectionBox(shell, "Load", args, n);
  XtManageChild(loadform);
#else
  loadform = XmCreateFileSelectionDialog(TopLevel, "Load", args, n);
#endif
 
/*****************************************************************************/

  temp = XmFileSelectionBoxGetChild(loadform, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(temp);

  XtAddCallback(loadform, XmNokCallback, (XtCallbackProc) load_selection,
		(XtPointer) NULL);

  temp = XmFileSelectionBoxGetChild(loadform, XmDIALOG_CANCEL_BUTTON);

  xname = XmStringCreateSimple("Hide");
  XtVaSetValues(temp, XmNlabelString, xname, NULL);
  XmStringFree(xname);

  XtAddCallback(temp, XmNactivateCallback, (XtCallbackProc) hide_loadpanel,
		(XtPointer) NULL);

/*****************************************************************************/

/*pathload = mib_load_interface(loadform, "interface/LoadPaths.mib",
			MI_FROMFILE);*/
  pathload = mib_load_interface(loadform, Root,
			MI_FROMSTRING);
  pathform = pathload->me;

  pathlist = mib_find_name(pathload, "PathList")->me;
  XtAddCallback(pathlist, XmNbrowseSelectionCallback,
		(XtCallbackProc) select_path, (XtPointer) NULL);
  XtManageChild(pathform);
  XtManageChild(pathlist);

/*****************************************************************************/

#ifdef SVR4
  AProtocol = XmInternAtom(XtDisplay(shell), "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol,
			(XtCallbackProc) hide_loadpanel, (XtPointer) NULL);
#else
  AProtocol = XmInternAtom(XtDisplay(loadform), "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(XtParent(loadform), AProtocol,
			(XtCallbackProc) hide_loadpanel, (XtPointer) NULL);
#endif

  loaded = 1;
}


/*****************************************************************************/

void ui_show_loadpanel()
{
  if (!loaded)
  {
    oldstderr = dup(fileno(stderr));
    freopen("/dev/null", "w", stderr);

    ui_load_loadpanel();

    freopen("/dev/null", "w", stderr);
    dup2(oldstderr, fileno(stderr));
    close(oldstderr);
  }

  if (shown)
    return;

  ui_update_loadpanel();

#ifdef SVR4
  XtRealizeWidget(shell);
#else
  XtManageChild(loadform);
#endif

  if (pos_later)
  {
    /* May put this in later if we can ever really want to
	position the file panel

    sprintf(geometry, "=+%d+%d", posx, posy);
    XtVaSetValues(loadform, XmNgeometry, geometry,
				XmNx, posx, XmNy, posy, NULL);
    */
    pos_later = 0;
  }

  XtSetMappedWhenManaged(loadform, True);

#ifdef SVR4
  XRaiseWindow(dpy, XtWindow(shell));
#else
  XRaiseWindow(dpy, XtWindow(loadform));
#endif

  shown = 1;
}

/*****************************************************************************/

void ui_hide_loadpanel()
{
  if (!loaded)
    return;

  if (!shown)
    return;

#ifdef SVR4
  XtUnrealizeWidget(shell);
#else
  XtUnmanageChild(loadform);
#endif

  shown = 0;
}

/*****************************************************************************/

void ui_move_loadpanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (!loaded)
    return;

  if (!pos_later)
    XtMoveWidget(XtParent(loadform), (Position)x, (Position)y);
}

/*****************************************************************************/

static void ui_update_loadpanel()
{
  int		i;
  XmString	str;

  XmListDeleteAllItems(pathlist);
  dirp = getfiledirs();
  for (i=0; dirp[i] != NULL; i++)
  {
    str = XmStringCreateSimple(dirp[i]);
    XmListAddItemUnselected(pathlist, str, 0);
    XmStringFree(str);
  }
}

/*****************************************************************************/

static void hide_loadpanel(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_FILEBROWSER, 0);
  ui_showpanel(P_INPUT, 0);
}

/*****************************************************************************/

static void select_path(Widget w, XtPointer data, XmListCallbackStruct *cbs)
{
  char        *temp, dirmask[200];
  XmString     dmask;

  if (!XmStringGetLtoR(cbs->item, XmSTRING_DEFAULT_CHARSET, &temp))
    return;

  if (!*temp)
    return;

  sprintf(dirmask,"%s/*", temp);
  XtFree(temp);
  dmask = XmStringCreate(dirmask, XmSTRING_DEFAULT_CHARSET);

  XmFileSelectionDoSearch(loadform, dmask);

  XmStringFree(dmask);
}

/*****************************************************************************/

static void load_selection(Widget w, XtPointer data,
		XmFileSelectionBoxCallbackStruct *cbs)
{

  char  *object;

  if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &object))
    return;

  if (!*object)
    return;

  gv_load(object, NULL);
  XtFree(object);
}

/*****************************************************************************/
