#include "mibload.h"
#include "../common/drawer.h"
#include "../common/ui.h"
#include "gvui.h"
#include "interface/Lights.mib"

#define		MAXLIGHTS	8
#define		LIGHTINDEX      255


extern Display *dpy;
extern UIState uistate;
extern int light_count();
extern void set_light(int);
extern Pixmap geomicon;

/* private methods and variables */
/*****************************************************************************/

static void hide_lightspanel(Widget, XtPointer, XmAnyCallbackStruct *);
static void select_light(Widget, XtPointer, XmListCallbackStruct *);
static void intensity_light(Widget, XtPointer, XmScaleCallbackStruct *);
static void toggle_lights(Widget, XtPointer, XmToggleButtonCallbackStruct *);
static void color_light(Widget, XtPointer, XmAnyCallbackStruct *);
static void light_add(Widget, XtPointer, XmAnyCallbackStruct *);
static void light_del(Widget, XtPointer, XmAnyCallbackStruct *);
static Widget  shell,
	       ltoggle,
	       lintensity,
	       lightslist;
static char   *lights[MAXLIGHTS+1];
static int    pos_later = 0, posx = 0, posy = 0;
static char   geometry[40];


/*****************************************************************************/

void ui_load_lightspanel()
{
  Arg	     args[20];
  int	     n, decor, menu;
  Widget     lightsform,
	     lightsadd,
	     lightsdel,
	     ColButton,
	     HideButton;
  char	     buf[100];

  mib_Widget *lightsload;
  Atom       AProtocol;

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Lights"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNwidth, 285); n++;
  XtSetArg(args[n], XmNminWidth, 285); n++;
  XtSetArg(args[n], XmNmaxWidth, 285); n++;
  XtSetArg(args[n], XmNheight, 132); n++;
  XtSetArg(args[n], XmNminHeight, 132); n++;
  XtSetArg(args[n], XmNmaxHeight, 132); n++;
  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

  if (pos_later)
  {
    sprintf(geometry, "=+%d+%d", posx, posy);
    XtSetArg(args[n], XmNgeometry, geometry); n++;
    pos_later = 0;
  }

  shell = XtAppCreateShell("Lights", "gv", topLevelShellWidgetClass, dpy,
				args, n);
  XtVaSetValues(shell, XmNiconPixmap, geomicon, NULL);

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Lights"); n++;

  lightsform = XmCreateForm(shell, "Lights", args, n);
/*lightsload = mib_load_interface(lightsform, "interface/Lights.mib",
		MI_FROMFILE);*/
  lightsload = mib_load_interface(lightsform, Root,
		MI_FROMSTRING);
 
  XtManageChild(lightsform);

/*****************************************************************************/

  ColButton  = mib_find_name(lightsload, "ColorButton")->me;
  HideButton = mib_find_name(lightsload, "HideButton")->me;
  lightslist = mib_find_name(lightsload, "LightsList")->me;
  lintensity = mib_find_name(lightsload, "IntensityScale")->me;
  ltoggle    = mib_find_name(lightsload, "LightsToggle")->me;
  lightsadd  = mib_find_name(lightsload, "AddButton")->me;
  lightsdel  = mib_find_name(lightsload, "DeleteButton")->me;

  XtAddCallback(ColButton, XmNactivateCallback, (XtCallbackProc) color_light,
			(XtPointer) NULL);
  XtAddCallback(HideButton, XmNactivateCallback,
			(XtCallbackProc) hide_lightspanel, (XtPointer) NULL);
  XtAddCallback(lightslist, XmNbrowseSelectionCallback,
			(XtCallbackProc) select_light, (XtPointer) &lintensity);
  XtAddCallback(lintensity, XmNdragCallback, (XtCallbackProc) intensity_light,
			(XtPointer) NULL);
  XtAddCallback(lintensity, XmNvalueChangedCallback,
			(XtCallbackProc) intensity_light, (XtPointer) NULL);
  XtAddCallback(ltoggle, XmNvalueChangedCallback, (XtCallbackProc) toggle_lights,
			(XtPointer) NULL);
  XtAddCallback(lightsadd, XmNactivateCallback, (XtCallbackProc) light_add,
			(XtPointer) NULL);
  XtAddCallback(lightsdel, XmNactivateCallback, (XtCallbackProc) light_del,
			(XtPointer) NULL);

/*****************************************************************************/

  AProtocol = XmInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol, (XtCallbackProc) hide_lightspanel,
			(XtPointer) NULL);

  decor = MWM_DECOR_BORDER | MWM_DECOR_TITLE | MWM_DECOR_MENU |
                MWM_DECOR_MINIMIZE;
  menu = MWM_FUNC_MOVE | MWM_FUNC_MINIMIZE | MWM_FUNC_CLOSE;
  XtVaSetValues(shell, XmNmwmDecorations, decor, XmNmwmFunctions, menu, NULL);


/*****************************************************************************/
/* Initialize Panel Variables */

  lights[0] = "ambient";
  for (n = 1; n <= MAXLIGHTS; ++n)
  {
    sprintf(buf, "light %1d", n);
    lights[n] = strdup(buf);
  }
  ui_build_browser(lightslist, light_count(), lights);

}


/*****************************************************************************/

void ui_show_lightspanel()
{
  set_light(light_count() > 0 ? 1 : 0);
  XmListSelectPos(lightslist, uistate.current_light + 1, False);

  if (pos_later)
  {
    XtMoveWidget(shell, (Position)posx, (Position)posy);
    pos_later = 0;
  }

  XtRealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
}

/*****************************************************************************/

void ui_hide_lightspanel()
{
  XtUnrealizeWidget(shell);
}

/*****************************************************************************/

static void hide_lightspanel(Widget w, XtPointer data,
				XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_LIGHTS, 0);
}

/*****************************************************************************/

void ui_move_lightspanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (!pos_later)
    XtMoveWidget(shell, (Position)x, (Position)y);
}

/*****************************************************************************/

void set_light_display(int lightno)
{
  extern float light_intensity();

  XmScaleSetValue(lintensity, (int) (light_intensity()*100.0));
}

/*****************************************************************************/

void ui_light_button()
{
  int state = (uistate.lights_shown != 0);
  XmToggleButtonSetState(ltoggle, state, False);
}

/*****************************************************************************/

void ui_lights_changed()
{
  ui_build_browser(lightslist, light_count(), lights);
  set_light(uistate.current_light);
}

/*****************************************************************************/

static void select_light(Widget w, XtPointer data, XmListCallbackStruct *cbs)
{
  extern float light_intensity();
  Widget intensity = (Widget)*((Widget *)data);

  set_light(cbs->item_position-1);
  XmScaleSetValue(intensity, (int) (light_intensity()*100.0));
}

/*****************************************************************************/

static void color_light(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  extern Color *light_color(); /* in clights.c */

  ui_config_colorpanel("Light Color", light_color(), LIGHTINDEX,
			DRAWER_LIGHTCOLOR, 0);
  ui_showpanel(P_COLOR, 1);
}

/*****************************************************************************/

static void light_add(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  extern void add_light();

  if (light_count() > 8)
  {
    OOGLError(0, "Can't have more than 8 lights\n");
    return;
  }
  add_light();
}

/*****************************************************************************/

static void light_del(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  extern void delete_light();

  if (uistate.current_light == 0)
    return;
  delete_light();
}

/*****************************************************************************/

static void toggle_lights(Widget w, XtPointer data,
				XmToggleButtonCallbackStruct *cbs)
{
  extern void light_edit_mode(int);

  light_edit_mode(cbs->set);
}

/*****************************************************************************/

static void intensity_light(Widget w, XtPointer data,
                                XmScaleCallbackStruct *cbs)
{
  float f = (float)cbs->value/100.0;
  drawer_float(GEOMID(uistate.targetgeom), DRAWER_LIGHT_INTENSITY, f);
}

/*****************************************************************************/
