#include "../common/drawer.h"
#include "../common/ui.h"
#include "../common/comm.h"
#include "../common/space.h"
#include "../common/event.h"
#include "../common/motion.h"
#include "../common/worldio.h"
#include "../common/version.h"
#include "../common/lang.h"
#include "clang.h"

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
/* #include <sys/dir.h> Do we need this? - slevy 94.03.09 */
#include <sys/signal.h>
#include <sys/types.h>
#include <sys/time.h>

#include <X11/X.h>
#include <X11/keysym.h>
#include "mibload.h"
#include "gvui.h"

/* gvevent.c global vars */
/*****************************************************************************/

#define ESC	'\033'

extern Display *dpy;
static void perftick();
static struct perf {            /* Performance metering */
    int interval;               /* Interval between auto-reports */
    int mindt, maxdt, meandt;   /* Integer milliseconds */
    int cycles;                 /* # cycles where we actually did something */
    struct timeval then;
} perf;

static int lastx;
static int lasty;
static int dragx;
static int dragy;
static int nseen;
static int dragstop, dragging, deldrag, numdrags;
int    justdragged;

static Time lastt;
static Event  gev; /* geomview event structure */

/*****************************************************************************/

void main_loop()
{

  fd_set thesefds;
  int nwatch = 0;
  int queuefd;
  XEvent xev;

  queuefd = ConnectionNumber(dpy);
  dragging = 0;
  dragstop = 1;
  justdragged = 0;
  deldrag = 0;
  numdrags = 0;

  while (1) {
    struct timeval await;
#define	BRIEF	0.1
    static struct timeval brief = { 0, 100000 };
    float timelimit;

    if(drawerstate.pause)
    {
	if(!dragging && !drawer_moving())
	    select(0, NULL, NULL, NULL, &brief);
	nseen = 0;
    }
    else
    {
      timelimit = PoolInputFDs( &thesefds, &nwatch );

      if(timelimit > 0 && drawer_moving())
	    timelimit = 0;	/* "Is anything moving?" */

      if (queuefd >= 0 )
	FD_SET(queuefd, &thesefds);

      if(queuefd >= nwatch)
	  nwatch = queuefd+1;

      if(timelimit > BRIEF) timelimit = BRIEF;

      await.tv_sec = floor(timelimit);
	await.tv_usec = 1000000*(timelimit - await.tv_sec);

	nseen = select(nwatch, &thesefds, NULL, NULL, &await);
    }

    gettimeofday(&perf.then, NULL);

    if(!drawerstate.pause)
	PoolInAll( &thesefds, &nseen );

    ui_update();

    justdragged = 0;
    deldrag = gev.t;


    while (XtAppPending(App))
    {
      XtAppNextEvent(App, &xev);
      XtDispatchEvent(&xev);
    }

    if (dragging && !justdragged && !dragstop)
    {
      gv_rawevent( gev.dev, -1, gev.x, gev.y, gev.t);
      dragstop = 1;
    }

    if (dragging)
    {
      deldrag = gev.t - deldrag;
    }
    else
     {
      deldrag = 0;
     }

    XSync(dpy, False);

    gv_update_draw( ALLCAMS, 0.001 * (float)deldrag );

    if(perf.interval > 0)
        perftick();

    numdrags = 0;
 }

}

/*****************************************************************************/

static void
perftick()
{
    int dt;
    struct timeval now;
    gettimeofday(&now, NULL);
    dt = (now.tv_sec - perf.then.tv_sec)*1000 +
         (now.tv_usec - perf.then.tv_usec)/1000;
    if(dt > 0) {
        if(dt < perf.mindt) perf.mindt = dt;
        if(dt > perf.maxdt) perf.maxdt = dt;
        perf.meandt += dt;
        if(++perf.cycles == perf.interval)
            timing(perf.interval);
    }
}

/*****************************************************************************/

void
timing(int interval)
{
    if(perf.cycles > 0) {
        printf("%d..%d ms/cycle, mean %d ms over %d cycles\n",
                perf.mindt, perf.maxdt,
                perf.cycles ? perf.meandt/perf.cycles : 0,
                perf.cycles);
        fflush(stdout);
    }
    perf.mindt = 9999999, perf.maxdt = -1, perf.meandt = perf.cycles = 0;
    perf.interval = interval;
}

/*****************************************************************************/

void cam_input(Widget w, XtPointer data, XmDrawingAreaCallbackStruct *cbs)
{

  static char    str[10];
  KeySym         keysym;
  XComposeStatus compose;
  XEvent *event = cbs->event;
  int newstate;

  switch (event->type)
  {
    case ButtonPress:
    case ButtonRelease:
      newstate = (event->type == ButtonPress);

      button.left = ((event->xbutton.state & Button1Mask) ? 1 : 0);
      button.middle = ((event->xbutton.state & Button2Mask) ? 1 : 0);
      button.right = ((event->xbutton.state & Button3Mask) ? 1 : 0);
      button.shift = ((event->xbutton.state & ShiftMask) ? 1 : 0);
      button.ctrl = ((event->xbutton.state & ControlMask) ? 1 : 0);
      dragging = newstate;

      lastt = event->xbutton.time;
      dragx = event->xbutton.x_root;
      dragy = YScrnSize - event->xbutton.y_root;

      if (dragstop && !newstate)
        gv_rawevent( gev.dev, -1, dragx, dragy, lastt);

      switch (event->xbutton.button)
      {
	 case 1:
           gev.dev = ELEFTMOUSE;
           button.left = newstate;
	   break;
	 case 2:
           gev.dev = EMIDDLEMOUSE;
           button.middle = newstate;
	   break;
	 case 3:
           gev.dev = ERIGHTMOUSE;
           button.right = newstate;
	   break;
       }

      gev.x = dragx; gev.y = dragy; gev.t = lastt;
      deldrag = gev.t;
      gv_rawevent( gev.dev, newstate, gev.x, gev.y, gev.t);
      dragstop = 1;
      break;

    case KeyPress:
      XLookupString(&(event->xkey), str, 10, &keysym, &compose);

      if ((int)keysym == (int)'Q')
	str[0] = ESC;

      if (((keysym >= XK_KP_Space)
		&& (keysym <= XK_KP_9))
		|| ((keysym >= XK_space)
		&& (keysym <= XK_asciitilde)))
        {
	  gev.dev = str[0];
	  gev.x = event->xkey.x_root;
	  gev.y = YScrnSize - event->xkey.y_root;
	  gev.t = event->xkey.time;
          gv_rawevent(str[0], 1, gev.x, gev.y, gev.t);
        }

      break;

    default:
      break;
  }
  
}

/*****************************************************************************/

void cam_mouse(Widget w, XtPointer data, XPointerMovedEvent *event,
	Boolean *cont)
{
  static lasthere = 0;
  dragging = 1;
  dragstop = 0;
  justdragged = 1;

  numdrags++;
  if (numdrags > 2)
    return;

  gev.x = event->x_root; gev.y = YScrnSize - event->y_root; gev.t = event->time;

  if ((gev.t - lastt) > uistate.cursor_still)
  {
    if (abs(gev.x - lastx) < uistate.cursor_twitch &&
	abs(gev.y - lasty) < uistate.cursor_twitch)
      {
	gev.x = dragx;
	gev.y = dragy;
      }
    lastx = gev.x;
    lasty = gev.y;
    lastt = gev.t;
  }
  dragx = gev.x;
  dragy = gev.y;
  if (lasthere != gev.t)
    gv_rawevent( gev.dev, -1, gev.x, gev.y, gev.t);
  else
    dragstop = 1;

  lasthere = gev.t;
}

/*****************************************************************************/

void cam_mousecross(Widget w, XtPointer data, XEnterWindowEvent *event,
	Boolean *cont)
{
  DView *dv = (DView *)data;

  gv_winenter(dv->id);
}

/*****************************************************************************/

#ifdef MGX11

void cam_expose(Widget w, XtPointer data, XmDrawingAreaCallbackStruct *cbs)
{
  DView *dv = (DView *)data;

  mgctxselect(dv->mgctx);
  mgctxset(MG_X11EXPOSE, MG_END);
  gv_redraw(dv->id);
}

#endif

/*****************************************************************************/

#ifdef MGGL
void cam_exposegl(Widget w, XtPointer data, GlxDrawCallbackStruct *cbs)
{
  DView *dv = (DView *)data;

  GLXwinset(XtDisplay(w), cbs->window);
  gv_redraw(dv->id);
  gflush();
}

/*****************************************************************************/

void cam_initgl(Widget w, XtPointer data, GlxDrawCallbackStruct *cbs)
{
  GLXwinset(XtDisplay(w), cbs->window);
  gflush();
}
#endif /* MGGL */

/*****************************************************************************/

/***************** END DAERON *******************/
