#include "mibload.h"
#include "../common/drawer.h"
#include "gvui.h"
#include "../common/version.h"
#include "interface/Credits.mib"

extern Display *dpy;
extern char builddate[], buildinfo1[], buildinfo2[];
extern Pixmap geomicon;

/* private methods and variables */
/*****************************************************************************/

static void hide_credits(Widget, XtPointer, XmAnyCallbackStruct *);
static void add_text(Widget, char *[]);
static Widget shell;
static int loaded = 0;
static int pos_later = 0, posx = 0, posy = 0;
static char geometry[40];

static char *credits[] = {
  "Geomview for X, " GEOMVIEW_VERSION,
  " ",
  "Original Geomview Kernel + GL version:",
  "Stuart Levy, Tamara Munzner, Mark Phillips",
  " ",
  "X Window System Version:",
  "Daeron Meyer, Timothy Rowley",
  " ",
  "NeXTSTEP Version:",
  "Dan Krech, Scott Wisdom",
  " ",
  "Important Modifications:",
  "Celeste Fowler, Charlie Gunn, Nathaniel Thurston", 
  " ",
  "The Geometry Center   Copyright (c) 1994",
  "anonymous ftp: geom.umn.edu",
  "email: software@geom.umn.edu",
  "gopher: gopher.geom.umn.edu",
  "www: http://www.geom.umn.edu/",
  " ",
  "geomview/OOGL is free software which may be.",
  "obtained via anonymous ftp from the above site.",
  "You can redistribute and/or modify it only",
  "under the terms given in the file COPYING,",
  "which is included in the geomview distribution.",
  " ",
  "The National Science and Technology Research",
  "Center for the Computation and Visualization of",
  "Geometric Structures",
  " ",
  "University of Minnesota",
  "1300 South Second Street",
  "Minneapolis, MN  55454  USA",
  " ",
  "Compiled:",
  buildinfo1,
  buildinfo2,
  NULL
};

/*****************************************************************************/

void ui_load_creditspanel()
{
  Arg	     args[20];
  int	     n;
  Widget     creditsform,
	     creditslist,
	     HideButton;

  mib_Widget *creditsload;
  Atom       AProtocol;

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Credits"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNwidth, 348); n++;
  XtSetArg(args[n], XmNminWidth, 355); n++;
  XtSetArg(args[n], XmNheight, 231); n++;
  XtSetArg(args[n], XmNminHeight, 231); n++;
  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

  if (pos_later)
  {
    sprintf(geometry, "=+%d+%d", posx, posy);
    XtSetArg(args[n], XmNgeometry, geometry); n++;
    pos_later = 0;
  }

  shell = XtAppCreateShell("Credits", "gv", topLevelShellWidgetClass, dpy,
				args, n);
  XtVaSetValues(shell, XmNiconPixmap, geomicon, NULL);

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Credits"); n++;

  creditsform = XmCreateForm(shell, "Credits", args, n);
/*creditsload = mib_load_interface(creditsform, "interface/Credits.mib",
		MI_FROMFILE);*/
  creditsload = mib_load_interface(creditsform, Root,
		MI_FROMSTRING);
 
  XtManageChild(creditsform);

/*****************************************************************************/

  HideButton = mib_find_name(creditsload, "HideButton")->me;
  XtAddCallback(HideButton, XmNactivateCallback, (XtCallbackProc) hide_credits,
			(XtPointer) shell);

  creditslist = mib_find_name(creditsload, "CreditsList")->me;
  add_text(creditslist, credits);
  

/*****************************************************************************/

  AProtocol = XmInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol, (XtCallbackProc) hide_credits,
				(XtPointer) NULL);

  loaded = 1;
}


/*****************************************************************************/

void ui_show_creditspanel()
{
  if (!loaded)
    ui_load_creditspanel();

  if (pos_later)
  {
    XtMoveWidget(shell, (Position)posx, (Position)posy);
    pos_later = 0;
  }

  XtRealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
}

/*****************************************************************************/

void ui_hide_creditspanel()
{
  if (!loaded)
    return;

  XtUnrealizeWidget(shell);
}

/*****************************************************************************/

void ui_move_creditspanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (!pos_later)
    XtMoveWidget(shell, (Position)x, (Position)y);
}

/*****************************************************************************/

static void hide_credits(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_CREDITS, 0);
}

/*****************************************************************************/

static void add_text(Widget clist, char *text[])
{
  int line = 0;
  XmString str;

  while (text[line])
  {
   str = XmStringCreateSimple(text[line]);
   XmListAddItemUnselected(clist, str, 0);
   XmStringFree(str);
   line++;
  }
  
}

/*****************************************************************************/
