#include "mibload.h"
#include "../common/drawer.h"
#include "../common/ui.h"
#include "../common/comm.h"
#include "gvui.h"
#include "interface/Commands.mib"
#include "bitmaps/up_arrow"
#include "bitmaps/down_arrow"

extern HandleOps CommandOps;
extern Display *dpy;
extern Pixmap   geomicon;

/* private methods and variables */
/*****************************************************************************/

static void hide_commands(Widget, XtPointer, XmAnyCallbackStruct *);
static void command_input(Widget, XtPointer, XmAnyCallbackStruct *);
static void command_scroll(Widget, XtPointer, XmListCallbackStruct *);
static void command_up(Widget, XtPointer, XmAnyCallbackStruct *);
static void command_down(Widget, XtPointer, XmAnyCallbackStruct *);

static Widget shell;
static int num_items;
static int loaded = 0;
static int pos_later = 0, posx = 0, posy = 0;
static char geometry[40];


/*****************************************************************************/

void ui_load_commandspanel()
{
  Arg	     args[20];
  int	     n, depth;
  Widget     commandsform,
	     commscroll,
	     commtext,
	     HideButton,
	     temp;

  Pixel      fg, bg;
  Pixmap     button_pix;
  mib_Widget *commandsload;
  Atom       AProtocol;

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Commands"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNkeyboardFocusPolicy, XmPOINTER); n++;
  XtSetArg(args[n], XmNwidth, 400); n++;
  XtSetArg(args[n], XmNminWidth, 200); n++;
  XtSetArg(args[n], XmNheight, 182); n++;
  XtSetArg(args[n], XmNminHeight, 120); n++;
  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

  if (pos_later)
  {
    sprintf(geometry, "=+%d+%d", posx, posy);
    XtSetArg(args[n], XmNgeometry, geometry); n++;
    pos_later = 0;
  }


  shell = XtAppCreateShell("Commands", "gv", topLevelShellWidgetClass, dpy,
				args, n);

  XtVaSetValues(shell, XmNiconPixmap, geomicon, NULL);

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Commands"); n++;

  commandsform = XmCreateForm(shell, "Commands", args, n);
/*commandsload = mib_load_interface(commandsform, "interface/Commands.mib",
		MI_FROMFILE);*/
  commandsload = mib_load_interface(commandsform, Root,
		MI_FROMSTRING);
 
  XtManageChild(commandsform);

/*****************************************************************************/

  HideButton = mib_find_name(commandsload, "HideButton")->me;
  XtAddCallback(HideButton, XmNactivateCallback, (XtCallbackProc) hide_commands,
		NULL);

  commtext = mib_find_name(commandsload, "CommandText")->me;
  commscroll = mib_find_name(commandsload, "CommandScroll")->me;
  XtAddCallback(commtext, XmNactivateCallback, (XtCallbackProc) command_input,
		(XtPointer) commscroll);
  XtAddCallback(commscroll, XmNbrowseSelectionCallback,
			(XtCallbackProc) command_scroll, (XtPointer) commtext);

  temp = mib_find_name(commandsload, "UpButton")->me;
  XtVaGetValues(temp, XmNforeground, &fg,
			XmNbackground, &bg, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		up_arrow_bits, up_arrow_width, up_arrow_height, fg, bg, depth);
  XtVaSetValues(temp, XmNlabelType, XmPIXMAP,
			XmNlabelPixmap, button_pix, NULL);
  XtAddCallback(temp, XmNactivateCallback, (XtCallbackProc) command_up,
		(XtPointer) commscroll);

  temp = mib_find_name(commandsload, "DownButton")->me;
  XtVaGetValues(temp, XmNforeground, &fg,
			XmNbackground, &bg, XmNdepth, &depth, NULL);
  button_pix = XCreatePixmapFromBitmapData(dpy, DefaultRootWindow(dpy),
		down_arrow_bits, down_arrow_width, down_arrow_height,
		fg, bg, depth);
  XtVaSetValues(temp, XmNlabelType, XmPIXMAP,
			XmNlabelPixmap, button_pix, NULL);
  XtAddCallback(temp, XmNactivateCallback, (XtCallbackProc) command_down,
		(XtPointer) commscroll);


/*****************************************************************************/

  AProtocol = XmInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol, (XtCallbackProc) hide_commands, NULL);

  num_items = 0;
  loaded = 1;
}


/*****************************************************************************/

void ui_show_commandspanel()
{
  if (!loaded)
    ui_load_commandspanel();

  if (pos_later)
  {
    XtMoveWidget(shell, (Position)posx, (Position)posy);
    pos_later = 0;
  }

  XtRealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
}

/*****************************************************************************/

void ui_hide_commandspanel()
{
  if (!loaded)
    return;

  XtUnrealizeWidget(shell);
}

/*****************************************************************************/

void ui_move_commandspanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (!pos_later)
    XtMoveWidget(shell, (Position)x, (Position)y);
}

/*****************************************************************************/

static void hide_commands(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_COMMANDS, 0);
}

/*****************************************************************************/

static void command_input(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  Widget commscroll = (Widget)data;
  XmString addlist;
  char *str;

  str = XmTextFieldGetString(w);
  if (!strlen(str))
  {
    XtFree(str);
    return;
  }
  comm_object(str, &CommandOps, NULL, NULL, COMM_NOW);

  addlist = XmStringCreate(str, XmSTRING_DEFAULT_CHARSET);
  XtFree(str);

  XmListAddItemUnselected(commscroll, addlist, 0);
  num_items++;
}

/*****************************************************************************/

static void command_scroll(Widget w, XtPointer data, XmListCallbackStruct *cbs)
{
  Widget commtext = (Widget)data;

  char *temp;

  if (!XmStringGetLtoR(cbs->item, XmSTRING_DEFAULT_CHARSET, &temp))
    return;

  if (!*temp)
    return;

  XmTextFieldSetString(commtext, temp);
  XtFree(temp);

}

/*****************************************************************************/

static void command_up(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  Widget commscroll = (Widget)data;
  int *poslist, poscount, pos;

  if (!XmListGetSelectedPos(commscroll, &poslist, &poscount))
  {
    if (!num_items)
      return;
    XmListSelectPos(commscroll, 0, True);
  }
  if (!poscount)
    return;
  pos = poslist[0]-1;
  if (pos<0)
    pos = num_items-1;
  if (pos<0)
    pos = 0;
  XmListSelectPos(commscroll, pos, True);
}

/*****************************************************************************/

static void command_down(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  Widget commscroll = (Widget)data;
  int *poslist, poscount, pos;

  if (!XmListGetSelectedPos(commscroll, &poslist, &poscount))
  {
    if (!num_items)
      return;
    XmListSelectPos(commscroll, 0, True);
  }
  if (!poscount)
    return;
  pos = poslist[0]+1;
  if (pos>num_items)
    pos = 1;

  XmListSelectPos(commscroll, pos, True);
}

/*****************************************************************************/
