#include "mibload.h"
#include "mg.h"
#include "../common/drawer.h"
#include "../common/lights.h"
#include "../common/ui.h"
#include "gvui.h"
#include "interface/Color.mib"

extern Display *dpy;
extern GC       mib_gc;
extern Pixmap   geomicon;

/* public methods */
/*****************************************************************************/

void ui_config_colorpanel(char *, Color *, int, int, int);

/* private methods and variables */
/*****************************************************************************/

static Pixel ui_RGB(float, float, float);
static void hide_color(Widget, XtPointer, XmAnyCallbackStruct *);
static void reset_color(Widget, XtPointer, XmAnyCallbackStruct *);
static void rgb_sliders(Widget, XtPointer, XmScaleCallbackStruct *);
static void set_rgb_sliders(Widget, XtPointer, XmAnyCallbackStruct *);
static void set_rgbtext();
static void set_rgbtest();
static Widget shell,
	      RGBText,
	      RGBTest,
	      SliderR,
	      SliderG,
	      SliderB;
static Color oldc;
static Color rgb;
static int   shown, myindex, myval, colortarget, loaded = 0;
static int    pos_later = 0, posx = 0, posy = 0;
static char  geometry[40];

/*****************************************************************************/

void ui_load_colorpanel()
{
  Arg	     args[20];
  int	     n, decor, menu;

  XVisualInfo vTemplate;
  XVisualInfo *visualList;
  int         visualsMatched;

  Widget     colorform,
	     DoneButton,
	     CancelButton;

  mib_Widget *colorload;
  Atom       AProtocol;

/*****************************************************************************/

  n = 0;

  XtSetArg(args[n], XmNvisual, gvvisual); n++;
  XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
  XtSetArg(args[n], XmNcolormap, gvcolormap); n++;

/*****************************************************************************/

  XtSetArg(args[n], XmNtitle, "Color"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNkeyboardFocusPolicy, XmPOINTER); n++;
  XtSetArg(args[n], XmNwidth, 208); n++;
  XtSetArg(args[n], XmNheight, 139); n++;
  XtSetArg(args[n], XmNminWidth, 208); n++;
  XtSetArg(args[n], XmNmaxWidth, 208); n++;
  XtSetArg(args[n], XmNminHeight, 139); n++;
  XtSetArg(args[n], XmNmaxHeight, 139); n++;
  if (pos_later)
  {
    sprintf(geometry, "=+%d+%d", posx, posy);
    XtSetArg(args[n], XmNgeometry, geometry); n++;
    pos_later = 0;
  }

  shell = XtAppCreateShell("Color", "gv", topLevelShellWidgetClass, dpy,
				args, n);

  XtVaSetValues(shell, XmNiconPixmap, geomicon, NULL);

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Color"); n++;

  colorform = XmCreateForm(shell, "Color", args, n);
/*colorload = mib_load_interface(colorform, "interface/Color.mib",
		MI_FROMFILE);*/
  colorload = mib_load_interface(colorform, Root,
		MI_FROMSTRING);
 
  XtManageChild(colorform);

/*****************************************************************************/

  DoneButton = mib_find_name(colorload, "DoneButton")->me;
  CancelButton = mib_find_name(colorload, "CancelButton")->me;
  XtAddCallback(DoneButton, XmNactivateCallback, (XtCallbackProc) hide_color,
		NULL);
  XtAddCallback(CancelButton, XmNactivateCallback, (XtCallbackProc) reset_color,
		NULL);

  SliderR = mib_find_name(colorload, "RScale")->me;
  XtAddCallback(SliderR, XmNvalueChangedCallback, (XtCallbackProc) rgb_sliders,
			(XtPointer) 0);
  XtAddCallback(SliderR, XmNdragCallback, (XtCallbackProc) rgb_sliders,
			(XtPointer) 0);
  XtVaSetValues(SliderR, XmNmaximum, 255, NULL);

  SliderG = mib_find_name(colorload, "GScale")->me;
  XtAddCallback(SliderG, XmNvalueChangedCallback, (XtCallbackProc) rgb_sliders,
			(XtPointer) 1);
  XtAddCallback(SliderG, XmNdragCallback, (XtCallbackProc) rgb_sliders,
			(XtPointer) 1);
  XtVaSetValues(SliderG, XmNmaximum, 255, NULL);

  SliderB = mib_find_name(colorload, "BScale")->me;
  XtAddCallback(SliderB, XmNvalueChangedCallback, (XtCallbackProc) rgb_sliders,
			(XtPointer) 2);
  XtAddCallback(SliderB, XmNdragCallback, (XtCallbackProc) rgb_sliders,
			(XtPointer) 2);
  XtVaSetValues(SliderB, XmNmaximum, 255, NULL);

  RGBText = mib_find_name(colorload, "RGBText")->me;
  XtAddCallback(RGBText, XmNactivateCallback, (XtCallbackProc) set_rgb_sliders,
		NULL);

  RGBTest = mib_find_name(colorload, "ColorTest")->me;
  XtAddCallback(RGBTest, XmNexposeCallback, (XtCallbackProc) set_rgbtest,
			NULL);

/*****************************************************************************/

  AProtocol = XmInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol, (XtCallbackProc) reset_color, NULL);

  decor = MWM_DECOR_BORDER | MWM_DECOR_TITLE | MWM_DECOR_MENU |
                MWM_DECOR_MINIMIZE;
  menu = MWM_FUNC_MOVE | MWM_FUNC_MINIMIZE | MWM_FUNC_CLOSE;
  XtVaSetValues(shell, XmNmwmDecorations, decor, XmNmwmFunctions, menu, NULL);

  rgb.r = 0.0; rgb.g = 0.0; rgb.b = 0.0;
  oldc.r = 0.0; oldc.g = 0.0; oldc.b = 0.0;

  shown = 0;
  set_rgbtext();
  loaded = 1;
}


/*****************************************************************************/

void ui_show_colorpanel()
{
  if (!loaded)
    return;

  if (pos_later)
  {
    XtMoveWidget(shell, (Position)posx, (Position)posy);
    pos_later = 0;
  }

  XtRealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
  shown = 1;
}

/*****************************************************************************/

void ui_hide_colorpanel()
{
  if (!loaded)
    return;

  XtUnrealizeWidget(shell);
  shown = 0;
}

/*****************************************************************************/

void ui_move_colorpanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (!pos_later)
    XtMoveWidget(shell, (Position)x, (Position)y);
}


/*****************************************************************************/

static void hide_color(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_COLOR, 0);
}

/*****************************************************************************/

static void reset_color(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  rgb = oldc;
  set_rgbtest();
  ui_showpanel(P_COLOR, 0);
}

/*****************************************************************************/

static void set_rgbtest()
{
  if (shown)
  {
    XSetForeground(dpy, mib_gc, ui_RGB(rgb.r, rgb.g, rgb.b));
    XFillRectangle(dpy, XtWindow(RGBTest), mib_gc, 0, 0, 64, 96);
  }

  if (myval == DRAWER_BACKCOLOR)
    gv_backcolor(colortarget, rgb.r, rgb.g, rgb.b);
  else
    if (myval == DRAWER_LIGHTCOLOR)
      set_light_color(&rgb);
  else
    if (myval == DRAWER_BBOXCOLOR)
      gv_bbox_color( colortarget, rgb.r, rgb.g, rgb.b);
  else
    drawer_color(colortarget, myval, &rgb);
}

/*****************************************************************************/

static void set_rgbtext()
{
  char str[100];

  sprintf(str, "%.3f %.3f %.3f", rgb.r, rgb.g, rgb.b);
  XmTextFieldSetString(RGBText, str);
  set_rgbtest();
}

/*****************************************************************************/

static void set_rgb_sliders(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  char *str;
  float colr, colg, colb;

  str = XmTextFieldGetString(w);

  if (3 == sscanf(str,"%f %f %f", &colr, &colg, &colb))
  {
    if ((colr < 0.0 ) || (colr > 1.0))
      colr = 0.0;
    if ((colg < 0.0 ) || (colg > 1.0))
      colg = 0.0;
    if ((colb < 0.0 ) || (colb > 1.0))
      colb = 0.0;

    rgb.r = colr;
    rgb.g = colg;
    rgb.b = colb;
    XmScaleSetValue(SliderR, (int)(255.0 * rgb.r));
    XmScaleSetValue(SliderG, (int)(255.0 * rgb.g));
    XmScaleSetValue(SliderB, (int)(255.0 * rgb.b));
  }

  set_rgbtext();
  XtFree(str);
}

/*****************************************************************************/

static void rgb_sliders(Widget w, XtPointer data, XmScaleCallbackStruct *cbs)
{
  int component = (int)data;

  if (component == 0)
    rgb.r = ((float)cbs->value)/255.0;
  else
    if (component == 1)
      rgb.g = ((float)cbs->value)/255.0;
  else
    if (component == 2)
      rgb.b = ((float)cbs->value)/255.0;

  set_rgbtext();

}

/*****************************************************************************/

void ui_config_colorpanel(char *name, Color *old, int index, int val,
				int id)
{
  rgb = *old;
  oldc = *old;

  if (rgb.r > 1.0) rgb.r /= 255.0;
  if (rgb.g > 1.0) rgb.g /= 255.0;
  if (rgb.b > 1.0) rgb.b /= 255.0;

  myindex = index; myval = val;
  colortarget = id;

  XtVaSetValues(shell, XmNtitle, name, NULL);
  XmScaleSetValue(SliderR, (int)(255.0 * rgb.r));
  XmScaleSetValue(SliderG, (int)(255.0 * rgb.g));
  XmScaleSetValue(SliderB, (int)(255.0 * rgb.b));
  set_rgbtext();
}

/*****************************************************************************/

static Pixel ui_RGB(float r, float g, float b)
{

#ifdef MGX11

  if (gvbitdepth == 24)
  {
    XColor	col;

    col.red = (unsigned short)(r*65535.0);
    col.green = (unsigned short)(g*65535.0);
    col.blue = (unsigned short)(b*65535.0);

    if (XAllocColor(dpy, gvcolormap, &col))
      return col.pixel;
  }
  else
  if (gvbitdepth == 8)
    return mgx11_setRGB((int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b));
  else
    return WhitePixel(dpy, DefaultScreen(dpy)); /* can't handle 1 bit yet */

#endif

#ifdef MGGL
    XColor	col;

    col.red = (unsigned short)(r*65535.0);
    col.green = (unsigned short)(g*65535.0);
    col.blue = (unsigned short)(b*65535.0);

    if (XAllocColor(dpy, gvcolormap, &col))
      return col.pixel;

/*  return ui_nearestRGB(r, g, b); */
#endif

}

/*****************************************************************************/

Pixel ui_nearestRGB(float r, float g, float b)
{
#ifdef MGGL
  XColor	col;

  col.red = (unsigned short)(r*65535.0);
  col.green = (unsigned short)(g*65535.0);
  col.blue = (unsigned short)(b*65535.0);

  if (XAllocColor(dpy,
		  DefaultColormap(dpy, DefaultScreen(dpy)),
		  &col)
     )

    return col.pixel;

  else
  {
    fprintf(stderr, "Could not allocate color.\n");
    return WhitePixel(dpy, DefaultScreen(dpy));
  }
#endif

#ifdef MGX11
  return mgx11_RGB((int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b));
#endif
}

/*****************************************************************************/
