#include "mibload.h"
#include "../common/drawer.h"
#include "../common/ui.h"
#include "gvui.h"
#ifdef MGGL
  #include <gl/gl.h>
  #include <X11/Xirisw/GlxMDraw.h>
#endif

extern Display *dpy;
extern UIState  uistate;
extern Pixmap   geomicon;

/* private methods and variables */
/*****************************************************************************/

static int oldstderr;
static void ui_delete_camera(Widget, XtPointer, XmAnyCallbackStruct *);

/*****************************************************************************/

Widget ui_create_camera(Widget parent, Widget *camret, DView *dv, int *depth,
			Visual **visual)
{
  Arg	 args[20];
  int	 n, sx, sy;
  char  *title;
  Atom   AProtocol;
  Widget shell, camform, camdraw;
  WnPosition prefpos;
  int haspref;
  static char geometry[30];

#ifdef MGGL
  static GLXconfig db_rgb_desc[] = {
   { GLX_NORMAL, GLX_RGB, TRUE},
   { GLX_NORMAL, GLX_DOUBLE, TRUE},
   { GLX_NORMAL, GLX_ZSIZE, GLX_NOCONFIG },
   { 0,0,0 }
  };
#endif

/*****************************************************************************/

  WnGet(dv->win, WN_XSIZE, &sx);
  WnGet(dv->win, WN_YSIZE, &sy);
  WnGet(dv->win, WN_NAME, &title);
  haspref = WnGet(dv->win, WN_PREFPOS, &prefpos);

  n = 0;

  XtSetArg(args[n], XmNvisual, gvvisual); n++;
  XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
  XtSetArg(args[n], XmNcolormap, gvcolormap); n++;

  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNtitle, title); n++;
  XtSetArg(args[n], XmNwidth, sx); n++;
  XtSetArg(args[n], XmNheight, sy); n++;
  if(haspref > 0) {
    sprintf(geometry, "=%dx%d+%d-%d",
	prefpos.xmax-prefpos.xmin+1, prefpos.ymax-prefpos.ymin+1,
	prefpos.xmin, prefpos.ymin);
    XtSetArg(args[n], XmNgeometry, geometry); n++;
  }

/*****************************************************************************/

  oldstderr = dup(fileno(stderr));
  freopen("/dev/null", "w", stderr);

  shell = XtAppCreateShell(title, "gv", topLevelShellWidgetClass,
				dpy, args, n);

  XtVaSetValues(shell, XmNiconPixmap, geomicon, NULL);

  camform = shell;

/*****************************************************************************/

#ifdef MGX11
  n = 0;
  XtSetArg(args[n], XmNtitle, title); n++;
  XtSetArg(args[n], XmNwidth, sx); n++;
  XtSetArg(args[n], XmNheight, sy); n++;
  XtSetArg(args[n], XmNrubberPositioning, False); n++;
#endif

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNwidth, sx); n++;
  XtSetArg(args[n], XmNheight, sy); n++;

#ifdef MGX11
  camdraw = XtCreateManagedWidget("camdraw", xmDrawingAreaWidgetClass, camform,
		args, n);
#endif

#ifdef MGGL
  XtSetArg (args[n], GlxNglxConfig, db_rgb_desc); n++;

  camdraw = GlxCreateMDraw(shell, "camdraw", args, n);
#endif
  
/*****************************************************************************/

  *camret = camdraw;

  AProtocol = XmInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol, (XtCallbackProc) ui_delete_camera,
			(caddr_t)dv);

  freopen("/dev/null", "w", stderr);
  dup2(oldstderr, fileno(stderr));
  close(oldstderr);

  return shell;
}

/*****************************************************************************/

static void ui_delete_camera(Widget w, XtPointer data,
			XmAnyCallbackStruct *cbs)
{
  extern int real_id(int);
  DView *dv = (DView *)data;

  gv_delete(dv->id);
  uistate.targetcam = INDEXOF(FOCUSID);
  ui_target_cameraspanel(real_id(FOCUSID));

#ifdef MGGL
  XtDestroyWidget(XtParent(w));
#endif

}

/*****************************************************************************/
