#include <X11/X.h>
#include "mibload.h"
#include "mibwidgets.h"
#include "../common/drawer.h"
#include "../common/ui.h"
#include "../common/lang.h"
#include "gvui.h"
#include "interface/Cameras.mib"

extern Display *dpy;
extern Pixmap   geomicon;

/* public methods */
/*****************************************************************************/

void   ui_target_cameraspanel(int);

/* private methods and variables */
/*****************************************************************************/

static void hide_cameras(Widget, XtPointer, XmAnyCallbackStruct *);
static void background_color(Widget, XtPointer, XmAnyCallbackStruct *);
static void soft_shading(Widget, XtPointer, XmToggleButtonCallbackStruct *);
static void draw_cams(Widget, XtPointer, XmToggleButtonCallbackStruct *);
static void draw_sphere(Widget, XtPointer, XmToggleButtonCallbackStruct *);
static void toggle_dither(Widget, XtPointer, XmToggleButtonCallbackStruct *);
static void list_callbacks(Widget, XtPointer, XmListCallbackStruct *);
static void text_callbacks(Widget, XtPointer, XmAnyCallbackStruct *);
static void depth_callbacks(Widget, XtPointer, XmAnyCallbackStruct *);
static void ui_float(char *, int, int, float, float);

static Widget shell,
	      ProjectList,
	      CurrentCam,
	      ModelList,
	      SphereToggle,
	      DitherToggle,
	      DrawCams,
	      NearClipText,
	      FarClipText,
	      FOVText,
	      FocalText,
	      LinesText;
mib_Widget    *DepthMenu;


static int    currentcam_id, modelpos, projpos;
static int    dither_state = 0;
static int    depth_state = 0;
static float  keepfov;
static char   lastcamname[255];
static char   store[255];
static char   geometry[40];
static int    pos_later = 0, posx = 0, posy = 0;


/*****************************************************************************/

void ui_load_cameraspanel()
{
  Arg	     args[20];
  int	     n, i, menu, decor;
  Widget     camerasform,
	     HideButton,
	     TempWidget;

  mib_Widget *camerasload;
  Atom       AProtocol;

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Cameras"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNkeyboardFocusPolicy, XmPOINTER); n++;
  XtSetArg(args[n], XmNwidth, 190); n++;
  XtSetArg(args[n], XmNminWidth, 190); n++;
  XtSetArg(args[n], XmNmaxWidth, 190); n++;
  XtSetArg(args[n], XmNheight, 496); n++;
  XtSetArg(args[n], XmNminHeight, 496); n++;
  XtSetArg(args[n], XmNmaxHeight, 496); n++;
  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }

  if (pos_later)
  {
    sprintf(geometry, "=+%d+%d", posx, posy);
    XtSetArg(args[n], XmNgeometry, geometry); n++;
    pos_later = 0;
  }


  shell = XtAppCreateShell("Cameras", "gv", topLevelShellWidgetClass, dpy,
				args, n);
  XtVaSetValues(shell, XmNiconPixmap, geomicon, NULL);

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Cameras"); n++;

  camerasform = XmCreateForm(shell, "Cameras", args, n);
/*camerasload = mib_load_interface(camerasform, "interface/Cameras.mib",
		MI_FROMFILE);*/
  camerasload = mib_load_interface(camerasform, Root,
		MI_FROMSTRING);
 
  XtManageChild(camerasform);

/*****************************************************************************/

  HideButton   = mib_find_name(camerasload, "HideButton")->me;
  ProjectList  = mib_find_name(camerasload, "ProjectList")->me;
  ModelList    = mib_find_name(camerasload, "SpaceModelList")->me;
  CurrentCam   = mib_find_name(camerasload, "CurrentLabel")->me;
  DrawCams     = mib_find_name(camerasload, "DrawCamsButton")->me;
  SphereToggle = mib_find_name(camerasload, "DrawSphereToggle")->me;
  DitherToggle = mib_find_name(camerasload, "DitherToggle")->me;
  NearClipText = mib_find_name(camerasload, "NCText")->me;
  FarClipText  = mib_find_name(camerasload, "FCText")->me;
  FOVText      = mib_find_name(camerasload, "FOVText")->me;
  FocalText    = mib_find_name(camerasload, "FLText")->me;
  LinesText    = mib_find_name(camerasload, "LCText")->me;
  DepthMenu    = mib_find_name(camerasload, "DepthMenu");

  XtAddCallback(HideButton, XmNactivateCallback, (XtCallbackProc) hide_cameras,
			(XtPointer)NULL);
  XtAddCallback(ProjectList, XmNbrowseSelectionCallback,
			(XtCallbackProc) list_callbacks,
			(XtPointer) DRAWER_PROJECTION);
  XtAddCallback(ModelList, XmNbrowseSelectionCallback,
			(XtCallbackProc) list_callbacks,
			(XtPointer) NULL);
  XtAddCallback(DrawCams, XmNvalueChangedCallback,
			(XtCallbackProc) draw_cams,
			(XtPointer) NULL);
  XtAddCallback(SphereToggle, XmNvalueChangedCallback,
			(XtCallbackProc) draw_sphere,
			(XtPointer) NULL);
  XtAddCallback(DitherToggle, XmNvalueChangedCallback,
			(XtCallbackProc) toggle_dither,
			(XtPointer) NULL);

  XtAddCallback(NearClipText, XmNactivateCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) DRAWER_NEAR);
  XtAddCallback(NearClipText, XmNlosingFocusCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) DRAWER_NEAR);

  XtAddCallback(FarClipText, XmNactivateCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) DRAWER_FAR);
  XtAddCallback(FarClipText, XmNlosingFocusCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) DRAWER_FAR);

  XtAddCallback(FOVText, XmNactivateCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) DRAWER_FOV);
  XtAddCallback(FOVText, XmNlosingFocusCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) DRAWER_FOV);

  XtAddCallback(FocalText, XmNactivateCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) DRAWER_FOCALLENGTH);
  XtAddCallback(FocalText, XmNlosingFocusCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) DRAWER_FOCALLENGTH);

  XtAddCallback(LinesText, XmNactivateCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) DRAWER_LINE_ZNUDGE);
  XtAddCallback(LinesText, XmNlosingFocusCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) DRAWER_LINE_ZNUDGE);

  for (i=0; i<3; i++)
      XtAddCallback(((mib_Menu *)DepthMenu->myres)->items[i], 
		    XmNactivateCallback, (XtCallbackProc) depth_callbacks,
		    (XtPointer) i);
		    
/*****************************************************************************/

  TempWidget = mib_find_name(camerasload, "BackColorButton")->me;
  XtAddCallback(TempWidget, XmNactivateCallback,
		(XtCallbackProc) background_color, (XtPointer) NULL);
  TempWidget = mib_find_name(camerasload, "SoftShadeButton")->me;
  XtAddCallback(TempWidget, XmNvalueChangedCallback,
		(XtCallbackProc) soft_shading, (XtPointer) NULL);

#ifdef MGX11
  XtUnmanageChild(TempWidget);
#else
  XtUnmanageChild(DepthMenu->me);
  XtUnmanageChild(DitherToggle);
#endif

  ui_build_browser(ProjectList, COUNT(proj), proj);
  ui_build_browser(ModelList, COUNT(mdl), mdl);

/*****************************************************************************/

  AProtocol = XmInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol, (XtCallbackProc) hide_cameras,
				(XtPointer) NULL);

  decor = MWM_DECOR_BORDER | MWM_DECOR_TITLE | MWM_DECOR_MENU |
                MWM_DECOR_MINIMIZE;
  menu = MWM_FUNC_MOVE | MWM_FUNC_MINIMIZE | MWM_FUNC_CLOSE;
  XtVaSetValues(shell, XmNmwmDecorations, decor, XmNmwmFunctions, menu, NULL);

  lastcamname[0] = '\0';

  modelpos = -1;
  projpos = -1;
  keepfov = 0.0;
}


/*****************************************************************************/

void ui_show_cameraspanel()
{

  if (pos_later)
  {
    XtMoveWidget(shell, (Position)posx, (Position)posy);
    pos_later = 0;
  }

  XtRealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
}

/*****************************************************************************/

void ui_hide_cameraspanel()
{
  XtUnrealizeWidget(shell);
}

/*****************************************************************************/

void ui_move_cameraspanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (!pos_later)
    XtMoveWidget(shell, (Position)x, (Position)y);
}

/*****************************************************************************/

static void hide_cameras(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_CAMERA, 0);
}

/*****************************************************************************/

static void background_color(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_pickcolor(DRAWER_BACKCOLOR);
}

/*****************************************************************************/

static void soft_shading(Widget w, XtPointer data,
				XmToggleButtonCallbackStruct *cbs)
{

   gv_soft_shader(currentcam_id, cbs->set ? ON_KEYWORD : OFF_KEYWORD);
}

/*****************************************************************************/

static void draw_cams(Widget w, XtPointer data,
				XmToggleButtonCallbackStruct *cbs)
{
  int    number;
  DView *dv;

  dv = (DView *)drawer_get_object(currentcam_id);
  number = dv ? !dv->cameradraw : 1;
  drawer_int(currentcam_id, DRAWER_CAMERADRAW, number);
}

/*****************************************************************************/

static void draw_sphere(Widget w, XtPointer data,
				XmToggleButtonCallbackStruct *cbs)
{
  drawer_int(currentcam_id, DRAWER_HSPHERE, cbs->set);
}

/*****************************************************************************/

static void toggle_dither(Widget w, XtPointer data,
				XmToggleButtonCallbackStruct *cbs)
{
  DView *dv;

  dither_state = cbs->set;

  dv = (DView *)drawer_get_object(currentcam_id);
  mgctxselect(dv->mgctx);
  mgctxset(MG_DITHER, cbs->set, MG_END);
  gv_redraw(dv->id);

}

/*****************************************************************************/

static int
getfloat(char *str, float *fp)
{
   if (sscanf(str, "%f", fp))
     return 1;
   else
     return 0;
}

/*****************************************************************************/

static void ui_float(char *str, int key, int id, float min, float max)
{
    float f;
    if(getfloat(str, &f) && strcmp(str,store)) {
        if(f < min) f = min;
        else if(f > max) f = max;
        drawer_float(id, key, f);
    } else {
        ui_select(id);
    }
}

/*****************************************************************************/

static void text_callbacks( Widget		  w,
			    XtPointer		  data,
			    XmAnyCallbackStruct *cbs )
{
  int val = (int)data;
  char *str;
  str = XmTextFieldGetString(w);
/*
  XmTextFieldSetInsertionPosition(w, (XmTextPosition) 0);
*/

  switch(val)
  {
	case DRAWER_NEAR:
	case DRAWER_FAR:
	ui_float(str, val, currentcam_id, -1e20, 1e20);
	break;

	case DRAWER_FOV:
	ui_float(str, val, currentcam_id, 1e-6, 179.999);
	break;

	case DRAWER_FOCALLENGTH:
	ui_float(str, val, currentcam_id, 1e-20, 1e20);
	break;

	case DRAWER_LINE_ZNUDGE:
	ui_float(str, val, currentcam_id, -10000., 10000.);
	break;

	default:
	break;
  
  }

  XtFree(str);

}

/*****************************************************************************/

static void list_callbacks( Widget		  w,
			    XtPointer		  data,
			    XmListCallbackStruct *cbs )
{
  int id, val = (int)data;

  if (!val)
  {
    modelpos = cbs->item_position;
    gv_hmodel(currentcam_id, hmodelkeyword("ModelBrowserProc",
		cbs->item_position - 1));
    return;
  }
  else
  if (val == DRAWER_PROJECTION)
  {
    projpos = cbs->item_position;
    id = currentcam_id;
    drawer_int( id, val, cbs->item_position - 1);
    return;
  }
  else
    OOGLError(1,"invalid val (%d) in ObscureBrowserProc", val);

  return;
}

/*****************************************************************************/

static void depth_callbacks( Widget		  w,
			    XtPointer		  data,
			    XmAnyCallbackStruct *cbs )
{
    DView *dv;
    int type = (int) data;

    depth_state = type;

    dv = (DView *)drawer_get_object(currentcam_id);
    mgctxselect(dv->mgctx);
    mgctxset(MG_DEPTHSORT, type, MG_END);
    gv_redraw(dv->id);

    return;
}

/*****************************************************************************/

void   ui_target_cameraspanel(int id)
{
  char     *name;
  XmString xname;
  DView   *dv;
  float    f;
  int      persp, depth, dither, bitdepth, exists = 0;
  extern   int id_exists(int);
  extern   int real_id(int);


  if ((exists = id_exists(real_id(id))))
    name = drawer_id2name(real_id(id));
  else
    name = "No Camera";

  currentcam_id = id;

  if (strcmp(name, lastcamname))
  {
    sprintf(lastcamname, "%s", name);

    xname = XmStringCreateSimple(name);
    XtVaSetValues(CurrentCam, XmNlabelString, xname, NULL);
    XmStringFree(xname);
  }

  if (exists)
  {
    dv = (DView *) drawer_get_object(currentcam_id);

    if ((dv->hsphere != NULL) != XmToggleButtonGetState(SphereToggle))
      XmToggleButtonSetState(SphereToggle, dv->hsphere != NULL, False);

    if (dv->cameradraw != XmToggleButtonGetState(DrawCams))
      XmToggleButtonSetState(DrawCams, dv->cameradraw, False);

#ifdef MGX11

    mgctxselect(dv->mgctx);
    mgctxget(MG_DEPTHSORT, &depth);

    if ((depth >= 0) && (depth < 3))
    {
      if (depth_state != depth)
      {
        XtVaSetValues(DepthMenu->me,
		  XmNmenuHistory, ((mib_Menu *)DepthMenu->myres)->items[depth],
		  NULL);
	depth_state = depth;
      }
    }

    mgctxget(MG_BITDEPTH, &bitdepth);
    if ((bitdepth == 1) || (bitdepth == 24))
      XtUnmanageChild(DitherToggle);
    else
    {
      mgctxget(MG_DITHER, &dither);
      if (dither_state != dither)
      {
        XmToggleButtonSetState(DitherToggle, dither, False);
        dither_state = dither;
      }
    }

#endif

    if (modelpos != (dv->hmodel + 1))
    {
      XmListSelectPos(ModelList, dv->hmodel + 1, False);
      modelpos = dv->hmodel + 1;
    }

    CamGet(dv->cam, CAM_PERSPECTIVE, &persp);
    if (projpos != (persp + 1))
    {
      XmListSelectPos(ProjectList, persp + 1, False);
      projpos = persp + 1;
    }

    CamGet(dv->cam, CAM_NEAR, &f);
    ui_set_ftext(NearClipText, f);
    CamGet(dv->cam, CAM_FAR, &f);
    ui_set_ftext(FarClipText, f);
    CamGet(dv->cam, CAM_FOV, &f);
    if (f != keepfov)
    {
      keepfov = f;
      ui_set_ftext(FOVText, f);
    }
    CamGet(dv->cam, CAM_FOCUS, &f);
    ui_set_ftext(FocalText, f);
    ui_set_itext(LinesText, (int)dv->lineznudge);
  }

}

/*****************************************************************************/
