#include "mibload.h"
#include "../common/drawer.h"
#include "../common/ui.h"
#include "gvui.h"
#include <stdlib.h>
#include "interface/Appearance.mib"

extern Display *dpy;
extern Pixmap   geomicon;

/* private methods and variables */
/*****************************************************************************/

static void hide_appearance(Widget, XtPointer, XmAnyCallbackStruct *);
static void revert_appearance(Widget, XtPointer, XmAnyCallbackStruct *);
static void ap_toggle(Widget, XtPointer, XmToggleButtonCallbackStruct *);
static void ap_color(Widget, XtPointer, XmAnyCallbackStruct *);
static void list_callbacks(Widget, XtPointer, XmListCallbackStruct *);
static void text_callbacks(Widget, XtPointer, XmAnyCallbackStruct *);
static Widget shell,
	      NormalList,
	      ShadeList,
	      FaceToggle, FaceColor,
	      EdgeToggle, EdgeColor,
	      NormalToggle, NormalColor,
	      BBoxToggle, BBoxColor,
	      BezDiceInput, NormalScaleInput,
	      LineWidthInput;

static int    NormalListSet = -1, ShadeListSet = -1;
static int    FaceSet = 0, EdgeSet = 0, NormalSet = 0, BBoxSet = 0;
static int    app_loaded = 0;
static int    pos_later = 0, posx = 0, posy = 0;
static char   store[255];
static char   geometry[40];

/*****************************************************************************/

void ui_load_appearancepanel()
{
  Arg	     args[20];
  int	     n, val, decor, menu;
  Widget     appform,
	     Temp,
	     HideButton;

  mib_Widget *appload;
  Atom       AProtocol;

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Appearance"); n++;
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING);n++;
  XtSetArg(args[n], XmNkeyboardFocusPolicy, XmPOINTER); n++;
  XtSetArg(args[n], XmNwidth, 310); n++;
  XtSetArg(args[n], XmNminWidth, 310); n++;
  XtSetArg(args[n], XmNmaxWidth, 310); n++;
  XtSetArg(args[n], XmNheight, 244); n++;
  XtSetArg(args[n], XmNminHeight, 244); n++;
  XtSetArg(args[n], XmNmaxHeight, 244); n++;
  if (gvbitdepth != 24) {
    XtSetArg(args[n], XmNvisual, gvvisual); n++;
    XtSetArg(args[n], XmNdepth, gvbitdepth); n++;
    XtSetArg(args[n], XmNcolormap, gvcolormap); n++;
  }


  if (pos_later)
  {
    sprintf(geometry, "=+%d+%d", posx, posy);
    XtSetArg(args[n], XmNgeometry, geometry); n++;
    pos_later = 0;
  }


  shell = XtAppCreateShell("Appearance", "gv", topLevelShellWidgetClass, dpy,
				args, n);

  XtVaSetValues(shell, XmNiconPixmap, geomicon, NULL);

/*****************************************************************************/

  n = 0;
  XtSetArg(args[n], XmNtitle, "Appearance"); n++;

  appform = XmCreateForm(shell, "Appearance", args, n);
/*appload = mib_load_interface(appform, "interface/Appearance.mib",
		MI_FROMFILE);*/
  appload = mib_load_interface(appform, Root,
		MI_FROMSTRING);
 
  XtManageChild(appform);

/*****************************************************************************/

  HideButton   = mib_find_name(appload, "HideButton")->me;
  NormalList   = mib_find_name(appload, "NormList")->me;
  ShadeList    = mib_find_name(appload, "ShadeList")->me;
  FaceToggle   = mib_find_name(appload, "FaceToggle")->me;
  EdgeToggle   = mib_find_name(appload, "EdgeToggle")->me;
  NormalToggle = mib_find_name(appload, "NormalToggle")->me;
  BBoxToggle   = mib_find_name(appload, "BBoxToggle")->me;
  FaceColor    = mib_find_name(appload, "FaceColor")->me;
  EdgeColor    = mib_find_name(appload, "EdgeColor")->me;
  NormalColor  = mib_find_name(appload, "NormalColor")->me;
  BBoxColor    = mib_find_name(appload, "BBoxColor")->me;
  BezDiceInput = mib_find_name(appload, "DiceInput")->me;
  NormalScaleInput = mib_find_name(appload, "NormInput")->me;
  LineWidthInput = mib_find_name(appload, "LineInput")->me;

  XtAddCallback(HideButton, XmNactivateCallback,
		(XtCallbackProc) hide_appearance, (XtPointer) shell);
  XtAddCallback(NormalList, XmNbrowseSelectionCallback,
		(XtCallbackProc) list_callbacks,
		(XtPointer) DRAWER_NORMALIZATION);
  XtAddCallback(ShadeList, XmNbrowseSelectionCallback,
		(XtCallbackProc) list_callbacks,
		(XtPointer) DRAWER_SHADING);
  XtAddCallback(FaceToggle, XmNvalueChangedCallback, (XtCallbackProc) ap_toggle,
		(XtPointer) DRAWER_FACEDRAW);
  XtAddCallback(EdgeToggle, XmNvalueChangedCallback, (XtCallbackProc) ap_toggle,
		(XtPointer) DRAWER_EDGEDRAW);
  XtAddCallback(NormalToggle, XmNvalueChangedCallback, (XtCallbackProc) ap_toggle,
		(XtPointer) DRAWER_NORMALDRAW);
  XtAddCallback(BBoxToggle, XmNvalueChangedCallback, (XtCallbackProc) ap_toggle,
		(XtPointer) DRAWER_BBOXDRAW);

  XtAddCallback(FaceColor, XmNactivateCallback, (XtCallbackProc) ap_color,
		(XtPointer) DRAWER_DIFFUSE);
  XtAddCallback(EdgeColor, XmNactivateCallback, (XtCallbackProc) ap_color,
		(XtPointer) DRAWER_EDGECOLOR);
  XtAddCallback(NormalColor, XmNactivateCallback, (XtCallbackProc) ap_color,
		(XtPointer) DRAWER_NORMALCOLOR);
  XtAddCallback(BBoxColor, XmNactivateCallback, (XtCallbackProc) ap_color,
		(XtPointer) DRAWER_BBOXCOLOR);

  val = DRAWER_BEZDICE;
  XtAddCallback(BezDiceInput, XmNactivateCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) val);
  XtAddCallback(BezDiceInput, XmNlosingFocusCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) val);

  val = DRAWER_NORMSCALE;
  XtAddCallback(NormalScaleInput, XmNactivateCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) val);
  XtAddCallback(NormalScaleInput, XmNlosingFocusCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) val);

  val = DRAWER_LINEWIDTH;
  XtAddCallback(LineWidthInput, XmNactivateCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) val);
  XtAddCallback(LineWidthInput, XmNlosingFocusCallback,
		(XtCallbackProc) text_callbacks, (XtPointer) val);

  ui_build_browser(NormalList, COUNT(norm), norm);
  ui_build_browser(ShadeList, COUNT(shades), shades);

  Temp       = mib_find_name(appload, "RevButton")->me;
  XtAddCallback(Temp, XmNactivateCallback, (XtCallbackProc) revert_appearance,
		(XtPointer) NULL);

/*****************************************************************************/

  AProtocol = XmInternAtom(dpy, "WM_DELETE_WINDOW", False);
  XmAddWMProtocolCallback(shell, AProtocol, (XtCallbackProc) hide_appearance,
		(XtPointer) NULL);

  decor = MWM_DECOR_BORDER | MWM_DECOR_TITLE | MWM_DECOR_MENU |
                MWM_DECOR_MINIMIZE;
  menu = MWM_FUNC_MOVE | MWM_FUNC_MINIMIZE | MWM_FUNC_CLOSE;
  XtVaSetValues(shell, XmNmwmDecorations, decor, XmNmwmFunctions, menu, NULL);

  app_loaded = 1;
}


/*****************************************************************************/

void ui_show_appearancepanel()
{
  if (!app_loaded)
    return;

  if (pos_later)
  {
    XtMoveWidget(shell, (Position)posx, (Position)posy);
    pos_later = 0;
  }

  XtRealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
}

/*****************************************************************************/

void ui_hide_appearancepanel()
{
  if (!app_loaded)
    return;

  XtUnrealizeWidget(shell);
}

/*****************************************************************************/

void ui_move_appearancepanel(int pos, int x, int y)
{
  pos_later = pos; posx = x; posy = y;

  if (!app_loaded)
    return;

  if (!pos_later)
    XtMoveWidget(shell, (Position)x, (Position)y);
}

/*****************************************************************************/

static void revert_appearance(Widget w, XtPointer data,
		XmAnyCallbackStruct *cbs)
{

  drawer_set_ap( GEOMID(uistate.targetgeom), NULL, NULL );

}

/*****************************************************************************/

static void hide_appearance(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_showpanel(P_APPEARANCE, 0);
}

/*****************************************************************************/

static void ap_color(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  ui_pickcolor((int)data);
}

/*****************************************************************************/

static void ap_toggle(Widget w, XtPointer data,
		XmToggleButtonCallbackStruct *cbs)
{
  drawer_int(GEOMID(uistate.targetgeom), (int)data, cbs->set);
}

/*****************************************************************************/

static void set_ap_toggle(Widget w, int *current, Appearance *ap, int flagbit)
{
  int val = (ap->flag & flagbit) ? 1 : 0;

  if (*current != val)
  {
    *current = val;
    XmToggleButtonSetState(w, *current ? True : False, False);
  }
}

/*****************************************************************************/

void ui_target_appearancepanel(int id)
{

  if (!app_loaded)
    return;

  if (ISGEOM(id))
  {
    DGeom      *dg;
    Appearance *ap;
    int         val;
    int         revert = 0;

    if ((dg = (DGeom *)drawer_get_object(id)))
    {
	ap = drawer_get_ap(id);
	revert = ap->override;

        set_ap_toggle(FaceToggle, &FaceSet, ap, APF_FACEDRAW);
        set_ap_toggle(EdgeToggle, &EdgeSet, ap, APF_EDGEDRAW);
        set_ap_toggle(NormalToggle, &NormalSet, ap, APF_NORMALDRAW);

        if (dg->bboxdraw != BBoxSet)
	{
	  BBoxSet = dg->bboxdraw;
	  XmToggleButtonSetState(BBoxToggle, BBoxSet ? True : False, False);
	}

	if ((val = (dg->normalization + 1)) != NormalListSet)
	{
	  NormalListSet = val;
	  XmListSelectPos(NormalList, val, False);
	}

	if ((val = (ap->shading - CONSTANTSHADE + 1)) != ShadeListSet)
	{
	  ShadeListSet = val;
	  XmListSelectPos(ShadeList, val, False);
	}

	ui_set_itext(BezDiceInput, dg->bezdice);
	ui_set_ftext(NormalScaleInput, ap->nscale);
	ui_set_itext(LineWidthInput, ap->linewidth);

    }


  }
}

/*****************************************************************************/

static void list_callbacks(Widget w, XtPointer data, XmListCallbackStruct *cbs)
{
  int val = (int) data;
  int offset = 0;

  switch (val)
  {
    case DRAWER_NORMALIZATION:
      NormalListSet = offset = cbs->item_position - 1;
      break;
    case DRAWER_SHADING:
      ShadeListSet = offset = cbs->item_position - 1 + CONSTANTSHADE;
      break;
    default:
      OOGLError(1, "Bogus browser callback.\n");
      return;
  }

  drawer_int(GEOMID(uistate.targetgeom), val, offset);
}

/*****************************************************************************/

static int
getfloat(char *str, float *fp)
{
   if (sscanf(str, "%f", fp))
     return 1;
   else
     return 0;
}

/*****************************************************************************/

static void ui_float(char *str, int key, int id, float min, float max)
{
    float f;
    if(getfloat(str, &f)) {
        if(f < min) f = min;
        else if(f > max) f = max;
        drawer_float(id, key, f);
    } else {
        ui_select(id);
    }

}

/*****************************************************************************/

static int
getint(char *str, int *ip)
{
   char *after;
   *ip = strtol(str, &after, 0);
   return str != after;

}

/*****************************************************************************/

static void ui_int(char *str, int key, int id, int min, int max)
{
    int i;
    if(getint(str, &i) && strcmp(str,store)) {
        if(i < min) i = min;
        else if(i > max) i = max;
        drawer_int(id, key, i);
    } else {
        ui_select(id);
    }

}

/*****************************************************************************/

static void text_callbacks(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  int val = (int)data;
  char *str;
  str = XmTextFieldGetString(w);
  XmTextFieldSetInsertionPosition(w, (XmTextPosition) 0);

  switch(val)
  {
     case DRAWER_BEZDICE:
     ui_int(str, val, GEOMID(uistate.targetgeom), 0, 999);
     break;
     case DRAWER_NORMSCALE:
     ui_float(str, val, GEOMID(uistate.targetgeom), 0.0, 999.0);
     break;
     case DRAWER_LINEWIDTH:
     ui_int(str, val, GEOMID(uistate.targetgeom), 1, 256);
     break;
     default:
     break;
  }

  XtFree(str);
}

/*****************************************************************************/
