typedef struct Motion {
  int moving_id;
  int center_id;
  int frame_id;
  void (*transform)();
  float amount[3];
  float timeunit;
  float timeleft;	/* Nonzero if bounded animation */
  int smooth;		/* Smooth animation, else linear */
  struct Motion *next;
} Motion;

void drawer_transform(
  int moving_id, int center_id, int frame_id,
  int transform_type,
  float amount[3],
  float timeunit,
  char *repeat_type,
  int smoothanim
  );

void drawer_position( int moving_id, int ref_id, char *position_type,
		     char *center );
void drawer_zoom(int id, float amount);
void drawer_scale(int id, float amount);
void set_motion(Motion *motion);
void apply_motion(Motion *motion, float dt);

void insert_motion(Motion *motion);
void apply_all_motions(float dt);
void do_motion(float dt);
void delete_motion(Motion *m);
void delete_like_motions(Motion *m);
void drawer_post_xform(int id, Transform T);

int e3space(void *data);
int h3space(void *data);

void stop_motions(int id);
int motions_exist();
int real_id(int id);

void make_center(char *objname, Point3 *pt);
void make_center_from_pick(char *objname, Pick *pick, int focalcam);

