/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef COMM_H
#define COMM_H

/*
 * comm_object() interprets a string to yield an object.
 * If the string is exactly the name of a file, open & read the file,
 * otherwise interpret it as something in that object's syntax.
 * The 'now' flag determines whether the file must be read immediately.
 *  COMM_NOW returns failure (0) if an object can't immediately be
 *	read from the file.  It reads at most one object from the file,
 *	then closes it.  If trying to guess the type of a file,
 *	you MUST use COMM_NOW.
 *  COMM_LATER reads an object if it can, but returns failure only
 *	if a file can't be opened.  However, it leaves the file open and
 *	listening for further data.  If opening something other than a plain
 *	file e.g. a named pipe, you MUST use COMM_LATER.
 */

#define	COMM_NOW	1
#define	COMM_LATER	0

extern HandleOps CommandOps, TransOps, GeomOps, CamOps, WindowOps;

extern void comm_init();

extern int comm_object(char *str, HandleOps *, Handle **hp, Ref **rp, int now);

extern int comm_read(char *kind, Pool *p);
extern int comm_route(char *str);	/* interpret str as command */
extern void gv_merge(HandleOps *ops, int id, Ref *window_or_camera);

		/* Maps string 'commands/geometry/transform/camera'
		 * into a HandleOps pointer, or NULL.
		 * Allows abbreviations.
		 */
extern HandleOps *str2ops(char *name);

extern void	loadfile(char *filename, HandleOps *defaultops, int guess);
extern emodule *emodule_run(emodule *em);
extern int	emodule_kill(emodule *em);
extern void	emodule_reap(emodule *em);

#endif /* ! COMM_H */
