/*
 * anytooff.main.c
 * author:  Celeste Fowler
 * date:  June 12, 1992
 */

#include <stdio.h>
#include "geom.h"
#include "transform.h"
#include "plutil.h"

main(int argc, char *argv[]) {
  Geom *g, *gpl, *pl = NULL;
  int i;

  if(argc > 1 && argv[1][0] == '-' && argv[1][1] != '\0') {
    fprintf(stderr, "\
Usage: %s [filename ...]  -- convert OOGL file(s) to OFF format\n\
Writes to standard output.  Reads from stdin if no file(s) specified.\n\
Produces the union of all file(s) if several are specified.\n",
	argv[0]);
    exit(1);
  }

  if(argc <= 1) {
    argc = 2;
    argv[1] = "-";
  }
  for(i = 1; i < argc; i++) {
    g = strcmp(argv[i], "-") ? GeomLoad(argv[i]) : GeomFLoad(stdin, "standard input");
    gpl = AnyToPL(g, TM_IDENTITY);
    if(pl) pl = PLCombine(pl, gpl);
    else pl = gpl;
  }
  GeomFSave(pl, stdout, NULL);
  return 0;
}

  
