5a 
 oogl/cvs     2  *  
 v        *  
 sign        
 absmant      *  
 Copyright 1993 by Stuart Levy, Geometry Center       *  >    
 type        *  0     
 float       D  :  .       
 cat     *    
 abs     *    
 op      *        :  .       
 substring       *  
 -        4         
 signum      *        >          >              *           *     
 $       *         *      *   4       
 length      *      
 .          *   4               "              *      *  
 .0000000         4              *   4           *    > 
 e            *   
 realcons               
 default_libdir   
 /usr/local/maple/lib         
 help/text/writeoogl    
 TEXT         * I 
          
 HELP FOR: writeoogl, gvplot						        w 
 	CALLING SEQUENCE:							         
 	readlib(gvplot):						      
 
	writeoogl( `filename`, 3dplot_struct );			      
 	writeoogl( 3dplot_struct );					        
 
	gvplot( 3dplot_struct );					       
 	gvplot( `geomview_name`, 3dplot_struct )			         w 
 PARAMETERS:								      
 	filename        the file which will contain the Geomview data	      
 	3dplot_struct	a Maple PLOT3D data structure			      
 	geomview_name	name of the object in the Geomview browser	       w 
 SYNOPSIS: 								       
 	writeoogl() accepts Maple PLOT3D structures and writes files	       
 	readable by Geomview.  gvplot() converts Maple PLOT3D structures        
 	and displays them immediately using Geomview, starting a copy of        
 	Geomview if necessary.      
          
 	Supported data types include the Maple structures MESH, GRID,	      
 
	CURVES, POINTS, and POLYGONS.	      
 	See ?plot3d[structure] for more information on Maple PLOT3D types.      w 
 	The Maple MESH and GRID structures are translated into Geomview's       
 	MESH and ZMESH objects, respectively, Maple CURVES and POINTS       
 	become VECT objects, and Maple POLYGONS becomes an OFF object.      w 
 	The Maple TEXT structure is not supported. Color information is         
 	supported for all objects EXCEPT for POLYGONS.		        H 
 	The form writeoogl(filename, plot_struct) writes data in OOGL       
 	(Geomview) form to the given file; writeoogl(plot) writes to the        
 	current output stream as selected by writeto().         H 
 	gvplot() normally starts the program "geomview", with no options;       
 	to specify something else, set the variable "gvcommand", as in:         
 	   gvcommand := `/usr/local/bin/gv -wpos 200x200 -c startup.gv`;        
 	before invoking gvplot().  Also, if the programs "geomview" or      
 	"togeomview" are not on your UNIX search path, set the variable         
 	   gvdirectories := `/some/dir/ectory:/some/other/directory`;       
 	to the appropriate directory (or directories separated by colons).      w 
 EXAMPLES:								         
 	my_plot := plot3d(sin(x+y), x=-Pi..Pi, y=-Pi..Pi):		        
 
	writeoogl( `sinxy.mesh`, my_plot );				         
                   Saving Maple 3D structs to Geomview file, sinxy.mesh	      
 	steiner := plot3d([ sin(2*x)*(cos(y))^2, sin(x)*sin(2*y),	      
 	      cos(x)*sin(2*y)], x=-Pi..Pi, y=-Pi..Pi):			       
 
	writeoogl( `steiner.mesh`, steiner);				        
                   Saving Maple 3D structs to Geomview file, steiner.mesh         
 	# Display it in geomview directly				       
 		gvplot( steiner );						        
 	# load in the plots package					        
 	with(plots):							         
 	trefoil := spacecurve([ -2*cos(t)- 1/2*cos(5*t)+ 3*sin(2*t),	       
               -3*cos(2*t)+ 2*sin(t)- 1/2*sin(5*t), 2*cos(3*t), t=0..2*Pi]):      
 
	writeoogl( `trefoil.vect`, trefoil);				        
                   Saving Maple 3D structs to Geomview file, trefoil.vect         
 	tetrahedra := [[1,0,0],[-1,0,0],[0,0,1]], [[1,0,0],[0,0,1],[0,1,0]],        
 	              [[0,1,0],[-1,0,0],[0,0,1]], [[1,0,0],[0,1,0],[-1,0,0]]:       
 
	Tplot :=polygonplot3d([tetrahedra]):				        
 
	writeoogl( `tetrahedra.off`, Tplot);				        
                   Saving Maple 3D structs to Geomview file, tetrahedra.off       
 	# you can even create a single file with multiple objects	      
 	all_objs := display3d( {my_plot, steiner, trefoil, Tplot} ):	       
 	writeoogl( `all.list`, all_objs );				      
                   Saving Maple 3D structs to Geomview file, all.list	        w 
 SEE ALSO: plot3d[structure]						        
 HSV2RGB  2  *  
 h        
 s         *  
 hh       
 ip       
 fp       
 p        
 q        
 t        *  
 Copyright 1990 by Foley, vanDam, Feiner, Hughes       >    0      >  "      
 RETURN      *  0     _ _   
 ERROR       *  
 Undefined color      D 	 >  "    :    :           :     
 floor       *   :  .           :  .       _      R   :  .       _        R      :  .       _        R           >        Z *  _         Z *   _        Z *   _            Z *    _           Z *    _   Z *  _     
 oogl/lprnV2  2   *  
 i          >     *   
 list          
 lprint      *     *           4     
 nops         P        *  
 0 #        
 oogl/lprnV1  2      >      *     *       *    $              *      P # &   
 oogl/lprn     
 help/text/gvplot     q 
 help/text/geomview   q 
 default_gvdirectories    H 
 default_gvcommand    
 geomview         
 find_colorlist   2  *  
 n        
 item          *  
 Copyright 1993 by Frederick Wicklin, Geometry Center          D  <        *  R 
 true        >  $     *     *   R 
 function        (       *    
 COLOR           
 COLOUR         Z *     Z *  ,  *  
 FALSE          
 writeoogl    2   *  
 header        
 ps       
 zlist        
 plist        
 llist        
 ppoint        
 j        
 totl         
 xrange       
 yrange       
 nx       
 ny       
 oldgc        
 coloron      
 colorlist        
 ccnt         
 totalverts       *  
 Copyright 1993 by Frederick Wicklin and Stuart Levy, Geometry Center          D  >  (  "   0        @    d *  
 Usage:writeoogl(`filename`,3dplot_struct); OR writeoogl(3dplot_struct);      :     0  *  @ >  &     *   
 PLOT3D         d *  
 Invalid plot structure        
 ; must be of type PLOT3D, as from plot3d(), tubeplot(), spacecurve(), etc.       >  $    @  &     *    _ *   
 string        d *  
 
Invalid file name (not string)        >  "     *      d *  
 	Empty 3D plot structure!         >   D  :  .       
 status       *         
 gc      *     
 print       *  
 
Saving Maple 3D structs to Geomview file            
 writeto     *   :  .           *  
 {LIST        <     D  :  .      :      *    >     
 FUNCTION         D  :      *       
     >     *   
 =       :      *    :  .        *    >     *  1 & :  1    *   1 :  W .    
 GRID         D  >     *   
 ..      :    D  :      *    :  1    *    :      *    >  "    D  :  .       } *    :      *   v :  .    
    *   :  .        *     *    >     *     *        *  
 { { MESH           D     *  
 { INST transform {         W *  ,  *       @     *   1              W *  ,  *      +     *                   *        W *  ,  *      >         *  
   } geom { ZMESH              *  
   } geom { CZMESH          :  .      <     <  .       D    W *   > 	 $     
 HUE      "      *  v D     *    ! *     *   v    :         $  '   .     *    ! *     *   v    $     
 RGB      "   . D     *  9    *  C v    *        v  :         $  \   .     *  S    *   v    *   v     *  
 } }         
 MESH         D 
 :   ] >  "    D  :  v   } f } >      *  
 { MESH          *  
 { CMESH             *     *      *     *     *    :    :    <  .    	     <  .         D  :      *      *    ! > 	 &    *    ! *     *                    v    H M [    *     *          v    *        v    *          v       *  
 }           
 CURVES       D 
 :     
 select      *         *  
 { VECT       :  .       
 sum     *       *        4       *   Y >   D         *    
 seq     *  a    h    *      *     f 4    D     *  Y v v <     <     ! >      *      & <     .  3 H <       M [ <     .  e  <        8    
 POLYGONS         D  :  .    
  :    <     >     *    D  :         :         $     *    (       *         D  :  v  }    *  
 { OFF           *     <     >   <     !    *  H  <     >   D     *      *      4            8    
 POINTS       D     *  
 { VECT          <        *  
 1         <        *  
 0         <     ! 8    r    *  w 8 >   D     *  
 terminal            *    *  W 
 gvplot   2   *  
 gvname       
 gvcmd        
 gvdirs         
 tmp_fname        %  D  >    
 UsEr_ID__           :       
 mod      *    
 round       *      
 rand              
 time                '    :     
 Maple         >    
 gvcommand           :    :   r >    
 gvdirectories           :    :   j :   ^ :    >  (  "  @  >   d *  
 Usage: gvplot(3dplot_structure)  -or-  gvplot(`name`, 3dplot_structure)      >  "   @ :    >  &     *   i   d *  p  y >      
 system      *              
 PATH=         
 :$PATH togeomview -Mcp        w  
 </dev/null          d *        
 gvplot: togeomview: Can't start a copy of geomview.          
 If "togeomview" or "geomview" were not found         
 try setting the variable "gvdirectories" to the name of the directory where          
 they're installed (or to a colon-separated list of directories).         :        *    
 /tmp/geomview/           *  
 (geometry                *  
 )        x    *    *    r  j