#include <stdio.h>
#include "geom.h"
#include "color.h"
#include "callbacks.h"
#include "ui.h"
#include "crayola.h"
#include "forms.h"
#include "panel.h"


main() {
  foreground();

  create_the_forms();

  fl_init();

  fl_set_button(GetButton, 1); 

  fl_set_slider_value(IntensitySlide, 1.0);
  fl_set_colorwheel_intensity(colorwheel, 1.0);
  fl_set_slider_value(AlphaSlide, 1.0);
  fl_set_colorwheel_alpha(colorwheel, 1.0);

  fl_show_form(MainForm, FL_PLACE_SIZE, TRUE, "Crayola");
 
  init();
 
  uiThaw();

  while(1) {
    fl_check_forms();
    checkpipes();
  }
}

float get_float_val(FL_OBJECT *obj) {
  float f;
  sscanf(fl_get_input(obj), "%f", &f);
  return f;
}


void set_float_val(FL_OBJECT *obj, float f) {
  char buf[64];
  sprintf(buf, "%.2f", f);
  fl_set_input(obj, buf);
}

void UndoButtonProc(FL_OBJECT *obj, long val) {
  undo();
}

void IntensityProc(FL_OBJECT *obj, long val) {
  fl_set_colorwheel_intensity(colorwheel, 
			      fl_get_slider_value(IntensitySlide));
  fl_redraw_object(colorwheel);
}

void AlphaProc(FL_OBJECT *obj, long val) {
  fl_set_colorwheel_alpha(colorwheel, fl_get_slider_value(AlphaSlide));
  fl_redraw_object(colorwheel);
}

void QuitButtonProc(FL_OBJECT *obj, long val) {
  quit();
}

void EliminateButtonProc(FL_OBJECT *obj, long val) {
}
		 
/* 
 * UI routines requried by the common routines 
 */
void uiFreeze() {
  fl_freeze_form(MainForm);
}

void uiThaw() {
  fl_unfreeze_form(MainForm);
}

int uiSet() {
  return fl_get_button(SetButton);
}

int uiSetAll() {
  return fl_get_button(SetAllButton);
}

int uiGet() {
  return fl_get_button(GetButton);
}

int uiEliminateColor() {
  return fl_get_button(EliminateButton);
}

void uiChangeColor(ColorA *color) {
  fl_set_colorwheel(colorwheel, &(color->r));
  fl_set_colorwheel_alpha(colorwheel, color->a);
  fl_set_slider_value(IntensitySlide, 
		      fl_get_colorwheel_intensity(colorwheel));
  fl_set_slider_value(AlphaSlide, color->a);
}

void uiCurrentColor(ColorA *color) {
  fl_get_colorwheel(colorwheel, &(color->r));
  color->a = fl_get_slider_value(AlphaSlide);
}

int uiQuery(char *ques1, char *ques2, char *ques3, char *res1, char *res2) 
{
  FL_OBJECT *obj = NULL;
  uiFreeze();
  fl_set_object_label(QuestionText1, ques1);
  fl_set_object_label(QuestionText2, ques2);
  fl_set_object_label(QuestionText3, ques3);
  fl_set_object_label(AnswerButton1, res1);
  fl_set_object_label(AnswerButton2, res2);
  fl_show_form(QueryForm, FL_PLACE_MOUSE, TRUE, "Crayola");
  while (1) {
    obj = fl_do_forms();
    if (obj == AnswerButton1 || obj == AnswerButton2) break;
  }
  fl_hide_form(QueryForm);
  uiThaw();
  return (obj == AnswerButton1 ? 0 : 1);
}
