
#import <stdio.h>

#import "geom.h"
#import "color.h"
#import "callbacks.h"
#import "ui.h"
#import "crayola.h"

#import "Crayola.h"

@implementation Crayola

static id selfID, modeMatrixID, currentColorID, colorPanelID;

void StdinProc(int fd, void *userDate);

- appDidInit:sender
{
  fprintf(stderr, "Doing initialization...\n");

  colorPanel = [NXColorPanel sharedInstance:1];
  [colorPanel setHideOnDeactivate:NO];
  [colorPanel setShowAlpha:1];
  [colorPanel setAction:@selector(takeColorFrom:)];
  [colorPanel setTarget:currentColor];
  [self showColorPicker:self];

  [queryPanel setAvoidsActivation:YES];
  [colorPanel setAvoidsActivation:YES];

  selfID = self;
  modeMatrixID = modeMatrix;
  currentColorID = currentColor;
  colorPanelID = colorPanel;

  DPSAddFD(0, StdinProc, NULL, 1);

  init();

  return self;
}

- appWillTerminate:sender
{
  quit();
  return self;
}

- Undo:sender
{
  undo();
  return self;
}

- showColorPicker:sender
{
  [colorPanel makeKeyAndOrderFront:self];
  return self;
}  


void StdinProc(int fd, void *userDate) {
  fprintf(stderr, "Got input\n");
  dopipes();
}


/* Routines called by the common routines. */

void uiFreeze() {
}

void uiThaw() {
}

int whichButton() {
  fprintf(stderr, "button = %d\n", [modeMatrixID selectedRow] * 2 + [modeMatrixID selectedCol]);
  
  return ([modeMatrixID selectedRow] * 2 + [modeMatrixID selectedCol]);
}

int uiGet() {
  return (whichButton() == 0 ? 1 : 0);
}

int uiSet() {
  return (whichButton() == 1 ? 1 : 0);
}

int uiSetAll() {
  return (whichButton() == 2 ? 1 : 0);
}


int uiEliminateColor() {
  return (whichButton() == 3 ? 1 : 0);
}

void uiChangeColor(ColorA *color) {
  [currentColorID setColor:NXConvertRGBAToColor(color->r, color->g, 
						color->b, color->a)];
}

void uiCurrentColor(ColorA *color) {
  NXConvertColorToRGBA([currentColorID color], 
		       &color->r, &color->g, &color->b, &color->a);
  fprintf(stderr, "%f %f %f %f\n", color->r, color->g, color->b, color->a);
}

int uiQuery(char *ques1, char *ques2, char *ques3, char *res1, char *res2)
{
  char *question;
  int response;

  question = OOGLNewNE(char, strlen(ques1) + strlen(ques2) 
		       + strlen(ques3) + 3, "uiQuery");
  strcpy(question, ques1);
  strcat(question, " ");
  strcat(question, ques2);
  strcat(question, " ");
  strcat(question, ques3);
  response =  NXRunAlertPanel("Alert", (const char *)question, 
			      (const char *)res2, 
			      (const char *)res1, NULL, NULL);
  OOGLFree(question);
  return response;
}


@end
