#include <stdio.h>
#include <math.h>
#include "mg.h"
#include "mggl.h"
#include "geom.h"
#include "mibload.h"
#include "clip.h"
#include <gl/gl.h>
#include <X11/Xirisw/GlxMDraw.h>

void wininit(Widget, XtPointer,
	GlxDrawCallbackStruct *);
void winexpose(Widget, XtPointer,
	GlxDrawCallbackStruct *);

extern Geom *theObject;

ColorA white = {1.0, 1.0, 1.0, 1.0};
ColorA red = {1.0, 0, 0, 1.0};
ColorA darkgray = {0.2, 0.2, 0.2, 1.0};
ColorA darkblue = {0, 0, .2, 1.0};
Point lightpos1 = {1, .3, .7, 0.0};
Point lightpos2 = {-0.5, 1.0, 0.5, 0.0};
ColorA lightcol2 = {0.6, 0.6, 0.6, 1.0};
Point lightpos3 = {0.0, -2.0, 1.0, 0.0};
ColorA lightcol3 = {0.4, 0.4, 0.4, 1.0};


Camera		*theCamera;
Appearance	*theAppearance;
LmLighting	*lightingModel;
LtLight		*theLight;
mgcontext	*mgctx;

void clipboard_init(Widget parent)
{
  int           n;
  Arg           args[20];
  Widget	MG_DrawArea;

  static GLXconfig db_rgb_desc[] = {
   { GLX_NORMAL, GLX_RGB, TRUE},
   { GLX_NORMAL, GLX_DOUBLE, FALSE},
   { GLX_NORMAL, GLX_ZSIZE, GLX_NOCONFIG },
   { 0,0,0 }
  };

  n = 0;
  XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNleftOffset, 110);n++;
  XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNtopOffset, 6);n++;
  XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNrightOffset, 7);n++;
  XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNbottomOffset, 8);n++;
  XtSetArg (args[n], XmNhighlightThickness, 0); n++;
  XtSetArg (args[n], GlxNglxConfig, db_rgb_desc); n++;

  MG_DrawArea = GlxCreateMDraw(parent, "mg", args, n);

  XtManageChild(MG_DrawArea);

  mmode(MVIEWING);

  XtAddCallback(MG_DrawArea, GlxNginitCallback, wininit, 0);
  XtAddCallback(MG_DrawArea, GlxNexposeCallback, winexpose, 0);

  mgdevice_GL();

  theObject = NULL;

  theCamera = CamCreate( CAM_FOV, 40.0, CAM_END );

  lightingModel = LmCreate( LM_AMBIENT, &darkgray,
			    LM_REPLACELIGHTS, 1,
			    LM_END);

  theLight = LtCreate( LT_COLOR, &white,
		       LT_POSITION, &lightpos1,
		       LT_INTENSITY, 1.0, LT_END);

  LtAppend(lightingModel, theLight);

  theLight = LtCreate( LT_COLOR, &lightcol2,
		       LT_POSITION, &lightpos2,
		       LT_INTENSITY, 1.0, LT_END);

  LtAppend(lightingModel, theLight);

  theLight = LtCreate( LT_COLOR, &lightcol3,
		       LT_POSITION, &lightpos3,
		       LT_INTENSITY, 1.0, LT_END);

  LtAppend(lightingModel, theLight);

  theAppearance = ApCreate( AP_DO, APF_FACEDRAW | APF_SHADING | APF_EDGEDRAW |
			    APF_VECTDRAW, AP_MtSet, MT_Kd, 1.0, MT_DIFFUSE,
			    &white, MT_END, AP_LGT, lightingModel,
			    AP_SHADING, APF_FLAT, AP_END);

  mgctx = mgctxcreate(MG_GLXDISPLAY, XtDisplay(MG_DrawArea),
	      MG_GLWINID, XtWindow(MG_DrawArea),
	      MG_CAMERA, theCamera, MG_BACKGROUND, &darkblue,
	      MG_APPEAR, theAppearance, MG_END);

/*  theObject = GeomLoad("dodec.quad");*/

}

void wininit(Widget w, XtPointer stuff, GlxDrawCallbackStruct *data)
{

  GLXwinset(XtDisplay(w), data->window);
  fprintf(stderr,"init!\n");
/*  color(GREEN);
  clear();*/

}

void redraw(Widget w)
{
  GLXwinset(XtDisplay(w), XtWindow(w));
  mgreshapeviewport();
  mgworldbegin();
  GeomDraw(theObject);
  mgworldend();
  gflush();
}


void winexpose(Widget w, XtPointer stuff, GlxDrawCallbackStruct *data)
{
  static float p1[] = {0.0, 0.0, 0.0};
  static float p2[] = {800.0, 800.0, 0.0};

  GLXwinset(XtDisplay(w), data->window);
  mgreshapeviewport();
  mgworldbegin();
  GeomDraw(theObject);
  mgworldend();
  gflush();
}
