/*  NDdemo.c:  external module for geomview
 *             showing a demonstration of 4d rotation
 *  version II: Nov 29, 1993        by Olaf Holt
 */

#include<stdio.h>
#include<stdlib.h>
#include "forms.h"
#include "NDdemopanels.h"

#define SPEEDCONST .3
#define SLIDERSIZE .20

float FONTSIZE = 17;

int debug = 0;
int camerasready = 0;
long winid;

extern char *getenv();
char NDviewdir[512];

char *NDviewfile(char *file)
{
static char path[512];

	sprintf(path,"%s/%s",NDviewdir,file);
	return(path);
}

main( argc, argv )
int argc; char ** argv;
{
	char *geomroot;

	foreground();

	if(argc > 1 && argv[1][1] == 'd' )  { /* debugging turned on */
		fprintf(stderr, "Debugging on.\n");
		debug = 1;
	}

	if( (geomroot = getenv("GEOMROOT")) == NULL ) {
		fprintf(stderr, "Normally, modules are run in an environment in which the GEOMROOT environment\nvariable is set, which has not been done.  This is done by the geomview\nshell script:  please check your shell script.\n");
		if ( debug != 1) exit(1);
		else sprintf(NDviewdir,"/u/gcg/ngrap/data/NDview");
	/* NOTE: tmp fix for debugging! */
	} else sprintf(NDviewdir,"%s/data/NDview",geomroot);
	
	create_the_forms();

	if((fl_load_browser(ObjectBrowser,NDviewfile("text/objectbrowser.txt"))) == NULL)
		fprintf(stderr, "Can't load %s\n",NDviewfile("text/objectbrowser.txt"));
	if((fl_load_browser(Browser,NDviewfile("text/demohelp.txt"))) == NULL)
		fprintf(stderr, "Can't load %s\n",NDviewfile("text/demohelp.txt"));
	if((fl_load_browser(SidePanelBrowser,NDviewfile("text/side.txt"))) == NULL)
		fprintf(stderr, "Can't load %s\n",NDviewfile("text/side.txt"));

	fl_hide_object(abutton);
	fl_hide_object(bbutton);
	fl_hide_object(abbutton);

	fl_set_browser_fontsize(ObjectBrowser,FONTSIZE);

	fl_set_slider_bounds(speedslider, 0.0, 1.0);
	fl_set_slider_value(speedslider, 0.0);
	fl_set_slider_size(speedslider, SLIDERSIZE);

	fl_show_form(NDdemoMainPanel,FL_PLACE_SIZE,TRUE,"Tesseract Demo");

	buttonproc (NULL,-1);  /* initialize buttons on main panel */
	Ebuttonproc (NULL,-1);  /* initialize buttons on expert panel */


	while(1) {fl_do_forms(); }
}

void ObjectBrowserproc(FL_OBJECT *obj, long i)
{
	int line = fl_get_browser(obj);

	if(!camerasready)  initialize_windows();

	switch (line) {
		case 1:     /* point button pressed */
			if((fl_load_browser(Browser,NDviewfile("text/point.txt"))) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/point.txt"));
			printf("(if (real-id g2) (progn (geometry g2 <NDview/geom/demo/point)) (load NDview/geom/demo/point))\n");
			fflush(stdout);
			break;
		case 2:     /* 2 points button pressed */
			if((fl_load_browser(Browser,NDviewfile("text/pointd.txt"))) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/pointd.txt"));
			printf("(if (real-id g2) (progn (geometry g2 <NDview/geom/demo/points)) (load NDview/geom/demo/points))\n");
			fflush(stdout);
			break;
		case 3:     /* segment button pressed */
			if((fl_load_browser(Browser,NDviewfile("text/segment.txt"))) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/segment.txt"));
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/segmentw+x+z+)) (load NDview/geom/demo/segmentw+x+z+))\n");
			fflush(stdout);
			break;
		case 4:     /* 2 segments button pressed */
			if(fl_load_browser(Browser,NDviewfile("text/segmentd.txt")) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/segmentd.txt"));
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/segmentw+x+z)) (load NDview/geom/demo/segmentw+x+z))\n");
			fflush(stdout);
			break;
		case 5:     /* square button pressed */
			if(fl_load_browser(Browser,NDviewfile("text/square.txt")) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/square.txt"));
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/squarew+x+)) (load NDview/geom/demo/squarew+x+))\n");
			fflush(stdout);
			break;
		case 6:     /* 2 squares button pressed */
			if(fl_load_browser(Browser,NDviewfile("text/squared.txt")) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/squared.txt"));
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/squarew+x)) (load NDview/geom/demo/squarew+x))\n");
			fflush(stdout);
			break;
		case 7:     /* cube button pressed */
			if(fl_load_browser(Browser,NDviewfile("text/cube.txt")) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/cube.txt"));
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/cubew+)) (load NDview/geom/demo/cubew+))\n");
			fflush(stdout);
			break;
		case 8:     /* 2 cubes button pressed */
			if(fl_load_browser(Browser,NDviewfile("text/cubed.txt")) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/cubed.txt"));
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/cubew)) (load NDview/geom/demo/cubew))\n");
			fflush(stdout);
			break;
		case 9:     /* tesseract button pressed */
			if(fl_load_browser(Browser,NDviewfile("text/tesseract.txt")) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/tesseract.txt"));
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/tesseract)) (load NDview/geom/demo/tesseract))\n");
			fflush(stdout);
			break;
	}
	fl_set_button(expertbutton,0);
	fl_set_button(helpbutton,0);
	fl_set_button(resetbutton,0);
}

void initialize_windows()
{
	long i = getgdesc(GD_XPMAX);  /* find # horiz pixels on screen */
	
	if ( i == 1024 ) {
		/* don't even show the side panel */
		fl_hide_form(NDdemoMainPanel);
		fl_set_form_position(NDdemoMainPanel,0,-1);
		winid = fl_show_form(NDdemoMainPanel,FL_PLACE_POSITION,TRUE,"Tesseract Demo");
		winset(winid);
		prefposition(8,1024-186,495,768-32);
		minsize(10,10); maxsize(1024,800);
		winconstraints();
		printf("(load NDview/scripts/startup.small.script command)\n");
		printf("(load NDview/scripts/reset.script command)\n");
		printf("(emodule-run %s/scripts/eitherwindow)\n",NDviewdir);
	} else {  /* default, larger screen */
		fl_set_form_position(SidePanel,853,0);
		fl_show_form(SidePanel,FL_PLACE_POSITION,FALSE,NULL);
		fl_hide_form(NDdemoMainPanel);
		fl_set_form_position(NDdemoMainPanel,0,-1);
		winid = fl_show_form(NDdemoMainPanel,FL_PLACE_POSITION,TRUE,"Tesseract Demo");
		winset(winid);
		minsize(10,10); maxsize(1200,900);
		winconstraints();
		printf("(load NDview/scripts/startup.big.script command)\n");
		printf("(load NDview/scripts/reset.script command)\n");
		printf("(emodule-run %s/scripts/eitherwindow)\n",NDviewdir);
	}
	camerasready = 1;
}

void buttonproc(FL_OBJECT *obj, long i)
{
	if ( i == 110 ) { /* expert button pressed */
			if(fl_load_browser(Browser,NDviewfile("text/expert.txt")) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/expert.txt"));
		    winid = fl_show_form(ExpertPanel,FL_PLACE_MOUSE,TRUE,"Expert Object Selection");
		    winset(winid);  winpop();
	} else if ( i == 120)  {  /* help button pressed */
			if(fl_load_browser(Browser,NDviewfile("text/demohelp.txt")) == NULL)
				fprintf(stderr, "Couldn't load %s\n",NDviewfile("text/demohelp.txt"));
			else fl_set_browser_topline(Browser,16);
	} else if ( i == 130)  {   /* reset button pressed */
			if(!camerasready)  initialize_windows();
			printf("(load NDview/scripts/reset.script command)\n");
			fflush(stdout);
			fl_set_slider_value(speedslider, 0.0);
	} else if(i == 99) {  /* quit button pressed */
		/* NOTE:  restore original geomview configuration? */
		printf("(if (real-id axes) (delete axes))\n");
		printf("(if (real-id g2) (delete g2))\n");
		printf("(if (real-id X_W_plane) (delete X_W_plane))\n");
		printf("(if (real-id X_Y_Z_hyperplane) (delete X_Y_Z_hyperplane))\n");
		fflush(stdout);
		system("/etc/killall eitherwindow");
		exit(0);
	} else if ( i == -1 ) {   /* initialization */
		fl_set_button(helpbutton,1);  /* pushes help button in */
		fl_set_button(stopbutton,1);  /* pushes stop button in */
	} else {
			fprintf(stderr, "Please check source: #2347\n");
	}
}

void Ebuttonproc(FL_OBJECT *obj, long i)
{
	static char cube, cubesign, square, squaresign, segment, segmentsign;
	char X,Y,Z,W, se1, se2, sq1, sq2, sq3, label[10];
	float x1val, y1val, z1val, w1val, x2val, y2val, z2val, w2val;
	static short cubeflag, squareflag, segmentflag;

	/* first figure out what each button in the tree corresponds to */
	switch (i) {
			case -1:
				/* gray is 47 (I think), and green is 60, yellow 3 */
				fl_set_object_color(cubepair4button,60,3);
				fl_set_object_color(cubeplusbutton,60,3);
				fl_set_object_color(squarepair1button,60,3);
				fl_set_object_color(squareplusbutton,60,3);
				fl_set_object_color(segmentpair2button,60,3);
				fl_set_object_color(segmentplusbutton,60,3);
				cubeflag = 4; squareflag = 10; segmentflag = 200;
				cubesign = '+'; squaresign = '+'; segmentsign = '+';
				break;
			case 12:
				segmentflag = 100; break;
			case 13:
				segmentflag = 200; break;
			case 22:
				squareflag = 10; break;
			case 23:
				squareflag = 20; break;
			case 24:
				squareflag = 30; break;
			case 32:
				cubeflag = 1; break;
			case 33:
				cubeflag = 2; break;
			case 34:
				cubeflag = 3; break;
			case 35:
				cubeflag = 4; break;
	}
	switch ( cubeflag + squareflag + segmentflag ) {
			case 111: segment = 'z'; square = 'y'; cube = 'x';
				se1 = 'z'; se2 = 'w'; sq1 = 'y'; sq2 = 'z'; sq3 = 'w'; break;
			case 112: segment = 'z'; square = 'x'; cube = 'y';
				se1 = 'z'; se2 = 'w'; sq1 = 'x'; sq2 = 'z'; sq3 = 'w'; break;
			case 113: segment = 'y'; square = 'x'; cube = 'z';
				se1 = 'y'; se2 = 'w'; sq1 = 'x'; sq2 = 'y'; sq3 = 'w'; break;
			case 114: segment = 'y'; square = 'x'; cube = 'w';
				se1 = 'y'; se2 = 'z'; sq1 = 'x'; sq2 = 'y'; sq3 = 'z'; break;
			case 121: segment = 'y'; square = 'z'; cube = 'x';
				se1 = 'y'; se2 = 'w'; sq1 = 'y'; sq2 = 'z'; sq3 = 'w'; break;
			case 122: segment = 'x'; square = 'z'; cube = 'y';
				se1 = 'x'; se2 = 'w'; sq1 = 'x'; sq2 = 'z'; sq3 = 'w'; break;
			case 123: segment = 'x'; square = 'y'; cube = 'z';
				se1 = 'x'; se2 = 'w'; sq1 = 'x'; sq2 = 'y'; sq3 = 'w'; break;
			case 124: segment = 'x'; square = 'y'; cube = 'w';
				se1 = 'x'; se2 = 'z'; sq1 = 'x'; sq2 = 'y'; sq3 = 'z'; break;
			case 131: segment = 'y'; square = 'w'; cube = 'x';
				se1 = 'y'; se2 = 'z'; sq1 = 'y'; sq2 = 'z'; sq3 = 'w'; break;
			case 132: segment = 'x'; square = 'w'; cube = 'y';
				se1 = 'x'; se2 = 'z'; sq1 = 'x'; sq2 = 'z'; sq3 = 'w'; break;
			case 133: segment = 'x'; square = 'w'; cube = 'z';
				se1 = 'x'; se2 = 'y'; sq1 = 'x'; sq2 = 'y'; sq3 = 'w'; break;
			case 134: segment = 'x'; square = 'z'; cube = 'w';
				se1 = 'x'; se2 = 'y'; sq1 = 'x'; sq2 = 'y'; sq3 = 'z'; break;
			case 211: segment = 'w'; square = 'y'; cube = 'x';
				se1 = 'z'; se2 = 'w'; sq1 = 'y'; sq2 = 'z'; sq3 = 'w'; break;
			case 212: segment = 'w'; square = 'x'; cube = 'y';
				se1 = 'z'; se2 = 'w'; sq1 = 'x'; sq2 = 'z'; sq3 = 'w'; break;
			case 213: segment = 'w'; square = 'x'; cube = 'z';
				se1 = 'y'; se2 = 'w'; sq1 = 'x'; sq2 = 'y'; sq3 = 'w'; break;
			case 214: segment = 'z'; square = 'x'; cube = 'w';
				se1 = 'y'; se2 = 'z'; sq1 = 'x'; sq2 = 'y'; sq3 = 'z'; break;
			case 221: segment = 'w'; square = 'z'; cube = 'x';
				se1 = 'y'; se2 = 'w'; sq1 = 'y'; sq2 = 'z'; sq3 = 'w'; break;
			case 222: segment = 'w'; square = 'z'; cube = 'y';
				se1 = 'x'; se2 = 'w'; sq1 = 'x'; sq2 = 'z'; sq3 = 'w'; break;
			case 223: segment = 'w'; square = 'y'; cube = 'z';
				se1 = 'x'; se2 = 'w'; sq1 = 'x'; sq2 = 'y'; sq3 = 'w'; break;
			case 224: segment = 'z'; square = 'y'; cube = 'w';
				se1 = 'x'; se2 = 'z'; sq1 = 'x'; sq2 = 'y'; sq3 = 'z'; break;
			case 231: segment = 'z'; square = 'w'; cube = 'x';
				se1 = 'y'; se2 = 'z'; sq1 = 'y'; sq2 = 'z'; sq3 = 'w'; break;
			case 232: segment = 'z'; square = 'w'; cube = 'y';
				se1 = 'x'; se2 = 'z'; sq1 = 'x'; sq2 = 'z'; sq3 = 'w'; break;
			case 233: segment = 'y'; square = 'w'; cube = 'z';
				se1 = 'x'; se2 = 'y'; sq1 = 'x'; sq2 = 'y'; sq3 = 'w'; break;
			case 234: segment = 'y'; square = 'z'; cube = 'w';
				se1 = 'x'; se2 = 'y'; sq1 = 'x'; sq2 = 'y'; sq3 = 'z'; break;
			default:
				fprintf(stderr, "Please check source: #29388438\n");
	}

	switch (i) {
		case -1:    /* initialization */
			break;
		case 0:     /* point pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/point)) (load NDview/geom/demo/point))\n");
			fflush(stdout);
			break;
		case 2:     /* point pair pressed */
			X = Y = Z = W = '0';
			x1val = y1val = z1val = w1val = x2val = y2val = z2val = w2val = .4;
			if ( segment == 'x' )  X = segmentsign;
			else if ( segment == 'y' ) Y = segmentsign;
			else if ( segment == 'z' ) Z = segmentsign;
			else if ( segment == 'w' ) W = segmentsign;
			else fprintf(stderr,"Please check source: #29384\n");
			if ( square == 'x' ) X = squaresign;
			else if ( square == 'y' ) Y = squaresign;
			else if ( square == 'z' ) Z = squaresign;
			else if ( square == 'w' ) W = squaresign;
			else fprintf(stderr,"Please check source: #29384\n");
			if ( cube == 'x' ) X = cubesign;
			else if ( cube == 'y' ) Y = cubesign;
			else if ( cube == 'z' ) Z = cubesign;
			else if ( cube == 'w' ) W = cubesign;
			else fprintf(stderr,"Please check source: #29384\n");
			if ( X == '-' ) { x1val *= -1; x2val *= -1; }
			else if ( X == '0' ) x2val *= -1;
			if ( Y == '-' ) { y1val *= -1; y2val *= -1; }
			else if ( Y == '0' ) y2val *= -1;
			if ( Z == '-' ) { z1val *= -1; z2val *= -1; }
			else if ( Z == '0' ) z2val *= -1;
			if ( W == '-' ) { w1val *= -1; w2val *= -1; }
			else if ( W == '0' ) w2val *= -1;
					
			printf("(if (real-id g2) (progn (geometry g2  { appearance {shading smooth} 4VECT 2 2 1 1 1 1 0 %f %f %f %f %f %f %f %f 1 1 1 1})))\n",x1val, y1val, z1val, w1val, x2val, y2val, z2val, w2val);
			/* NOTE:  need to add the else case */
			fflush(stdout);
			break;
		case 10:    /* segment plus pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/segment%c%c%c%c%c+)) (load NDview/geom/demo/segment%c%c%c%c%c+))\n",cube,cubesign,square,squaresign,segment,cube,cubesign,square,squaresign,segment);
			fflush(stdout);
			segmentsign = '+';
			fl_set_object_color(segmentplusbutton,60,3);
			fl_set_object_color(segmentminusbutton,47,47);
			break;
		case 11:    /* segment minus pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/segment%c%c%c%c%c-)) (load NDview/geom/demo/segment%c%c%c%c%c-))\n",cube,cubesign,square,squaresign,segment,cube,cubesign,square,squaresign,segment);
			fflush(stdout);
			segmentsign = '-';
			fl_set_object_color(segmentminusbutton,60,3);
			fl_set_object_color(segmentplusbutton,47,47);
			break;
		case 12:    /* segment pair 1 pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/segment%c%c%c%c%c)) (load NDview/geom/demo/segment%c%c%c%c%c))\n",cube,cubesign,square,squaresign,segment,cube,cubesign,square,squaresign,segment);
			fflush(stdout);
			fl_set_object_color(segmentpair1button,60,3);
			fl_set_object_color(segmentpair2button,47,47);
			break;
		case 13:    /* segment pair 2 pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/segment%c%c%c%c%c)) (load NDview/geom/demo/segment%c%c%c%c%c))\n",cube,cubesign,square,squaresign,segment,cube,cubesign,square,squaresign,segment);
			fflush(stdout);
			fl_set_object_color(segmentpair2button,60,3);
			fl_set_object_color(segmentpair1button,47,47);
			break;
		case 20:    /* square plus pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/square%c%c%c+)) (load NDview/geom/demo/square%c%c%c+))\n",cube,cubesign,square,cube,cubesign,square);
			fflush(stdout);
			squaresign = '+';
			fl_set_object_color(squareplusbutton,60,3);
			fl_set_object_color(squareminusbutton,47,47);
			break;
		case 21:    /* square minus pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/square%c%c%c-)) (load NDview/geom/demo/square%c%c%c-))\n",cube,cubesign,square,cube,cubesign,square);
			fflush(stdout);
			squaresign = '-';
			fl_set_object_color(squareminusbutton,60,3);
			fl_set_object_color(squareplusbutton,47,47);
			break;
		case 22:    /* square pair 1 pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/square%c%c%c)) (load NDview/geom/demo/square%c%c%c))\n",cube,cubesign,square,cube,cubesign,square);
			fflush(stdout);
			fl_set_object_color(squarepair1button,60,3);
			fl_set_object_color(squarepair2button,47,47);
			fl_set_object_color(squarepair3button,47,47);
			break;
		case 23:    /* square pair 2 pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/square%c%c%c)) (load NDview/geom/demo/square%c%c%c))\n",cube,cubesign,square,cube,cubesign,square);
			fflush(stdout);
			fl_set_object_color(squarepair2button,60,3);
			fl_set_object_color(squarepair1button,47,47);
			fl_set_object_color(squarepair3button,47,47);
			break;
		case 24:    /* square pair 3 pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/square%c%c%c)) (load NDview/geom/demo/square%c%c%c))\n",cube,cubesign,square,cube,cubesign,square);
			fflush(stdout);
			fl_set_object_color(squarepair3button,60,3);
			fl_set_object_color(squarepair1button,47,47);
			fl_set_object_color(squarepair2button,47,47);
			break;
		case 30:    /* cube plus pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/cube%c+)) (load NDview/geom/demo/cube%c+))\n",cube,cube);
			fflush(stdout);
			cubesign = '+';
			fl_set_object_color(cubeplusbutton,60,3);
			fl_set_object_color(cubeminusbutton,47,47);
			break;
		case 31:    /* cube minus pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/cube%c-)) (load NDview/geom/demo/cube%c-))\n",cube,cube);
			fflush(stdout);
			cubesign = '-';
			fl_set_object_color(cubeminusbutton,60,3);
			fl_set_object_color(cubeplusbutton,47,47);
			break;
		case 32:    /* cube pair 1 pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/cubex)) (load NDview/geom/demo/cubex))\n");
			fflush(stdout);
			fl_set_object_color(cubepair1button,60,3);
			fl_set_object_color(cubepair2button,47,47);
			fl_set_object_color(cubepair3button,47,47);
			fl_set_object_color(cubepair4button,47,47);
			break;
		case 33:    /* cube pair 2 pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/cubey)) (load NDview/geom/demo/cubey))\n");
			fflush(stdout);
			fl_set_object_color(cubepair2button,60,3);
			fl_set_object_color(cubepair1button,47,47);
			fl_set_object_color(cubepair3button,47,47);
			fl_set_object_color(cubepair4button,47,47);
			break;
		case 34:    /* cube pair 3 pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/cubez)) (load NDview/geom/demo/cubez))\n");
			fflush(stdout);
			fl_set_object_color(cubepair3button,60,3);
			fl_set_object_color(cubepair2button,47,47);
			fl_set_object_color(cubepair1button,47,47);
			fl_set_object_color(cubepair4button,47,47);
			break;
		case 35:    /* cube pair 4 pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/cubew)) (load NDview/geom/demo/cubew))\n");
			fflush(stdout);
			fl_set_object_color(cubepair4button,60,3);
			fl_set_object_color(cubepair2button,47,47);
			fl_set_object_color(cubepair3button,47,47);
			fl_set_object_color(cubepair1button,47,47);
			break;
		case 40:    /* tesseract pressed */
			printf("(if (real-id g2) (progn (geometry g2 < NDview/geom/demo/tesseract)) (load NDview/geom/demo/tesseract))\n");
			fflush(stdout);
			break;
		case 99:     /* hide button pressed */
			fl_hide_form(ExpertPanel);
			break;
		default:
			fprintf(stderr, "Please check source: #493285\n");
	}
	
	sprintf(label,"%c+",segment); fl_set_object_label(segmentplusbutton,label);
	sprintf(label,"%c-",segment); fl_set_object_label(segmentminusbutton,label);
	sprintf(label,"%c",se1); fl_set_object_label(segmentpair1button,label);
	sprintf(label,"%c",se2); fl_set_object_label(segmentpair2button,label);
	sprintf(label,"%c+",square); fl_set_object_label(squareplusbutton,label);
	sprintf(label,"%c-",square); fl_set_object_label(squareminusbutton,label);
	sprintf(label,"%c",sq1); fl_set_object_label(squarepair1button,label);
	sprintf(label,"%c",sq2); fl_set_object_label(squarepair2button,label);
	sprintf(label,"%c",sq3); fl_set_object_label(squarepair3button,label);
	sprintf(label,"%c+",cube); fl_set_object_label(cubeplusbutton,label);
	sprintf(label,"%c-",cube); fl_set_object_label(cubeminusbutton,label);
	fl_redraw_form(ExpertPanel);
}

void Sbuttonproc(FL_OBJECT *obj, long i)
{
	fl_hide_form(SidePanel);
}

void speedproc(FL_OBJECT *obj, long i)
{
	float speed = fl_get_slider_value(obj);

	if (speed == 0) {
		printf("(transform g2 X_W_plane X_W_plane rotate 0 0 0)\n");
	} else {
		printf("(transform-incr g2 X_W_plane X_W_plane rotate 0 0 1.57 %f)\n",SPEEDCONST/(speed*speed));
	}
	fflush(stdout);
}
