#include <stdio.h>
#include <math.h>
#include "mibload.h"
#include <gl/gl.h>
#include <X11/Xirisw/GlxMDraw.h>
#include "coled.h"

void wininit(Widget, XtPointer,
	GlxDrawCallbackStruct *);
void winexposecedit(Widget, XtPointer,
	GlxDrawCallbackStruct *);
void winexposecbar(Widget, XtPointer,
	GlxDrawCallbackStruct *);

extern void get_my_color(Widget, short *, short *, short *);
extern colnode *get_colors();

void color_init(Widget parent, Widget *cbar, Widget *cedit)
{
  int           n;
  Arg           args[20];
  Widget	color_bar,
		color_edit;

  GLXconfig db_rgb_desc[] = {
   { GLX_NORMAL, GLX_RGB, TRUE},
   { GLX_NORMAL, GLX_DOUBLE, FALSE},
/*   { GLX_NORMAL, GLX_ZSIZE, GLX_NOCONFIG },*/
   { 0,0,0 }
  };

  n = 0;
  XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNleftOffset, 7);n++;
  XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNtopOffset, 136);n++;
  XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNrightOffset, 192);n++;
  XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNbottomOffset, 7);n++;
  XtSetArg (args[n], XmNhighlightThickness, 0); n++;
  XtSetArg (args[n], XmNwidth, 201);n++;
  XtSetArg (args[n], XmNheight, 39); n++;
  XtSetArg (args[n], GlxNglxConfig, db_rgb_desc); n++;

  color_bar = GlxCreateMDraw(parent, "color_bar", args, n);

  XtAddCallback(color_bar, GlxNginitCallback, wininit, 0);
  XtAddCallback(color_bar, GlxNexposeCallback, winexposecbar, 0);

  n = 0;
/*  XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNleftOffset, 213);n++;*/
  XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNtopOffset, 136);n++;
  XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNrightOffset, 143);n++;
  XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg (args[n], XmNbottomOffset, 7);n++;
  XtSetArg (args[n], XmNhighlightThickness, 0); n++;
  XtSetArg (args[n], XmNwidth, 44);n++;
  XtSetArg (args[n], XmNheight, 39); n++;
  XtSetArg (args[n], GlxNglxConfig, db_rgb_desc); n++;

  color_edit = GlxCreateMDraw(parent, "color_edit", args, n);

  XtAddCallback(color_edit, GlxNginitCallback, wininit, 0);
  XtAddCallback(color_edit, GlxNexposeCallback, winexposecedit, 0);

  XtManageChild(color_bar);
  XtManageChild(color_edit);

  mmode(MVIEWING);

  *cbar = color_bar;
  *cedit = color_edit;

}

void wininit(Widget w, XtPointer stuff, GlxDrawCallbackStruct *data)
{

  GLXwinset(XtDisplay(w), data->window);
  reshapeviewport();
  RGBcolor((short)0,(short)0,(short)0);
  clear();
  gflush();

}

void winexposecbar(Widget w, XtPointer stuff, GlxDrawCallbackStruct *data)
{

/*  GLXwinset(XtDisplay(w), data->window);*/
  redraw_cbar(w);
}

void winexposecedit(Widget w, XtPointer stuff, GlxDrawCallbackStruct *data)
{

  short r, g, b;

  GLXwinset(XtDisplay(w), data->window);
  reshapeviewport();
  get_my_color(w,&r,&g,&b);
  RGBcolor(r,g,b);
  clear();
  gflush();
}

void redraw_cedit(Widget w)
{

  short r, g, b;

  if (!w)
    return;

  GLXwinset(XtDisplay(w), XtWindow(w));
  reshapeviewport();
  get_my_color(w,&r,&g,&b);
  RGBcolor(r,g,b);
  clear();
  gflush();
}

void redraw_cbar(Widget w)
{
  long posx;
  float cola[3], colb[3];
  long  vec[2];
  long sx, sy;
  float scale,max,min;
  colnode *head, *tmp;

  GLXwinset(XtDisplay(w), XtWindow(w));
  reshapeviewport();
  getsize(&sx, &sy);

  head = get_colors();
  tmp = head->next;
  if (tmp != NULL)
  {
    min = tmp->depth;
    max = tmp->depth;
  }
  else
  {
    RGBcolor(0,0,0);
    clear();
    gflush();
    return;
  }
  while (tmp->next != NULL)
  {
    tmp = tmp->next;
    max = tmp->depth;
  }

  if (max == min)
  {
    cola[0] = tmp->col.r; cola[1] = tmp->col.g; cola[2] = tmp->col.b;
    RGBcolor((short)(cola[0]*255.0), (short)(cola[1]*255.0),
                        (short)(cola[2]*255.0));
    clear();
    gflush();
    return;
  }

/*  scale = (float)sx/(max-min);*/
  scale = 201.0/(max-min);


  tmp = head->next;
  while (tmp->next != NULL)
  {
    cola[0] = tmp->col.r; cola[1] = tmp->col.g; cola[2] = tmp->col.b;
    colb[0] = tmp->next->col.r; colb[1] = tmp->next->col.g;
        colb[2] = tmp->next->col.b;
    bgnpolygon();
    posx = (long)(scale*(tmp->depth-min));
    c3f(cola);
    vec[0] = posx; vec[1] = 0;
    v2i(vec);
    c3f(cola);
    vec[0] = posx; vec[1] = sy;
    v2i(vec);
    posx = (long)(scale*(tmp->next->depth-min));
    c3f(colb);
    vec[0] = posx; vec[1] = sy;
    v2i(vec);
    c3f(colb);
    vec[0] = posx; vec[1] = 0;
    v2i(vec);
    endpolygon();
    tmp = tmp->next;
  }
  gflush();
}
