#include <stdio.h>
#include <math.h>
#include "mibload.h"
#include "mib/coledit.mib"
#include "mib/axis.mib"
#include "coled.h"

extern color_init(Widget, Widget *, Widget *);
extern void redraw_cedit(Widget);
extern void redraw_cbar(Widget);

void axis_callback(Widget , XtPointer,
	XmPushButtonCallbackStruct *);
void delete_callback(Widget , XtPointer,
	XmPushButtonCallbackStruct *);
void add_callback(Widget , XtPointer,
	XmPushButtonCallbackStruct *);
void save_callback(Widget , XtPointer,
	XmPushButtonCallbackStruct *);
void exit_callback(Widget , XtPointer,
	XmPushButtonCallbackStruct *);
void scale_callback(Widget , XtPointer,
	XmScaleCallbackStruct *);
void text_to_scale(Widget , XtPointer,
	XmAnyCallbackStruct *);
void list_callback(Widget, XtPointer,
	XmListCallbackStruct *);
void get_my_color(Widget, short *, short *, short *);
colnode *get_colors();
void delete_item(colnode *, Widget, int);
void add_item(colnode *, Widget, colnode *);
int  find_item(colnode *, float);

/* global vars */
short cred, cblue, cgreen;

typedef struct _me {
    Widget	RTextBox,
		GTextBox,
		BTextBox,
		ZTextBox,
		RScale,
		GScale,
		BScale,
		ColorEdit,
		ColorBar,
		ColorList,
		AxisWindow,
		CamTextBox,
		DirTextBox;
		
    int		changedflag;
    int		listpos;
    colnode    *head;
} mylist;

mylist *global_data;

main(int argc, char **argv)
{
  XtAppContext	App;
  Widget	TopLevel,
		MainWindow,
		AxisWindow,
		AxisButton,
		DeleteButton,
		AddButton,
		SaveButton,
		ExitButton,
		PointList,
		RTextBox,
		GTextBox,
		BTextBox,
		RScale,
		GScale,
		BScale,
		ZTextBox,
		ColorDraw,
		ColorEditDraw,
		CamTextBox,
		DirTextBox;

  mylist	mine;

  int		no_mi;
  Arg		args[20];
  int		n;

  mib_Widget   *MainForm;
  mib_Widget   *AxisForm;
  String	fallbacks[] = {
	"myprog*Foreground:			gray20", /*15*/
	"myprog*Background:			gray70", /*80*/
	"myprog*XmTextField.background:	       DeepSkyBlue",
	"myprog*fontList:\
	-adobe-helvetica-medium-r-normal--14-100-100-100-p-76-iso8859-1",
	NULL};

  no_mi = 0;				/* no motif interface if no_mi = 1 */


  /* initialize application top level widget */

  TopLevel = XtVaAppInitialize(&App, "myprog", NULL, 0,
	&argc, argv, fallbacks, NULL);


  /* configure resize policy of window */

  XtVaSetValues(TopLevel, XmNminWidth, 400, XmNminHeight, 182,/* XmNmaxWidth,
			400,*/ XmNmaxHeight, 182, NULL);

  /* create the application main window widget */

  MainWindow = XtCreateManagedWidget("MainWindow",
	xmMainWindowWidgetClass, TopLevel, NULL, 0);

  n = 0;
  XtSetArg (args[n], XmNwidth, 230); n++;
  XtSetArg (args[n], XmNheight, 78); n++;
  XtSetArg (args[n], XmNminWidth, 178); n++;
  XtSetArg (args[n], XmNminHeight, 78); n++;
  XtSetArg (args[n], XmNmaxHeight, 78); n++;
  XtSetArg (args[n], XmNtitle, "Color Axis"); n++;

  AxisWindow = XmCreateFormDialog(MainWindow, "Color Axis", args, n);

  /* load the interface via the mib library */

  MainForm = mib_load_interface(MainWindow,
	Root, MI_FROMSTRING);
  AxisForm = mib_load_interface(AxisWindow,
	Axis, MI_FROMSTRING);

  if (MainForm == NULL || AxisForm == NULL)
    exit(0);

  if (!(AxisButton = (mib_find_name(MainForm, "AxisButton"))->me))
    no_mi = 1;
  if (!(DeleteButton = (mib_find_name(MainForm, "DeleteButton"))->me))
    no_mi = 1;
  if (!(ColorDraw = (mib_find_name(MainForm, "ColorDraw"))->me))
    no_mi = 1;
  if (!(ColorEditDraw = (mib_find_name(MainForm, "ColorEditDraw"))->me))
    no_mi = 1;
  if (!(ExitButton = (mib_find_name(MainForm, "ExitButton"))->me))
    no_mi = 1;
  if (!(SaveButton = (mib_find_name(MainForm, "SaveButton"))->me))
    no_mi = 1;
  if (!(AddButton = (mib_find_name(MainForm, "AddButton"))->me))
    no_mi = 1;
  if (!(PointList = (mib_find_name(MainForm, "PointList"))->me))
    no_mi = 1;
  if (!(RTextBox = (mib_find_name(MainForm, "RTextBox"))->me))
    no_mi = 1;
  if (!(GTextBox = (mib_find_name(MainForm, "GTextBox"))->me))
    no_mi = 1;
  if (!(BTextBox = (mib_find_name(MainForm, "BTextBox"))->me))
    no_mi = 1;
  if (!(ZTextBox = (mib_find_name(MainForm, "ZTextBox"))->me))
    no_mi = 1;
  if (!(RScale = (mib_find_name(MainForm, "RScale"))->me))
    no_mi = 1;
  if (!(GScale = (mib_find_name(MainForm, "GScale"))->me))
    no_mi = 1;
  if (!(BScale = (mib_find_name(MainForm, "BScale"))->me))
    no_mi = 1;
  if (!(CamTextBox = (mib_find_name(AxisForm, "CamTextBox"))->me))
    no_mi = 1;
  if (!(DirTextBox = (mib_find_name(AxisForm, "DirTextBox"))->me))
    no_mi = 1;
 
  /* if we found both widgets then add a callback to the button. This
     is called whenever the user clicks the button. If there was no
     button and/or no text box then we avoid adding the callback. */

  if (!no_mi)
  {
    mine.RTextBox = RTextBox;
    mine.GTextBox = GTextBox;
    mine.BTextBox = BTextBox;
    mine.ZTextBox = ZTextBox;
    mine.RScale = RScale;
    mine.GScale = GScale;
    mine.BScale = BScale;
    mine.changedflag = 0;
    mine.ColorList = PointList;
    mine.AxisWindow = AxisWindow;
    mine.CamTextBox = CamTextBox;
    mine.DirTextBox = DirTextBox;
    mine.head = (colnode *)malloc(sizeof(colnode));
    mine.head->next = NULL;
    mine.listpos = -1;

    global_data = &mine;

    cred = 0; cgreen = 0; cblue = 100;

    XtAddCallback(AxisButton, XmNactivateCallback, axis_callback, &mine);
    XtAddCallback(DeleteButton, XmNactivateCallback, delete_callback, &mine);
    XtAddCallback(AddButton, XmNactivateCallback, add_callback, &mine);
    XtAddCallback(SaveButton, XmNactivateCallback, save_callback, &mine);
    XtAddCallback(ExitButton, XmNactivateCallback, exit_callback, NULL);

    XtAddCallback(RScale, XmNdragCallback, scale_callback, &mine);
    XtAddCallback(GScale, XmNdragCallback, scale_callback, &mine);
    XtAddCallback(BScale, XmNdragCallback, scale_callback, &mine);
    XtAddCallback(RScale, XmNvalueChangedCallback, scale_callback, &mine);
    XtAddCallback(GScale, XmNvalueChangedCallback, scale_callback, &mine);
    XtAddCallback(BScale, XmNvalueChangedCallback, scale_callback, &mine);

    XtAddCallback(RTextBox, XmNvalueChangedCallback, text_to_scale, &mine);
    XtAddCallback(GTextBox, XmNvalueChangedCallback, text_to_scale, &mine);
    XtAddCallback(BTextBox, XmNvalueChangedCallback, text_to_scale, &mine);

    XtAddCallback(PointList, XmNbrowseSelectionCallback, list_callback, &mine);


    XmTextFieldSetString(RTextBox, "0.000000");
    XmTextFieldSetString(GTextBox, "0.000000");
    XmTextFieldSetString(BTextBox, "0.000000");
    XmTextFieldSetString(ZTextBox, "0.000000");
    XmTextFieldSetString(CamTextBox, "cluster1:1_2_3");
    XmTextFieldSetString(DirTextBox, "1 0 0 0");
  }


  /* Bring the application window up on the screen. */

  XtRealizeWidget(TopLevel);

  color_init(MainForm->me,&(mine.ColorBar),&(mine.ColorEdit));

  /* Begin main Intrinsics event loop */

  XtAppMainLoop (App);

}

void axis_callback(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs)
{
  mylist	*me = (mylist *) data;

  XtManageChild(me->AxisWindow); 
}

void delete_callback(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs)
{
  char		tmp, *str;
  mylist	*me = (mylist *) data;


  delete_item(me->head, me->ColorList, me->listpos);
  me->listpos = -1;
  redraw_cbar(me->ColorBar);
}

void add_callback(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs)
{
  char		*str;
  mylist	*me = (mylist *) data;
  colnode	*tmp;
  float		zval;


  str = XmTextFieldGetString(me->ZTextBox);

  sscanf(str,"%f",&zval);
/*  fprintf(stdout,"add color - Z = %s, r = %d, g = %d, b = %d\n", str,
		(int)cred, (int)cgreen, (int)cblue);*/

  delete_item(me->head, me->ColorList, find_item(me->head,zval));

  tmp = (colnode *)malloc(sizeof(colnode));
  tmp->depth = zval;
  (tmp->col).r = (float)cred/255.0;
  (tmp->col).g = (float)cgreen/255.0;
  (tmp->col).b = (float)cblue/255.0;

  add_item(me->head, me->ColorList, tmp);

  fflush(stdout);

  redraw_cbar(me->ColorBar);
  XtFree(str);
}

void save_callback(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs)
{
  mylist	*me = (mylist *) data;
  colnode       *tmp;
  char		*cam, *dir;

  if (!(tmp=me->head->next))
    return;

  cam = XmTextFieldGetString(me->CamTextBox);
  dir = XmTextFieldGetString(me->DirTextBox);
  fprintf(stdout,"(ND-color %s\n",cam);
  fprintf(stdout,"        (\n");
  fprintf(stdout,"          (\n");
  fprintf(stdout,"            ( %s )\n",dir);
  fprintf(stdout,"             ");


  while (tmp!=NULL)
  {
    fprintf(stdout," %f %f %f %f 1.0",tmp->depth, tmp->col.r,
		 tmp->col.g, tmp->col.b);
    tmp = tmp->next;
  }

  fprintf(stdout,"          )\n");
  fprintf(stdout,"        )\n");
  fprintf(stdout,")\n");
  fflush(stdout);

  XtFree(cam);
  XtFree(dir);
}

void exit_callback(Widget w, XtPointer data, XmPushButtonCallbackStruct *cbs)
{
  exit(0);
}

void scale_callback(Widget w, XtPointer data, XmScaleCallbackStruct *cbs)
{
  int		 val;
  float		 scaleval;
  char		 str[100];
  Widget	 text;
  mylist	*me = (mylist *) data;

  XmScaleGetValue(w, &val);

  scaleval = (float)val / 100.0;

  sprintf(str,"%f",scaleval);

  if (w == me->RScale)
  {
    text = me->RTextBox;
    cred = (short)(255.0*scaleval);
  }
  else
  if (w == me->GScale)
  {
    text = me->GTextBox;
    cgreen = (short)(255.0*scaleval);
  }
  else
  if (w == me->BScale)
  {
    text = me->BTextBox;
    cblue = (short)(255.0*scaleval);
  }

  XmTextFieldSetString(text, str);
  redraw_cedit(me->ColorEdit);
  me->changedflag = 1;
}

void text_to_scale(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  int		 val;
  float		 scaleval;
  char		*str;
  mylist	*me = (mylist *) data;
  Widget	 scale;

  if (me->changedflag)
  {
    me->changedflag = 0;
    return;
  }
  str = XmTextFieldGetString(w);

  if (1==sscanf(str,"%f",&scaleval))
  {
    val = (int)(scaleval*100.0);
    if (w == me->RTextBox)
    {
      scale = me->RScale; 
      cred = (short)(255.0*scaleval);
    }
    else
    if (w == me->GTextBox)
    {
      scale = me->GScale;
      cgreen = (short)(255.0*scaleval);
    }
    else
    if (w == me->BTextBox)
    {
      scale = me->BScale;
      cblue = (short)(255.0*scaleval);
    }

    if ((val >= 0) && (val <= 100))
      XmScaleSetValue(scale, val);
  }

  XtFree(str);
  redraw_cedit(me->ColorEdit);
}


void list_callback(Widget w, XtPointer data, XmListCallbackStruct *cbs)
{
  mylist	*me = (mylist *) data;
  int		 num;
  colnode	*tmp;
  char		 str[100];

  me->listpos = cbs->item_position;

  num = me->listpos;
  tmp = me->head;
  while (num)
  {
    tmp=tmp->next;
    num--;
  }
  sprintf(str,"%f",tmp->col.r);
  XmTextFieldSetString(me->RTextBox, str);
  sprintf(str,"%f",tmp->col.g);
  XmTextFieldSetString(me->GTextBox, str);
  sprintf(str,"%f",tmp->col.b);
  XmTextFieldSetString(me->BTextBox, str);
  sprintf(str,"%f",tmp->depth);
  XmTextFieldSetString(me->ZTextBox, str);
/*  redraw_cedit(me->ColorEdit);*/

}

void get_my_color(Widget w, short *r, short *g, short *b)
{
  *r = cred;
  *g = cgreen;
  *b = cblue;
  return;
}

void delete_item(colnode *head, Widget w, int num)
{
  colnode *tmp,*remove, *old;
  int	   del;

  if (num == -1)
    return;

  del = num;
  XmListDeletePos(w, del);
  tmp = head->next;

  if (del == 1)
  {
    remove = tmp;
    head->next = remove->next;
    free(remove);
    return;
  }

  del--;
  while (del)
  {
    old = tmp;
    tmp = tmp->next;
    del--;
  }

  old->next = tmp->next;
  free(tmp);

}

void add_item(colnode *head, Widget w, colnode *item)
{
  colnode *tmp,*old;
  int      num;
  char     strc[100];
  XmString str;
 
  sprintf(strc,"%f",item->depth);
  str = XmStringCreateLtoR(strc, XmSTRING_DEFAULT_CHARSET);

  if (head->next == NULL)
  {
    num = 1;
    head->next = item;
    item->next = NULL;
    XmListAddItem(w, str, num);
    XmStringFree(str);
    return;
  }
  else
  if (head->next->depth > item->depth)
  {
    num = 1;
    item->next = head->next;
    head->next = item;
    XmListAddItem(w, str, num);
    XmStringFree(str);
    return;
  }
  old = head->next;
  tmp = old->next;
  if (tmp == NULL)
    tmp = old;
  num = 2;
  while ((item->depth > tmp->depth) && tmp->next != NULL)
  {
    old = tmp;
    tmp = tmp->next;
    num++;
  }
  if ((tmp->next == NULL) && (item->depth > tmp->depth))
  {
    num = 0;
    tmp->next = item;
    item->next = NULL;
    XmListAddItem(w, str, 0);
    XmStringFree(str);
    return;
  }
  old->next = item;
  item->next = tmp;
  XmListAddItem(w, str, num);
  XmStringFree(str);
}

int  find_item(colnode *head, float zval)
{
  colnode *tmp;
  int      num;

  num = 1;
  tmp = head->next;
  while (tmp != NULL)
  {
    if (zval == tmp->depth)
      return num;
    tmp = tmp->next;
    num++;
  }
  return -1;
}

colnode *get_colors()
{
  return global_data->head;
}
