#include <stdio.h>
#include "geomclass.h"
#include "geom.h"
#include "transform.h"
#include "plutil.h"
#include "ooglwrap.h"

void CCWrap(char *in, char *out)
{
 FILE *fin,*fout;
 Geom *gin;
 Geom *gout;

 if (!(fin=fopen(in,"r")))
 {
  fprintf(stderr,"Couldn\'nt open tmp file\n");
  return;
 }
 if (!(fout=fopen(out,"w")))
 {
  fprintf(stderr,"Couldn\'nt open tmp file\n");
  return;
 }
 gin = GeomFLoad(fin, NULL);
 gout = AnyToPL(gin, TM_IDENTITY);

 GeomFSave(gout, fout, NULL);
 GeomDelete(gin);
 GeomDelete(gout);
 fclose(fout);
 fclose(fin);
}
