#ifndef SPHEREP_H
#define SPHEREP_H

#include "sphere.h"
#include "instP.h"

#define SPHEREFIELDS \
  INSTFIELDS \
  float radius; \
  HPoint3 center; \
  int space;

struct Sphere {
  SPHEREFIELDS
};
    
#define SPHEREMAGIC	GeomMagic('s', 1)

extern GeomClass *SphereMethods();
extern Sphere *SphereCreate(Geom *, GeomClass *, va_list a_list );
extern Sphere *SphereFLoad(FILE *, char *);
extern Sphere *SphereSave(Sphere *, char *);
extern Sphere *SphereFSave(Sphere *, FILE *, char *);

/* These are non-mallocing if sphere exists; will create a new sphere and
 * return it if sphere does not exist */

#endif
