/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef SKELPDEF
#define SKELPDEF

#include "geomclass.h"
#include "skel.h"

typedef struct Skline {
	int nv;			/* Number of vertices for this polyline */
	int v0;			/* offset into vi[] of all vertices on line */
	int nc;			/* Number of colors for this polyline */
 	int c0;			/* index into c[] of first color */
} Skline;

struct Skel {
	GEOMFIELDS
	int nvert, nlines;
	int dim;		/* Dimension of points */
	float *p;		/* Array[nvert][dim] of point coords */
	Skline *l;		/* nl[nlines] */
	int nvi;		/* Total number of vertex indices */
	int *vi;		/* All vertex index lists */
	int nc;			/* Total number of colors */
	ColorA *c;		/* Array of colors */
};


#define SKEL_4D		1

extern Skel *SkelCreate( Skel *, GeomClass *, va_list );
extern void  SkelDelete( Skel * );
extern Skel *SkelCopy( Skel * );
extern Skel *SkelPick( Skel *, Pick *, Appearance *, Transform );
extern Skel *SkelFLoad( FILE *f, char *fname );
extern Skel *SkelFSave( Skel *, FILE * );
extern BBox *SkelBound( Skel *, Transform );
extern Skel *SkelDraw( Skel * );
extern Skel *SkelTransform( Skel *, Transform );

#endif /*SKELPDEF*/
