typedef struct
{
    int init;
    int P1x, P1r, P1g, P1b, P2x, P2r, P2g, P2b;
    double P1z, P2z;
} endPoint;

#define ABS(a) (((a)<0) ? -(a) : (a))
#define SGN(a) (((a)<0) ? -1 : 1)
#define MAX(a,b) (((a)<(b)) ? b : a)
#define MIN(a,b) (((a)<(b)) ? a : b)

void
Xmgr_gradWrapper(unsigned char *buf, float *zbuf, int zwidth, int width,
	int height, CPoint3 *p0, CPoint3 *p1, int lwidth,
	void (*flat)(unsigned char *, float *, int, int, int, int, int, float,
			int, int, float, int, int *),
	void (*smooth)(unsigned char *, float *, int, int, int, CPoint3 *,
			CPoint3 *, int));

void
Xmgr_polyscan(unsigned char *buf, float *zbuf, int zwidth, 
	      int width, int height, CPoint3 *p, int n, int *color,
	      endPoint *mug,
	      void (*scanfunc)(unsigned char *, float *, int, int, int, int,
				int, int *, endPoint *));

void
Xmgr_Zpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
	       int width, int height, CPoint3 *p, int n, int *color,
	       endPoint *mug,
	       void (*scanfunc)(unsigned char *, float *, int, int, int, int,
				int, int *, endPoint *));

void
Xmgr_Graypolyscan(unsigned char *buf, float *zbuf, int zwidth, 
		  int width, int height, CPoint3 *p, int n,
		  endPoint *mug,
		  void (*scanfunc)(unsigned char *, float *, int, int, int, 
				   int, int, endPoint *));


void
Xmgr_GrayZpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
		   int width, int height, CPoint3 *p, int n,
		   endPoint *mug,
		   void (*scanfunc)(unsigned char *, float *, int, int, int, 
				    int, int, endPoint *));

void
Xmgr_Gpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
	       int width, int height, CPoint3 *p, int n,
	       endPoint *mug,
	       void (*scanfunc)(unsigned char *, float *, int, int, int, 
				int, int, endPoint *));

void
Xmgr_GZpolyscan(unsigned char *buf, float *zbuf, int zwidth, 
		int width, int height, CPoint3 *p, int n,
		endPoint *mug,
		void (*scanfunc)(unsigned char *, float *, int, int, int,
				 int, int, endPoint *));
