/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */


/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "mgP.h"
#include "mg_xgl.h"

#define _sys_varargs_h	/* Prevent including <varargs.h>! */

#undef __STDC__		/* Kludge around Sun "DOTDOTDOT" misdeclarations */
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xgl/xgl.h>
#define __STDC__


typedef struct mgxglcontext {
    mgcontext 	mgc;
    int		born;

			/* XGL state data */
    Xgl_3d_ctx	xglctx;		/* XGL context; == ctx_win or ctx_mem */
    Xgl_win_ras xglwin;		/* XGL X11/XView window */
    Xgl_mem_ras xglmem;		/* XGL memory raster, in case we need it */
    Xgl_trans xglview;		/* Viewing (camera projection) transform */
    Xgl_trans xglmodel;		/* Modelling transform */
    Xgl_trans xglcam;		/* World-to-camera transform */
    Xgl_cmap xglcmap;		/* XGL Colormap */

    Xgl_3d_ctx  ctx_win;	/* XGL 3D context for window */
    Xgl_3d_ctx	ctx_mem;	/* XGL 3D context for memory raster (if any) */
    void	*memras;	/* Memory area, in case we use mem raster */

#define MGXGL_MAXLIGHTS	12
    Xgl_light	xgllgts[MGXGL_MAXLIGHTS]; /* Array of lights */
    int		xglnlights;	/* Number of lights */
    int		xgllgtmask;	/* Bitmask: which of these are on? */

    Xgl_trans	xglidentity;	/* Convenient identity transform */

			/* Double-buffering state */
    int		membuf;		/* Drawing into (memory) back-buffer */
    int		already;	/* Front buffer already exists */

    int		useX11;		/* Using X11 (else XView) */

			/* X11 settable values */
    Window	x11win;		/* MG_XWINDOW */
    Display	*x11dpy;	/* MG_XDISPLAY */
    int		x11scrn;	/* MG_XSCREEN */
 
			/* XView settable values */
    Xv_Window	xvwin;		/* XView window structure */
    Frame	frame;		/*  "    frame-window structure */
    Canvas	canvas;		/*  "    canvas */
    int		repaint;	/* MG_REPAINT flag */
    int		resize;		/* MG_RESIZE flag */
    void	(*dorepaint)();	/* MG_REPAINT_PROC callback */
    void	(*doresize)();	/* MG_RESIZE_PROC callback */

			/* Misc private data */
    void	*xbuf;		/* General-use buffer for XGL primitive data */
    int		bufsiz;		/* size of malloc'ed xbuf */
    int		bufused;	/* buf pointer -- amount used now */
    void	(*flushfunc)();	/* function to flush buffer [not yet used] */


			/* mg emulation of stuff XGL really ought to handle */
			/* Not implemented yet (if ever) - 91.09.24 slevy */
    char	weshade;	/* We compute shading, not XGL */
    char	wedither;	/* We (not XGL) dither to approximate colors */
    char	colorindex;	/* Running XGL in colorindex (else RGB) mode */
    Transform	world2cam;	/* World->Camera transform from MGC->cam, */
				/*  cached for quick access while shading. */

} mgxglcontext;

#define	MGXGL	  ((mgxglcontext *)_mgc)
#define	MGC	  _mgc

