/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef _MG_PDEFS_
#define _MG_PDEFS_

/*
 * Private, but machine-independent, declarations for mg library.
 */
#include "mg.h"

#define	MGCONTEXTMAGIC	OOGLMagic('m', 'c'<<8 | 1)

/*
 * Appearance portion of state.
 * We have a global stack of these which represent the user-specified values,
 * with a stack push at every mgpushappearance().
 */
struct mgastk {
	struct mgastk	*next;	/* stack link */
	short		changed;
	short		ap_seq, mat_seq, light_seq;
	Appearance	ap;	/* Shallow copy of appearance -- don't delete */
	Material	mat;	/* Ditto, Material */
	LmLighting	lighting;/* Ditto, Lighting */

	int		useshader; /* Flag: use shader function? (shader!=NULL
					&& appearance requires shading */
	mgshadefunc	shader; /* Software shading function, or NULL if none */
	void		*shaderdata; /* Data which shader might use */
};

/*
 * Transform stack, pushed by mgpushtransform().
 */
struct mgxstk {
	struct mgxstk	*next;	/* stack link */
	Transform	T;	/* Current object->world xform */
	short		xfm_seq;
	short		hasinv;	/* Flag: Tinv is valid */
	Transform	Tinv;
};

struct mgcontext {
	REFERENCEFIELDS
	struct mgfuncs	*devfuncs; /* Pointers to devices */
	short	devno;		/* Device index -- MGD_GL, MGD_X11, ... */

	short	changed;	/* flags: Must update device state because...*/
#define	  MC_WIN	0x01	/*  window changed (reshaped, &c) */
#define	  MC_CAM	0x02	/*  Camera changed */
#define	  MC_AP		0x04	/*  Appearance changed */
#define	  MC_MAT	0x08	/*  Material changed */
#define	  MC_LIGHT	0x10	/*  Lighting changed */
#define   MC_TRANS	0x20	/*  Transformation changed */
#define	  MC_OPT	0x40	/*  Options changed */

	WnWindow	*win;	/* Window */
	Camera		*cam;	/* Camera */
	mgcontext	*parent; /* Parent mg window, if any */
	mgcontext	*next;	/* Link in list of all mg contexts */
	struct mgastk	*astk;	/* Top of appearance stack */
	struct mgxstk	*xstk;	/* Top of transform stack */
	int		shown;	/* Is window 'visible'? */
	ColorA		background; /* Background color */

	int		opts;	/* MG_SETOPTIONS flag mask */

	Transform	W2C;	/* World->camera transform */
	Transform	C2W;	/* Camera->world transform */

	Transform	T4;	/* 4D->3D transform */
	int		T4_seq;	/* sequence number for T4 */

	float		zfnudge; /* fraction of Z-range by which lines are
				  * nudged closer than surfaces.
				  */
	int		space;	/* space in which objects being drawn
				 * live; should be TM_EUCLIDEAN,
				 * TM_HYPERBOLIC, or TM_SPHERICAL
				 */


	Transform	W2S, S2W; /* world-to-screen, screen-to-world xfms */

	int		has;	/* Flag bits, set when cached values valid */
#define HAS_CPOS   0x1
#define	HAS_S2O	   0x2
#define HAS_POINT  0x4
				/* Cached values, computed when needed: */
	Point3		cpos;	  /* Location of camera in object coordinates */
	Transform	O2S, S2O; /* object-to-screen, screen-to-object xfms */
	vvec		point;	/* outline for fat points */

	void		*NDinfo; /* Opaque pointer to caller-defined ND closure */
	mgmapfunc	NDmap;	/* NDmap(NDinfo, HPtN *, HPt3 *, ColorA *) */
};

/*
 * Pointer to the current mg context.
 */
extern struct mgcontext *_mgc;

/*
 * List of all extant mg contexts.
 */
extern struct mgcontext *_mgclist;

/*
 * Declarations of common mg routines, accessible to other mg packages
 * (but not intended to be public):
 */

extern void mg_identity(void);
extern void mg_transform(Transform T);
extern void mg_settransform(Transform T);
extern void mg_gettransform(Transform T);
extern void mg_quads(int nquads, HPoint3 *v, Point3 *n, ColorA *c);
extern void mg_bezier(int du, int dv, int dimn, float *ctrlpts, float *txmapst,
  ColorA *c);
extern void mg_findcam();
extern void mg_findS2O();
extern void mg_findO2S();
extern void mg_makepoint();

extern int mg_pushtransform(void),  mg_poptransform(void);
extern int mg_pushappearance(void), mg_popappearance(void);
extern void mg_reshapeviewport(void);
extern Appearance *mg_getappearance(void);
extern Appearance *mg_setappearance(Appearance *ap, int mergeflag);

extern mgcontext *mg_newcontext(struct mgcontext *);
extern int mg_appearancebits( Appearance *ap, int merge, int *valid, int *flag );


#endif /*_MG_PDEFS_*/
