#SPEC -name ''textfilter'' -realname ''Text'' -import -ext ''.txt'' -export

#
# open tool
#
proc exportshape {fileid} {
	puts $fileid "SHAPE"
	
	set listfacesshape [shape -faces]
	
	set numfaces [llength $listfacesshape]
	puts $fileid "NUMFACES"
	puts $fileid $numfaces
	
	set listpointshape [ shape -points]
	wait -init "export shape ..." $numfaces
	for {set i 0} {$i < $numfaces} {incr i} {
		wait -do $i
		puts $fileid "FACE"
		set faceshape [lindex $listfacesshape $i]
		set numptface [llength $faceshape]
		
		puts $fileid $numptface
		for {set j 0} {$j < $numptface} {incr j} {

			set point [lindex $listpointshape [lindex $faceshape $j]]
			puts $fileid [lindex $point 0]
			puts $fileid [lindex $point 1]
			puts $fileid [lindex $point 2]
		}
	}
	wait -close
}

proc exportcurve {fileid} {
	if { [shape -closed] } {
		puts $fileid "CLOSEDCURVE"
	} else {
		puts $fileid "CURVE"
	}
	set pointscurve [shape -points]
	set numpointscurve [llength $pointscurve]
	puts $fileid $numpointscurve
	wait -init "export curve ..." $numpointscurve
	for {set i 0} {$i < $numpointscurve} {incr i} {
		wait -do $i
		set point [lindex $pointscurve $i]
		set coord0 [lindex $point 0]
		set coord1 [lindex $point 1]
		set coord2 [lindex $point 2]
		puts $fileid $coord0
		puts $fileid $coord1
		puts $fileid $coord2
	}
	wait -close
}

proc exportnucurve {fileid} {
	puts $fileid "NUCURVE"
	
	puts $fileid "NU"
	puts $fileid [shape -nu]
	
	puts $fileid "UORDER"
	puts $fileid [shape -uorder]
	
	puts $fileid "UKNOT"
	set knot [shape -uknot]
	set nk [llength $knot]
	for {set i 0} {$i < $nk} {incr i} {
		puts $fileid [lindex $knot $i]
	}
	
	puts $fileid "CTRLPTS"
	set ctrlpts [shape -ctrlpts]
	set numctrl [llength $ctrlpts]
	wait -init "export nurbs curve ..." $numctrl
	for {set i 0} {$i < $numctrl} {incr i} {
		wait -do $i
		set point [lindex $ctrlpts $i]
		puts $fileid [lindex $point 0]
		puts $fileid [lindex $point 1]
		puts $fileid [lindex $point 2]
		puts $fileid [lindex $point 3]
	}
	wait -close
}

proc exportnupatch {fileid} {
	puts $fileid "NUPATCH"
	
	puts $fileid "NU"
	puts $fileid [shape -nu]
	
	puts $fileid "NV"
	puts $fileid [shape -nv]
	
	puts $fileid "UORDER"
	puts $fileid [shape -uorder]
	
	puts $fileid "VORDER"
	puts $fileid [shape -vorder]
	
	puts $fileid "UKNOT"
	set knot [shape -uknot]
	set nk [llength $knot]
	for {set i 0} {$i < $nk} {incr i} {
		puts $fileid [lindex $knot $i]
	}
	
	puts $fileid "VKNOT"
	set knot [shape -vknot]
	set nk [llength $knot]
	for {set i 0} {$i < $nk} {incr i} {
		puts $fileid [lindex $knot $i]
	}
	
	puts $fileid "CTRLPTS"
	set ctrlpts [shape -ctrlpts]
	set numctrl [llength $ctrlpts]
	wait -init "export nurbs patch ..." $numctrl
	for {set i 0} {$i < $numctrl} {incr i} {
		wait -do $i
		set point [lindex $ctrlpts $i]
		puts $fileid [lindex $point 0]
		puts $fileid [lindex $point 1]
		puts $fileid [lindex $point 2]
		puts $fileid [lindex $point 3]
	}
	wait -close
}

proc importshape {fileid} {

	newshape shape {
		gets $fileid line
		gets $fileid numfaces
		wait -init "import shape ..." $numfaces
		for {set i 0} {$i < $numfaces} {incr i} {
			wait -do $i
			gets $fileid line
			gets $fileid numpoints
			set faceshape {}
			for {set j 0} {$j < $numpoints} {incr j} {
				gets $fileid coordx
				gets $fileid coordy
				gets $fileid coordz
				set pointshape [list $coordx $coordy $coordz]
				lappend faceshape $pointshape
			}
			addface $faceshape
		}
		wait -close
	}
	shape -checkin
}

proc importnupatch {fileid} {

	gets $fileid line
	gets $fileid nu
	
	gets $fileid line
	gets $fileid nv
	
	gets $fileid line
	gets $fileid uorder
	
	gets $fileid line
	gets $fileid vorder
	
	gets $fileid line
	set nk [expr {$nu + $uorder}]
	set uknot {}
	for {set i 0} {$i < $nk} {incr i} {
		gets $fileid k
		lappend uknot $k
	}
	
	gets $fileid line
	set nk [expr {$nv + $vorder}]
	set vknot {}
	for {set i 0} {$i < $nk} {incr i} {
		gets $fileid k
		lappend vknot $k
	}
	
	gets $fileid line
	set ctrlpts {}
	set numctrl [expr {$nu * $nv}]
	wait -init "import nurbs patch ..." $numctrl
	for {set i 0} {$i < $numctrl} {incr i} {
		wait -do $i
		gets $fileid x
		gets $fileid y
		gets $fileid z
		gets $fileid w
		lappend ctrlpts [list $x $y $z $w]
	}
	wait -close
	
	newshape shape {
		setnupatch $nu $nv $uorder $vorder $uknot $vknot $ctrlpts
	}
	shape -checkin
}

proc importnucurve {fileid} {

	gets $fileid line
	gets $fileid nu
	
	gets $fileid line
	gets $fileid uorder
	
	gets $fileid line
	set nk [expr {$nu + $uorder}]
	set uknot {}
	for {set i 0} {$i < $nk} {incr i} {
		gets $fileid k
		lappend uknot $k
	}
	
	gets $fileid line
	set ctrlpts {}
	wait -init "import nurbs patch ..." $nu
	for {set i 0} {$i < $nu} {incr i} {
		wait -do $i
		gets $fileid x
		gets $fileid y
		gets $fileid z
		gets $fileid w
		lappend ctrlpts [list $x $y $z $w]
	}
	wait -close
	
	newshape shape {
		setnucurve $nu $uorder $uknot $ctrlpts
	}
	shape -checkin
}

proc importcurve {fileid style} {
	newshape curve {
		gets $fileid numpoints
		wait -init "import curve ..." $numpoints
		for {set i 0} {$i < $numpoints} {incr i} {
			wait -do $i
			gets $fileid coordx
			gets $fileid coordy
			gets $fileid coordz
			addpoint [list $coordx $coordy $coordz]
		}
		wait -close
	}
	
	case $style in {
		{CURVE} {
			curve -status open
		}
		{CLOSEDCURVE} {
			curve -status close
		}
	}
	curve -checkin
}

proc import {file} {
	set fileid [open $file r]
	gets $fileid style
	while { [eof $fileid] == 0 } {
		case $style in {
			{SHAPE} {
				importshape $fileid
			}
			{CURVE} {
				importcurve $fileid $style
			}
			{CLOSEDCURVE} {
				importcurve $fileid $style
			}
			{NUPATCH} {
				importnupatch $fileid
			}
			{NUCURVE} {
				importnucurve $fileid
			}
			default {
				.amapi error "Syntax error in " $file ": " $style
			}
		}
		gets $fileid style
	}
	close $fileid
}

proc export {file} {
	
	set fileid [open $file w]
	
	set scene [.amapi scene]
	set numshape [llength $scene]
	wait -init "export scene ..." $numshape
	for {set i 0} {$i < $numshape} {incr i} {
		wait -do $i
		newshape shape [lindex $scene $i]		
		if { [shape -curve] } then {
			if { [shape -nucurve] } then {
				exportnucurve $fileid
			} else {
				exportcurve $fileid
			}
		} else {
			if { [shape -nupatch] } then {
				exportnupatch $fileid
			} else {
				exportshape $fileid
			}
		}
	}
	wait -close
	close $fileid
}

proc callback_open {argv} {
	set file [.match $argv "open" -string]
	if {$file != ""} {
		import $file
	}
	set file [.match $argv "save" -string]
	if {$file != ""} {
		export $file
	}
	.exit
}

#
# close tool
#

proc callback_exit {} {
	
}
