# create a new window
.amapi newwindow

# insert short cut to stop tutorial
binding -insertglobal "s" <> "cd \"$HELPWD\"; source fr_close.tcl"

#get running system and set corresponding local messages
set mysystem [.amapi getsystem]
if {$mysystem == "macos"} {
	set ALTmsg "POMME"
	set OPTIONmsg "Touche OPTION + Bouton Souris"
}
if {$mysystem == "windows" || $mysystem == "x11" || $mysystem == "pxp"} {
	set ALTmsg "ALT"
	set OPTIONmsg "Bouton Droite Souris"
}

set tutostopmsg ""
verbose -text ''/left /n /n /n /normal DEBUT DU TUTORIAL \
				/n /n /red ACTION.....: /yellow Bouton Souris \
				/n    /red OPTIONS....: /yellow $OPTIONmsg \
				/n    /red VALIDER....: /yellow Touche Entre \
				/n    /red BASCULER...: /yellow Touche Espace \
				/n    /red PARAMETRER.: /yellow Touche Tabulation \
				/n    /red POSER......: /yellow Glisser la Souris  Droite de l'Ecran \
				/n /n  /normal A tout moment vous pouvez taper /red 'S' /normal pour stopper le tutorial \
				/n /n /normal Cliquez pour continuer ''
verbose -bmap ''bmap_export'' -pos {0 0 0}

# utility hook function to filter key events, ex:
# set filterchar "5"
# .passevent -hook ischar

proc ischar {msg} {
	global filterchar # just set filterchar
	if {$msg == "key"} {
		if {[.event key] == $filterchar} {
			return "rtrn"
		}
	}
	return "forget"
}

# accept and return only event key "s" and event basculate
proc StopandBasculate {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s" || $key == " "} {
			return "accept"
		}
	}
	if {$msg == "basculate"} {
		return "rtrn"
	}
	return "forget"
}

# accept and return only event key "s" and event leftbtn
proc StopandLeftbtn {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s"} {
			return "accept"
		}
	}
	if {$msg == "leftbtn"} {
		return "rtrn"
	}
	return "forget"
}

# accept only event key "s" and passover event leftbtn
proc PassLeftbtn {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s"} {
			return "accept"
		}
	}
	if {$msg == "leftbtn"} {
		return "passover"
	}
	return "forget"
}

# accept and return only event key "s" and event shift
proc StopandShift {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s"} {
			return "accept"
		}
	}
	if {$msg == "shift"} {
		return "rtrn"
	}
	return "forget"
}

# accept and return only event validate
proc OnlyValidate {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "return"} {
			return "rtrn"
		}
	}
	return "forget"
}

# accept and return only event edit
proc StopandEdit {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s" || $key == "tab"} {
			return "rtrn"
		}
	}
	return "forget"
}

# accept and return only event key "s" and event cancel
proc StopandCancel {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s"} {
			return "accept"
		}
	}
	if {$msg == "cancel"} {
		return "rtrn"
	}
	return "forget"
}

# accept and return only event key "s" and event cancel
proc StopandDel {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s" || $key == "backspace"} {
			return "rtrn"
		}
	}
	return "forget"
}

# accept and return only event of the arrows key
proc StopandArrows {msg} {
	if {$msg == "key"} {
		set key [.event key]

		if {$key == "s" || $key == "left" || $key == "right" || $key == "up" || $key == "down"} {
			return "rtrn"
		}
	}
	return "forget"
}

# accept and return only event key "s" but pass over the event leftbtn
proc StopandPassLeftbtn {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s"} {
			return "accept"
		}
	}
	if {$msg == "leftbtn"} {
		return "passover"
	}
	return "forget"
}

.passevent -hook StopandPassLeftbtn
