/********************************************************************************
 *  Projektname		: AERO - Teilprojekt FSB
 *  Filename		: kraft.c
 *  Filetyp		: C-Source
 ********************************************************************************
 *  Modulname		: kraft.o
 *  letzte Aenderung	: 10.03.93
 *  Autor		: Horst Stolz (HUS)
 *  
 *  Beschreibung:
 *  
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *  10.03.93	Erstellungsdatum
 *  
 ********************************************************************************/

#include <stdio.h>

#include "kraft.h"
#include "koerper.h"
#include "vektor.h"

int kr_debug_level = 0;


void KraefteEinbringen(struct TKoerper *k, TReal t)
/****************************************************************************
 * Von jedem Koerper in der Koerperlist k wird
 * die Kraftliste in k->Kraefte in die Bewegungsgleichungen eingebracht,
 * durch Addition zu k->a und k->u.
 * Kraefte wirken nur wenn t im Zeitintervall [StartZeit, EndZeit] liegt.
 * 
 * RAUMFEST: 
 *   F = f->Kraft, R = k->RotTrans1 * f->Angriffspunkt
 *   k->a += F, k->u += R x F
 * KOERPERFEST: 
 *   F = k->RotTrans1 * f->Kraft, R = k->RotTrans1 * f->Angriffspunkt
 *   k->a += F, k->u += R x F
 * GERICHTET:
 *   R = k->RotTrans1 * f->Angriffspunkt
 *   R2 = f->KD.GerKraft.ZielKoerper->RotTrans1 * f->KD.GerKraft.Zielpunkt
 *   Richtung = R2 + f->KD.GerKraft.ZielKoerper->ty->p - (k->ty + R)
 *   F = f->KD.GerKraft.Kraftbetrag * Richtung / | Richtung|
 *   k->a += F, k->u += R x F
 *   
 */
{
    TKraft *f;
    TVektor R, F, M;
    TReal h;


#ifndef NODEBUG
    if (kr_debug_level>=1) printf("KraefteEinbringen(koerper, t=%f) 1-\n", t);
#endif
    
    for (;k; k=k->Naechster)
        for (f = k->Kraefte; f; f=f->Naechste) if (t>=f->StartZeit && t<=f->EndZeit) {
	    switch(f->Typ) {
	    case RAUMFEST:
	        V_INC(k->a, f->KD.Kraft);
	        MV_MUL2(R, k->RotTrans1, f->Angriffspunkt);
	        V_MUL(M, R,  f->KD.Kraft);
	        V_INC(k->u, M);
#ifndef NODEBUG
	        if (kr_debug_level>=2)
		    printf("KE() 2- Kraft = %f %f %f, Ort %f %f %f, Moment = %f %f %f\n",
			    f->KD.Kraft[0], f->KD.Kraft[1], f->KD.Kraft[2],
			    R[0], R[1], R[2], M[0], M[1], M[2]);
#endif
	        break;

	    case KOERPERFEST:
	        MV_MUL2(F, k->RotTrans1, f->KD.Kraft);
	        V_INC(k->a, F);
	        MV_MUL2(R, k->RotTrans1, f->Angriffspunkt);
	        V_MUL(M, R, F);
	        V_INC(k->u, M);
#ifndef NODEBUG
	        if (kr_debug_level>=2)
		    printf("KE() 2- Kraft = %f %f %f, Ort %f %f %f, Moment = %f %f %f\n",
			    F[0], F[1], F[2], R[0], R[1], R[2], M[0], M[1], M[2]);
#endif
	        break;

	    case GERICHTET:
	        MV_MUL2(R, k->RotTrans1, f->Angriffspunkt);
	        MV_MUL2(F, f->KD.GerKraft.ZielKoerper->RotTrans1, f->KD.GerKraft.Zielpunkt);
	        F[0] += f->KD.GerKraft.ZielKoerper->ty->p[0] - k->ty->p[0] - R[0];
	        F[1] += f->KD.GerKraft.ZielKoerper->ty->p[1] - k->ty->p[1] - R[1];
	        F[2] += f->KD.GerKraft.ZielKoerper->ty->p[2] - k->ty->p[2] - R[2];
	        h = V_BETRAG(F);
	        if (h == 0.0) break;      /* Keine Kraftrichtung bestimmbar */
			    
	        h = f->KD.GerKraft.Kraftbetrag / h;
	        V_SKALAR(F, F, h);

	        V_INC(k->a, F);
	        V_MUL(M, R,  F);
	        V_INC(k->u, M);
#ifndef NODEBUG
	        if (kr_debug_level>=2)
		    printf("KE() 2- Kraft = %f %f %f, Ort %f %f %f, Moment = %f %f %f\n",
			    F[0], F[1], F[2], R[0], R[1], R[2], M[0], M[1], M[2]);
#endif
	        break;

	    default:
	        break;
	    }
	}
}
