/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: grundtypen.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: - 
 *  Version           	: 0.1.2
 *  letzte Aenderung	: 22.02.94
 *  Autor		: Horst Stolz (HUS)
 *  Status		: ungetestetes Dummy-File
 *  Zweck               : allgemein gebraeuchliche Grundtypen und Makros bereit-
 *                        stellen.
 *
 *  Versionsgeschichte:
 *  -------------------
 *  10.01.93	Typ TQuarternion eingefuehrt
 *  24.01.93    Makro QUADRAT(x) eingefuehrt
 *  05.03.93    TRUE nun mit 1 statt -1 belegt
 *  22.02.94    Makro pi richtig gestellt!
 *  30.05.94    Makros is_zero und is_not_zero,... eingefuehrt.
 *  
 ********************************************************************************/
#ifndef GRUNDTYPEN_H
#define GRUNDTYPEN_H

#include <math.h>
#include <float.h>

/*
 * GCC benutzt noch die CC-Math-libs, in denen kein PI definiert ist
 */
#ifndef PI
#define PI 3.14159265358979323846
#endif


typedef double	TReal;		/* Fliesskommatyp */

#ifdef DBL_EPSILON
#define REAL_EPSILON      DBL_EPSILON    /* kleinster wert x fuer den 1.0+x!=1.0 gilt */
#else
#define REAL_EPSILON      1e-9 
#endif
#ifdef DBL_MAX
#define REAL_MAX          DBL_MAX        /* groesstmoeglicher Gleitpunktwert */
#else
#define REAL_MAX          1e+37
#endif

typedef	TReal TVektor[3];       /* x, y, z */

typedef TReal TMatrix[3][3];    /* [zeile][spalte] */

typedef TReal TQuaternion[4];


#ifndef TRUE 
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL 0
#endif

#define QUADRAT(r) ((r)*(r))


typedef enum EBoolean {BOOL_TRUE = TRUE, BOOL_FALSE = FALSE} TBoolean;

#ifndef max
#define max(a,b) (((a)>(b))?(a):(b))
#endif


#define is_zero(x) (fabs(x)<=REAL_EPSILON)
#define is_not_zero(x) (fabs(x)>REAL_EPSILON)
#define is_greater_than_zero(x) ((x)>REAL_EPSILON)
#define is_lower_than_zero(x) ((x)<REAL_EPSILON)

#endif

