/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: folgeschrittberechnung.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: folgeschrittberechnung.o
 *  Version           	: 5
 *  letzte Aenderung	: Donnerstag, 29. August 1996, 17:12:07
 *  Autor		: Horst Stolz (HUS)
 *  
 *  Beschreibung:
 *    Simulation von einem Zustand zum Naechsten(Folgebild)
 *    
 *  
 *  Exportierte Funktionen:
 *    void FolgeBildBerechnung(TZustand *Z, TReal dt);
 *    void KoeIniMech(TKoerper *k, TMaterialTabelle *MatTab);
 *    void InitFBB(TZustand *z);
 *    void EndFBB(TZustand *z);
 *    void ErfrageKonfigFBB(TKonfigFBB *Konfig);
 *    void KonfigFBB(TKonfigFBB *Konfig);
 *    void UngeaendertFBB(TZustand *z);
 *
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *  -------------------
 *  26.10.92   TVektor und TMatrix-Definitionen u. aehnliches ausgelagert in
 *             in "grundtypen.h", Verhinderung von mehrmaligem scannen des
 *             Header-Files durch #if..#endif und HEADERNAM_H als Konstante!
 *   8.11.92   Verbindungsarten einfuehren
 *  25.11.92   Koerper PUNKT und NAGEL eingefuehrt 
 *             koerperfeste Vektoren in TVerbindung: * entfernt
 *             in TKoerper: Drehwinkel gestrichen da Begriff falsch
 *                          Drehbeschleunigung eingefuehrt!!
 *  02.12.92   Bemerkungen eingefuegt bzw. korregiert
 *  03.12.92   Element "Gravitation" in TZustand eingefuegt
 *             Bemerkung von TKoerper verbessert. fuer Andie
 *             Materialtyp EISEN eingefuegt
 *  13.12.92   InitFBB() und EndFBB() eingefuehrt, Massepunkt MPUNKT ohne
 *             geometrische Form eingefuehrt um Drehung zu berpruefen
 *             MaterialTabelle im Zustand nun ein Zeiger!
 *  17.12.92   Konfig-Routine KonfigFBB eingefuehrt (samt TKonfig-Struktur)
 *  21.12.92   Zusammengesetzte Koerper eingebaut, Dichte aus TKoerper gestrichen
 *  10.01.93   Typ TQuaternion eingebaut
 *  12.01.93   Form-Definition des Quaders geaendert um Missverstaendnisse die bei
 *             Breite, Hoehe, Tiefe sind zu vermeiden. (nun: Vektor KantenLaenge)
 *  20.01.93   UngeaenderFBB() eingefuehrt.
 *  21.01.93   Reihenfolge der Elemente in TForm geaendert.
 *  24.01.93   Voellige Umstrukturierung der jetzigen Def. in verschiedene Files
 *  25.02.93   Konfiguration umgestellt. Jetzt nur eine grosse Konfigstruktur
 *             in der Alles eingetragen wird.
 *  
 ********************************************************************************/
#ifndef FOLGESCHRITTBERECHNUNG_H
#define FOLGESCHRITTBERECHNUNG_H



/****************************************************************************
 * allgemeine und benutzte Typdefinitionen
 */

#ifndef GRUNDTYPEN_H
#include "grundtypen.h"
#endif

#ifndef ZUSTAND_H
#include "zustand.h"
#endif


#ifndef KONFIG_H
#include "konfig.h"
#endif



extern void ErfrageKonfigFBB(TKonfigFBB *Konfig);
/****************************************************************************
 * Zweck:
 *   Man erhaelt eine Ausgefuellte KonfigFBB-Struktur zurueck!
 *   Die Eintraege  in dieser Struktur sind in konfig.h zu finden.
 *
 */


extern void KonfigFBB(TKonfigFBB *Konfig);
/****************************************************************************
 * Zweck:
 *   Aenderung von internen Parametern die die FolgeBildBerechnung betreffen.
 *
 * Benutzung:
 *   Erst mit ErfrageKonfigFBB() die aktuelle Konfiguration erfragen, die 
 *   ensprechenden Werte aendern und mit KonfigFBB() die neuen Konfiguration
 *   setzen.
 */


extern void InitFBB(TZustand *z);
/****************************************************************************
 * Zweck:
 *   Initialisierung der FolgeBildBerechnung.
 *   Muss vor der 1. Benutzung von FolgeBildBerechnung(..) aufgerufen werden
 */

extern void EndFBB(TZustand *z);
/****************************************************************************
 * Zweck:
 *   Vor beendigen des Programms (nach der letzten Benutzung von 
 *   denn FolgeBildBerechnungs-Routinen) sollte diese Routine aufgerufen
 *   werden => sauberes Verlassen
 *
 */


extern TBoolean FolgeBildBerechnung(TZustand *Z, TReal dt);
/***********************************************************************
 * Zweck:
 *   Aus den physikalisch relevanten Informationen in der TZustand-
 *   Struktur werden die neuen Lage- und Bewegungsvektoren fuer den
 *   neuen Zeitpunkt Z.Zeit + dt berechnet.
 * 
 * Beschraenkungen:
 *
 * Ruckgabewert:
 *   TRUE wenn schritt erfolgreich.
 *   FALSE ansonsten. Zeit bis zu der Berechnet werden konnte steht in z->Zeit
 *
 * Fehler:
 *   viel zu viele um sie Aufzuzaehlen!
 */


extern void UngeaendertFBB(TZustand *z);
/****************************************************************************
 * Zweck:
 *   Der Benutzer der FBB kann damit explizit angeben das er an den
 *   Zustandsdaten keine Aenderungen vorgenommen hat. Normalerweise wird
 *   angenommen das zwischen den Aufrufen der FolgeBildBerechnung(..)
 *   sich die Zustandsdaten aendern (z.B.: Koerper/Verbindungen +/-). 
 *   Wird zwischen zwei FBB(..) nun UngeandertFBB(..) aufgerufen, so
 *   wird versucht (falls implementiert) bisherige Zwischenergebnisse
 *   weiter zu Benutzen. -> Geschwindigkeitsgewinn.
 *
 * Benutzung:
 *   NUR ZWISCHEN zwei FolgeBildBerechnung(..) - Aufrufen!
 */


extern int fsb_debug_level;


#endif
