/* ##################################################
   Noch zu aendern/zu tun:
     
   - Der (2D-) Feder auch eine Windungszahl abhaengig von der Ruhelaenge geben
   - Koordinatenangabe fuer Achsen in den Darstellungsfenstern (als
     Parameter in AnzeigeDarstellung()?) Wohl besser 3 Routinen fuer jedes Window
     (XY, XZ, YZ) eine.
   - Koordinatenachsen nochmal anschauen (z.B. bzgl. Verschiebung der Darstellungsposition). 
     Pfeil-Routine schreiben. Siehe animat.c
     Diese Pfeil-Routine fuer Koordinatenachsen und Kraefte verwenden
   - Bei AnzeigeDarstellung() koennte ein Recalculate-Modus angegeben werden:
     Bit 0: Koerper neu berechnen, Bit 1: Verbindungen, Bit 2: Kraefte
     oft wird bloss eine Verbindung oder ein Koerper geaendert, da ist es nicht
     noetig, den ganzen Rest auch neu zu berechnen. (Bsp.: eine Kraft hat sich
     geaendert: alle Verbindungen und alle Koerper koennen so bleiben, wie sie 
     sind). Dieser Modus ist wahrscheinlich nur interessant, wenn die Objekte
     vorberechnet werden (mit Darstellungslisten). Wird die Darstellung auf 
     Direktberechnung umgestellt, ist wohl das meiste hinfaellig. Obwohl, wenn
     man sich vom Koerper schon die transformierten Koordinaten merkt (z.B. die
     3D-Eckpunkte des Quaders), dann kann man sich auch dann noch einiges sparen.
   - Zusammenhaengend mit obigem: Es koennte 3 Routinen geben:
     KoerperAendern(), VerbindungAendern(), KraftAendern(). Wenn sich bis
     jetzt nicht die Reihenfolge innerhalb der Strukturen geaendert hat
     (dies ist eine Voraussetzung fuer den Aufruf dieser Routinen), dann
     werden nur die selected-Objekte neu gezeichnet. Dies laesst sich z.B.
     dadurch realisieren, dass die selected-Objekte im XOR-Modus gezeichnet
     werden. Durch erneutes Zeichnen werden sie dann wieder geloescht.
     Dies wuerde die Eingabe enorm beschleunigen und funktioniert auch mit
     Gruppierungen. Sobald sich die Struktur aendert (neue oder geloeschte
     Objekte) oder andere Objekte selektiert werden, muss halt mal wieder
     die normale AnzeigeDarstellung() aufgerufen werden.


   ################################################## */





/********************************************************************************
 *  Projektname:	AERO
 *  Filename:		darstellung.c
 *  Filetyp:		Modul
 ********************************************************************************
 *  WICHTIG:            Dieser Quelltext benoetigt einen Compiler, der Struktur-
 *                      Zuweisungen beherrscht (z.B. ANSI-C, gcc). Sind also z.B.
 *                      a und b Strukturen gleichen Typs, muss bei b=a; der ge-
 *                      samte Inhalt von a nach b kopiert werden. Ausserdem werden
 *                      Prototypen benutzt (gibt es i.a. nicht bei Standard-C).
 ********************************************************************************
 *  Modulname:		Anzeige
 *  Version:		0.1.3
 *  letzte Aenderung:	Freitag,  8. September 1995, 02:23:33
 *  Autor:  		Hartmut 
 *  Status:		Neue, umgemodelte Darstellungsroutinen, funktionstuechtig
 *
 *  importierte Bezeichner:	-
 *  -----------------------
 *
 *  exportierte Bezeichner:
 *  -----------------------
 *  void InitialisiereDarstellung(Widget d_xy, d_yz, d_xz, d_3d): 
 *          Belegen aller wichtigen Variablen fuer die Darstellung. Da hierbei
 *          auf die den Widgets zugeordneten Windows bezug genommen wird, muessen
 *          die Widgets also schon gemapped sein.
 *
 *  void SetzeActionsDarstellung(XtAppContext *a, Widget d_xy, d_yz, d_xz, d_3d): 
 *          Alle noetigen Actions und Translations fuer die 4 Darstellungswidgets
 *          hinzufuegen. Diese Routine muss jedesmal neu aufgerufen werden, wenn
 *          XtUninstallTranslations auf (mindestens) eines der 4 Darstellungs-
 *          widgets ausgefuehrt wird.
 *
 *  void AnzeigeDarstellung(Widget d_xy, d_yz, d_xz, d_3d, TVektor darstpos, 
 *                          TQuaternion q, TReal zoom, TZustand *zustand,
 *                          int darstmodus):
 *          Projektion des angegebenen Zustandes auf die Editor-Darstellungs-
 *          widgets (3 Ansichten + Schraegbild). Sichtposition (sozusagen der
 *          Mittelpunkt der Objekte) ist darstpos, die Blickrichtung auf die
 *          Objekte ist entlang der Koordinatenachsen des mit q in der Lage
 *          angegebenen Koordinatensystems. Die Vergroesserung (sozusagen die
 *          Entfernung der virtuellen Kameras auf den Achsen) wird durch zoom
 *          angegeben. Mit darstmodus wird die Anzeigeart festgelegt:
 *              Bit 0: Fussboden zeichnen (1) oder nicht (0)
 *              Bit 1: Koordinatenachsen der Fenster zeichnen (1) oder nicht (0)
 *              Bit 2: Koordinatenachsen der einzelnen Koerper zeichnen oder
 *                     nicht (0)
 *
 *  TKoerper *SelektiereVonDarstellung(Widget w, AXKoord sx, AXKoord sy,
 *	    			       TVektor darstpos, TKoerper *koerper)
 *          Selektion des Objekts, das den Koordinaten sx,sy am naechsten ist.
 *
 *  void OffsetDarstellung(Widget w, AXKoord sx, AXKoord sy, TVektor darstpos)
 *          Verschieben der Darstellungsposition entsprechend den
 *          Koordinaten sx,sy.
 *
 *  void InitialisiereRGB(XtAppContext *app_context, Widget w):
 *          Alle noetigen Actions und Translations fuer das RGB-Widget
 *          setzen. Da hier die Windownummer ermittelt wird, muss das Widget
 *          schon gemapped sein.
 *
 *  void AnzeigeRGB(Widget w, unsigned short G, unsigned short G,
 *                                                       unsigned short B):
 *          Das RGB-Widget w wird mit der Farbe, die der angegebenen am
 *          ehesten entspricht, gefuellt.
 *
 *
 *  Beschreibung:
 *  -------------
 *  In diesem Modul sind alle Routinen fuer den Editor enthalten. Dies
 *  umfasst die 4 Darstellungsfenster (3 Ansichten + Schraegbild) sowie
 *  ein kleines Fenster fuer die Darstellung der aktuellen RGB-Werte.
 *
 *  4 Darstellungsfenster:
 *  Fuer jedes dieser Fenster wird bei AnzeigeDarstellung() eine Liste
 *  aufgebaut, in der alle zu zeichnenden Elemente (i.a. Linien) enthalten
 *  sind. Anschliessend wird nur noch jedes Fenster geloescht und dadurch
 *  ein Redraw (ueber Expose-Events) ausgeloest. In den Redraw-Routinen
 *  werden dann nur noch die entsprechenden Listen hingezeichnet, ohne dass
 *  irgendetwas neu berechnet wird. 
 *
 *  Dieses Vorgehen begruendet sich dadurch, dass ein Redraw ja auch durch
 *  Benutzeraktionen ausgeloest werden kann (z.B. durch Verschieben von
 *  weiteren Fenstern auf dem Bildschirm). Um in einem solchen Fall erneut
 *  malen zu koennen, muesste man noch die Daten des entsprechenden
 *  Zustandes haben, was bedeuten wuerde, dass in AnzeigeDarstellung()
 *  zumindest alle relevanten Daten des Zustandes kopiert werden muessten.
 *  (ANMERKUNG: Jetzt im Nachhinein erscheint mir dieses Vorgehen auch nicht
 *  mehr als allzu abwegig, zumal dann ein besseres Reagieren auf
 *  Fenstergroessenaenderungen moeglich waere.)
 *
 *  RGB-Fenster:
 *  Damit im restlichen Editor nicht unnoetig mit Farben hantiert werden
 *  muss (X-Toolkit ist dafuer etwas unpraktisch), ist die Bearbeitung
 *  dieses Fensters auch hierher gekommen. Die Bearbeitung beschraenkt sich
 *  auf das Neuzeichnen eines Rechteckes in der passenden Farbe.
 *
 *  Insgesamt sind noch weitere Routinen enthalten, die entsprechend auf
 *  Redraws und Groessenaenderung der Fenster reagieren, um unnoetige
 *  Abfragen der Widget-Strukturen zu vermeiden.
 *  
 *
 *  Fehler:
 *  -------
 *  - Fussboden fehlt noch ganz (ist wohl auch nicht mehr vorgesehen, dafuer
 *    gibt es jetzt die Ebenen)
 *
 *  Versionsgeschichte:
 *  -------------------
 *  ->0.0.2:  Version mit Pseudo-Animation (4 bouncing balls). Noch keine
 *            Darstellungsroutinen
 *  0.0.3:    Darstellungsroutinen eingebaut fuer Quader und Kugel
 *  0.0.4:    Darstellungsroutinen fuer Zylinder und Nagel, alle Projektions-
 *            routinen ausgemistet und kommentiert
 *  0.0.5:    Darstellungsroutinen fuer Koordinatensysteme eingebaut, Routinen
 *            fuer Animationsfenster in eigenes File (animat.c) ausgelagert
 *  0.0.6:    Darstellungsroutinen fuer Verbindungen eingebaut, erste (noch
 *            falsche) Farbroutinen.
 *  0.0.7:    Korrektur der Farbroutinen, Objekt EBENE als Spurlinien
 *            eingebaut. (Schnittlinien mit der XY-, XZ- und YZ-Ebene)
 *  0.0.8:    Ebenen als perspektivisches Quadrat
 *  0.0.9:    Zoom-Faktor wird erst bei ProjektionPunkt() auf die Bildschirm-
 *            koordinaten aufmultipliziert (2D), nicht schon bei
 *            TransformationPunkt() auf die 3D-Koordinaten. Auslagerung
 *            einiger Routinen in ein eigenes Utility-File autils.c
 *  0.0.10:   Achsenschnittpunkte werden nun auch durch Projektion berechnet
 *            und sind nun genauer. Kraefte eingebaut. Probleme durch
 *            casting von TReal auf AXKoord beseitigt (TReal2AXKoord).
 *  0.1.0:    Die ganze Routine ist umgemodelt und merkt sich nun nicht mehr
 *            2D-Linien, sondern 3D-Punktkoordinaten. Diese werden dann beim
 *            Redraw auf 2D projiziert, d.h. der Redraw ist etwas
 *            aufwendiger geworden. Dafuer erfolgt jetzt ein korrektes
 *            Verhalten bei Windowgroessenanderung. Dieses Prinzip
 *            ermoeglicht einen einfacheren und uebersichtlicheren
 *            Programmaufbau. Ab jetzt heissen die beteiligten Files nicht
 *            mehr anzeige.[ch], sondern darstellung.[ch]
 *  0.1.1:    Zusammengesetzte Objekte eingefuegt, Gelenkaussehen veraendert,
 *            einige Fehler entfernt.
 *  0.1.2:    Kraftprojektion korrigiert. Variable dfont war versehentlich
 *            nicht static deklariert (ist jetzt korrigiert).
 *  0.1.3:    Selektionsroutinen SelektiereVonDarstellung() und
 *            OffsetDarstellung() eingebaut
 ********************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <stdio.h>

#include <stdlib.h>
#include <math.h>

#include "darstellung.h"		  /* alle lokalen Definitionen */
#include "autils.h"			  /* diverse Matrix-, Vektor und */
					  /* Error-Funktionen */

/*======================================================================*/

/***********************************************************************
 *  Variablen fuer die Darstellungsroutinen
 ***********************************************************************/



/* ------- Infos ueber die 4 verwendeten Fenster der Darstellung ------- */

static Window  window[AnzahlAnsichten];   /* Window-IDs fuer die 4 Fenster */
                                          /* der Darstellung */
static Display *display[AnzahlAnsichten];/* Display-Zeiger fuer diese 4 */
                                       	  /* Fenster (i.a. alle gleich) */
static int     screen[AnzahlAnsichten];	  /* Screen-IDs feur diese 4 Fenster */
                                     	  /* (wohl auch alle gleich) */
static AXKoord winwidth[AnzahlAnsichten]; /* Breiten der 4 Fenster */
static AXKoord winheight[AnzahlAnsichten];/* Hoehen der 4 Fenster */ 



/* ----- Infos ueber die verwendeten Graphics-Contexts der Darstellung ----- */

static GC darst_GC;			  /* Zum Zeichnen der Koerper u.ae. */
static GC darst_achseGC;		  /* fuer Koordinatenachsen u.ae. */

static unsigned int liniendicke;	  /* akt. Liniendicke in darst_GC */

static XFontStruct *dfont;		  /* Info ueber den Font (noetig */
					  /* fuer die Achsenbeschriftung) */



/* ---------------------- Infos ueber die Farben ---------------------- */

static AXColornum RGB_farbnr;		  /* Farbnummer, die fuer das */
					  /* RGB-Fenster verwendet wird. */



/* ---------- Info ueber die Koordinatenachsen in den 4 Fenstern ---------- */

static XPoint achsenXY, achsenYZ, achsenXZ; /* Schnittpunkte der */
					    /* Koordinatenachsen in den 3 */
					    /* Seitenansichten */

static XPoint xr, xl, yo, yu, zv, zh;	    /* Achsenendpunkte und */
static XPoint xp1, xp2, yp1, yp2, zp1, zp2; /* Pfeilspitzenpunkte im */
					    /* 3d-Window */
     


/* --- Infos ueber den momentan angezeigten Zustand (z.B. fuer den Redraw) --- */

static AZustand darstellung;		  /* Koerper-/Verbindungsdaten */




/* ---------- Matrizen zur Transformation von Punkten im Raum ---------- */

static AMatrix M_ansicht[AnzahlAnsichten];/* Transformation fuer Kamerapo- */
					  /* sition der jeweiligen Ansicht */

static AMatrix M_t[AnzahlAnsichten];	  /* Gesamttransformation fuer */
					  /* einen Koerper/eine Verbindung */

/******************************************************************************
 *  Die Matrizen M_t enthalten im einzelnen folgende Transformationen:
 *  1. Objekt in die Welt platzieren (fuer jedes Objekt anders)
 *    1a. Objekt in korrekte Lage drehen (-> Quaternion)
 *    1b. Objekt an seine Position in der Welt verschieben     
 *  2. Darstellungsposition einbeziehen (eindeutig fuer gesamte Darstellung)
 *    2a. Darstellungsposition an Koordinatenursprung verschieben
 *    2b. Koordinatensystem in die Lage der Darstellung drehen (-> Quaternion)
 *  3. Pseudo-Kamera fuer entsprechendes Darstellungsfenster (jeweils eindeutig
 *     fuer ein Darstellungsfenster)
 *    3a. Drehung des Koordinatensystems in die Lage der entsprechenden Kamera
 *    3b. Verschiebung der Kamera nach hinten (in z-Richtung)
 *
 *  Mit einer solchen Matrix kann die gesamte Transformation (ausser der
 *  Projektion 3D->2D) fuer einen Punkt eines Koerpers/einer Verbindung auf
 *  einmal ausgefuehrt werden. 
 *****************************************************************************/


/* -------- Variablen fuer Beschleunigung beim Linienzeichnen ---------- */

static XSegment linien[DARST_MAXLINES];
static anzahl = 0;



/* -------- Variablen zur Einsparung unnoetiger Funktions-Parameter -------- */

static TReal    d_zoom;			  /* momentaner Zoom-Faktor */
static AXKoord  winmaxx[AnzahlAnsichten], /* maximale x- und y-Koordinate */
                winmaxy[AnzahlAnsichten]; /* der 4 Windows */
static int      modus;			  /* Anzeigemodus fuer das momentane */
					  /* Bild (Werte siehe bei */
					  /* AnzeigeDarstellung() ) */


/*======================================================================*/

/***********************************************************************
 *  Das Makro AlleAnsichten ermoeglicht es, Schleifen folgenden Aussehens zu
 *  formulieren (z.B. fuer die einzelnen Koerper):
 *      {
 *        short ansicht;
 *        ...
 *        for AlleAnsichten(ansicht)
 *        { ... Schleifenkoerper, Laufvariable ansicht ... }
 *      }
 ***********************************************************************/

#define AlleAnsichten(i) (i=0; i<AnzahlAnsichten; i++)




/*****************************************************************************
 *  Funktion:       void ProjektionPunkt(TVektor punkt, TReal x, TReal y, TReal z)
 *  Parameter:      x,y,z: Koordinaten des Punktes vor der Abbildung
 *                            
 *  Rueckgabewert:  punkt: Koordinaten des abgebildeten Punktes
 *
 *  Importierte Bezeichner: 
 *
 *  Beschreibung:
 *  -------------
 *  Transformation des Punktes punkt auf die 2D-Ebene (Parallelprojektion). 
 *  Punkt muss dabei einen z-Wert<0 haben, damit er im Blickfeld der virtuellen 
 *  Kamera liegt. Im 2D-Bereich wird dann entsprechend skaliert (mit d_zoom),
 *  damit die Bilder passend auf dem Window zu sehen sind.
 *****************************************************************************/

static void ProjektionPunkt(short a, TVektor punkt, AXKoord *x, AXKoord *y)
{
     *x = TReal2AXKoord(B_ACHSEN_X * punkt[0] * d_zoom + winmaxx[a]/2 +0.5);
     *y = TReal2AXKoord(B_ACHSEN_Y * punkt[1] * d_zoom + winmaxy[a]/2 +0.5);
}




/*****************************************************************************
 *  Funktion:       XPoint ProjektionAchsenPunkt(TReal x, TReal y, TReal z)
 *  Parameter:      x,y,z: Koordinaten des Punktes vor der Abbildung
 *                            
 *  Rueckgabewert:         2D-Koordinaten des abgebildeten Punktes
 *
 *  Importierte Bezeichner: M_ansicht: Matrix fuer Transformation
 *                          winmaxx:   Breite des aktuellen Fensters
 *                          winmaxy:   Hoehe des aktuellen Fensters
 *                          achsen:    Faktoren fuer die Achsen (+/- 1)
 *
 *  Beschreibung:
 *  -------------
 *  Projektion eines Punktes auf das aktuelle Fenster. Dies wird nur mit der 
 *  Matrix M_ansicht durchgefuehrt und damit fuer Punkte geeignet, die nur vom
 *  Fenster und nicht von irgendwelchen Koerpern oder Verbindungen abhaengen
 *  (z.B. Koordinatenachsen). (Entspricht in etwa einer Kombination aus
 *  TransformationPunkt und ProjektionPunkt. Dabei erfolgt die Berechnung
 *  nur fuer 2 Koordinaten und ohne den Faktor d_zoom.)
 *****************************************************************************/

static XPoint ProjektionAchsenPunkt(short a, TReal x, TReal y, TReal z)
{
     XPoint punkt;

     punkt.x = B_ACHSEN_X*(M_ansicht[a][0][0]*x + M_ansicht[a][0][1]*y 
			 + M_ansicht[a][0][2]*z + M_ansicht[a][0][3])+winmaxx[a]/2;
     punkt.y = B_ACHSEN_Y*(M_ansicht[a][1][0]*x + M_ansicht[a][1][1]*y 
			 + M_ansicht[a][1][2]*z + M_ansicht[a][1][3])+winmaxy[a]/2;

     return punkt;

}


/*****************************************************************************
 *  Funktion:       void ClipLinie2d(AXkoord x1, AXKoord y1, AXKoord x2, AXKoord y2)
 *  Parameter:      x1, y1,
 *                  x2, y2: Koordinaten der abzulegenden Linie
 *                            
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   linien[]: Feld, in das die Linien abgelegt werden
 *                  anzahl:   Anzahl Linien, die schon in diesem Feld sind
 *
 *  Beschreibung:
 *  -------------
 *  Die Linie mit den angegebenen Koordinaten wird im Linien-Puffer
 *  abgelegt. Am Ende koennen dann alle Linien auf einmal mit ZeicheLinien()
 *  hingemalt werden. 
 *****************************************************************************/

static void ClipLinie2d(AXKoord x1, AXKoord y1, AXKoord x2, AXKoord y2)
{
     linien[anzahl].x1 = x1;
     linien[anzahl].y1 = y1;
     linien[anzahl].x2 = x2;
     linien[anzahl].y2 = y2;

     if (anzahl<DARST_MAXLINES-1) anzahl++;
}



/*****************************************************************************
 *  Funktion:       void ClipLinie3d(TVektor p1, TVektor p2)
 *  Parameter:      p1, p2:  Endpunkte der Linie (im Raum)
 *                            
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   linien[]: Puffer fuer die Linien
 *                  anzahl:   Anzahl Linien, die schon in dem Puffer sind
 *
 *  Beschreibung:
 *  -------------
 *  Die Linie mit den 3D-Endpunkten p1 und p2 wird (mit Parallelprojektion)
 *  auf eine Ebene (2D) projiziert. ACHTUNG: zur Vereinfachung des
 *  Algorithmus kann es sein, dass Anfangs- und Endpunkt logisch vertauscht
 *  werden.  
 *  Anschliessend wird die Linie durch Aufruf von ClipLinie2d() in den
 *  Linien-Puffer eingetragen.
 *****************************************************************************/

static void ClipLinie3d(short a, TVektor p1, TVektor p2)
{
     AXKoord x1, y1, x2, y2;

#if 0
     if (p1[2] >= 0)			 
     {
	  if (p2[2] >= 0) return;	  /* Linie nicht sichtbar (hinter Kamera) */

	  hilfs = p1;			  /* wenn, dann nur p2 hinter Kamera */
	  p1 = p2;			  /* also: p1 und p2 vertauschen */
	  p2 = hilfs;

     }
#endif

     ProjektionPunkt(a, p1, &x1, &y1);
					  /* Anfangspunkt garantiert sichtbar */

#if 0
     if (p2[2] < 0)			  /* Linie normal sichtbar */
     {
#endif
	  ProjektionPunkt(a, p2, &x2, &y2);
#if 0
     }
     else				  /* Linie mit Bildebene schneiden */
     {
	  TVektor neu;

	  h = -p1[2]/(p2[2]-p1[2]);
	  neu[0] = p1[0]+h*(p2[0]-p1[0]);
	  neu[1] = p1[1]+h*(p2[1]-p1[1]);
	  neu[2] = 0;
	  
	  ProjektionPunkt(a, neu, &x2, &y2);
     }
#endif

     ClipLinie2d(x1, y1, x2, y2);
}



/*****************************************************************************
 *  Funktion:       void ClipPfeil3d(short a, GC malGC, TVektor p1, TVektor p2)
 *
 *  Parameter:      a:       benutzte Ansicht
 *                  malGC:   GC, mit dem die Linie gezeichnet werden soll
 *                  p1, p2:  Endpunkte der Linie (im Raum)
 *                            
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   linien[]: Puffer fuer die Linien
 *                  anzahl:   Anzahl Linien, die schon in dem Puffer sind
 *
 *  Beschreibung:
 *  -------------
 *  Die Linie mit den 3D-Endpunkten p1 und p2 wird (mit Parallelprojektion)
 *  auf eine Ebene (2D) projiziert. ACHTUNG: zur Vereinfachung des
 *  Algorithmus kann es sein, dass Anfangs- und Endpunkt logisch vertauscht
 *  werden.  
 *****************************************************************************/

static void ClipPfeil3d(short a, GC malGC, TVektor p1, TVektor p2)
{
     AXKoord x1, y1, x2, y2;
     TReal h;

#if 0
     if (p1[2] >= 0)			 
     {
	  if (p2[2] >= 0) return;	  /* Linie nicht sichtbar (hinter Kamera) */

	  hilfs = p1;			  /* wenn, dann nur p2 hinter Kamera */
	  p1 = p2;			  /* also: p1 und p2 vertauschen */
	  p2 = hilfs;

     }
#endif

     ProjektionPunkt(a, p1, &x1, &y1);
					  /* Anfangspunkt garantiert sichtbar */

     if (p2[2] < 0)			  /* Linie normal sichtbar */
     {
	  ProjektionPunkt(a, p2, &x2, &y2);
     }
     else				  /* Linie mit Bildebene schneiden */
     {
	  TVektor neu;

	  h = -p1[2]/(p2[2]-p1[2]);
	  neu[0] = p1[0]+h*(p2[0]-p1[0]);
	  neu[1] = p1[1]+h*(p2[1]-p1[1]);
	  neu[2] = 0;
	  
	  ProjektionPunkt(a, neu, &x2, &y2);
     }

     XDrawLine(display[a], window[a], malGC, x1, y1, x2, y2);

     /* ##### hier jetzt Pfeilspitze malen, aber nur, wenn p2 sichtbar #### */
}



/*****************************************************************************
 *  Funktion:       void ZeichneLinien(short a)
 *  
 *  Parameter:      a:    Ansicht, auf die gezeichnet werden soll
 *                            
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   linien:    Puffer fuer Linien
 *                  anzahl:    Anzahl Linien in diesem Puffer
 *                  display[]: Display fuer Ansicht
 *                  window[]:  Window fuer Ansicht
 *                  darst_GC:  Benutzter GC beim zeichnen
 *
 *  Beschreibung:
 *  -------------
 *  Wenn im Linienpuffer Linien enthalten sind, dann werden diese mit einem
 *  XDrawSegments()-Aufruf auf das Window fuer die angegebene Ansicht
 *  gezeichnet und der Puffer wieder geleert. Wenn keine Linien enthalten
 *  sind, dann passiert gar nichts.
 *  Diese Routine sollte immmer aufgerufen werden, wenn wieder ein Objekt
 *  vollstaendig berechnet und im Linienpuffer abgelegt wurde. Durch den
 *  Aufruf mit XDrawSegments() sollte das Zeichnen schneller gehen als durch
 *  einzelne XDrawLine()-Aufrufe innerhalb von ClipLinie3d().
 *****************************************************************************/

static void ZeichneLinien(short a)
{
     if (anzahl>0)
     {
	  XDrawSegments(display[a], window[a], darst_GC, linien, anzahl);
	  anzahl = 0;
     }
}



/*****************************************************************************
 *  Funktion:       void ProjektionQuader(AKoerper *z, TVektor ausdehnung)
 *  
 *  Parameter:      z:          Zeiger auf das aktuelle Koeper-Element
 *                  ausdehnung: Groesse des Quaders in die 3 Achsenrichtungen
 *                            
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   M_t[]:   Koerpertransformationen
 *
 *  Beschreibung:
 *  -------------
 *  Berechnen der Eckpositionen des Quaders.
 *****************************************************************************/

static void ProjektionQuader(AKoerper *z, TVektor ausdehnung)
{
     TReal vorne, hinten, oben, unten, rechts, links;
     short a;

     rechts= ausdehnung[0]/2;
     links = -rechts;
     oben  = ausdehnung[1]/2;
     unten = -oben;
     vorne = ausdehnung[2]/2;
     hinten= -vorne;

     for AlleAnsichten(a)
     {
	  ATransformation(z->param.quader.luv[a], M_t[a], links, unten, vorne);
	  ATransformation(z->param.quader.lov[a], M_t[a], links, oben, vorne);
	  ATransformation(z->param.quader.rov[a], M_t[a], rechts, oben, vorne);
	  ATransformation(z->param.quader.ruv[a], M_t[a], rechts, unten, vorne);
	  ATransformation(z->param.quader.luh[a], M_t[a], links, unten, hinten);
	  ATransformation(z->param.quader.loh[a], M_t[a], links, oben, hinten);
	  ATransformation(z->param.quader.roh[a], M_t[a], rechts, oben, hinten);
	  ATransformation(z->param.quader.ruh[a], M_t[a], rechts, unten, hinten);
     }

}		    




/*****************************************************************************
 *  Funktion:       void ProjektionZylinder(AKoerper *z, TReal radius, TReal hoehe)
 *  Parameter:      z:       Zeiger auf das aktuelle Koeper-Element
 *                  radius:  Radius des Zylinders
 *                  hoehe:   Hoehe des Zylinders
 *                            
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   M_t[]:   Koerpertransformationen
 *
 *  Beschreibung:
 *  -------------
 *  Vom Zylinder DARST_ZYLPOINTS auf den beiden Kreisraendern berechnen und
 *  in der Koerper-Liste ablegen.
 *****************************************************************************/

static void ProjektionZylinder(AKoerper *z, TReal radius, TReal hoehe)
{
     TReal winkel1, winkel2, h2;
     short a;

     winkel1 = radius * 0.8660254;	  /* sin 60 deg = cos 30 deg */
     winkel2 = radius * 0.5;		  /* sin 30 deg = cos 60 deg */
     h2 = hoehe/2;

     for AlleAnsichten(a)
     {
	  /* oberen Kreis mit einigen Punkten berechnen */
	  ATransformation(z->param.zylinder.p[a][0], M_t[a], radius, 0, h2);
	  ATransformation(z->param.zylinder.p[a][1], M_t[a], winkel1, winkel2, h2);
	  ATransformation(z->param.zylinder.p[a][2], M_t[a], winkel2, winkel1, h2);
	  ATransformation(z->param.zylinder.p[a][3], M_t[a], 0, radius, h2);
	  ATransformation(z->param.zylinder.p[a][4], M_t[a], -winkel2, winkel1, h2);
	  ATransformation(z->param.zylinder.p[a][5], M_t[a], -winkel1, winkel2, h2);
	  ATransformation(z->param.zylinder.p[a][6], M_t[a], -radius, 0, h2);
	  ATransformation(z->param.zylinder.p[a][7], M_t[a], -winkel1, -winkel2, h2);
	  ATransformation(z->param.zylinder.p[a][8], M_t[a], -winkel2, -winkel1, h2);
	  ATransformation(z->param.zylinder.p[a][9], M_t[a], 0, -radius, h2);
	  ATransformation(z->param.zylinder.p[a][10], M_t[a], winkel2, -winkel1, h2);
	  ATransformation(z->param.zylinder.p[a][11], M_t[a], winkel1, -winkel2, h2);
	  
	  h2=-h2;
	  
	  /* unteren Kreis mit einigen Punkten berechnen */
	  ATransformation(z->param.zylinder.q[a][0], M_t[a], radius, 0, h2);
	  ATransformation(z->param.zylinder.q[a][1], M_t[a], winkel1, winkel2, h2);
	  ATransformation(z->param.zylinder.q[a][2], M_t[a], winkel2, winkel1, h2);
	  ATransformation(z->param.zylinder.q[a][3], M_t[a], 0, radius, h2);
	  ATransformation(z->param.zylinder.q[a][4], M_t[a], -winkel2, winkel1, h2);
	  ATransformation(z->param.zylinder.q[a][5], M_t[a], -winkel1, winkel2, h2);
	  ATransformation(z->param.zylinder.q[a][6], M_t[a], -radius, 0, h2);
	  ATransformation(z->param.zylinder.q[a][7], M_t[a], -winkel1, -winkel2, h2);
	  ATransformation(z->param.zylinder.q[a][8], M_t[a], -winkel2, -winkel1, h2);
	  ATransformation(z->param.zylinder.q[a][9], M_t[a], 0, -radius, h2);
	  ATransformation(z->param.zylinder.q[a][10], M_t[a], winkel2, -winkel1, h2);
	  ATransformation(z->param.zylinder.q[a][11], M_t[a], winkel1, -winkel2, h2);
     }
}		    




/*****************************************************************************
 *  Funktion:       void ProjektionKugel(AKoerper *z, TReal radius)
 *
 *  Parameter:      z:       Zeiger auf das aktuelle Koeper-Element
 *                  radius:  Radius der Kugel
 *                            
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   M_t[]:   Koerpertransformationen
 *
 *  Beschreibung:
 *  -------------
 *  Position der Kugel ausrechnen und in Koerper-Liste ablegen.
 *****************************************************************************/

static void ProjektionKugel(AKoerper *z, TReal radius)
{
     short a;

     for AlleAnsichten(a)
     {
	  ATransformation(z->param.kugel.mittelpunkt[a], M_t[a], 0, 0, 0);
     }
	  z->param.kugel.radius = radius;
}



/*****************************************************************************
 *  Funktion:       void ProjektionNagel(AKoerper *z)
 *
 *  Parameter:      z:        Zeiger auf das aktuelle Koeper-Element
 *                            
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   M_t[]:   Koerpertransformationen
 *
 *  Beschreibung:
 *  -------------
 *  Die Position des Nagels wird fuer alle 4 Ansichten berechnet und in der
 *  zugehoerigen Koerper-Liste abgelegt.
 *****************************************************************************/

static void ProjektionNagel(AKoerper *z)
{
     short a;

     for AlleAnsichten(a)
     {
	  ATransformation(z->param.nagel.punkt[a], M_t[a], 0, 0, 0);
     }
}



/*****************************************************************************
 *  Funktion:       void ProjektionEbene(AKoerper *z, TVektor darstpos)
 *
 *  Parameter:      z:        Zeiger auf das aktuelle Koeper-Element
 *                  darstpos: Darstellungsposition (siehe AnzeigeDarstellung())
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   M_t[]:       Matrizen mit den aktuellen Koerpertrans-
 *                               formationen (zur Berechnung des Normalen-
 *                               vektors der Ebene)
 *                  M_ansicht[]: Matrizen mit den aktuellen Ansichtstrans-
 *                               formationen (fuer Transformation der
 *                               Darstellungsposition)
 *
 *  Beschreibung:
 *  -------------
 *  Ueber den Normalenvektor der Ebene wird der Punkt auf der Ebene
 *  gesucht, der der Darstellungsposition am naechsten ist. Um diesen Punkt
 *  herum wird nun ein Rechteck berechnet, dessen Groesse abhaengig von der
 *  Groesse des aktuellen Darstellungsfensters ist. Die Linien dieses
 *  Rechtecks werden in die aktuell-Struktur uebernommen.
 *****************************************************************************/

static void ProjektionEbene(AKoerper *z, TVektor darstpos)
{
     TVektor n;				  /* Normalenvektor der Ebene */

     TVektor p, dp;
     TReal lambda;
     short a;

     for AlleAnsichten(a)
     {
	  ATransformation(p, M_t[a], 0, 0, 0); /* Aufsetzpunkt der Ebene */
	  
	  /* Berechne Normalenvektor durch M_t[a][0..2][0..2]*(0,1,0), d.h.
	     die Positionsverschiebung M_t[a][0..2][3] wird nicht einberechnet.
	     Das Ergebnis ist einfach der Spaltenvektor M_t[a][0..2][1];
	     dieser Vektor muesste eigentlich schon normiert sein. */
	  
	  n[0] = M_t[a][0][1];		  /* (0,0,0) kann es hier nie geben! */
	  n[1] = M_t[a][1][1];		  /* (sonst gaebe es Probleme beim */
	  n[2] = M_t[a][2][1];		  /* Normieren) */
	  
	  ANormiereVektor(n);		  /* mathematisch unnoetig, Vektor */
	                                  /* muesste schon vorher Laenge 1 */
                                	  /* haben. Nur zur Sicherheit.  */
	  
#if 0	  /* Alternative Berechnungsmethode fuer n: */
	  ATransformation(n, M_t[a], 0, 1, 0); 
	  n[0]-=p[0];
	  n[1]-=p[1];
	  n[2]-=p[2];
	  ANormiereVektor(n);
#endif
	  

	  /* Ort der Darstellungsposition in dieser Ansicht */
	  ATransformation(dp, M_ansicht[a], darstpos[0], darstpos[1], darstpos[2]);
#if 0
	  printf("ProjektionEbene: dp=(%f,%f,%f)\n",dp[0],dp[1],dp[2]);
#endif
	  

	  lambda = ((dp[0]-p[0])*n[0]+(dp[1]-p[1])*n[1]+(dp[2]-p[2])*n[2]);
	  
	  z->param.ebene.q[a][0] = dp[0]-lambda*n[0];	  /* Punkt auf der Ebene, der dp am */
	  z->param.ebene.q[a][1] = dp[1]-lambda*n[1];	  /* naechsten ist */
	  z->param.ebene.q[a][2] = dp[2]-lambda*n[2];
	  

	  /* Berechnen von 2 Basisvektoren in der rotierten Ebene:
	     b1 = M_t[a][0..2][0..2] * (1,0,0) = M_t[a][0..2][0]
	     b2 = M_t[a][0..2][0..2] * (0,0,1) = M_t[a][0..2][2]
	     d.h. die Berechnung erfolgt aenlich der von n (s.o.) */
	  
	  z->param.ebene.b1[a][0] = M_t[a][0][0];
	  z->param.ebene.b1[a][1] = M_t[a][1][0];
	  z->param.ebene.b1[a][2] = M_t[a][2][0];
	  
	  z->param.ebene.b2[a][0] = M_t[a][0][2];
	  z->param.ebene.b2[a][1] = M_t[a][1][2];
	  z->param.ebene.b2[a][2] = M_t[a][2][2];
	  
	  ANormiereVektor(z->param.ebene.b1[a]); /* eigentlich unnoetig, s.o. bei n */
	  ANormiereVektor(z->param.ebene.b2[a]); /* zur Sicherheit trotzdem */
	  
#if 0
	  /* alternative Berechnung von b1 und b2: */
	  ATransformation(b1, M_t[a], 1.0, 0.0, 0.0);
	  ATransformation(b2, M_t[a], 0.0, 0.0, 1.0);
	  
	  b1[0]-=p[0];
	  b1[1]-=p[1];
	  b1[2]-=p[2];
	  
	  b2[0]-=p[0];
	  b2[1]-=p[1];
	  b2[2]-=p[2];
	  
	  ANormiereVektor(b1);
	  ANormiereVektor(b2);
#endif
	  

     }	/* for AlleAnsichten(a) */
}





/*****************************************************************************
 *  Funktion:       void ProjektionKraefte(AKraft **old, TKraft *kraft,
 *                                            TKoerper *koerper)
 *
 *  Parameter:      old:     Zeiger auf das vorhergehende Objekt
 *                  kraft:   Zeiger auf die Kraftliste
 *                  koerper: Zeiger auf den aktuellen Koerper (nur bei
 *                                       gerichteten Kraeften gebraucht)
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   M_ansicht[], M_t[]
 *
 *  Beschreibung:
 *  -------------
 *  Die Liste mit Kraeften (eines einzelnen Koerpers) wird (mit den gerade
 *  aktuellen Linienattributen) hingezeichnet.
 *****************************************************************************/

static void ProjektionKraefte(AKraft **old, TKraft *kraft, TKoerper *koerper)
{
     AKraft *zeiger;
     short  a;
     TVektor normkraft;

     do
     {
	  zeiger = (AKraft *) malloc(sizeof(AKraft)); /* Kraftelement */
	  if (zeiger==NULL)		  /* Fehler? */
	  {
	       AFehler("malloc(): No room for force at display routines.\n");
	  }
	  zeiger->next = NULL;		  /* momentan letztes Element */

	  *old = zeiger;		  /* letztes Element hierher zeigen */
	  old = &(zeiger->next);	  /* lassen */

	  for AlleAnsichten(a)
	  {
	       ATransformation(zeiger->anfang[a], M_t[a], 
			       kraft->Angriffspunkt[0],
			       kraft->Angriffspunkt[1],
			       kraft->Angriffspunkt[2]);
	  }
	  switch(kraft->Typ)
	  {
	    case RAUMFEST:
	       for AlleAnsichten(a)
	       {
		    normkraft[0] = kraft->KD.Kraft[0];
		    normkraft[1] = kraft->KD.Kraft[1];
		    normkraft[2] = kraft->KD.Kraft[2];
		    ANormiereVektor(normkraft);
		    normkraft[0]*=KraftMproN;
		    normkraft[1]*=KraftMproN;
		    normkraft[2]*=KraftMproN;

		    ATransformation(zeiger->ende[a], M_ansicht[a],
				    normkraft[0], normkraft[1], normkraft[2]);

		    zeiger->ende[a][0]+=zeiger->anfang[a][0]-M_ansicht[a][0][3];
		    zeiger->ende[a][1]+=zeiger->anfang[a][1]-M_ansicht[a][1][3];
		    zeiger->ende[a][2]+=zeiger->anfang[a][2]-M_ansicht[a][2][3];
	       }
	       break;		    

	    case KOERPERFEST:
	       for AlleAnsichten(a)
	       {
		    normkraft[0] = kraft->KD.Kraft[0];
		    normkraft[1] = kraft->KD.Kraft[1];
		    normkraft[2] = kraft->KD.Kraft[2];
		    ANormiereVektor(normkraft);

		    normkraft[0]*=KraftMproN;
		    normkraft[1]*=KraftMproN;
		    normkraft[2]*=KraftMproN;
		    
		    ATransformation(zeiger->ende[a], M_t[a],
				    normkraft[0], normkraft[1], normkraft[2]);

		    zeiger->ende[a][0]+=zeiger->anfang[a][0]-M_t[a][0][3];
		    zeiger->ende[a][1]+=zeiger->anfang[a][1]-M_t[a][1][3];
		    zeiger->ende[a][2]+=zeiger->anfang[a][2]-M_t[a][2][3];
	       }
	       break;		    

	    case GERICHTET:
	       {
		    AMatrix M_k2, M_k1;
		    TVektor hilfs;
		    
		    MatrixFromQuaternion(koerper->q, M_k1);
		    M_k1[0][3] = koerper->Position[0];
		    M_k1[1][3] = koerper->Position[1];
		    M_k1[2][3] = koerper->Position[2];
		    
		    MatrixFromQuaternion(kraft->KD.GerKraft.ZielKoerper->q,
					 M_k2);

		    M_k2[0][3] = kraft->KD.GerKraft.ZielKoerper->Position[0];
		    M_k2[1][3] = kraft->KD.GerKraft.ZielKoerper->Position[1];
		    M_k2[2][3] = kraft->KD.GerKraft.ZielKoerper->Position[2];

		    ATransformation(hilfs, M_k1, 
				    kraft->Angriffspunkt[0],
				    kraft->Angriffspunkt[1],
				    kraft->Angriffspunkt[2]);

		    ATransformation(normkraft, M_k2, 
				    kraft->KD.GerKraft.Zielpunkt[0],
				    kraft->KD.GerKraft.Zielpunkt[1],
				    kraft->KD.GerKraft.Zielpunkt[2]);
		    
		    normkraft[0] -= hilfs[0];
		    normkraft[1] -= hilfs[1];
		    normkraft[2] -= hilfs[2];

		    ANormiereVektor(normkraft);
		    normkraft[0] *= KraftMproN;
		    normkraft[1] *= KraftMproN;
		    normkraft[2] *= KraftMproN;

		    for AlleAnsichten(a)
		    {
			 ATransformation(zeiger->ende[a], M_ansicht[a],
					 normkraft[0], normkraft[1], normkraft[2]);
			 zeiger->ende[a][0]+=zeiger->anfang[a][0]-M_ansicht[a][0][3];
			 zeiger->ende[a][1]+=zeiger->anfang[a][1]-M_ansicht[a][1][3];
			 zeiger->ende[a][2]+=zeiger->anfang[a][2]-M_ansicht[a][2][3];
		    }				    
	       }
	       break;
	  }

	  kraft = kraft->Naechste;	  /* naechste Kraft */
     } while (kraft != NULL);		  /* weiter, bis alle Kraefte durch */
}



/*****************************************************************************
 *  Funktion:       void ProjektionKoerper(TKoerper *koerper, TVektor darstpos)
 *
 *  Parameter:      koerper: Zeiger auf die 3D-Koerper-Daten im aktuellen Zustand
 *                  darstpos:Darstellungposition (noetig fuer Objekt EBENE)
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   M_ansicht[], M_t[]
 *
 *  Beschreibung:
 *  -------------
 *  Die Liste der Koerper aus dem Zustand wird bearbeitet. Dabei wird eine
 *  eigene Koerperliste aufgebaut, in die fuer die Darstellung wichtigen
 *  Daten eingetragen werden. Insbesondere werden die Koerper relativ zu den
 *  einzelnen Ansichten in den Raum platziert und die Positionen in den
 *  neuen Koerper-Elementen abgelegt. Ausserdem werden alle Kraefte
 *  berechnet und diverse Kraeftelisten (abhaengig von den Koerpern)
 *  aufgebaut.
 *****************************************************************************/

static void ProjektionKoerper(TKoerper *koerper, TVektor darstpos)
{
     AKoerper *zeiger;      /* Zeiger auf Element innerhalb der Darstellungsliste */
     AKoerper **old;        /* Zeiger auf Next-Zeiger des vorhergehenden Elements */
     AMatrix M_koerper;			  /* Matrix fuer Koerperdrehung */
     XColor farbe;			  /* Zum Allozieren der Farben */


     old = &(darstellung.koerper);	  /* Beim erstenmal Listenanfang aendern */

     do
     {
	  /* Matrix fuer Koerperfest->Raumfest berechnen */
	  MatrixFromQuaternion(koerper->q, M_koerper);

	  M_koerper[0][3] = koerper->Position[0];
	  M_koerper[1][3] = koerper->Position[1];
	  M_koerper[2][3] = koerper->Position[2];


	  /* Matrizen zusaetzlich auch fuer Raumfest->Ansicht berechnen */
	  AMatrixMult(M_ansicht[Axy], M_koerper, M_t[Axy]);
	  AMatrixMult(M_ansicht[Ayz], M_koerper, M_t[Ayz]);
	  AMatrixMult(M_ansicht[Axz], M_koerper, M_t[Axz]);
	  AMatrixMult(M_ansicht[A3d], M_koerper, M_t[A3d]);


	  /* Platz fuer ein neues Koerper-Element anfordern */
	  zeiger = (AKoerper *) malloc(sizeof(AKoerper));
	  if (zeiger == NULL)
	  {
	       AFehler("malloc(): No room for object at display-routines.\n");
	       return;
	  }
	  zeiger->next  = NULL;		  /* momentan letztes Listenelement */


	  /* Verkettung: das vorhergehende Element (bzw. der Listenpointer
	     selbst) muss jetzt hierher zeigen */
	  *old = zeiger;
	  old = &(zeiger->next);


	  /* einige Koerperdaten kopieren */
	  zeiger->art = koerper->Art;
	  zeiger->AStatus = koerper->AStatus;

	  if (koerper->Art==ZUSGESOBJ)
	  {
	       farbe.red   = 0;		  /* Koerperkoordinatensystem von */
	       farbe.green = 0;		  /* zusammengesetzten Koerpern in */
	       farbe.blue  = 0;		  /* schwarz */
	  }
	  else
	  {
	       /* Farbe fuer diesen Koerper read-only allozieren */
	       farbe.red   = koerper->R;
	       farbe.green = koerper->G;
	       farbe.blue  = koerper->B;
	  }
	  farbe.flags = DoRed | DoGreen | DoBlue;
	  AGetColor(display[0], a_colormap, &farbe, "ProjektionKoerper()");

	  zeiger->farbnr = farbe.pixel;	  /* Farbnummer merken */

	  /* ggf. Endpunkte der Koerper-Koordinatenachsen berechnen */
	  if (modus & ObjectCoordON) 
	  {
	       switch (koerper->Art)
	       {
		 case KUGEL:	  /* nur bei KUGEL, QUADER, ZYLINDER  */
		 case QUADER:	  /* und Ebene sind Koordinatenachsen */
		 case EBENE:	  /* sinnvoll */
		 case ZYLINDER:
		    {
			 short a;

			 for AlleAnsichten(a)
			 {
			      ATransformation(zeiger->k0[a], M_t[a], 0, 0, 0);
			      ATransformation(zeiger->kx[a], M_t[a], 0.2, 0, 0);
			      ATransformation(zeiger->ky[a], M_t[a], 0, 0.2, 0);
			      ATransformation(zeiger->kz[a], M_t[a], 0, 0, 0.2);
			 }
		    }
		    break;
		 default:
		    break;
	       }  /* switch (koerper->Art) */
	  }  /* if (modus & ObjectCoordON) */

	  
	  zeiger->kraft = NULL;

	  if (modus & ForcesON)
	  {
	       /* Positionen aller Kraefte an diesem Koerper berechnen */
	       if ((koerper->Kraefte) != NULL)
	       {
		    ProjektionKraefte(&(zeiger->kraft), koerper->Kraefte, koerper);
	       }
	  }

	  
	  /* Positionen der Koerper berechnen */
	  switch (koerper->Art)
	  {
	    case KUGEL:
	       ProjektionKugel(zeiger, koerper->Form.Kugel.Radius);
	       break;
	       
	    case QUADER:
	       ProjektionQuader(zeiger, koerper->Form.Quader.KantenLaenge);
	       break;
	       
	    case ZYLINDER:
	       ProjektionZylinder(zeiger,
				  koerper->Form.Zylinder.Radius, 
				  koerper->Form.Zylinder.Hoehe);
	       break;
	       
	    case EBENE:
	       ProjektionEbene(zeiger, darstpos);
	       break;
	       
	    case MPUNKT:		  /* wie Nagel */
	    case PUNKT:			  /* wie Nagel */
	    case NAGEL:
	       ProjektionNagel(zeiger);
	       break;
	       
	    case ZUSGESOBJ:
	       {
		    TKoerper *zus;

		    zus = koerper->Form.ZusGesObj.KoerperListe;
		    while (zus!=NULL)
		    {
			 /* Matrix fuer Koerperfest->Raumfest berechnen */
			 MatrixFromQuaternion(zus->q, M_koerper);
			 
			 M_koerper[0][3] = zus->Position[0];
			 M_koerper[1][3] = zus->Position[1];
			 M_koerper[2][3] = zus->Position[2];
			 
			 
			 /* Matrizen zusaetzlich auch fuer Raumfest->Ansicht berechnen */
			 AMatrixMult(M_ansicht[Axy], M_koerper, M_t[Axy]);
			 AMatrixMult(M_ansicht[Ayz], M_koerper, M_t[Ayz]);
			 AMatrixMult(M_ansicht[Axz], M_koerper, M_t[Axz]);
			 AMatrixMult(M_ansicht[A3d], M_koerper, M_t[A3d]);
			 
			 
			 /* Platz fuer ein neues Koerper-Element anfordern */
			 zeiger = (AKoerper *) malloc(sizeof(AKoerper));
			 if (zeiger == NULL)
			 {
			      AFehler("malloc(): No room for group object at display-routines.\n");
			      return;
			 }
			 zeiger->next  = NULL; /* momentan letztes Listenelement */
			 
			 
			 /* Verkettung: das vorhergehende Element (bzw. der Listenpointer
			    selbst) muss jetzt hierher zeigen */
			 *old = zeiger;
			 old = &(zeiger->next);
			 
			 
			 /* einige Koerperdaten kopieren */
			 zeiger->art = zus->Art;
			 zeiger->AStatus = koerper->AStatus; /* Vom ZusgesObj! */
			 zeiger->kraft = NULL; /* keine Kraefte bei Teilkoerpern */
			 
			 /* Farbe fuer diesen Teil-Koerper read-only allozieren */
			 farbe.red   = zus->R;
			 farbe.green = zus->G;
			 farbe.blue  = zus->B;
			 
			 farbe.flags = DoRed | DoGreen | DoBlue;
			 AGetColor(display[0], a_colormap, &farbe, 
				   "ProjektionKoerper() (group object)");
			 zeiger->farbnr = farbe.pixel;	  /* Farbnummer merken */

			 switch (zus->Art)
			 {
			   case KUGEL:
			      ProjektionKugel(zeiger, zus->Form.Kugel.Radius);
			      break;
			      
			   case QUADER:
			      ProjektionQuader(zeiger, zus->Form.Quader.KantenLaenge);
			      break;
			      
			   case ZYLINDER:
			      ProjektionZylinder(zeiger,
						 zus->Form.Zylinder.Radius, 
						 zus->Form.Zylinder.Hoehe);
			      break;
			      
			   case NAGEL:
			   case MPUNKT:
			   case PUNKT:
			      ProjektionNagel(zeiger);
			      break;
			      
			   default:
			      AFehler("Warning: PLANE and GROUP OBJECTS not allowed inside a GROUP OBJECT");
			      break;
			 }
			 
			 zus = zus->Naechster; /* naechster Teil-Koerper */
		    }
	       }
	       break;

	    default: 
	       break;
	  } /* switch (koerper->Art) */




	  /* naechster Koerper */
	  koerper = koerper->Naechster;

    } while (koerper!=NULL);

}










/*****************************************************************************
 *  Funktion:       void ProjektionVerbindungen(TVerbindung *verbindung)
 *
 *  Parameter:      verbindung: Zeiger auf die 3D-Verbindungs-Daten im aktuellen
 *                              Zustand
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   M_ansicht[], M_t[]
 *                            
 *  Beschreibung:
 *  -------------
 *  Die Liste der Verbindungen aus dem Zustand wird bearbeitet. Dabei wird
 *  eine eigene Verbindungsliste aufgebaut, in der die 3D-Positionen der
 *  Verbindungsendpunkte gemerkt werden. Ausserdem werden noch Dinge
 *  gemerkt, die fuer die Darstellung wichtig sind (momentan nur die Anzahl
 *  Windungen bei der Feder).
 *****************************************************************************/

#define WindungenProM 40

static void ProjektionVerbindungen(TVerbindung *verbindung)
{
     AVerbindung *z;
     AVerbindung **old;        /* Zeiger auf Next-Zeiger des vorhergehenden Elements */
     AMatrix M_verb;			  /* Matrix fuer Verbindungsdrehung */

     short a;				  /* Ansicht */


     old = &(darstellung.verbindungen);  /* Beim erstenmal Listenanfang aendern */

     do
     {
	  /* Platz fuer ein neues Verbindungs-Element anfordern */
	  z = (AVerbindung *) malloc(sizeof(AVerbindung));
	  if (z == NULL)
	  {
	       AFehler("malloc(): No room for object link at display routines.\n");
	       return;
	  }
	  z->next = NULL;		  /* momentan letztes Listenelement */

	  /* Verkettung: das vorhergehende Element (bzw. der Listenpointer
	     selbst) muss jetzt hierher zeigen */
	  *old = z;
	  old = &(z->next);

	  z->art = verbindung->Art;
	  z->AStatus = verbindung->AStatus;

	  for AlleAnsichten(a)
	  {
	       /* Anfangspunkt der Verbindung berechnen */
	       MatrixFromQuaternion(verbindung->Koerper1->q, M_verb);
	       
	       M_verb[0][3] = verbindung->Koerper1->Position[0];
	       M_verb[1][3] = verbindung->Koerper1->Position[1];
	       M_verb[2][3] = verbindung->Koerper1->Position[2];
	       
	       /* Matrix zusaetzlich auch fuer Raumfest->Ansicht berechnen */
	       AMatrixMult(M_ansicht[a], M_verb, M_t[a]);
	       ATransformation(z->anfang[a], M_t[a], verbindung->VPunkt1[0],
			       verbindung->VPunkt1[1], verbindung->VPunkt1[2]);
	       
	       /* Endpunkt der Verbindung berechnen */
	       MatrixFromQuaternion(verbindung->Koerper2->q, M_verb);
	       
	       M_verb[0][3] = verbindung->Koerper2->Position[0];
	       M_verb[1][3] = verbindung->Koerper2->Position[1];
	       M_verb[2][3] = verbindung->Koerper2->Position[2];
	       
	       AMatrixMult(M_ansicht[a], M_verb, M_t[a]);
	       
	       ATransformation(z->ende[a], M_t[a], verbindung->VPunkt2[0],
				   verbindung->VPunkt2[1], verbindung->VPunkt2[2]);
	       
	       /* Falls Feder: Anzahl Windungen eintragen */
	       if ((verbindung->Art) == FEDER)
	       {
		    z->param.feder.windungen = 
			 (verbindung->VerParameter.Feder.Ruhelaenge)
			  *WindungenProM;
	       }
	  }

	  verbindung = verbindung->Naechste;
    } while (verbindung!=NULL);
}




/*****************************************************************************
 *  Funktion:       void Projektion(Display *display, int screen, Window window, 
 *                                  ADarstListe *darst, TVektor darstpos,
 *                                                          TZustand *zustand) 
 *
 *  Parameter:      display,
 *                  screen,
 *                  window:  Information ueber das Fenster
 *                  darst:   Zeiger auf die Darstellungsliste mit den 2D-Pro-
 *                           jektionen der Koerper, Verbindungen, etc.
 *                  darstpos:Darstellungsposition (noetig fuer Ebene)
 *                  zustand: Abzubildender Zustand
 *                            
 *  Rueckgabewert:  -
 *
 *  Beschreibung:
 *  -------------
 *  Alle Objekte im aktuellen Zustand werden (unter Verwendung der in M_ansicht
 *  abgelegten Matrix) auf ein Window abgebildet, wobei die Linien auf die 
 *  Bildgroesse geclipped werden. Dabei wird in darst eine Darstellungsliste 
 *  aufgebaut, die genau die sichtbaren Linien in diesem Window enthaelt, d.h.
 *  alle nicht sichtbaren Linien werden auch nicht abgelegt. Diese Liste kann
 *  von der dem Window zugehoerigen Redraw-Routine direkt abgearbeitet und auf
 *  das Window gezeichnet werden, dort sind dann also keine komplizierten 
 *  Projektionen mehr noetig. Die aufgebauten Darstellungslisten erlauben auch
 *  eine relativ einfache Selektion von Objekten.
 *****************************************************************************/

static void Projektion(TVektor darstpos, TZustand *zustand)
{
     TKoerper *koerper;
     AKoerper *zeiger, *old;
     
     zeiger = darstellung.koerper;	  /* alte Koerperliste freigeben */
     while (zeiger != NULL)
     {					  /* Farbe deallozieren */
	  XFreeColors(display[A3d], a_colormap, &(zeiger->farbnr), 1, 0);
	  DeleteListe(zeiger->kraft);	  /* alle Kraefte loeschen */
	  old = zeiger;
	  zeiger = zeiger->next;
	  free(old);			  /* Koerperelement freigeben */
     }
     darstellung.koerper = NULL;

     DeleteListe(darstellung.verbindungen); /* Verbindungsliste loeschen */
     darstellung.verbindungen = NULL;
     /* ##### Fussboden loeschen #### */

     if (zustand == NULL) return;	  /* Wenn Zustand leer, ist nichts zu tun */
     
     koerper = zustand->Koerper;
     if (koerper != NULL)		  /* Wenn keine Koerper existieren, dann */
					  /* existieren auch keine Verbindungen */
     {
	  /* alle Koerper auf das Window abbilden */
	  ProjektionKoerper(koerper, darstpos);
	  if (zustand->Verbindungen != NULL)
	  {
	       /* alle Verbindungen auf das Window abbilden */
	       ProjektionVerbindungen(zustand->Verbindungen);
	  }
     }
     
     /* #### Fussboden projizieren #### */

}




/*****************************************************************************
 *  Funktion:       void AnzeigeDarstellung(Widget d_xy, Widget d_yz, 
 *                                          Widget d_xz, Widget d_3d,
 *                       		    TVektor darstpos, TQuaternion q,
 *                                          TReal zoom, TZustand *zustand, 
 *                                          int modus);
 *
 *  Parameter:      d_xy, d_yz,
 *                  d_xz, d_3d: Widgets fuer die 4 Darstellungsfenster
 *                  darstpos:   Hier liegt gerade die Darstellung in der Welt
 *                  q:          Lage der Darstellung
 *                  zoom:       Zoom-Faktor der Pseudo-Kameras fuer die 4 Ansichten
 *                  zustand:    Zeiger auf den darzustellenden Zustand
 *                  modus:      Art der Ausgabe (Bitvektor)
 *                              Bit 0: Fussboden zeichnen (1) oder nicht (0)
 *                              Bit 1: Koordinatenachsen der Fenster zeichnen (1)
 *                                     oder nicht (0)
 *                              Bit 2: Koordinatenachsen der einzelnen Koerper
 *                                     zeichnen (1) oder nicht (0)
 *
 *  Rueckgabewert:  -
 *
 *  Importierte Bezeichner: -
 *
 *  Beschreibung:
 *  -------------
 *  Mit dieser Routine wird der angegebene Zustand zustand auf alle 4
 *  Darstellungswindows projiziert. Dabei wird fuer jedes Window eine
 *  Darstellungsliste erstellt, in der von allen sichtbaren Koerpern
 *  und Verbindungen alle Linien (in Window-Koordinaten) abgelegt
 *  werden. Sodann wird jedes der 4 Windows geloescht und damit ein
 *  Redraw ueber XExpose-Events ausgeloest. Erst in den
 *  Redraw-Routinen (siehe dort, RedrawDarstellungXY() ...
 *  RedrawDarstellung3D() ) wird dann das Bild physikalisch
 *  gezeichnet.
 *****************************************************************************/

/*******************************************
 * Matrizen fuer die 4 Darstellungsfenster *
 *******************************************/

/* Matrix fuer Darstellung xy-Fenster */
static AMatrix M_ansichtxy = 
{ 
     { 1, 0, 0, 0 },
     { 0, 1, 0, 0 },
     { 0, 0, 1, -DARST_DEFAULTABSTAND },
     { 0, 0, 0, 1 }
};

/* Matrix fuer Darstellung yz-Fenster */
static AMatrix M_ansichtyz =
{
     { 0, 0, -1, 0 },
     { 0, 1, 0,  0 },
     { 1, 0, 0,  -DARST_DEFAULTABSTAND },
     { 0, 0, 0,  1 }
};

/* Matrix fuer Darstellung xz-Fenster */
static AMatrix M_ansichtxz =
{
     { 1, 0, 0,  0 },
     { 0, 0, -1, 0 },
     { 0, 1, 0,  -DARST_DEFAULTABSTAND },
     { 0, 0, 0,  1 }
};

/* Matrix fuer Darstellung 3d-Fenster */
static AMatrix M_ansicht3d =
{
     { 0.8660254,         0,       -0.5, 0 },
     {     -0.25, 0.8660254, -0.4330127, 0 },
     { 0.4330127,       0.5,       0.75, -DARST_DEFAULTABSTAND },
     {         0,         0,          0, 1 }
};

/***********************
 * Eigentliche Routine *
 ***********************/

/* export */
void AnzeigeDarstellung(Widget d_xy, Widget d_yz, Widget d_xz, Widget d_3d,
			TVektor darstpos, TQuaternion q, TReal zoom,
			TZustand *zustand, int darstmodus)
{ 
     AMatrix M_darst;			  /* Matrix fuer Darstellungsposition */

     d_zoom = zoom*DARST_ZOOM;		  /* d_zoom fuer TransformationPunkt() */
     modus = darstmodus;		  /* Modus setzen (fuer Projektionen) */

     AClearColWarningFlag();		  /* Farb-Warnung ermoeglichen */

     MatrixFrom_I_Quaternion(q, M_darst);

     M_darst[0][3] = -M_darst[0][0]*darstpos[0]-M_darst[0][1]*darstpos[1]
	             -M_darst[0][2]*darstpos[2];
     M_darst[1][3] = -M_darst[1][0]*darstpos[0]-M_darst[1][1]*darstpos[1]
	             -M_darst[1][2]*darstpos[2];
     M_darst[2][3] = -M_darst[2][0]*darstpos[0]-M_darst[2][1]*darstpos[1]
	             -M_darst[2][2]*darstpos[2];
     

     winmaxx[Axy] = winwidth[Axy]-1;
     winmaxy[Axy] = winheight[Axy]-1;
     winmaxx[Ayz] = winwidth[Ayz]-1;
     winmaxy[Ayz] = winheight[Ayz]-1;
     winmaxx[Axz] = winwidth[Axz]-1;
     winmaxy[Axz] = winheight[Axz]-1;
     winmaxx[A3d] = winwidth[A3d]-1;
     winmaxy[A3d] = winheight[A3d]-1;

     AMatrixMult(M_ansichtxy, M_darst, M_ansicht[Axy]);
     AMatrixMult(M_ansichtyz, M_darst, M_ansicht[Ayz]);
     AMatrixMult(M_ansichtxz, M_darst, M_ansicht[Axz]);
     AMatrixMult(M_ansicht3d, M_darst, M_ansicht[A3d]);


     achsenXY = ProjektionAchsenPunkt(Axy, 0, 0, 0); /* Achsenschnittpunkt */
     achsenYZ = ProjektionAchsenPunkt(Ayz, 0, 0, 0); /* Achsenschnittpunkt */
     achsenXZ = ProjektionAchsenPunkt(Axz, 0, 0, 0); /* Achsenschnittpunkt */

     Projektion(darstpos, zustand);


     /* Inhalt des 3D-Darstellungsfensters berechnen */

     {		
	  /* Koordinatenachsen transformieren */
	  xr = ProjektionAchsenPunkt(A3d, winwidth[A3d]/2, 0, 0); 
	  xl = ProjektionAchsenPunkt(A3d, -winwidth[A3d]/2, 0, 0);
	  yo = ProjektionAchsenPunkt(A3d, 0, winheight[A3d]/2, 0);
	  yu = ProjektionAchsenPunkt(A3d, 0, -winheight[A3d]/2, 0);
	  zv = ProjektionAchsenPunkt(A3d, 0, 0, winwidth[A3d]/2);
	  zh = ProjektionAchsenPunkt(A3d, 0, 0, -winwidth[A3d]/2);

	  /* Pfeilspitze bei x-Achse */
	  xp1 = ProjektionAchsenPunkt(A3d, winwidth[A3d]/2-2*DARST_PFEILHOEHE,
				      0, 1.5*DARST_PFEILBREITE);
	  xp2 = ProjektionAchsenPunkt(A3d, winwidth[A3d]/2-2*DARST_PFEILHOEHE,
				      0, -1.5*DARST_PFEILBREITE);

	  /* Pfeilspitze bei y-Achse */
	  yp1 = ProjektionAchsenPunkt(A3d, 1.5*DARST_PFEILBREITE,
				      winheight[A3d]/2-2*DARST_PFEILHOEHE, 0);
	  yp2 = ProjektionAchsenPunkt(A3d, -1.5*DARST_PFEILBREITE,
				      winheight[A3d]/2-2*DARST_PFEILHOEHE, 0);

	  /* Pfeilspitze bei z-Achse */
	  zp1 = ProjektionAchsenPunkt(A3d, 1.5*DARST_PFEILBREITE, 0,
				      -winwidth[A3d]/2+2*DARST_PFEILHOEHE);
	  zp2 = ProjektionAchsenPunkt(A3d, -1.5*DARST_PFEILBREITE, 0,
				      -winwidth[A3d]/2+2*DARST_PFEILHOEHE);
     }

     /* alte Fensterinhalte loeschen und Redraw ausloesen */
     XClearArea(display[Axy], window[Axy], 0, 0, winwidth[Axy], winheight[Axy], TRUE);
     XClearArea(display[Ayz], window[Ayz], 0, 0, winwidth[Ayz], winheight[Ayz], TRUE);
     XClearArea(display[Axz], window[Axz], 0, 0, winwidth[Axz], winheight[Axz], TRUE);
     XClearArea(display[A3d], window[A3d], 0, 0, winwidth[A3d], winheight[A3d], TRUE);
}


/***************************************************************************
 *  Funktion:       void DoRedrawQuader(short a, TVektor lov, TVektor luv, 
 *                                     TVektor ruv, TVektor rov, TVektor loh,
 *                                     TVektor luh, TVektor ruh, TVektor roh)
 *
 *  Parameter:      a:      Ansicht, die benutzt wird
 *                  lov,
 *                  ...roh: die 8 Eckpunkte des Quaders
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   darst_GC:  Graphics-Context, mit dem gemalt wird
 *                  linien,
 *                  anzahl:    Zwischenablage fuer Linien
 *
 *  Beschreibung:
 *  -------------
 *  Die 12 Linien des Quaders werden in die entsprechende Ansicht gezeichnet.
 ***************************************************************************/
 


static void DoRedrawQuader(short a, TVektor lov, TVektor luv, TVektor ruv,
			   TVektor rov, TVektor loh, TVektor luh, 
			   TVektor ruh, TVektor roh)
{
     /* vorderes Rechteck */
     ClipLinie3d(a, luv, lov);
     ClipLinie3d(a, lov, rov);
     ClipLinie3d(a, rov, ruv);
     ClipLinie3d(a, ruv, luv);

     /* hinteres Rechteck */
     ClipLinie3d(a, luh, loh);
     ClipLinie3d(a, loh, roh);
     ClipLinie3d(a, roh, ruh);
     ClipLinie3d(a, ruh, luh);

     /* Verbindungslinien von vorne nach hinten */
     ClipLinie3d(a, luv, luh);
     ClipLinie3d(a, lov, loh);
     ClipLinie3d(a, rov, roh);
     ClipLinie3d(a, ruv, ruh);

     ZeichneLinien(a);
}

/***************************************************************************
 *  Funktion:       void DoRedrawZylinder(short a, AZylFeld p, AZylFeld q)
 *
 *  Parameter:      a:     Ansicht, die benutzt wird
 *                  p, q:  Koordinaten der Kreispunkte des Zylinders
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   darst_GC:  Graphics-Context, mit dem gemalt wird
 *                  linien,
 *                  anzahl:    Zwischenablage fuer Linien
 *
 *  Beschreibung:
 *  -------------
 *  Die untere und obere Ellipse des Kreises mit Hilfe der 12 berechneten
 *  Punkte durch 12 Linien hinzeichnen. Dann in der Liste der Punkte die
 *  beiden gegenueberliegenden Punkte suchen, die am weitesten auseinander
 *  liegen. Diese stellen dann die breiteste Ausdehnung des Zylinders dar
 *  und werden fuer die Silhouettenlinien benutzt.
 ***************************************************************************/
 
static void DoRedrawZylinder(short a, AZylFeld p, AZylFeld q)
{
     TReal d0, d1;			  /* Ellipsendurchmesser */
     int i, j;				  /* Kreisindizes */

     /* oberer Kreis (eigentlich Ellipse) */
     ClipLinie3d(a, p[0], p[1]);
     ClipLinie3d(a, p[1], p[2]);
     ClipLinie3d(a, p[2], p[3]);
     ClipLinie3d(a, p[3], p[4]);
     ClipLinie3d(a, p[4], p[5]);
     ClipLinie3d(a, p[5], p[6]);
     ClipLinie3d(a, p[6], p[7]);
     ClipLinie3d(a, p[7], p[8]);
     ClipLinie3d(a, p[8], p[9]);
     ClipLinie3d(a, p[9], p[10]);
     ClipLinie3d(a, p[10], p[11]);
     ClipLinie3d(a, p[11], p[0]);
     

     /* unterer Kreis (eigentlich Ellipse) */
     ClipLinie3d(a, q[0], q[1]);
     ClipLinie3d(a, q[1], q[2]);
     ClipLinie3d(a, q[2], q[3]);
     ClipLinie3d(a, q[3], q[4]);
     ClipLinie3d(a, q[4], q[5]);
     ClipLinie3d(a, q[5], q[6]);
     ClipLinie3d(a, q[6], q[7]);
     ClipLinie3d(a, q[7], q[8]);
     ClipLinie3d(a, q[8], q[9]);
     ClipLinie3d(a, q[9], q[10]);
     ClipLinie3d(a, q[10], q[11]);
     ClipLinie3d(a, q[11], q[0]);

     /* Ansatzpunkte fuer Silhouettenlinien suchen */
     i = 0;
     d0 = QUADRAT(p[0][0]-p[6][0])+QUADRAT(p[0][1]-p[6][1]);

     for (j=1; j<DARST_ZYLPOINTS/2; j++)
     {
	  d1 = QUADRAT(p[j][0]-p[j+DARST_ZYLPOINTS/2][0])+
	       QUADRAT(p[j][1]-p[j+DARST_ZYLPOINTS/2][1]);
	  if (d1>d0)
	  { 
	       d0 = d1;
	       i = j;
	  }
/*	  else break; */
     }

     /* Silhouettenlinien entlang des Zylinders */
     ClipLinie3d(a, p[i], q[i]);
     ClipLinie3d(a, p[i+DARST_ZYLPOINTS/2], q[i+DARST_ZYLPOINTS/2]);

     ZeichneLinien(a);
}




/***************************************************************************
 *  Funktion:       void DoRedrawKugel(short a, TVektor m, TReal r)
 *
 *  Parameter:      a:     Ansicht, die benutzt wird
 *                  m:     Mittelpunkt der Kugel
 *                  r:     Radius der Kugel
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   darst_GC:  Graphics-Context, mit dem gemalt wird
 *
 *  Beschreibung:
 *  -------------
 *  Falls die Kugel sichtbar ist (vor der Kamera), wird sie als Kreis in die
 *  entsprechende Ansicht gezeichnet.
 ***************************************************************************/
 
static void DoRedrawKugel(short a, TVektor m, TReal r)
{
     AXKoord x, y;

#if 0
     if ((m[2]-r) > 0) return;		  /* Kugel hinter Kamera unsichtbar */
#endif

     ProjektionPunkt(a, m, &x, &y);
     r*=d_zoom;

     if ((x-r+0.5) < (TReal) AXmin) return; /* Pruefen, ob im Wertebereich */
     if ((x+r+0.5) > (TReal) AXmax) return; /* fuer X-Windows */
     if ((y-r+0.5) < (TReal) AXmin) return; 
     if ((y+r+0.5) > (TReal) AXmax) return; 

     XDrawArc(display[a], window[a], darst_GC, 
	      (AXKoord)(x-r+0.5), (AXKoord)(y-r+0.5), 2*r, 2*r, 0, 360*64);

}


/***************************************************************************
 *  Funktion:       void DoRedrawNagel(short a, TVektor punkt)
 *
 *  Parameter:      a:     Ansicht, die benutzt wird
 *                  punkt: 3D-Koordinaten des Punktes
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   darst_GC:  Graphics-Context, mit dem gemalt wird
 *                  linien,
 *                  anzahl:    Zwischenablage fuer Linien
 *
 *  Beschreibung:
 *  -------------
 *  Der Punkt wird als kleines Kreuzchen auf die entsprechende Ansicht
 *  gezeichnet. 
 ***************************************************************************/
 
static void DoRedrawNagel(short a, TVektor punkt)
{
     AXKoord x,y;

     if (punkt[2]>0) return;		  /* Punkt hinter Kamera nicht sichtbar */

     ProjektionPunkt(a, punkt, &x, &y);
     
     /* Linien des Kreuzes auf Windowgroesse clippen */
     ClipLinie2d(x-DARST_NAGELGROESSE, y-DARST_NAGELGROESSE,
		 x+DARST_NAGELGROESSE, y+DARST_NAGELGROESSE);
     ClipLinie2d(x+DARST_NAGELGROESSE, y-DARST_NAGELGROESSE,
		 x-DARST_NAGELGROESSE, y+DARST_NAGELGROESSE);
     ZeichneLinien(a);
}


/***************************************************************************
 *  Funktion:       void DoRedrawEbene(short a, TVektor q, TVektor b1,
 *                                                             TVektor b2)
 *
 *  Parameter:      a:     Ansicht, die benutzt wird
 *                  q:     Mittelpunkt des Rechtecks
 *                  b1,b2: die beiden Basisvektoren in dieser Ebene. Diese
 *                         werden benutzt, um die Ecken des Rechtecks
 *                         auszurechnen  
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   darst_GC:  Graphics-Context, mit dem gemalt wird
 *                  linien,
 *                  anzahl:    Zwischenablage fuer Linien
 *
 *  Beschreibung:
 *  -------------
 *  Die Ebene wird durch ein gestricheltes Rechteck dargestellt. Hier werden
 *  also die 4 Linien des Rechtecks in die entsprechende Ansicht gezeichnet.
 ***************************************************************************/
 
static void DoRedrawEbene(short a, TVektor q, TVektor b1, TVektor b2)
{
     TReal g;
     TVektor p1, p2, p3, p4;

     /* Groesse des Quadrats abhaengig von der Window-Groesse */
     g = (winwidth[a] > winheight[a]) ? winwidth[a] : winheight[a];
     g = ((g+1)/2+1)/d_zoom;     
     
     /* Berechnen der 4 Eckpunkte des Ebenen-Rechtecks */
     p1[0] = q[0]+g*(b1[0]+b2[0]);
     p1[1] = q[1]+g*(b1[1]+b2[1]);
     p1[2] = q[2]+g*(b1[2]+b2[2]);
     
     p2[0] = q[0]+g*(b1[0]-b2[0]);
     p2[1] = q[1]+g*(b1[1]-b2[1]);
     p2[2] = q[2]+g*(b1[2]-b2[2]);
     
     p3[0] = q[0]+g*(-b1[0]-b2[0]);
     p3[1] = q[1]+g*(-b1[1]-b2[1]);
     p3[2] = q[2]+g*(-b1[2]-b2[2]);
     
     p4[0] = q[0]+g*(-b1[0]+b2[0]);
     p4[1] = q[1]+g*(-b1[1]+b2[1]);
     p4[2] = q[2]+g*(-b1[2]+b2[2]);

     /* Zeichnen der 4 Linien */
     ClipLinie3d(a, p1, p2);
     ClipLinie3d(a, p2, p3);
     ClipLinie3d(a, p3, p4);
     ClipLinie3d(a, p4, p1);

     if (anzahl>0)
     {
	  XSetLineAttributes(display[a], darst_GC, liniendicke, 
			     LineDoubleDash, CapButt, JoinRound);
	  ZeichneLinien(a);
	  XSetLineAttributes(display[a], darst_GC, liniendicke,
			     LineSolid, CapButt, JoinRound);
     }
}



/***************************************************************************
 *  Funktion:       void DoRedrawEbene(short a, TVektor anfang, TVektor ende)
 *
 *  Parameter:      a:      Ansicht, die benutzt wird
 *                  anfang: 3D-Koordinaten des Pfeil-Anfangs
 *                  ende:   3D-Koordinaten der Pfeil-Spitze
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   darst_GC:  Graphics-Context, mit dem gemalt wird
 *
 *  Beschreibung:
 *  -------------
 *  Die Kraft wird in Koerperfarbe als Pfeil in die entsprechende Ansicht
 *  gezeichnet.
 ***************************************************************************/

static void DoRedrawKraft(short a, TVektor anfang, TVektor ende)
{
     ClipPfeil3d(a, darst_GC, anfang, ende); /* Linie mit Pfeil malen */
}


/***************************************************************************
 *  Funktion:       void DoRedrawKoerper(Display *display, Window window,
 *                                       AElement *koerper)
 *  Parameter:      display,
 *                  window:   Window, in das ausgegeben werden soll
 *                  koerper:  Darstellungsliste der Koerper, die gemalt werden soll
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   modus, darst_GC, darst_achseGC  
 *
 *  Beschreibung:
 *  -------------
 *  Alle Koerper aus der angegebenen Darstellungsliste werden (ohne erneute Inter-
 *  pretation) direkt in das angegebene Window gezeichnet. Dies wird i.a. dazu
 *  benutzt, ein Window bei einem Redraw neu zu zeichnen.
 ***************************************************************************/


static void DoRedrawKoerper(short a, AKoerper *z)
{
     if (z==NULL) return;		  /* Liste leer? */

     while (z!=NULL)
     {
	  XSetForeground(display[a], darst_GC, z->farbnr);

	  if (modus & ObjectCoordON)
	  {
	       switch (z->art)
	       {
		 case ZYLINDER:
		 case QUADER:
		 case KUGEL:
		 case EBENE:
		 case ZUSGESOBJ:
		    ClipLinie3d(a, z->k0[a], z->kx[a]);
		    ClipLinie3d(a, z->k0[a], z->ky[a]);
		    ClipLinie3d(a, z->k0[a], z->kz[a]);
		    break;
		 default:
		    break;
	       }
	       if (anzahl>0) ZeichneLinien(a);
		    
	  }

	  if ((z->AStatus) & SelectedON)
	  {				  /* dicke Linie fuer selected */
	       liniendicke = 3;
	       XSetLineAttributes(display[a], darst_GC, liniendicke,
				  LineSolid, CapButt, JoinRound);
	  }

	  switch (z->art)
	  {
	    case ZYLINDER:
	       DoRedrawZylinder(a, z->param.zylinder.p[a],
				z->param.zylinder.q[a]);
	       break;
	    case QUADER:	
	       DoRedrawQuader(a, 
			      z->param.quader.luv[a], z->param.quader.lov[a], 
			      z->param.quader.rov[a], z->param.quader.ruv[a], 
			      z->param.quader.luh[a], z->param.quader.loh[a], 
			      z->param.quader.roh[a], z->param.quader.ruh[a]);
	       break;
            case KUGEL:
	       DoRedrawKugel(a, z->param.kugel.mittelpunkt[a], 
			     z->param.kugel.radius);
	       break;
	    case MPUNKT:		  /* MPUNKT wie NAGEL */
	    case PUNKT:			  /* PUNKT wie NAGEL */
	    case NAGEL:
	       DoRedrawNagel(a, z->param.nagel.punkt[a]);
	       break;
	    case EBENE:
	       DoRedrawEbene(a, z->param.ebene.q[a], 
			     z->param.ebene.b1[a], z->param.ebene.b2[a]);
	       break;

	    case ZUSGESOBJ:
	       /* nichts zu tun, da nur Achsen relevant und diese schon oben
		  gezeichnet wurden */
	       break;
	    default:
	       break;
	  }

	  if (liniendicke > 0)  /* War Koerper selected? Wenn ja, dann*/
	  {				  /* ab jetzt wieder duenne Linien */
	       liniendicke = 0;		  /* 0 ist wie 1, aber schneller */
	       XSetLineAttributes(display[a], darst_GC, liniendicke,
				  LineSolid, CapButt, JoinRound);
	  }
     
	  if ((z->kraft) != NULL)	  /* Gibt es Kraefte im Koerper? */
	  {
	       AKraft *kraft;

	       kraft = z->kraft;	  /* ja: nacheinander alle hinmalen */
	       do
	       {
		    DoRedrawKraft(a, kraft->anfang[a], kraft->ende[a]);
		    kraft = kraft->next;
	       } while (kraft!=NULL);
	  }

	  z = z->next;
     } /* while (z!=NULL) */
}



/*****************************************************************************
 *  Funktion:       void DoRedrawStange(short a, TVektor von, TVektor bis)
 *
 *  Parameter:      a:        Ansicht, in die gezeichnet wird
 *                  von, bis: 3D-Koordinaten der beiden Stangenendpunkte
 *                            
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   
 *
 *  Beschreibung:
 *  -------------
 *  Die Verbindung der beiden Punkte wird als Linie gezeichnet.
 *****************************************************************************/

static void DoRedrawStange(short a, TVektor von, TVektor bis)
{
     ClipLinie3d(a, von, bis);
     ZeichneLinien(a);
}




/*****************************************************************************
 *  Funktion:       void DoRedrawFeder(short a, TVektor von, TVektor bis,
 *                                       int windungen)
 *
 *  Parameter:      a:         Ansicht, in die gezeichnet wird
 *                  von, bis:  3D-Koordinaten der beiden Federendpunkte
 *                  windungen: Anzahl Windungen der Feder
 *                     
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   
 *
 *  Beschreibung:
 *  -------------
 *  Die Verbindung der beiden Punkte wird als gezickzackte Linie gezeichnet,
 *  die auch im 3D-Fenster noch recht ordentlich aussieht.
 *  Dazu muessen einige Hilfspunkte berechnet werden (in2D), die ueber
 *  einzelne Linien verbunden werden. Da hierbei nur 90deg-Winkel auftreten,
 *  ist die Bildung des Normalex1nvektors auf die Verbindungslinie durch
 *  Vertauschen der Koordinaten relativ leicht moeglich.
 *****************************************************************************/

static void DoRedrawFeder(short a, TVektor von, TVektor bis,
			    int windungen)
{
     int dx, dy, nx, ny, i;
     TReal h;
     AXKoord pxalt, pyalt, pxneu, pyneu;
     AXKoord x1, y1, x2, y2;
     
     ProjektionPunkt(a, von, &x1, &y1);
     ProjektionPunkt(a, bis, &x2, &y2);

     if ((x1==x2) && (y1==y2)) return;	  /* Laenge 0: keine Richtung bestimmbar */

     dx = x2-x1;
     dy = y2-y1;

     pxalt = x1+(AXKoord)(0.1*dx);
     pyalt = y1+(AXKoord)(0.1*dy);

     ClipLinie2d(x1, y1, pxalt, pyalt);	  /* Linie bis zum Federanfang */

     h = 7*d_zoom/(DARST_ZOOM*sqrt(dx*dx+dy*dy));
     nx= (AXKoord)(dy*h);
     ny= -(AXKoord)(dx*h);

     for (i=0; i<2*windungen ; i++)
     {
	  h = 0.1+i*0.8/(2*windungen)+0.8/(2*2*windungen);
	  pxneu = x1+(AXKoord)(h*dx)+nx;
	  pyneu = y1+(AXKoord)(h*dy)+ny;
	  ClipLinie2d(pxalt, pyalt, pxneu, pyneu); /* nachster Windungspunkt */
	  pxalt = pxneu;
	  pyalt = pyneu;

	  nx = -nx;			  /* naechster Windungspunkt auf der  */
	  ny = -ny;			  /* anderen Seite der Verbindungslinie */
     }

     pxneu = x1+(AXKoord)(0.9*dx);
     pyneu = y1+(AXKoord)(0.9*dy);
     
     ClipLinie2d(pxalt, pyalt, pxneu, pyneu); /* Letzte Windung fertig */
     ClipLinie2d(pxneu, pyneu, x2, y2);	  /* bis zum Federende */
     
     ZeichneLinien(a);
}




/*****************************************************************************
 *  Funktion:       void DoRedrawGelenk(short a, TVektor von, TVektor bis)
 *
 *  Parameter:      a:        Ansicht, in die gezeichnet wird
 *                  von, bis: 3D-Koordinaten der beiden Verbindungsendpunkte
 *                            (sollten identisch sein, verwendet wird nur von)
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   
 *
 *  Beschreibung:
 *  -------------
 *  Die Verbindungspunkte (hoffentlich ergeben beide Punkte den gleichen
 *  2D-Punkt) werden als dicke Punkte gezeichnet und zusaetzlich mit einer
 *  duennen Linie verbunden.
 *****************************************************************************/

static void DoRedrawGelenk(short a, TVektor von, TVektor bis)
{
     AXKoord x1, y1, x2, y2;

     ProjektionPunkt(a, von, &x1, &y1);
     ProjektionPunkt(a, bis, &x2, &y2);
     XFillArc(display[a], window[a], darst_GC, x1-2, y1-2, 5, 5, 0, 360*64);
     XFillArc(display[a], window[a], darst_GC, x2-2, y2-2, 5, 5, 0, 360*64);
     ClipLinie3d(a, von, bis);

     ZeichneLinien(a);
}




/*****************************************************************************
 *  Funktion:       void DoRedrawDaempfer(short a, TVektor von, TVektor bis)
 *
 *  Parameter:      a:        Ansicht, in die gezeichnet wird
 *                  von, bis: 3D-Koordinaten der beiden Daempferendpunkte
 *                     
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   
 *
 *  Beschreibung:
 *  -------------
 *  Die Verbindung der beiden Punkte wird als Daempfer-Symbol gezeichnet:
 *                         +------------
 *                         |
 *                         |        |"Stoessel"
 *  -----------------------|        |-----------------------
 *                         |        |
 *                  "Gabel"|
 *                         +------------ 
 *  Dazu muessen einige Hilfspunkte berechnet werden (in2D), die ueber
 *  einzelne Linien verbunden werden. Da hierbei nur 90deg-Winkel auftreten,
 *  ist die Bildung des Normalenvektors auf die Verbindungslinie durch
 *  Vertauschen der Koordinaten relativ leicht moeglich.
 *****************************************************************************/

static void DoRedrawDaempfer(short a, TVektor von, TVektor bis)
{
     AXKoord dx, dy, nx, ny;
     TReal h;
     AXKoord px1, py1, px2, py2, px3, py3;
     AXKoord x1, y1, x2, y2;

     ProjektionPunkt(a, von, &x1, &y1);
     ProjektionPunkt(a, bis, &x2, &y2);

     if ((x1==x2) && (y1==y2)) return;	  /* Laenge 0: keine Richtung bestimmbar */

     dx = x2-x1;
     dy = y2-y1;

     px1 = x1+(AXKoord)(0.4*dx);
     py1 = y1+(AXKoord)(0.4*dy);
     ClipLinie2d(x1, y1, px1, py1);	  /* Linie bis zur "Gabel" */

     h = 7*d_zoom/(DARST_ZOOM*sqrt(dx*dx+dy*dy));
     nx= (AXKoord)(dy*h+0.5);
     ny= -(AXKoord)(dx*h+0.5);

     px2 = (AXKoord)(px1+nx);
     py2 = (AXKoord)(py1+ny);
     px3 = (AXKoord)(px1-nx);
     py3 = (AXKoord)(py1-ny);
     ClipLinie2d(px2, py2, px3, py3);	  /* Querlinie der "Gabel" */

     px1 = x1+ (AXKoord)(0.6*dx);
     py1 = y1+ (AXKoord)(0.6*dy);	  /* "Zinken" der "Gabel" */
     ClipLinie2d(px2, py2, px1+nx, py1+ny);
     ClipLinie2d(px3, py3, px1-nx, py1-ny);

     h *= 4.8/7.0;
     nx= (AXKoord)(dy*h+0.5);
     ny= -(AXKoord)(dx*h+0.5);

     px1 = x1+ (AXKoord)(0.55*dx);
     py1 = y1+ (AXKoord)(0.55*dy);	  /* Querlinie des "Stoessels" */
     ClipLinie2d(px1+nx, py1+ny, px1-nx, py1-ny);
     ClipLinie2d(px1, py1, x2, y2);	  /* Linie vom "Stoessel" zum Ende */

     ZeichneLinien(a);
}




/***************************************************************************
 *  Funktion:       void DoRedrawVerbindungen(short a, AVerbindung *verbindung)
 *
 *  Parameter:      a:          Ansicht, in die gezeichnet werden soll
 *                  verbindung: Verbindungsliste der zu malenden Verbindungen
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   -
 *
 *  Beschreibung:
 *  -------------
 *  Aehnlich DoRedrawKoerper(), jedoch werden die Verbindungen neu gezeichnet.
 ***************************************************************************/

static void DoRedrawVerbindungen(short a, AVerbindung *verbindung)
{
     XSetForeground(display[a], darst_GC, BlackPixel(display[a], screen[a]));

     do
     {
	  if (!((verbindung->AStatus) & HiddenON))
	  {
	       /* Liniendicke erhoehen, wenn Verbindug "selected" */
	       if (verbindung->AStatus & SelectedON)
	       {				  /* dicke Linie fuer selected */
		    liniendicke = 2;
		    XSetLineAttributes(display[a], darst_GC, liniendicke,
				       LineSolid, CapButt, JoinRound);
		    
	       }

#if 0	       
	       if ((verbindung->anfang[a][2]<=0) || (verbindung->ende[a][2]<=0))
#endif
	       {
		    /* Je nach Verbindungsart die passende Zeichenroutine aufrufen */
		    switch (verbindung->art)
		    {
		      case DAEMPFER:
			 DoRedrawDaempfer(a, verbindung->anfang[a],
					  verbindung->ende[a]);
			 break;
		      case STANGE:
			 DoRedrawStange(a, verbindung->anfang[a],
					verbindung->ende[a]);
			 break;
		      case FEDER:
			 DoRedrawFeder(a, verbindung->anfang[a], 
				       verbindung->ende[a],
				       verbindung->param.feder.windungen);
			 break;
		      case GELENK:
			 DoRedrawGelenk(a, verbindung->anfang[a],
					verbindung->ende[a]);
			 break;
		    }
		    if (verbindung->AStatus & SelectedON)
		    {			  /* Wieder duenne Linien */
			 liniendicke = 0; /* 0 ist wie 1, aber schneller */
			 XSetLineAttributes(display[a], darst_GC, liniendicke,
					    LineSolid, CapButt, JoinRound);
		    }
	       }
	  }
	  verbindung = verbindung->next;
     } while (verbindung != NULL);
}





/***************************************************************************
 *  Funktion:       void DoRedrawAchsen(Display *display, Window window,
 *                                      XKoord width, XKoord height, XKoord x,
 *                                      XKoord y, char *rechts, char *oben)
 *  Parameter:      display,
 *                  window:   Window, in das ausgegeben werden soll
 *                  width,
 *                  height:   Ausmasse des Windows
 *                  x, y:     Window-Koordinaten des Schnittpunktes der beiden
 *                            Koordinatenachsen
 *                  rechts:   String, dessen erstes Zeichen an den Pfeil rechts
 *                            an der waagrechten Achse gezeichnet wird
 *                  oben:     String, dessen erstes Zeochen an den Pfeil oben
 *                            an der senkrechten Achse gezeichnet wird
 *                  
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   darst_achseGC  
 *
 *  Beschreibung:
 *  -------------
 *  Zeichnen von 2 rechtwinkligen Koordinatenachsen, die das Window der Breite
 *  width und Hoehe height im Punkt x,y (Window-Koordinaten) schneiden und mit 
 *  den beiden Zeichen rechts und oben beschriftet sind.
 ***************************************************************************/

static void DoDrawAchsen(Display *display, Window window, 
			 AXKoord width, AXKoord height, AXKoord x, AXKoord y, 
			 char *rechts, char *oben)
{
     XPoint p[3];
     XDrawLine(display, window, darst_achseGC, x, 7, x, height-7);
     XDrawLine(display, window, darst_achseGC, 7, y, width-7, y);
     
     p[0].x = x+DARST_PFEILBREITE;
     p[0].y = 7+DARST_PFEILHOEHE;
     p[1].x = x;
     p[1].y = 7;
     p[2].x = x-DARST_PFEILBREITE;
     p[2].y = p[0].y;
     XFillPolygon(display, window, darst_achseGC, p, 3, Convex, CoordModeOrigin);

     p[0].x = width-7-DARST_PFEILHOEHE;
     p[0].y = y-DARST_PFEILBREITE;
     p[1].x = width-7;
     p[1].y = y;
     p[2].x = p[0].x;
     p[2].y = y+DARST_PFEILBREITE;
     XFillPolygon(display, window, darst_achseGC, p, 3, Convex, CoordModeOrigin);

     XDrawString(display, window, darst_achseGC, 
		 width-XTextWidth(dfont, rechts, 1)-7,
		 y+dfont->max_bounds.ascent, rechts, 1);
     XDrawString(display, window, darst_achseGC, x+5, 
		 7+dfont->max_bounds.ascent, oben, 1);
}



/***************************************************************************
 *  Funktion:       void DoRedrawWindow(Display *display, Window window,
 *                                      ADarstListe darst)
 *  Parameter:      display,
 *                  window:   Window, in das ausgegeben werden soll
 *                  darst:    Darstellungsliste, die in das Window ausgegeben
 *                            werden soll
 *                  
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   -
 *
 *  Beschreibung:
 *  -------------
 *  Hinmalen der Darstellungsliste darst auf das angegebene Window.
 ***************************************************************************/

static void DoRedrawWindow(short ansicht)
{
     if (darstellung.koerper != NULL)
     {
	  DoRedrawKoerper(ansicht, darstellung.koerper);
	  if (darstellung.verbindungen != NULL)
	       DoRedrawVerbindungen(ansicht, darstellung.verbindungen);
     }
}




/***************************************************************************
 *  Funktionen:     void RedrawDarstellungXY(Widget w, XEvent *event, ...)
 *                  void RedrawDarstellungYZ(Widget w, XEvent *event, ...)
 *                  void RedrawDarstellungXZ(Widget w, XEvent *event, ...)
 *                  void RedrawDarstellung3D(Widget w, XEvent *event, ...)
 *
 *  Parameter:      w:        Widget, fuer das der Xexpose-Event auftrat
 *                  event:    entsprechende expose-Event-Struktur
 *                  
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   -
 *
 *  Beschreibung:
 *  -------------
 *  Neuzeichnen der 4 Darstellungsfenster. Initiiert werden diese
 *  Routinen jeweils durch einen XExpose-event fuer das entsprechende
 *  Widget/Window. Daraufhin wird die entsprechende Darstellungsliste
 *  fuer das Window in das Window gemalt. Soll also etwas zu sehen
 *  sein, muessen die Darstellungslisten zuvor belegt worden sein
 *  (siehe AnzeigeDarstellung()). Beim allerersten Redraw (nach dem
 *  Mapping der Windows) wird demnach noch nichts zu sehen sein, da
 *  dann die Listen noch leer sind.
 *  Ausser den jeweiligen Darstellungslisten werden auch noch die
 *  entsprechenden Koordinatenachsen hingezeichnet.
 ***************************************************************************/


/***********************************************************************
 *  RedrawDarstellungXY():    XY-Darstellungsfenster neu hinzeichnen
 ***********************************************************************/

static void RedrawDarstellungXY(Widget w, XEvent *event, String *params, 
				Cardinal *num_params)
{
     /* alle weiteren Expose-Events (falls vorhanden) entfernen */
     while (XCheckWindowEvent(display[Axy], window[Axy], ExposureMask, event))
	  /* Tue nichts */ ;


     if (modus & WindowCoordON)		  /* Fensterkoordinatensystem zeichnen? */
     {
	  DoDrawAchsen(display[Axy], window[Axy], winwidth[Axy], winheight[Axy],
		       achsenXY.x, achsenXY.y, "x", "y");
     }

     DoRedrawWindow(Axy);
}




/***********************************************************************
 *  RedrawDarstellungYZ():    YZ-Darstellungsfenster neu hinzeichnen
 ***********************************************************************/

static void RedrawDarstellungYZ(Widget w, XEvent *event, String *params, 
				Cardinal *num_params)
{
     /* alle weiteren Expose-Events (falls vorhanden) entfernen */
     while (XCheckWindowEvent(display[Ayz], window[Ayz], ExposureMask, event))
	  /* Tue nichts */ ;


     if (modus & WindowCoordON)		  /* Fensterkoordinatensystem zeichnen? */
     {
	  DoDrawAchsen(display[Ayz], window[Ayz], winwidth[Ayz], winheight[Ayz],
		       achsenYZ.x, achsenYZ.y, "z", "y");
     }

     DoRedrawWindow(Ayz);
}




/***********************************************************************
 *  RedrawDarstellungXZ():    XZ-Darstellungsfenster neu hinzeichnen
 ***********************************************************************/

static void RedrawDarstellungXZ(Widget w, XEvent *event, String *params, 
				Cardinal *num_params)
{
     /* alle weiteren Expose-Events (falls vorhanden) entfernen */
     while (XCheckWindowEvent(display[Axz], window[Axz], ExposureMask, event))
	  /* Tue nichts */ ;


     if (modus & WindowCoordON)		  /* Fensterkoordinatensystem zeichnen? */
     {
	  DoDrawAchsen(display[Axz], window[Axz], winwidth[Axz], winheight[Axz],
		       achsenXZ.x, achsenXZ.y, "x", "z");
     }

     DoRedrawWindow(Axz);
}



/***********************************************************************
 *  RedrawDarstellung3D():    3D-Darstellungsfenster neu hinzeichnen
 *  
 *  Bemerkung:
 *  ----------
 *  Diese Routine ist etwas unterschiedlich von den anderen, da hier
 *  die Achsen anders angeordnet sind. Bei der Berechnung des
 *  3D-Darstellungswindows (siehe AnzeigeDarstellung()) werden auch 3
 *  Achsen mit ihren Pfeilspitzen projiziert. Diese werden hier jetzt
 *  hingezeichnet.
 ***********************************************************************/

static void RedrawDarstellung3D(Widget w, XEvent *event, String *params, 
				Cardinal *num_params)
{
     /* alle weiteren Expose-Events (falls vorhanden) entfernen */
     while (XCheckWindowEvent(display[A3d], window[A3d], ExposureMask, event))
	  /* Tue nichts */ ;

     if (modus & WindowCoordON)
     {
	  XPoint p[3];

	  /* Achsen malen */
	  XDrawLine(display[A3d], window[A3d], darst_achseGC, xl.x, xl.y, xr.x, xr.y);
	  XDrawLine(display[A3d], window[A3d], darst_achseGC, yu.x, yu.y, yo.x, yo.y);
	  XDrawLine(display[A3d], window[A3d], darst_achseGC, zv.x, zv.y, zh.x, zh.y);

	  p[0] = xp1;			  /* Pfeilspitze an x-Achse malen */
	  p[1] = xr;
	  p[2] = xp2;
	  XFillPolygon(display[A3d], window[A3d], darst_achseGC, p, 3, Convex,
		       CoordModeOrigin);
	  
	  p[0] = yp1;			  /* Pfeilspitze an y-Achse malen */
	  p[1] = yo;
	  p[2] = yp2;
	  XFillPolygon(display[A3d], window[A3d], darst_achseGC, p, 3, Convex,
		       CoordModeOrigin);
         
	  p[0] = zp1;			  /* Pfeilspitze an z-Achse malen */
	  p[1] = zh;
	  p[2] = zp2;
	  XFillPolygon(display[A3d], window[A3d], darst_achseGC, p, 3, Convex,
		       CoordModeOrigin);


	  /* Achsen beschriften */
	  XDrawString(display[A3d], window[A3d], darst_achseGC, 
		      xr.x-XTextWidth(dfont, "x",1), 
		      xr.y+dfont->max_bounds.ascent, "x", 1);
	  XDrawString(display[A3d], window[A3d], darst_achseGC,
		      yo.x+4, yo.y+dfont->max_bounds.ascent, "y", 1);
	  XDrawString(display[A3d], window[A3d], darst_achseGC,
		      zh.x, zh.y+dfont->max_bounds.ascent, "z", 1);
     }

     DoRedrawWindow(A3d);
}




/***************************************************************************
 *  Funktionen:     void ConfigureDarstellungXY(Widget w, XEvent *event, ...)
 *                  void ConfigureDarstellungYZ(Widget w, XEvent *event, ...)
 *                  void ConfigureDarstellungXZ(Widget w, XEvent *event, ...)
 *                  void ConfigureDarstellung3D(Widget w, XEvent *event, ...)
 *
 *  Parameter:      w:        Widget, fuer das der configure-Event auftrat
 *                  event:    entsprechende configure-Event-Struktur
 *                  
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   -
 *
 *  Beschreibung:
 *  -------------
 *  Wenn die Windows auf dem Schirm in Groesse oder Position veraendert
 *  werden (i.a. durch den Benutzer), wird ein Configure-Event ausgeloest.
 *  In diesen 4 Routinen werden nun fuer jedes der 4 Darstellungsfenster die
 *  Werte, die sich geaendert haben, neu gesetzt.
 ***************************************************************************/

static void ConfigureDarstellungXY(Widget w, XEvent *event, String *params, 
				   Cardinal *num_params)
{
     winwidth[Axy]  = event->xconfigure.width;
     winheight[Axy] = event->xconfigure.height;
}

static void ConfigureDarstellungYZ(Widget w, XEvent *event, String *params, 
				   Cardinal *num_params)
{
     winwidth[Ayz]  = event->xconfigure.width;
     winheight[Ayz] = event->xconfigure.height;
}

static void ConfigureDarstellungXZ(Widget w, XEvent *event, String *params, 
				   Cardinal *num_params)
{
     winwidth[Axz]  = event->xconfigure.width;
     winheight[Axz] = event->xconfigure.height;
}

static void ConfigureDarstellung3D(Widget w, XEvent *event, String *params, 
				   Cardinal *num_params)
{
     winwidth[A3d]  = event->xconfigure.width;
     winheight[A3d] = event->xconfigure.height;
}




/***************************************************************************
 *  Funktion:       void SetzeActionsDarstellung(XtAppContext *app_context,
 *                        Widget d_xy, Widget d_yz, Widget d_xz, Widget d_3d)
 *
 *  Parameter:      app_context: Kontext fuer XToolkit
 *                  d_xy, d_yz,
 *                  d_xz, d_3d:  Widgets der 4 Darstellungsfenster
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   
 *
 *  Beschreibung:
 *  -------------
 *  Lokale Actions in die Translationtables der 4 Darstellungsfenster
 *  einhaengen.  Diese Routine muss immer wieder dann aufgerufen werden,
 *  wenn die Translationtables leer sind (z.B. nach
 *  XtUninstallTranslations() oder zu Beginn des Programms) und die
 *  Darstellungsanzeige erfolgen soll.
 ***************************************************************************/
   
/* export */
void SetzeActionsDarstellung(XtAppContext *app_context, Widget d_xy, Widget d_yz,
			      Widget d_xz, Widget d_3d)
{
     static XtActionsRec actions_darstellung[] =
     { 
	  {"RedrawDarstellungXY",    RedrawDarstellungXY},
	  {"ConfigureDarstellungXY", ConfigureDarstellungXY},
	  {"RedrawDarstellungYZ",    RedrawDarstellungYZ},
	  {"ConfigureDarstellungYZ", ConfigureDarstellungYZ},
	  {"RedrawDarstellungXZ",    RedrawDarstellungXZ},
	  {"ConfigureDarstellungXZ", ConfigureDarstellungXZ},
	  {"RedrawDarstellung3D",    RedrawDarstellung3D},
	  {"ConfigureDarstellung3D", ConfigureDarstellung3D}
     };
     
     String trans_darstellungXY =
	  "#augment\n\
           <Expose>:	              RedrawDarstellungXY()  \n\
           <ConfigureNotify>:         ConfigureDarstellungXY()";
     
     String trans_darstellungYZ =
	  "#augment\n\
           <Expose>:	              RedrawDarstellungYZ()  \n\
           <ConfigureNotify>:         ConfigureDarstellungYZ()";
     
     String trans_darstellungXZ =
	  "#augment\n\
           <Expose>:	              RedrawDarstellungXZ()  \n\
           <ConfigureNotify>:         ConfigureDarstellungXZ()";
     
     String trans_darstellung3D =
	  "#augment\n\
          <Expose>:	             RedrawDarstellung3D()  \n\
          <ConfigureNotify>:         ConfigureDarstellung3D()";
     
     /* Setzen der noetigen Actions fuer alle 4 Widgets */
     
     XtAppAddActions(*app_context, actions_darstellung, 
		     XtNumber(actions_darstellung));
     
     XtAugmentTranslations(d_xy, XtParseTranslationTable(trans_darstellungXY));
     XtAugmentTranslations(d_yz, XtParseTranslationTable(trans_darstellungYZ));
     XtAugmentTranslations(d_xz, XtParseTranslationTable(trans_darstellungXZ));
     XtAugmentTranslations(d_3d, XtParseTranslationTable(trans_darstellung3D));
} 
 



/***************************************************************************
 *  Funktion:       void InitialisiereDarstellung(Widget d_xy, Widget d_yz, 
 *                                                      Widget d_xz, Widget d_3d)
 *
 *  Parameter:      d_xy, d_yz,
 *                  d_xz, d_3d: Widgets der 4 Darstellungsfenster
 *
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   
 *
 *  Beschreibung:
 *  -------------
 *  Setzen einiger Variablen. Diese Routine erfragt aus den Widgets die
 *  zugehoerigen Windows, was bedeutet, dass die Windows schon gemapped sein
 *  muessen. 
 ***************************************************************************/

/* export */   
void InitialisiereDarstellung(Widget d_xy, Widget d_yz, Widget d_xz, Widget d_3d)
{     
     XGCValues values;
     XWindowAttributes getattributes;
     XSetWindowAttributes setattributes; 
     XColor farbe;
     
     
     /* Window-IDs der 4 Widgets holen */
     
     window[Axy] = XtWindow(d_xy);
     window[Ayz] = XtWindow(d_yz);
     window[Axz] = XtWindow(d_xz);
     window[A3d] = XtWindow(d_3d);
     
     /* Displays der 4 Widgets holen (werden wohl immer die gleichen sein) */
     
     display[Axy] = XtDisplay(d_xy);
     display[Ayz] = XtDisplay(d_yz);
     display[Axz] = XtDisplay(d_xz);
     display[A3d] = XtDisplay(d_3d);
     
     /* Screens der 4 Widgets holen */
     
     screen[Axy] = DefaultScreen(display[Axy]);
     screen[Ayz] = DefaultScreen(display[Ayz]);
     screen[Axz] = DefaultScreen(display[Axz]);
     screen[A3d] = DefaultScreen(display[A3d]);
   
#if 0  
/* 
 * Diese Version der Colormap tut auch, jedoch ist die Colormap aus dem
 * Window selbst wohl am ehesten richtig, denn evtl. koennte das Programm
 * mit einer anderen Colormap als der Default-Colormap des Screens laufen.
 */
     a_colormap = DefaultColormap(display[A3d], screen[A3d]); 
#endif
     
     /* Window-Groessen der Widgets holen */
     
     XGetWindowAttributes(display[Axy], window[Axy], &getattributes);
     winwidth[Axy]  = getattributes.width;
     winheight[Axy] = getattributes.height;
     achsenXY.x  = winwidth[Axy]/2;
     achsenXY.y  = winheight[Axy]/2;

     setattributes.backing_store = NotUseful;
     setattributes.bit_gravity = ForgetGravity; 
     XChangeWindowAttributes(display[Axy], window[Axy], 
			     CWBackingStore | CWBitGravity,
			     &setattributes);
     
     XGetWindowAttributes(display[Ayz], window[Ayz], &getattributes);
     winwidth[Ayz]  = getattributes.width;
     winheight[Ayz] = getattributes.height;
     achsenYZ.x  = winwidth[Ayz]/2;
     achsenYZ.y  = winheight[Ayz]/2;
     XChangeWindowAttributes(display[Ayz], window[Ayz], 
			     CWBackingStore | CWBitGravity,
			     &setattributes);
     
     XGetWindowAttributes(display[Axz], window[Axz], &getattributes);
     winwidth[Axz]  = getattributes.width;
     winheight[Axz] = getattributes.height;
     achsenXZ.x  = winwidth[Axz]/2;
     achsenXZ.y  = winheight[Axz]/2;
     XChangeWindowAttributes(display[Axz], window[Axz],
			     CWBackingStore | CWBitGravity,
			     &setattributes);
     
     XGetWindowAttributes(display[A3d], window[A3d], &getattributes);
     winwidth[A3d]  = getattributes.width;
     winheight[A3d] = getattributes.height;
     /* Hier auch Farbtabelle entnehmen */
     a_colormap  = getattributes.colormap;
     XChangeWindowAttributes(display[A3d], window[A3d], 
			     CWBackingStore | CWBitGravity,
			     &setattributes);
     
     liniendicke = 0;			  /* schnelle Version der 1-Pixel-Dicke */

     values.foreground = BlackPixel(display[A3d], screen[A3d]);
     values.background = WhitePixel(display[A3d], screen[A3d]);
     values.fill_style = FillSolid;
     values.line_style = LineSolid;
     values.line_width = liniendicke;
     values.dash_offset= 0;
     values.dashes     = 2;

     darst_GC = XCreateGC(display[A3d], window[A3d], GCForeground | 
			  GCBackground | GCFillStyle | GCLineStyle |
			  GCLineWidth | GCDashOffset | GCDashList,
			  &values);

     darst_achseGC = XCreateGC(display[A3d], window[A3d], GCForeground |
			       GCBackground | GCFillStyle | GCLineStyle, 
			       &values);

     dfont = XQueryFont(display[A3d], XGContextFromGC(darst_achseGC));

     farbe.red = 0;
     farbe.green = 0;
     farbe.blue = 0;
     farbe.flags = DoRed | DoGreen | DoBlue;
     
     AGetColor(display[A3d], a_colormap, &farbe, "InitialisiereDarstellung()");
     RGB_farbnr = farbe.pixel;
}


/*============================================================================*/

/***********************************************************************
 *  Routinen fuer die Selektion per Maus
 *  ANMERKUNG: Diese Routinen sind nur rudimentaer. Eigentlich muessten hier
 *  die Quaternions fuer die 4 Ansichten aus AnzeigeAnimation() einfliessen.
 *  Bei einer allgemeinen Version waere dann auch eine Reaktion auf
 *  Selektion im 3D-Fenster moeglich.
 ***********************************************************************/

/***************************************************************************
 *  Funktion:       TKoerper *SelektiereVonDarstellung(Widget w, AXKoord sx, 
 *                         AXKoord sy, TVektor darstpos, TKoerper *koerper)
 *
 *  Parameter:      w:        Widget, in dem selektiert werden soll
 *                  sx, sy:   Koordinaten im Widget (0..winmaxx/winmaxy)
 *                  darstpos: Hier liegt gerade die Darstellung in der Welt
 *                  koerper:  Liste der Koerper (aus dem aktuellen Zustand)
 *                  
 *  Rueckgabewert:            Zeiger auf den selektierten Koerper
 *
 *  Import. Bez.:   sqr():    Quadratfunktion
 *                  d_zoom:   aktueller Zoom-Parameter vom letzten Aufruf
 *                            von AnzeigeDarstellung()
 *                  winmaxx:  momentane Breite des Fensters
 *                  winmaxy:  momentane Hoehe des Fensters
 *
 *  Beschreibung:
 *  -------------
 *  Je nach uebergebenem Widget werden die gegebenen X-Windows-Koordinaten
 *  sx,sy auf die reale Welt umgerechnet und anschliessend der Koerper in
 *  der Liste gesucht, der bei Betrachtung aus der Sicht des jeweiligen
 *  Fensters den geringsten seitlichen Abstand hat. Bei mehreren Koerpern
 *  mit dem gleichen Abstand wird das Objekt gefunden, dass zuerst in der
 *  Liste der Koerper auftaucht. Wird kein Objekt gefunden oder handelt es
 *  sich bei dem Widget nicht um die drei Grundansichten, dann wird NULL
 *  zurueckgegeben. 
 ***************************************************************************/

/* export */
TKoerper *SelektiereVonDarstellung(Widget w, AXKoord sx, AXKoord sy,
				   TVektor darstpos, TKoerper *koerper)
{
     TReal     x, y;			  /* Mausklick-Koordinaten, */
					  /* umgerechnet in virtuelle Welt */
     TReal     distanz;			  /* Abstand zum Koerpermittelpunkt */
     TReal     mindist = REAL_MAX;	  /* minim. Abstand (Minimumsuche) */
     TKoerper  *kmin = NULL;		  /* Zeiger auf diesen Koerper */
     TKoerper  *k;
     

     k = koerper;

     /* Maus im xy-Fenster geklickt? */
     if (XtWindow(w) == window[Axy]) 
     {
	  /* Berechne vom Mausklick die reale Koordinaten in der Welt */
	  x = (sx-winmaxx[Axy]/2)/d_zoom/B_ACHSEN_X+darstpos[0];
	  y = (sy-winmaxy[Axy]/2)/d_zoom/B_ACHSEN_Y+darstpos[1];

	  /* Suche den Koerper mit kleinstem seitlichem Abstand */
	  while (k != NULL) 
	  {
	       distanz = sqr(x-k->Position[0]) + sqr(y-k->Position[1]);
	       if (distanz < mindist) 
	       {
		    mindist = distanz;
		    kmin = k;
	       }
	       k = k->Naechster;
	  }
	  return kmin;
     } 

     /* Maus im xz-Fenster geklickt? */
     if (XtWindow(w) == window[Axz]) 
     {
	  /* Berechne vom Mausklick die reale Koordinaten in der Welt */
	  x = (sx-winmaxx[Axz]/2)/d_zoom/B_ACHSEN_X+darstpos[0];
	  y = (sy-winmaxy[Axz]/2)/d_zoom/B_ACHSEN_X+darstpos[2];

	  /* Suche den Koerper mit kleinstem seitlichem Abstand */
	  while (k != NULL) 
	  {
	       distanz = sqr(x-k->Position[0]) + sqr(y-k->Position[2]);
	       if (distanz < mindist) 
	       {
		    mindist = distanz;
		    kmin = k;
	       }
	       k = k->Naechster;
	  }
	  return kmin;
     }
 
     /* Maus im yz-Fenster geklickt? */
     if (XtWindow (w) == window[Ayz]) 
     {
	  /* Berechne vom Mausklick die reale Koordinaten in der Welt */
	  x = (sx-winmaxx[Ayz]/2)/d_zoom/B_ACHSEN_Y+darstpos[2];
	  y = (sy-winmaxy[Ayz]/2)/d_zoom/B_ACHSEN_Y+darstpos[1];

	  /* Suche den Koerper mit kleinstem seitlichem Abstand */
	  while (k != NULL) 
	  {
	       distanz = sqr(x-k->Position[2]) + sqr(y-k->Position[1]);
	       if (distanz < mindist) 
	       {
		    mindist = distanz;
		    kmin = k;
	       }
	       k = k->Naechster;
	  }
	  return kmin;
     } 
     
     /* Nein, Maus wurde im 3D-Fenster geklickt. */
     fprintf(stderr, "3D selection not yet implemented...\n");
     return NULL;
}


/***************************************************************************
 *  Funktion:       void OffsetDarstellung(Widget w, AXKoord sx, AXKoord sy,
 *                                                         TVektor darstpos)
 *
 *  Parameter:      w:        Widget, in dem selektiert werden soll
 *                  sx, sy:   Koordinaten im Widget (0..winmaxx/winmaxy)
 *                  darstpos: Hier liegt gerade die Darstellung in der Welt
 *                  
 *  Rueckgabewert:  darstpos: Neue Lage der Darstellung nach Verschiebung
 *
 *  Import. Bez.:   d_zoom:   aktueller Zoom-Parameter vom letzten Aufruf
 *                            von AnzeigeDarstellung()
 *                  winmaxx:  momentane Breite des Fensters
 *                  winmaxy:  momentane Hoehe des Fensters
 *
 *  Beschreibung:
 *  -------------
 *  Je nach uebergebenem Widget werden die gegebenen X-Windows-Koordinaten
 *  sx,sy auf die reale Welt umgerechnet. Diese ergeben ein Offset, das zur
 *  uebergebenen Position darstpos hinzuaddiert wird.
 ***************************************************************************/

/* export */
void OffsetDarstellung(Widget w, AXKoord sx, AXKoord sy, TVektor darstpos)
{
     if (XtWindow(w) == window[Axy]) 
     {
	  darstpos[0] += (sx - winmaxx[Axy]/2)/d_zoom/B_ACHSEN_X;
	  darstpos[1] += (sy - winmaxy[Axy]/2)/d_zoom/B_ACHSEN_Y;
     }
     else if (XtWindow(w) == window[Axz]) 
     {
	  darstpos[0] += (sx - winmaxx[Axz]/2)/d_zoom/B_ACHSEN_X;
	  darstpos[2] += (sy - winmaxy[Axz]/2)/d_zoom/B_ACHSEN_X;
     } 
     else if (XtWindow(w) == window[Ayz]) 
     {
	  darstpos[2] += (sx - winmaxx[Ayz]/2)/d_zoom/B_ACHSEN_Y;
	  darstpos[1] += (sy - winmaxy[Ayz]/2)/d_zoom/B_ACHSEN_Y;
     } 
     else 
     {
	  fprintf(stderr, "3D offset scrolling not yet implemented ...\n");
     }
}



/*============================================================================*/

/***********************************************************************
 *  Routinen fuer das kleine RGB-Fenster
 ***********************************************************************/


static AXKoord RGBwidth, RGBheight;	  /* Groesse des RGB-Fensters */
static GC RGB_GC;			  /* GC fuer dieses Fenster */
static Display *displayRGB;		  /* Display fuer dieses Fenster */
static Window windowRGB;		  /* Und WindowID dafuer */



/***************************************************************************
 *  Funktion:       void RedrawRGB(Widget w, XEvent *event, ...)
 *
 *  Parameter:      w:        Widget, fuer das der Xexpose-Event auftrat
 *                  event:    entsprechende expose-Event-Struktur
 *                  
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   -
 *
 *  Beschreibung:
 *  -------------
 *  Neuzeichnen des RGB-Windows. Dabei wird einfach das Rechteck in der
 *  richtigen Farbe neu gezeichnet.
 ***************************************************************************/

static void RedrawRGB(Widget w, XEvent *event, String *params, 
		      Cardinal *num_params)
{
     while (XCheckWindowEvent(displayRGB, windowRGB, ExposureMask, event))
	  /* Tue nichts */ ;

     XSetForeground(displayRGB, RGB_GC, RGB_farbnr);
     XFillRectangle(displayRGB, windowRGB, RGB_GC, 0, 0, RGBwidth, RGBheight);
}


/***************************************************************************
 *  Funktion:       void ConfigureRGB(Widget w, XEvent *event, ...)
 *
 *  Parameter:      w:        Widget, fuer das der Xexpose-Event auftrat
 *                  event:    entsprechende expose-Event-Struktur
 *                  
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   -
 *
 *  Beschreibung:
 *  -------------
 *  Neusetzen der Windowgroesse des RGB-Windows, falls sich die Groesse
 *  geaendert hat.
 ***************************************************************************/

static void ConfigureRGB(Widget w, XEvent *event, String *params, 
			 Cardinal *num_params)
{
     RGBwidth  = event->xconfigure.width;
     RGBheight = event->xconfigure.height;
}




/***************************************************************************
 *  Funktion:       void InitialisiereRGB(XtAppContext *app_context, Widget w)
 *
 *  Parameter:      app_contetxt: Application-Context des X-Toolkit (noetig
 *                                fuer die Eintragung der Actions und Translations)
 *                  w:            Widget, fuer das der Xexpose-Event auftrat
 *                  
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   -
 *
 *  Beschreibung:
 *  -------------
 *  Setzen aller noetigen Actions und Translations, initialisieren aller
 *  Variablen fuer das RGB-Widget. In diesem Widget wird immer die aktuelle
 *  Farbe angezeigt, die mit den Slidern eingestellt wird.
 ***************************************************************************/

/* export */
void InitialisiereRGB(XtAppContext *app_context, Widget w)
{
     static XtActionsRec actions_RGB[] =
     { 
	  {"RedrawRGB",    RedrawRGB},
	  {"ConfigureRGB", ConfigureRGB}
     };

     String trans_RGB =
	  "#overridee\n\
           <Expose>:	              RedrawRGB()  \n\
           <ConfigureNotify>:         ConfigureRGB()";
 
     XGCValues values;
     XWindowAttributes getattributes;
     XSetWindowAttributes setattributes; 


     XtAppAddActions(*app_context, actions_RGB, XtNumber(actions_RGB));
     
     XtOverrideTranslations(w, XtParseTranslationTable(trans_RGB));

     windowRGB = XtWindow(w);

     displayRGB = XtDisplay(w);

     XGetWindowAttributes(displayRGB, windowRGB, &getattributes);
     RGBwidth  = getattributes.width;
     RGBheight = getattributes.height;

     setattributes.backing_store = NotUseful;
     setattributes.bit_gravity = ForgetGravity; 
     XChangeWindowAttributes(displayRGB, windowRGB, CWBackingStore | CWBitGravity,
			     &setattributes);
     
     values.foreground = BlackPixel(display[A3d], screen[A3d]);
     values.background = WhitePixel(display[A3d], screen[A3d]);
     values.fill_style = FillSolid;

     RGB_GC = XCreateGC(displayRGB, windowRGB, GCForeground | GCBackground |
			GCFillStyle, &values);

}



/***************************************************************************
 *  Funktion:       void AnzeigeRGB(Widget w, unsigned short R, 
 *                                       unsigned short G, unsigned short B)
 *
 *  Parameter:      w:        Widget des RGB-Windows
 *                  R, G, B:  Farbanteile
 *                  
 *  Rueckgabewert:  -
 *
 *  Import. Bez.:   -
 *
 *  Beschreibung:
 *  -------------
 *  Die angegebene Farbe wird in der aktuellen Farbtabelle alloziert und mit
 *  dieser Farbe das Window gefuellt. Zuvor wird die alte Farbzelle
 *  freigegeben, sodass i.a. immer dieselbe Farbzelle der Farbtabelle
 *  benutzt wird. Von der Funktionalitaet entspricht dies der Benutzung
 *  einer READ/WRITE-Colorcell, aber diese Methode hier funktioniert auch
 *  bei Visuals mit Read-Only-Colormap (z.B. Monochrome, TrueColor, StaticGrey).
 ***************************************************************************/

/* export */
void AnzeigeRGB(Widget w, unsigned short R, unsigned short G, unsigned short B)
{
     XColor farbe;

     XFreeColors(displayRGB, a_colormap, &RGB_farbnr, 1, 0);

     farbe.red = R;
     farbe.green = G;
     farbe.blue = B;
     farbe.flags = DoRed | DoGreen | DoBlue;

     AGetColor(displayRGB, a_colormap, &farbe, "AnzeigeRGB()");
     RGB_farbnr = farbe.pixel;

     XSetForeground(displayRGB, RGB_GC, RGB_farbnr);
     XFillRectangle(displayRGB, windowRGB, RGB_GC, 0, 0, RGBwidth, RGBheight);
}

