/*    ShellyLibV2.0 - the ShellShapeGenerator 
**
**    Copyright (C) 1996 Randolf Schultz (rschultz@informatik.uni-rostock.de)
**
**    This software is shareware!
**    Read the file "License" for further information.
*/

#ifndef pi
#define pi 3.141592654
#endif

/* structs */
struct SLpoint
{
  struct SLpoint *next;
  double x, y, z, s;
};

struct SLshell
{
  struct SLshell *next;
  struct SLpoint *line;
};

struct SLgcpoint
{
  struct SLgcpoint *next;
  double x, y;
};

struct SLarguments
{ 
  /* normal arguments, as used in the article by M.B. Cortie */ 
  double alpha, beta, phi, my, omega, omin, omax, smin, smax,
         A, a, b, P, W1, W2, N, L, scale;
  double od, sd;
  
  /* extra arguments */ 

  /* additional nodules */
  double P2, W12, W22, N2, L2, Off2, P3, W13, W23, N3, L3, Off3;

  /* nodule start */
  double Nstart, Nstart2, Nstart3;

  /* control parameters for nodule-modes */
  double heightdiffo, heightdiffs, Scans, Scano;

  /* Skip */
  double SkipSStart, SkipSEnd, SkipOStart, SkipOEnd;

  /* Generating Curve */
  struct SLgcpoint *GCurve;

  /* status-information */
  unsigned int countp, counth, countw;
  unsigned int points, lines, triangles;

  int mode;
  int output;
};

/* index-structures */
struct SLpindex
{
  struct SLpindex *next;
  struct SLpoint *point;
  unsigned int pid;
};

struct SLlindex
{
  struct SLlindex *next;
  unsigned int pid1, pid2;
  unsigned int lid;
};

struct SLtindex
{
  struct SLtindex *next;
  unsigned int lid1, lid2, lid3;
  unsigned int pid1, pid2, pid3;
};

struct SLtriangle
{
  struct SLtriangle *next;
  struct SLpoint *p1, *p2, *p3;
};


/* prototypes */
int SLCalcShell (struct SLarguments *arg, struct SLshell **shell);

int SLCalcShellNodule (struct SLarguments *arg, struct SLshell **shell);

int SLCalcShellGC (struct SLarguments *arg, struct SLshell **shell);

int SLCalcLine (double O, struct SLarguments *arg, struct SLpoint **list);

int SLCalcNodLine (double O, struct SLarguments *arg, struct SLpoint **list);

int SLCalcLineFromGCurve (double O, struct SLarguments *arg, struct
 SLpoint **list);

int SLCalcPoint (double O, double S, struct SLarguments *arg, struct SLpoint 
		 **SLpoint);

void SLFreeGC (struct SLarguments *hp);

void SLFreeLine (struct SLpoint *hp);

void SLFreeShell (struct SLshell *hp);


int SLCreateIndex(struct SLarguments *arg, struct SLshell *shell, struct 
		  SLtindex **tind, struct SLlindex **lind, struct SLpindex 
		  **pind);
int SLTriangulate(struct SLpoint *list1, struct SLpoint *list2, 
		  struct SLtriangle **result);

void SLFreeTriangles (struct SLtriangle *hp);

void SLFreePindex (struct SLpindex *hp1);

void SLFreeLindex (struct SLlindex *hp1);

void SLFreeTindex (struct SLtindex *hp1);







