/*    ShellyLibV2.0 - the ShellShapeGenerator 
**
**    Copyright (C) 1996 Randolf Schultz (rschultz@informatik.uni-rostock.de)
**
**    This software is shareware!
**    Read the file "License" for further information.
*/


/* misc */
/* fileformat dependent scalefactors */
#define SCALEX3D 100
#define SCALERPL 0.01
#define SCALERAW 1
#define SCALETSP 1
#define SCALET3D 1
#define SCALEBEZ 1
#define SCALESCD 0.05
#define SCALERIB 0.1

/* POVRay-BezierPatch parameters */
#define BEZSTEPU 2
#define BEZSTEPV 2
#define BEZFLAT 0.0
#define BEZTYPE 1

/* constant to calculate controlpoints of BezierPatches */
#define BEZCON 3.3


/* prototypes */
void ReadInfile (struct SLarguments *arg, FILE *fp);

void WriteX3DFile (struct SLarguments *arg, struct SLshell *shell, struct 
		   SLpindex *pind, struct SLlindex *lind, struct SLtindex 
		   *tind, FILE *fp);

void WriteRPLFile (struct SLarguments *arg, struct SLshell *shell, struct
		   SLpindex *pind, struct SLtindex *tind, FILE *fp);

void WriteRAWFile (struct SLarguments *arg, struct SLshell *shell, FILE *fp);

void WriteT3DFile (struct SLarguments *arg, struct SLshell *shell, struct
		   SLpindex *pind, struct SLlindex *lind, struct SLtindex
		   *tind, FILE *fp);

void WriteTSPFile (struct SLarguments *arg, struct SLshell *shell, struct
		   SLpindex *pind, struct SLlindex *lind, struct SLtindex
		   *tind, FILE *fp);

void WriteSCDFile (struct SLarguments *arg, struct SLshell *shell, struct
		   SLpindex *pind, struct SLlindex *lind, struct SLtindex
		   *tind, FILE *fp);

void WriteSCDBFile (struct SLarguments *arg, struct SLshell *shell, FILE *fp);

void WriteRIBFile (struct SLarguments *arg, struct SLshell *shell, FILE *fp);

void WriteBEZFile (struct SLarguments *arg, struct SLshell *shell, FILE *fp);


