#   ShellyLibV2.0 - the ShellShapeGenerator 
#
#   Copyright (C) 1996 Randolf Schultz (rschultz@informatik.uni-rostock.de)
#
#   This software is shareware!
#   Read the file "License" for further information.

#
# The Shell Laboratory, a Tcl/Tk - OpenGL GUI for ShellyLib
# Tcl/Tk part
#

# bitmap, for the about-requester
image create bitmap nautilus -data\
{#define amm_width 63
#define amm_height 55
static char amm_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x80,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0x80,0x00,0x00,0x4b,0x74,0x00,0x00,
 0x00,0x80,0x00,0xc0,0xaa,0xaa,0x01,0x00,0x00,0x80,0x00,0xb0,0x0a,0x91,0x02,
 0x00,0x00,0x80,0x00,0x58,0x41,0x44,0x0d,0x00,0x00,0x80,0x00,0x2a,0x14,0x11,
 0x1a,0x00,0x00,0x80,0x00,0x4f,0x01,0x84,0x14,0x00,0x00,0x80,0x80,0x11,0xa4,
 0x20,0x29,0x00,0x00,0x80,0x80,0x45,0x01,0x08,0x64,0x00,0x00,0x80,0xc0,0x12,
 0x10,0x81,0x50,0x00,0x00,0x80,0xa0,0x84,0x04,0x24,0xa4,0x00,0x00,0x80,0x60,
 0x22,0xa0,0x00,0xa1,0x00,0x00,0x80,0x50,0x89,0x04,0x29,0x90,0x00,0x00,0x80,
 0xb0,0x00,0x10,0x82,0xa4,0x01,0x00,0x80,0x28,0x25,0x82,0x28,0x40,0x01,0x00,
 0x80,0x58,0x80,0x50,0x04,0x92,0x01,0x00,0x80,0x28,0x15,0x84,0xaa,0x40,0x01,
 0x00,0x80,0x98,0x40,0x20,0x15,0x92,0x01,0x00,0x80,0x54,0x04,0x4a,0xad,0x40,
 0x01,0x00,0x80,0x2c,0x41,0x10,0x12,0x94,0x00,0x00,0x80,0x14,0x08,0xa1,0xaa,
 0xc0,0x00,0x00,0x80,0xac,0x22,0x04,0x55,0xa8,0x00,0x00,0x80,0x28,0x80,0xa0,
 0x92,0x52,0x00,0x00,0x80,0x14,0x09,0x12,0x48,0x64,0x00,0x00,0x80,0xac,0x20,
 0x40,0x25,0x31,0x00,0x00,0x80,0x2c,0x84,0x14,0x90,0x44,0x00,0x00,0x80,0x94,
 0x02,0x40,0x45,0x10,0x01,0x00,0x80,0x5c,0x50,0x04,0x10,0x45,0x06,0x00,0x80,
 0x2c,0x05,0x21,0x45,0x00,0x18,0x00,0x80,0x50,0x10,0x08,0x10,0x95,0x22,0x00,
 0x80,0xa8,0x82,0x40,0x02,0x00,0xc8,0x00,0x80,0x58,0x24,0x12,0x90,0x24,0x01,
 0x03,0x80,0x30,0x01,0x00,0x05,0x10,0x48,0x04,0x80,0xb0,0x2a,0x49,0x50,0x42,
 0x01,0x11,0x80,0xa0,0x00,0x00,0x00,0x00,0x24,0x64,0x80,0x60,0x55,0x25,0x89,
 0x12,0x80,0x90,0x80,0x60,0x05,0x00,0x20,0x40,0x12,0x42,0x82,0xc0,0x52,0x52,
 0x82,0x08,0x40,0x10,0x8a,0x80,0x8a,0x00,0x08,0x82,0x0a,0x4a,0x95,0x00,0x2b,
 0x2a,0x21,0x28,0xa0,0x20,0xa9,0x00,0x95,0x00,0x04,0x81,0x04,0x8a,0x9a,0x00,
 0x56,0xaa,0x50,0x10,0xa0,0x50,0x85,0x00,0x5c,0x01,0x02,0x85,0x0a,0xa5,0x82,
 0x00,0x58,0xaa,0x24,0x20,0x40,0x52,0x81,0x00,0xb0,0x09,0x10,0x15,0x95,0xd4,
 0x80,0x00,0x40,0x55,0x85,0xa0,0x48,0x2a,0x80,0x00,0x80,0x55,0x51,0x0a,0x52,
 0x1b,0x80,0x00,0x00,0xaf,0x14,0x51,0xa9,0x06,0x80,0x00,0x00,0xb4,0xaa,0xaa,
 0xaa,0x01,0x80,0x00,0x00,0xf0,0x55,0x55,0x75,0x00,0x80,0x00,0x00,0x80,0x5f,
 0x55,0x0f,0x00,0x80,0x00,0x00,0x00,0xf8,0xff,0x00,0x00,0x80,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x80};
}

# Vars, lots of ;)
set slmode 0
set cvupdate_while_sliding 1
set cvdrawSys 1
set 3dview_open "no"

set filename ""

# the entries are bound to dummy, when focused
set dummy 0
set dummyval 0
set safedummy 0

# the sliders are bound to dummyval, when loading a file
set dummyval2 0

# all sliders, we derive varnames & widgetnames from this list
set sliders { alpha beta phi my omega _A a b scale omin omax od smin smax sd\
	_P1 _Nstart1 _W11 _W21 _N1 _L1 _P2 _Nstart2 _W12 _W22 _N2 _L2 _Off2\
	_P3 _Nstart3 _W13 _W23 _N3 _L3 _Off3 hdo scano hds scans }

# initial values for all sliders
set sinit { 90 90 1 1 1 5.0 1.5 1.5 1 0 360 10 -180 180 20\
	    0 0 30 30 0 0 0 0 30 30 0 0 0 0 0 30 30 0 0 0\
	    0.15 0.10 0.15 0.10 }

# initial minimum values for all sliders
set sinitmin { 10 0 0 0 0 0.1 0.1 0.1 0 0 360 1 -200 0 1\
	       -180 0 10 10 0 -10 -180 0 10 10 0 -10 0 -180 0\
	       10 10 0 -10 0 0.01 0.01 0.01 0.01 }

# initial maximum values for all sliders
set sinitmax { 90 90 90 90 90 10 10 10 1 100 900 40 0 200 40\
	       180 720 110 110 12 10 180 720 110 110 12 10 45\
	       180 720 110 110 12 10 45 1.0 1.0 1.0 1.0 }


set index 0

# generate global variables
foreach slider $sliders {

    set maxname  $slider
    set minname  $slider
    append minname "min"
    append maxname "max"

    set $slider [lindex $sinit $index]
    set $minname [lindex $sinitmin $index]
    set $maxname [lindex $sinitmax $index]

    incr index
}

# skip not yet implemented
#set _SkipOSt
#set _SkipOStmin
#set _SkipOStmax
#set _SkipOEnd
#set _SkipOEndmin
#set _SkipOEndmax
#set _SkipSSt
#set _SkipSStmin
#set _SkipSStmax
#set _SkipSEnd
#set _SkipSEndmin
#set _SkipSEndmax

# procedures

##############################
# helpTut:
# open tutorial-window
#
proc helpTut {} {
set w .hlptut
catch {destroy $w}
toplevel $w
wm title $w "Shell Laboratory Help: Tutorial"
wm iconname $w "ShellLabHelp"
wm group $w .

frame $w.ftext
frame $w.fbutton
pack $w.ftext -in $w -side top -expand yes -fill both
pack $w.fbutton -in $w -side bottom

text $w.ftext.text -yscrollcommand "$w.ftext.sbar set" \
	-setgrid 1 -height 25 -width 70
scrollbar $w.ftext.sbar -takefocus 0 -command "$w.ftext.text yview"
pack $w.ftext.text -in $w.ftext -side left -fill both -expand yes
pack $w.ftext.sbar -in $w.ftext -side right -fill y
$w.ftext.text insert end \
{ 
Shell Laboratory Tutorial
=========================

This is a small introduction to the Shell-Laboratory.

You may keep this window open while experimenting 
with the Shell Laboratory.

You did not touch any other thing than the 'Tutorial'
menu button? If not, restart the lab!

Our goal is to make the donut like shape currently displayed
in the 3D-View window to a nice looking shell. Let's say 
a Turritella.
Then we save our work to a .shy data file and to a 3D object.


1) Drag the uppermost slider labeled 'alpha' until
   the associated entry shows a value near 88. 

Watch the donut to begin looking like a spiral. 

2) Clickdrag into the 3D-View window to rotate the shell 
 (start in the middle and move the mouse about a quarter 
  of the current window-height straight up). 

You should now be able to look at the shell along the z-axis.

Back to the main window.

3) Drag 'beta' to a value of about 4. 

Watch the object getting smaller and ball alike.
The object seems to disappear, but don't worry
about this now.

The current configuration of the '_A' slider does not
allow the value we'd like to set it to (22).

4)
 4.1)  Click the accompanying 'Cal.' button. 
       
Another window appears.

 4.2)  Change the entry labeled '_Amax' to 22.
 4.3)  Press 'Ok!'.
 4.4)  Now drag the slider '_A' to its new maximum (right).

Whoops, the shell is gone? ;) No Problem for us.

 4.5)  Press '-' (while in the 3D-View) until the object
       (shaped like a curl) reappears.

Looks not to bad eh?
But a real Turritella has more whorls. Need to change that.

5) Set the 'omax' slider to 900 (This gives us 2 and 
   a half whorls, 360 == 1 whorl)

Note: You probably have to scroll the canvas of the main window
      to get to that slider, if you did not maximized the 
      window yet. The slider is in the 'Dimension' section.

900 is surely not enough, a real Turritella has 10 to 
20 whorls. 

6) Reconfigure the slider to a maximum value of 2000. 

You forgot how to? Look up step 4 then.

7) Set 'omax' to 2000, but this time use the entry.
   Click into the entry and change the value with
   the keyboard. Press the <TAB> key when finished.

The shell is now almost complete. It is just not to be seen.
Switch to the 3D-View.

8) Press 'Cursor-Up' several times, until the shell is
   displayed in the middle of the window.

We will now change the current wireframe display to a more
plastic one.

9) Choose Rendering/Mode/SmoothShaded from the menu of
   the main window. 

The current shape is actually not looking like a real shell.
There is too much space between the whorls.

10) Change this by dragging _A to a suitable value. 
    12 will be fine.

11) Adjust the view again by pressing 'Cursor-Down'.

12) Clickdrag into the 3D-View to rotate the shell.

We will save our work now.

13) Use the keyboard shortcut <Ctrl+s> to save.
    A filerequester pops up. 

14) Change the filename to whatever you like. 
    You shouldn't omit the '.shy' extension, 
    which marks the file as a ShellyLib datafile.

15) Use the 'Ok!' button, when finished.

Now we will generate a 3D object for inclusion of the
shell into other scenes.

16) Use the 'Shelly/Write 3D Object' submenu. 
    Choose the fileformat. The following file requester
    should suggest an appropriate filename. 
    If not, change it.

17) We don't forget the 'Ok!' button.


A last advice:
Take care when dragging the sliders. Especially the sliders of
the 'Dimension' section may easily fill up your memory or
lock your machine for a while ...

}

$w.ftext.text configure -state disabled

button $w.fbutton.b -text "Dismiss" -command "destroy $w"
pack $w.fbutton.b -in $w.fbutton

}


##############################
# helpLab:
# opens ShellLab-help-window
#
proc helpLab {} {
set w .hlptut
catch {destroy $w}
toplevel $w
wm title $w "Shell Laboratory Help: Shell Laboratory"
wm iconname $w "ShellLabHelp"
wm group $w .

frame $w.ftext
frame $w.fbutton

pack $w.ftext -in $w -side top -expand yes -fill both
pack $w.fbutton -in $w -side bottom

text $w.ftext.text -yscrollcommand "$w.ftext.sbar set" \
	-setgrid 1 -height 25 -width 70
scrollbar $w.ftext.sbar -takefocus 0 -command "$w.ftext.text yview"
pack $w.ftext.text -in $w.ftext -side left -fill both -expand yes
pack $w.ftext.sbar -in $w.ftext -side right -fill y

$w.ftext.text insert end \
{
Please refer to the real manual located in the "doc/" subdirectory of
the distribution for the documentation of the Shell Laboratory.
}

$w.ftext.text configure -state disabled

button $w.fbutton.b -text "Dismiss" -command "destroy $w"
pack $w.fbutton.b -in $w.fbutton

}


##############################
# helpAbout:
# opens about-window
#
proc helpAbout {} {
set w .hlpabout
catch {destroy $w}
toplevel $w
wm title $w "Shell Laboratory Help: About"
wm iconname $w "ShellLabHelp"
wm group $w .
wm resizable $w no no

frame $w.ftext
frame $w.fbutton
pack $w.ftext $w.fbutton -in $w -side top

text $w.ftext.text -yscrollcommand "$w.ftext.sbar set" \
	-setgrid 1 -height 14 -width 50
scrollbar $w.ftext.sbar -takefocus 0 -command "$w.ftext.text yview"
pack $w.ftext.text -in $w.ftext -side left -fill both -expand yes
pack $w.ftext.sbar -in $w.ftext -side right -fill y

label $w.ftext.text.l -image nautilus
$w.ftext.text window create end -window $w.ftext.text.l -align center\
	-pady 3

$w.ftext.text insert end \
{ 
Shell Laboratory

A Tcl/Tk - OpenGL GUI for
ShellyLibV2.0 the ShellShapeGenerator
Copyright (c) 1996 by Randolf Schultz
(rschultz@informatik.uni-rostock.de)
All rights reserved.
This software is shareware!
Refer to the file License for more details.
}
$w.ftext.text tag add "tag1" 1.0 end
$w.ftext.text tag add "name" 2.0 2.end
$w.ftext.text tag configure tag1 -justify center
$w.ftext.text tag configure name -underline yes

$w.ftext.text configure -state disabled

button $w.fbutton.b -text "Dismiss" -command "destroy $w"
pack $w.fbutton.b -in $w.fbutton

}


##############################
# rotate3DView:
# rotate 3D-View with mouse
#
proc rotate3DView { width height x y } {
    set w .3dwin

    $w.f3d.togl setXrot [expr 360.0 * $y / $height]
    $w.f3d.togl setYrot [expr 360.0 * ($width - $x) / $width]
}


##############################
# open3D:
# open 3D-View window
#
proc open3D {} {
global 3dview_open

set w .3dwin
catch {destroy $w}
toplevel $w
wm title $w "Shell Laboratory 3D-View"
wm iconname $w "View"
wm group $w .

 frame $w.f3d
    togl $w.f3d.togl -rgba true\
	    -double true -depth true -ident ShellView

# Bindings for the 3D-View
    bind $w.f3d.togl <B1-Motion> {
	rotate3DView [lindex [%W config -width] 4] \
		     [lindex [%W config -height] 4] \
		     %x %y
    }
 
    bind $w <KeyPress-plus> {
	.3dwin.f3d.togl zoomIn
    }
    bind $w <KeyPress-KP_Add> {
	.3dwin.f3d.togl zoomIn
    }

    bind $w <KeyPress-minus> {
	.3dwin.f3d.togl zoomOut
    }
    bind $w <KeyPress-KP_Subtract> {
	.3dwin.f3d.togl zoomOut
    }

    bind $w <KeyPress-Up> {
	.3dwin.f3d.togl moveZ  1
    }

    bind $w <KeyPress-Down> {
	.3dwin.f3d.togl moveZ -1
    }
    bind $w <KeyPress-Left> {
	.3dwin.f3d.togl setZrot -10
    }
    bind $w <KeyPress-Right> {
	.3dwin.f3d.togl setZrot 10
    }
    bind $w <KeyPress-r> {
	.3dwin.f3d.togl resetView
    }

 pack $w.f3d -in $w -fill both -expand yes
 pack $w.f3d.togl -in $w.f3d -side left -fill both -expand yes

 set 3dview_open "yes"
}


##############################
# updateView:
# update 3D-View
#
proc updateView {name value} {
    global cvupdate_while_sliding
    global 3dview_open

    if { $3dview_open == "yes" } {
	if { $cvupdate_while_sliding == 1 } {
	    .3dwin.f3d.togl update3DView $name $value
	}
    }

}

##############################
# setminmax:
# set a sliders from, to and resolution values
#
proc setminmax {min max paramname} {

set slfw .fmid.fsliders.canv.slidecon.$paramname

global $min $max $paramname

set $min [.calwindow.emin get]
set $max [.calwindow.emax get]

$slfw.lmin configure -text [.calwindow.emin get]
$slfw.lmax configure -text [.calwindow.emax get]

$slfw.s configure -from [.calwindow.emin get]
$slfw.s configure -to [.calwindow.emax get]
$slfw.s configure -resolution [.calwindow.step get]
}


##############################
# calibrateSlider:
# request new from, to and resolution values of a slider
#
proc calibrateSlider {paramname} {

set slfw .fmid.fsliders.canv.slidecon.$paramname

# create a new window
set w .calwindow
catch {destroy $w}
toplevel $w
wm title $w "Calibrate Slider: $paramname"
wm group $w .
wm iconname $w "Cal."
wm resizable $w no no

# fetch values
set min $paramname 
set max $paramname 
append min "min"
append max "max"
global $min $max $paramname

eval set rmin \$$min
eval set rmax \$$max
frame $w.entries
frame $w.entriesr
frame $w.entriesl
frame $w.buttons

pack $w.entries -in $w -side top 
pack $w.entriesr -in $w.entries -side right
pack $w.entriesl -in $w.entries -side left
pack $w.buttons -in $w -side bottom 

# create 3 labeled entries
label $w.lmin -text "$min:" -width 8
label $w.lmax -text "$max:" -width 8
label $w.lstep -text "Stepsize:" -width 8

entry $w.emin -width 8
$w.emin insert @0 $rmin

entry $w.emax -width 8 
$w.emax insert @0 $rmax

entry $w.step -width 8
set step [$slfw.s cget -resolution]
$w.step insert @0 $step

pack $w.lmin -in $w.entriesl -side top 
pack $w.lmax -in $w.entriesl -side top 
pack $w.lstep -in $w.entriesl -side top

pack $w.emin -in $w.entriesr -side top 
pack $w.emax -in $w.entriesr -side top 
pack $w.step -in $w.entriesr -side top 

# create ok & cancel button
button $w.buttons.ok -text "  Ok!  " \
	-command "setminmax $min $max $paramname; destroy $w"

button $w.buttons.cancel -text "Cancel!" -command "destroy $w"

pack $w.buttons.ok $w.buttons.cancel -in $w.buttons -side left\
	-padx 4m -pady 2m 
grab set $w
}


##############################
# createSlider:
# create a slider and associated entry & labels
#
proc createSlider { name slname } {

set min $name 
set max $name 
append min "min"
append max "max"
global $min $max $slname $name

# Don't you think using strings as varnames is a funny thing? ;)

eval set rmin \$$min
eval set rmax \$$max
eval set val \$$name
frame $slname.$name

# parameter name
label $slname.$name.l -text "$name " -width 6

# Entry showing the real value
entry $slname.$name.e -textvariable $name -width 8

bind $slname.$name.e <FocusIn> {
    set dummy [%W cget -textvariable]
    set dummyval [%W get]
    set safedummy $dummyval
    %W configure -textvariable dummyval }

bind $slname.$name.e <FocusOut> {
    eval set newval \$$dummy
	if { [catch {set $dummy $dummyval}] == 1} { set $dummy $safedummy }
	%W configure -textvariable $dummy
	if { $newval != $dummyval } { updateView $dummy [%W get] }
}

# the slider itself 
scale $slname.$name.s  -orient horizontal -showvalue no\
        -length 5c -variable $name -from $rmin -to $rmax\
	-command "updateView $name"

bind $slname.$name.s <Button-1> { focus %W }


#calc resolution, always a 100th of the next higher full dezimal
set a [expr ($rmax - $rmin)*10.0]
set b 1.0
while {$a > 1.0} {
    set a [expr $a/10.0]
    set b [expr $b*10.0]
}
$slname.$name.s configure -resolution [expr ($b/1000.0)]

$slname.$name.s configure -from $rmin
$slname.$name.s configure -to $rmax

#now that the sliders resolution is correct set, we may set a value
$slname.$name.s set $val

# Label showing the minval of the slider
label $slname.$name.lmin -text $rmin -width 5

# Label showing the maxval of the slider
label $slname.$name.lmax -text $rmax -width 5

# Calibrate button
button $slname.$name.b -text "Cal." -command "calibrateSlider $name"\
	-takefocus 0

pack $slname.$name.l $slname.$name.e \
	-in $slname.$name -side left -padx 2m
pack $slname.$name.lmin $slname.$name.s\
	$slname.$name.lmax\
	-in $slname.$name -side left
pack $slname.$name.b -side right -padx 2m

if {$name == "alpha"} {
    label $slname.laal -text "Angular Parameters:"
    pack $slname.laal -in $slname -pady 2m
}

pack $slname.$name -in $slname -pady 1m 

if {$name == "omega"} {
    label $slname.laom -text "Linear Parameters:"
    pack $slname.laom -in $slname -pady 2m
}
if {$name == "b"} {
    label $slname.lab -text "Dimension:"
    pack $slname.lab -in $slname -pady 2m
}
if {$name == "sd"} {
    label $slname.lan1 -text "Nodule #1:"
    pack $slname.lan1 -in $slname -pady 2m
}
if {$name == "_L1"} {
    label $slname.lan2 -text "Nodule #2:"
    pack $slname.lan2 -in $slname -pady 2m
}
if {$name == "_Off2"} {
    label $slname.lan3 -text "Nodule #3:"
    pack $slname.lan3 -in $slname -pady 2m
}
if {$name == "_Off3"} {
    label $slname.lanm -text "Nodule-Mode Parameters:"
    pack $slname.lanm -in $slname -pady 2m
}

}


############################
# gotoDir:
#
proc gotoDir {dir} {
global path
    set w .reqwin
    catch {cd $dir}
    set path [pwd]
    $w.upper.flist delete 0 end
    $w.upper.flist insert end ".."

    foreach i [lsort [glob -nocomplain */]] {
	$w.upper.flist insert end $i
    }

    foreach i [lsort [glob -nocomplain *]] {
	if {[file isdirectory $i] == 0} { $w.upper.flist insert end $i }
    }
    $w.upper.flist selection set 0
}


############################
# processFile:
#
proc processFile {file} {
global filename
set w .reqwin

if { $file != "" } {
    if {[file exists $file]} {
	if {[file isdirectory $file] == 1} {
	    gotoDir $file
	} else {
	    if {[file type $file] == "file"} {
		set filename $file
		destroy $w
	    }
	}

    } else {
	set filename $file
	destroy $w
    }
}
}


##############################
# requestFilename:  
# a little funny filerequester, ASL-like
# Amiga-Users will know ;)
#
proc requestFileName { name } {
global filename
set path [pwd]
set file $filename

set w .reqwin
catch {destroy $w}
toplevel $w
wm title $w "$name"
wm resizable $w no yes
wm iconname $w "SelFile"
wm group $w .


frame $w.upper
listbox $w.upper.flist -relief sunken -selectmode browse\
	-yscrollcommand "$w.upper.sbar set" -exportselection yes

scrollbar $w.upper.sbar -takefocus 0 -command "$w.upper.flist yview"

pack $w.upper.flist -in $w.upper -side left -fill both -expand yes
pack $w.upper.sbar -in $w.upper -side right -fill y

pack $w.upper -in $w -side top -expand yes -fill both

$w.upper.flist insert end ".."

foreach i [lsort [glob -nocomplain */]] {
 $w.upper.flist insert end $i
}

foreach i [lsort [glob -nocomplain *]] {
    if {[file isdirectory $i] == 0} { $w.upper.flist insert end $i }
}
$w.upper.flist selection set 0

# keybindings for our listbox
bind $w.upper.flist <Double-Button-1> {
    processFile [%W get [%W nearest %y]]}
bind $w.upper.flist <KeyPress-Return> {
    processFile [%W get [%W curselection]]}

bind $w.upper.flist <Button-1> {
    if {[file isdirectory [%W get [%W nearest %y]]] == 0 } {
	set file [%W get [%W nearest %y]]
    }
}
bind $w.upper.flist <KeyPress-Up> {
    if {[file isdirectory [%W get [expr [%W curselection] - 1]]] == 0} {
	set file [%W get [expr [%W curselection] - 1]]
    }
}
bind $w.upper.flist <KeyPress-Down> {
    if {[file isdirectory [%W get [expr [%W curselection] + 1]]] == 0} {
	set file [%W get [expr [%W curselection] + 1]]
    }
}
bind $w.upper.flist <Button-3> { gotoDir ".." }

frame $w.entry1
pack $w.entry1 -in $w  -fill x
frame $w.entry2
pack $w.entry2 -in $w  -fill x
frame $w.buttons 
pack $w.buttons -in $w -side bottom -fill x

# create 2 labeled entries
label $w.entry1.lpath -text "Path:"
label $w.entry2.lfile -text "File:"

entry $w.entry1.epath -textvariable path
$w.entry1.epath delete 0 end
$w.entry1.epath insert @0 $path

entry $w.entry2.efile -textvariable file
$w.entry2.efile delete 0 end
$w.entry2.efile insert @0 $file

pack $w.entry1.lpath -in $w.entry1 -side left -fill x -padx 2m
pack $w.entry1.epath -in $w.entry1 -side left -expand yes -fill x -padx 2m
pack $w.entry2.lfile -in $w.entry2 -side left -fill x -padx 2m
pack $w.entry2.efile -in $w.entry2 -side left -expand yes -fill x -padx 2m

# keybindings for the entries
bind $w.entry1.epath <KeyPress-Return> { gotoDir $path }
bind $w.entry1.epath <FocusOut> { gotoDir $path }

bind $w.entry2.efile <KeyPress-Return> { processFile $file }

# create ok, parent & cancel button
button $w.buttons.ok -text "  Ok!  " -command {processFile $file}
button $w.buttons.parent -text "Parent" -command {gotoDir ".."}
button $w.buttons.cancel -text "Cancel!" -command { 
    set filename ""; destroy .reqwin
}

pack $w.buttons.ok $w.buttons.parent $w.buttons.cancel\
	-in $w.buttons -expand yes -side left\
	-padx 4m -pady 2m  -fill x

focus $w.upper.flist
grab set $w
}


##############################
# readFile:  
# 
proc readFile { } {
global sliders
global slfw
global filename
global dummyval2

set filename ""

requestFileName "Select file to load:"
tkwait window .reqwin

if {[file exists $filename]} {

    if { $filename != "" } {
	pack forget .fmid.fsliders	

	#disconnect sliders from variables
	foreach slider $sliders {  
	    $slfw.$slider.s configure -variable dummyval2
	    $slfw.$slider.e configure -textvariable dummyval2
	}

	foreach slider $sliders {    
	    set min $slider 
	    set max $slider 
	    append min "min"
	    append max "max"
	    global $min $max $slider
	}

# puts stderr "Reading from file: $filename !"
	readShy $filename
	wm title . "Shell Laboratory - $filename"

	foreach slider $sliders {    
	    set min $slider 
	    set max $slider 
	    append min "min"
	    append max "max"
	    eval set rmin \$$min
	    eval set rmax \$$max
	    eval set val \$$slider
	    
            $slfw.$slider.s configure -from $rmin -to $rmax
            $slfw.$slider.s set $val
	    $slfw.$slider.lmin configure -text $rmin
	    $slfw.$slider.lmax configure -text $rmax

	    $slfw.$slider.s configure -variable $slider
	    $slfw.$slider.e configure -textvariable $slider

	    # recalculate new resolution
#	    if { ( abs([ $slfw.$slider.s cget -resolution ]) >= abs($val))\
#		    && ( $val != 0.0 ) } { 
#		set a [expr ($val - $rmin)*10.0]
#		set b 1.0
#		while {$a > 1.0} {
#		    set a [expr $a/10.0]
#		    set b [expr $b*10.0]
#		}
#		$slfw.$slider.s configure -resolution [expr ($b/1000.0)]
# puts stderr "Reconfiguring slider $slider to resolution [expr ($b/1000.0)]"
#	    }

	}
pack .fmid.fsliders -side left -in .fmid -fill y -expand yes

    }

}



}

##############################
# writeFile:
# 
proc writeFile { } {
global sliders
global filename
if { $filename == "" } { set filename "unnamed.shy" }

foreach slider $sliders {    
    global $slider
}
global slmode

requestFileName "Select file to save to:"

tkwait window .reqwin

if { $filename != "" } {
#    puts stderr "Writing to file $filename !"
    writeShy $filename
    wm title . "Shell Laboratory - $filename"
}
}

##############################
# write3DObject:
# save 3D Object 
#
proc write3DObject { type extension } {
global filename


if { $filename == "" } { 
    set filename "unnamed"
    append filename  $extension
} else {
    set filename [file rootname $filename]
    append filename $extension
}

requestFileName "Select file to save to:"

tkwait window .reqwin

if { $filename != "" } {
#    puts stderr "Writing to file $filename !"
    write3D $type $filename

}

}


#####################################################
#####################################################
# main
wm title . "Shell Laboratory"
wm iconname . "ShellLab"
wm minsize . 460 300
wm resizable . yes yes


# create frames
frame .fmenuBar -relief raise 
pack .fmenuBar -side top -fill x
frame .fbuttons 
pack .fbuttons -side bottom -fill x
frame .fmid
pack .fmid -fill both -expand yes
frame .fmid.fsliders 
pack .fmid.fsliders -side left -in .fmid -fill y -expand yes

# create menu-bar
# File-menu
menubutton .fmenuBar.file -text "File" -menu .fmenuBar.file.m\
	-underline 0

menu .fmenuBar.file.m

.fmenuBar.file.m add command -label "Load (.shy)" -command {\
	global cvupdate_while_sliding; \
	deleteShell; readFile ; \
	set cvupdate_while_sliding 0 ; \
	update idletasks; set cvupdate_while_sliding 1;\
	createShell }\
	-underline 0 -accelerator Ctrl+l

.fmenuBar.file.m add command -label "Save (.shy)" -command writeFile\
	-underline 0 -accelerator Ctrl+s

.fmenuBar.file.m add separator

.fmenuBar.file.m add command -label "Quit" -command "exit"\
	-underline 0 -accelerator Ctrl+q
pack .fmenuBar.file -in .fmenuBar -side left


# Rendering-menu
menubutton .fmenuBar.pref -text "Rendering" -menu .fmenuBar.pref.m\
 -underline 0
menu .fmenuBar.pref.m

.fmenuBar.pref.m add cascade -label "Mode"\
	-menu .fmenuBar.pref.m.rendering
menu .fmenuBar.pref.m.rendering

.fmenuBar.pref.m.rendering add radio -label "Wireframe"\
	-command "catch {.3dwin.f3d.togl setMode 0}"
.fmenuBar.pref.m.rendering invoke 1
.fmenuBar.pref.m.rendering add radio -label "FlatShaded"\
	-command "catch {.3dwin.f3d.togl setMode 1}"
.fmenuBar.pref.m.rendering add radio -label "SmoothShaded"\
	-command "catch {.3dwin.f3d.togl setMode 2}"

.fmenuBar.pref.m add separator

.fmenuBar.pref.m add checkbutton -label "DrawCoordSys"\
	-variable cvdrawSys -command "catch {.3dwin.f3d.togl drawSys}"

.fmenuBar.pref.m add check -label "AutoUpdate"\
	-variable cvupdate_while_sliding\
        -command { if {$cvupdate_while_sliding == 1 } createShell }

pack .fmenuBar.pref -in .fmenuBar -side left


# Shelly-menu
menubutton .fmenuBar.shelly -text "Shelly" -menu .fmenuBar.shelly.m\
	-underline 0
menu .fmenuBar.shelly.m

.fmenuBar.shelly.m add cascade -label "Mode"\
	-menu .fmenuBar.shelly.m.mode
menu .fmenuBar.shelly.m.mode

.fmenuBar.shelly.m.mode add radio -label "Normal"\
	-command "updateView slmode 0" -variable slmode

.fmenuBar.shelly.m.mode add radio -label "Nodule"\
	-command "updateView slmode 1" -variable slmode

.fmenuBar.shelly.m.mode add radio -label "GenCurve"\
	-command "updateView slmode 2" -variable slmode

pack .fmenuBar.shelly -in .fmenuBar -side left
.fmenuBar.shelly.m.mode invoke 1

.fmenuBar.shelly.m add cascade -label "Write 3D Object"\
	-menu .fmenuBar.shelly.m.write
menu .fmenuBar.shelly.m.write

.fmenuBar.shelly.m.write add command -label "POV Bez.Patch (.pov)"\
	-command "write3DObject 0 .pov"
.fmenuBar.shelly.m.write add command -label "Real3D (.rpl)"\
	-command "write3DObject 1 .rpl"
.fmenuBar.shelly.m.write add command -label "RIB (.rib)"\
	-command "write3DObject 2 .rib"
.fmenuBar.shelly.m.write add command -label "SCED (.scd)"\
	-command "write3DObject 3 .scd"
.fmenuBar.shelly.m.write add command -label "SCED Bez.Patch"\
	-command "write3DObject 4 .scd"
.fmenuBar.shelly.m.write add command -label "RAW (.raw)"\
	-command "write3DObject 5 .raw"
.fmenuBar.shelly.m.write add command -label "T3D (.t3d)"\
	-command "write3DObject 6 .t3d"
.fmenuBar.shelly.m.write add command -label "X3D (.x3d)"\
	-command "write3DObject 7 .x3d"
.fmenuBar.shelly.m.write add command -label "Truespace (.cob)"\
	-command "write3DObject 8 .cob"

pack .fmenuBar.shelly -in .fmenuBar -side left


# Help-menu
menubutton .fmenuBar.help -text Help -menu .fmenuBar.help.m -underline 0
menu .fmenuBar.help.m

.fmenuBar.help.m add command -label "Tutorial" -command "helpTut" -underline 0
pack .fmenuBar.help -in .fmenuBar -side right

.fmenuBar.help.m add command -label "Shell Laboratory" -command "helpLab" -underline 0
pack .fmenuBar.help -in .fmenuBar -side right

.fmenuBar.help.m add command -label "About Shell Laboratory" -command "helpAbout" -underline 0
pack .fmenuBar.help -in .fmenuBar -side right


# create slider-canvas
canvas .fmid.fsliders.canv -yscrollcommand {.fmid.fsliders.scrollb set}\
	-width 15c -height 10c\
	-scrollregion {0c 0c 10c 57c}\
	-relief sunken -borderwidth 2 

scrollbar .fmid.fsliders.scrollb -orient vertical\
	-command {.fmid.fsliders.canv yview}
pack .fmid.fsliders.scrollb -in .fmid.fsliders -side right -fill y

pack .fmid.fsliders.canv -in .fmid.fsliders -side left -fill both\
	-expand yes

set slfw .fmid.fsliders.canv.slidecon
frame $slfw

# now create all sliders + associated buttons & entrys
foreach slider $sliders {
    createSlider $slider $slfw
}
.fmid.fsliders.canv create window 0c 0.3c -window $slfw -anchor nw -tags item


# Global KeyBindings for main-window
bind . <Control-KeyPress-q> {exit}
bind . <Control-KeyPress-l> {\
	global cvupdate_while_sliding; \
	deleteShell; readFile ; \
	set cvupdate_while_sliding 0 ; \
	update idletasks; set cvupdate_while_sliding 1;\
	createShell }
bind . <Control-KeyPress-s> {writeFile}
bind . <KeyPress-F1> {helpLab}

createShell
open3D

# EOF

