/*    ShellyLibV2.0 - the ShellShapeGenerator 
**
**    Copyright (C) 1996 Randolf Schultz (rschultz@informatik.uni-rostock.de)
**
**    This software is shareware!
**    Read the file "License" for further information.
*/

/* A simple frontend to ShellyLib */

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "shellyl.h"
#include "frontend.h"
#include "rdwrt.h"


/********************************************/
/*main:                                     */
/********************************************/
int
main (int ac, char **av)
{
  FILE *fp;
  char name_in[255];
  struct SLarguments arg = {0};
  struct SLshell *shell = NULL;

  struct SLtindex *tind = NULL;
  struct SLlindex *lind = NULL;
  struct SLpindex *pind = NULL;

  fprintf (stdout, "Shelly, an example frontend to ShellyLib.\n");

  if (ac != 3)
  {
    fprintf (stdout, "USAGE:\n\n");
    fprintf (stdout, "   'shelly [path+]infilename [path+]outfilename'\n\n");
  }				/* if */


  if(ac == 1)
    { /* interactive mode */
      fprintf(stdout,"No arguments given, running interactive ...\n\n");

      fprintf(stdout,"Enter [path]name of data file to read:");
      fflush(stdout);
      fgets(name_in,254,stdin);
      name_in[strlen(name_in)-1] = '\0'; /* cutting of the '\n' */
      if ((fp = fopen(name_in,"r")) == NULL)
	{
	  fprintf(stderr,"Cannot open file \"%s\"!\n",name_in);
	  exit(10);
	}
      else
	{
	  ReadInfile (&arg, fp);
	  fclose(fp);
	}

      fprintf(stdout,"\nEnter [path]name of output file:");
      fflush(stdout);
      fgets(name_in,254,stdin);
      name_in[strlen(name_in)-1] = '\0'; /* cutting of the '\n' */

      if ((fp = fopen(name_in,"w")) == NULL)
	{
	  fprintf(stderr,"Cannot open file \"%s\"!\n",name_in);
	  exit(10);
	}

    }
  else
    { /* files specified on commandline */

      if(ac != 3)
	{
	  fprintf(stderr,"Bad number of arguments!\n");
	  exit(1);
	}

      /* read arguments from file or stdin? */
      if(!strcmp(av[1],"-"))
	 fp = stdin;
      else
         fp = fopen (av[1], "r");

      if(fp != NULL)
	{
	  ReadInfile (&arg, fp);
	  fclose(fp);
	}
      else
	{
	  fprintf(stderr,"Could not open file: \"%s\" !\n", av[1]);
	  exit(10);
	}

      /* write to file or stdout? */
      if(!strcmp(av[2],"-"))
	fp = stdout;
      else
	fp = fopen (av[2], "w");

      if(fp == NULL)
	{
	  fprintf(stderr,"Could not open file: \"%s\" !\n", av[2]);
	  exit(10);
	}
    }

  /* make NODULE-mode parameters relative to real noduleheight and od/sd */
  arg.heightdiffo = arg.heightdiffo * arg.L;
  arg.heightdiffs = arg.heightdiffs * arg.L;
  arg.Scano = arg.Scano * arg.od;
  arg.Scans = arg.Scans * arg.sd;

  /* calc shell */
  fprintf(stderr,"Calculating the Shell: ");
  switch(arg.mode)
    {
    case NORMAL:
      fprintf(stderr,"Normal-mode.\n");
      SLCalcShell (&arg, &shell); break;
    case NODULE:
      fprintf(stderr,"Nodule-mode.\n");
      SLCalcShellNodule (&arg, &shell); break;
    case GCURVE:
      fprintf(stderr,"GenCurve-mode.\n");
      SLCalcShellGC (&arg, &shell); break;
    }

  /* write output */
  fprintf(stderr,"Writing output: ");
  switch(arg.output)
    {
    case RPL:
      fprintf(stderr,"RPL.\n");
      SLCreateIndex(&arg, shell, &tind, &lind, &pind); 
      WriteRPLFile (&arg, shell, pind, tind, fp);
      break;

    case RAW: 
      fprintf(stderr,"RAW.\n");
      WriteRAWFile (&arg, shell, fp);
      break;
 
    case X3D: 
      fprintf(stderr,"X3D.\n");
      SLCreateIndex(&arg, shell, &tind, &lind, &pind);
      WriteX3DFile (&arg, shell, pind, lind, tind, fp);
      break;

    case T3D:
      fprintf(stderr,"T3D.\n");
      SLCreateIndex(&arg, shell, &tind, &lind, &pind);
      WriteT3DFile (&arg, shell, pind, lind, tind, fp);
      break;

    case TSP:
      fprintf(stderr,"Truespace.\n");
      SLCreateIndex(&arg, shell, &tind, &lind, &pind);
      WriteTSPFile (&arg, shell, pind, lind, tind, fp);
      break;
     
    case SCD:
      fprintf(stderr,"SCED.\n");
      SLCreateIndex(&arg, shell, &tind, &lind, &pind);
      WriteSCDFile (&arg, shell, pind, lind, tind, fp);
      break;

    case SCB:
      fprintf(stderr,"SCED BezierPatches.\n");
      WriteSCDBFile (&arg, shell, fp);
      break;

    case RIB:
      fprintf(stderr,"RIB.\n");
      WriteRIBFile (&arg, shell, fp);
      break;

    case BEZ:
      fprintf(stderr,"POV BezierPatches.\n");
      WriteBEZFile (&arg, shell, fp);
      break;

    }

  fclose(fp);

  fprintf(stderr,"Done.\n");
  
  exit (0);
}



