/*    
**  ShellyLibV2.0 - the ShellShapeGenerator 
**
**  Copyright (C) 1996 Randolf Schultz (rschultz@informatik.uni-rostock.de)
**
**  This software is shareware!
**  Read the file "License" for further information.
*/

/* Displacement Shader */
/*								*/
/* Parameters: 							*/ 
/* Km: height of the displacement				*/
/* Nu:								*/

displacement
ribs_sin_v(
	float	Km = 0.02;
	float   Nv = 100;

)
{
	float	magnitude = 0;

	/* Compute the distance the surface should be displaced. */
	 magnitude = abs(cos(v*PI*Nv));

	/* Now apply the displacement in the direction of the normal. */
	P += Km * magnitude * normalize(N);

	/* Recalculate the normal. */
	N = calculatenormal(P);
}

