/*    
**  ShellyLibV2.0 - the ShellShapeGenerator 
**
**  Copyright (C) 1996 Randolf Schultz (rschultz@informatik.uni-rostock.de)
**
**  This software is shareware!
**  Read the file "License" for further information.
*/

/* Displacement Shader 						*/
/* Simulates the strong ribs of a 'Precious Wentletrap' shell   */
/* currently, the ribs are sinusoidal, exponential might        */
/* deliver better results 					*/
/* Parameters: 							*/
/* Km: height of the ribs 					*/
/* O: number of whorls of the shell, in degrees 		*/
/* Space: free space between two ribs, in degrees 		*/
/* Width: width of the ribs, in degrees 			*/

displacement
precious(
	float	Km = 0.04;
	float   O  = 360;
	float   Space = 30; 
	float   Width = 9
)
{
	float	magnitude = 0;

	/* Compute the distance the surface should be displaced. */
        if(mod(v*O,Space) <= Width)
	 magnitude = cos(PI*((mod(v*O,Space)/Width)-0.5))*v;

	/* Now apply the displacement in the direction of the normal. */
	P += Km * magnitude * normalize(N);

	/* Recalculate the normal. */
	N = calculatenormal(P);
}

