/*
 *     Z-BUFFER algorithm  -  z-buffer.c
 *     Copyright (c) 1994,1995  R.Gosiorovsky, T.Hruz, I.Povazan
 */

#include "typy.h"

typedef struct {INT x; FLOAT z;} XZ_BUF;

FLOAT **Z_buffer = NULL;  

VOID close_ZBF()
  {
     free(Z_buffer);  
  }

VOID open_ZBF(INT W,INT H)
  {
     INT i;

     Z_buffer = (FLOAT **)malloc(W*sizeof(FLOAT *));
     for(i=0;i<W;i++) Z_buffer[i] = (FLOAT *)malloc(H*sizeof(FLOAT));
  }

VOID CLEAR_Z_BUFFER(INT x1,INT y1,INT x2,INT y2)
  {
    INT x,y;
    for(x=x1;x<=x2;x++)
      for(y=y1;y<=y2;y++)
       Z_buffer[x][y]=999999;  
  }

VOID Line_X_inc(INT x1,FLOAT z1,INT x2,FLOAT z2,INT y)
  {
     INT x,dir;
     FLOAT k,z;

     if (x1==x2) return;

     if (x1>x2) { dir= -1; k= (z2-z1)/(x1-x2); }
           else { dir=  1; k= (z2-z1)/(x2-x1); } 

     x=x1; z=z1;

     if (z < Z_buffer[x][y]) 
       { 
          Z_buffer[x][y]=z;  
          Point(x,y);  
       }

     while(x!=x2)
       {
          x+=dir;
          z=z+k;
          if (z < Z_buffer[x][y]) 
            { 
               Z_buffer[x][y]=z;  
               Point(x,y);  
	    }
       } 
   } 

VOID Line_Y_inc(INT x1,INT y1,FLOAT z1,INT x2,INT y2,FLOAT z2,XZ_BUF *xz_buf)
  {
     INT x,y,kx,ky;
     FLOAT z,kz;
     
     if (y1==y2) return;

     if (y1>y2) { ky= -1; kx= ((x2-x1)<<10)/(y1-y2); kz=(z2-z1)/(y1-y2); }
           else { ky=  1; kx= ((x2-x1)<<10)/(y2-y1); kz=(z2-z1)/(y2-y1); }

     y=y1; z=z1; x=x1<<10;

     xz_buf[y1].x=x1;
     xz_buf[y1].z=z1;

     while(y!=y2)
       {
          y+=ky;
          x+=kx;
          z=z+kz;
          xz_buf[y].x=x>>10;
          xz_buf[y].z=z;
        } 
  } 

VOID ZBF_Polygon(INT N,POINT2 b[],FLOAT Zet[],INT Color_O,INT Color_V)
  {
    INT i;
    XZ_BUF left[XMaxRES];
    XZ_BUF right[XMaxRES];
    INT ixtop,ixbot,iytop,iybot;

    GColor(Color_V);  

    hull(N,b,&ixbot,&ixtop,&iybot,&iytop);

    if (iytop==iybot) { return;
                       /*  left[b[iytop].y]=b[ixbot].x;
                        right[b[iytop].y]=b[ixtop].x; */ }
    else
      {
          i=iytop;
          while(i!=iybot)
           {
              Line_Y_inc(b[i].x,b[i].y,Zet[i],
                         b[(i+1)%N].x,b[(i+1)%N].y,Zet[(i+1)%N],right); 
              i=(i+1)%N;
           }
          i=iybot;
          while(i!=iytop)
           {
             Line_Y_inc(b[i].x,b[i].y,Zet[i],
                        b[(i+1)%N].x,b[(i+1)%N].y,Zet[(i+1)%N],left);
             i=(i+1)%N;
           }
       }
    
    for(i=b[iybot].y; i<=b[iytop].y; i++)
        Line_X_inc(left[i].x,left[i].z,right[i].x,right[i].z,i);
  }

/*---------------------------------------------------------------------*/
