/*      
 *         types,prototypes,etc.  -  typy.h
 */

#include <math.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* 
 *      keys
 */

#define RIGHT   1
#define LEFT    2
#define UP      3
#define DOWN    4
#define GO      5
#define BACK    6 
#define ESCAPE  7

/*
 *     output device
 */

#define SCREEN 0
#define PIXMAP 1
#define IMAGE  2
#define GFILE  3

/*
 *      models
 */

#define DSC  4
#define DSF  3
#define FFC  2
#define FFF  1
#define ALV  0
#define ZBF  9
#define COU1 5
#define COU2 6
#define COU3 7
#define COU4 8

/*
 *      boolean, to be or not to be ...
 */

#define FALSE  0
#define TRUE   1

/*
 *     Max Resolution 
 */

#define XMaxRES 1600
#define YMaxRES 1200

/*
 *    objects
 */

#define TRIANGLES    1
#define CUBE         2
#define TETRAHEDRON  3
#define SPHERE       4
#define TORUS        5
#define CYLINDER     6

/*
 *     types declaration
 */

#define VOID   void
#define INT    int
#define CHAR   char
#define FLOAT  float
#define SHORT  short  

typedef FLOAT MATRIX[4][4]; 

typedef struct { FLOAT x; FLOAT y; FLOAT z; } POINT;

typedef struct { CHAR verts;
                 INT  vertex[4];
                 CHAR color;     } FACE;

typedef struct { SHORT x; SHORT y; } POINT2;

typedef struct { CHAR    typ;
                 FLOAT   R,r;
                 MATRIX  position;
                 INT     segm1,segm2;                 

                 INT     verts;
                 INT     faces;
                 POINT   *vertex;
                 FACE   *face;
                 POINT2  *bd;     } OBJECT;

typedef struct { INT model;
                 INT proj;
                 FLOAT COS,SIN;
                 FLOAT angle;
                 FLOAT dist;
                 FLOAT ratio;
                 POINT P;
                 POINT r; }  CONTROL;

typedef struct { CHAR *name;
                 INT start;
                 INT x1,y1,x2,y2;
                 INT items;
                 CHAR *item[12];  }  MENU;

typedef struct { INT frame;
                 INT window;
                 INT header;
                 INT bottom;
                 INT shadow;
                 INT text;
                 INT header_text;
                 INT border;
                 INT work;
                 INT line;  } COLOR;

/*
 *     global variables
 */

#define MAX_OBJECTS 100

#if !defined(MAIN)                        /*-------------------------*/
   extern OBJECT object[MAX_OBJECTS];     /* array of objects        */
   extern INT pt;                         /* number of objects       */
   extern CONTROL *c;                     /* control parameters      */
   extern COLOR *f;                       /* colors                  */
   extern INT MinX,MaxX,MinY,MaxY;        /* work place              */
   extern INT Win_W,Win_H;                /* window size             */
                                          /*                         */
   extern VOID (* FillPoly)();            /* fill poly               */ 
   extern VOID (* Poly)();                /* draw poly               */
   extern VOID (* Point)();               /* draw point              */
   extern VOID (* Line)();                /* draw line               */
#else                                     /*-------------------------*/
   OBJECT object[MAX_OBJECTS];
   INT pt=0;
   CONTROL *c;
   COLOR *f;
   INT MinX,MaxX,MinY,MaxY;
   INT Win_W,Win_H;

   VOID  (* FillPoly)();
   VOID  (* Poly)();
   VOID  (* Point)();
   VOID  (* Line)();
#endif

/*______________________________ prototypes ______________________________*/

/*  main.c  */

VOID  zoom();
VOID  movie();
VOID  notice();
VOID  menu1(INT act_item);
VOID  menu2(INT act_item);
VOID  menu3(INT act_item);
VOID  menu4(INT act_item);
VOID  menu5(INT act_item);
VOID  menu6(INT act_item);
VOID  menu7(INT act_item);
VOID  menu8(INT act_item);
VOID  item_function(INT act,INT act_item);

/* griface.c */

VOID  IfKey(CHAR *);  
CHAR  GetKey();
INT   GetMaxX();
INT   GetMaxY();
VOID  init_graph(INT,INT);
VOID  close_graph();
VOID  Line_mode(INT Mod);
VOID  Clear(INT,INT,INT,INT,INT);
VOID  FillRectangle(INT x1,INT y1,INT x2,INT y2,INT Farba);
VOID  Rectangle(INT x1,INT y1,INT x2,INT y2,INT Farba);
VOID  PolozPixmapu(int,int,int,int);
INT   TextHeight(CHAR *Text);
INT   TextWidth(CHAR *Text);
VOID  TextXY(INT x,INT y,CHAR *text);
VOID  GetArea(INT x1,INT y1,INT x2,INT y2);
VOID  PutArea(INT x1,INT y1,INT x2,INT y2);
VOID  CLEAR_Z_BUFFER();
VOID  Z_BUFF_Polygon();
VOID  Output(INT);
VOID  GColor(INT);

/* grenvr.c */

VOID  init_layout();
VOID  label(INT x1,INT y1,INT x2,INT y2,CHAR *Hlavicka,INT head);
VOID  window(INT x1,INT y1,INT x2,INT y2,CHAR *Hlavicka,INT head);
VOID  close_window();
VOID  active_pop(INT act);
VOID  deactive_pop(INT act);
VOID  active_pull(INT act);
VOID  deactive_pull(INT act);
VOID  active_item(INT act,INT act_item);
VOID  deactive_item(INT act,INT act_item);
VOID  init_menu();
VOID  service();
VOID  mess(INT x,INT y,CHAR *m);
CHAR *input(INT x,INT y,CHAR *top,CHAR *text);
VOID  inform();
VOID  command(CHAR *mes);
VOID  restore_command();
VOID  anon(INT x,INT y,CHAR *head,INT N,CHAR *text[]);
VOID  bye();

/* kursor.c */

VOID   init_cursor();
VOID   coord_values(POINT *);
VOID   coordinates();
VOID   cross(POINT2 *);
VOID   cursor_line(POINT *A,POINT *B,INT c);
POINT  sipka(POINT *S,INT u);

/* MATRIX.c */

VOID   M_unit(MATRIX M);
VOID   M_translate(MATRIX M,POINT *T);
VOID   M_rotate(MATRIX M);
VOID   M_matrix_matrix(MATRIX A,MATRIX B);
VOID   M_object_matrix(OBJECT *,MATRIX);
VOID   M_point_matrix(POINT *,MATRIX);

/* d3.c */

VOID   init_control();
INT    save(CHAR *nazov_suboru);
INT    get(CHAR *nazov_suboru);
POINT  plus(POINT *A,POINT *B);
POINT  multiple(POINT *A,FLOAT *c);         
FLOAT  distance(POINT *A,POINT *B);
VOID   position_all();
VOID   rotate_all();
VOID   resize_object(OBJECT *t,FLOAT zv);
VOID   resize_all(FLOAT zv);
VOID   move_all(POINT *T);
POINT  minus(POINT *A,POINT *B);
FLOAT  scalar(POINT *A,POINT *B);
POINT  vector(POINT *A,POINT *B);
FLOAT  face_distance(OBJECT *t,FACE *face);
INT    visible(OBJECT *t,FACE *face);
VOID   draw_object(OBJECT *o);
VOID   draw_face(OBJECT *t,FACE *face);
VOID   draw_sort();
VOID   draw(OBJECT *t);
POINT2  *proj(POINT *B);
POINT2  *proj_ortho(POINT *B);
VOID   project_object(OBJECT *t);
VOID   project_all();
VOID   go();

/* objekty.c */

VOID   alloc_object(OBJECT *t,INT vert,INT faces);
VOID   free_object(OBJECT *t);
VOID   Resegment(FLOAT f);
OBJECT triangles(FLOAT *,INT);
OBJECT squere(POINT *);
OBJECT cube(MATRIX,FLOAT *);
OBJECT tetrahedron(MATRIX,FLOAT *);
OBJECT cylinder(MATRIX,FLOAT *,FLOAT *,INT);
OBJECT sphere(MATRIX,FLOAT *,INT M,INT N);
OBJECT torus(MATRIX,FLOAT *,FLOAT *,INT M,INT N);

/*-------------------------------------------------------------------------*/
