/*        
 *      Contour Union Algorithm   -  c-union3.c  
 *      (linear algorithm, linear list data structure)
 *      Copyright (c) 1994,1995  T.Hruz, I.Povazan, R.Gosiorovsky
 */

#include "typy.h"

int res_x;
int res_y;

#define xalloc malloc
#define point_xy(x_macro,y_macro) Point(x_macro,y_macro)

struct list_c
	{
	int down;
	int up;
	struct list_c *increas;
	};

struct p2_list_c
	{
	struct list_c *ptr;
	struct list_c *bck;
	};

struct p2_list_c positon_dot();

int cur_x,cur_y;

int *contour_up;
int *contour_down;

struct list_c **p_local_contour_x;
struct list_c *local_contour_x;

struct list_c **p_local_contour_y;
struct list_c *local_contour_y;

struct list_c **p_global_contour_x;
struct list_c **p_global_contour_y;

/*______________________________________________________________________*/
d_move(d_x,d_y)
int d_x,d_y;
{
cur_x=d_x;
cur_y=d_y;
}
/*______________________________________________________________________*/
void open_CU3(reso_x,reso_y)
int reso_x,reso_y;
	{
	res_x = reso_x;
	res_y = reso_y;

        p_local_contour_x = (struct list_c **) 
                            xalloc (res_x * sizeof(struct list_c *));
        local_contour_x   = (struct list_c *) 
                            xalloc (res_x * sizeof(struct list_c ));
        p_local_contour_y = (struct list_c **)
                            xalloc (res_y * sizeof(struct list_c *));
        local_contour_y   = (struct list_c *)
                             xalloc (res_y * sizeof(struct list_c ));
        p_global_contour_x = (struct list_c **)
                             xalloc (res_x * sizeof(struct list_c *));
        p_global_contour_y = (struct list_c **)
                             xalloc (res_y * sizeof(struct list_c *));
	}
/*______________________________________________________________________*/
void close_CU3()
	{
	res_x = 256;
	res_y = 256;

	free(p_local_contour_x);
	free(local_contour_x);
	free(p_local_contour_y);
	free(local_contour_y);
	free(p_global_contour_x);
	free(p_global_contour_y);
	}
/*---------------------------------------------------------------------*/
/*                       devca.c                                       */
/*---------------------------------------------------------------------*/
init_local_c_a(x_min,x_max,y_min,y_max)
int x_min,x_max,y_min,y_max;
{
int i;

for (i = x_min;i<=x_max;i++) p_local_contour_x[i] = NULL;
for (i = y_min;i<=y_max;i++) p_local_contour_y[i] = NULL;
}
/*_______________________________________________________________________*/
init_global_c_a()
{
int i;
for (i = 0;i<res_x;i++)	p_global_contour_x[i] = NULL;
for (i = 0;i<res_y;i++)	p_global_contour_y[i] = NULL;
for (i = 0;i<res_x;i++)	p_local_contour_x[i]  = NULL;
for (i = 0;i<res_y;i++)	p_local_contour_y[i]  = NULL;
}
/*________________________________________________________________________*/
/* Advanced contour Bresenham algorithm with vertical, horizontal and
   diagonal optimization */

/* definition of pixel algorithm */

#undef point
#define point(x_point,y_point) point_c_a(x_point,y_point);

d_draw_c_a(d_x,d_y)
int d_x,d_y;

{
int x_point,y_point;
int abs_dx,abs_dy;
int inc_1,inc_2,dd;
int exchange;

x_point = cur_x;
y_point = cur_y;

cur_x = d_x;
cur_y = d_y;

abs_dx = abs(x_point-d_x);
abs_dy = abs(y_point-d_y);

if (abs_dx==0)
	{
	if (abs_dy==0)
		{				/* point only */
		point(x_point,y_point)
		cur_x = d_x;
		cur_y = d_y;
		return 0;
		}
		else
		{				/* vertical */
		if(y_point<d_y)
			{
			exchange = y_point;
			y_point = d_y;
			d_y = exchange;
			}
		abs_dy++;
		for(;abs_dy != 0;y_point--,abs_dy--)
			{
			point(x_point,y_point)
			}
		}
	}
	else
	{
	if (abs_dy==0)
		{				/* horizontal */
		if(x_point>d_x)
			{
			exchange = x_point;
			x_point = d_x;
			d_x = exchange;
			}
		abs_dx++;
		for(;abs_dx != 0;x_point++,abs_dx--)
			{
			point(x_point,y_point)
			}
		}
		else
		{
		if(abs_dx==abs_dy)	/* diagonal */
			{
			if(x_point>d_x)
				{
				exchange = x_point;
				x_point = d_x;
				d_x = exchange;
				exchange = y_point;
				y_point = d_y;
				d_y = exchange;
				}

			abs_dx++;
			if(y_point<d_y)
				{
				for(;abs_dx != 0;x_point++,y_point++,abs_dx--)
					{
					point(x_point,y_point)
					}
				}
				else
				{
				for(;abs_dx != 0;x_point++,y_point--,abs_dx--)
					{
					point(x_point,y_point)
					}
				}
			}
			else
			{    /* after three tests starts the general case */
			if(abs_dx>abs_dy)
				{
				inc_1 = 2*abs_dy;
				inc_2 = 2*(abs_dy-abs_dx);
				dd = 2*abs_dy-abs_dx;
				abs_dx++;

				if(x_point>d_x)
					{
					exchange = y_point;
					y_point = d_y;
					d_y = exchange;
					exchange = x_point;
					x_point = d_x;
					d_x = exchange;
					}

				if(y_point<d_y)
					{
					while(abs_dx)	    /* x+1  y+1 */
						{
						point(x_point,y_point)
						x_point++;
						if(dd<0)
							{
							dd += inc_1;
							}
							else
							{
							dd += inc_2;
							y_point++;
							}
						abs_dx--;
						}
					}
					else
					{
					while(abs_dx)	    /* x+1  y-1 */
						{
						point(x_point,y_point)
						x_point++;
						if(dd<0)
							{
							dd += inc_1;
							}
							else
							{
							dd += inc_2;
							y_point--;
							}
						abs_dx--;
						}
					}
				}
				else
				{
				inc_1 = 2*abs_dx;
				inc_2 = 2*(abs_dx-abs_dy);
				dd = 2*abs_dx-abs_dy;
				abs_dy++;

				if(y_point<d_y)
					{
					exchange = y_point;
					y_point = d_y;
					d_y = exchange;
					exchange = x_point;
					x_point = d_x;
					d_x = exchange;
					}

				if(x_point<d_x)
					{
					while(abs_dy)	    /* y-1  x+1 */
						{
						point(x_point,y_point)
						y_point--;
						if(dd<0)
							{
							dd += inc_1;
							}
							else
							{
							dd += inc_2;
							x_point++;
							}
						abs_dy--;
						}
					}
					else
					{
					while(abs_dy)	      /* y-1  x-1 */
						{
						point(x_point,y_point)
						y_point--;
						if(dd<0)
							{
							dd += inc_1;
							}
							else
							{
							dd += inc_2;
							x_point--;
							}
						abs_dy--;
						}
					}
				}
			}
		}
	}
}

point_c_a(x_point,y_point)
int x_point,y_point;
	{
	if (p_local_contour_x[x_point]==NULL)
		{
		p_local_contour_x[x_point] = &local_contour_x[x_point];
		p_local_contour_x[x_point]->down = y_point;
		p_local_contour_x[x_point]->up = y_point;
		p_local_contour_x[x_point]->increas = NULL;
		}
	else
		{
		if ( p_local_contour_x[x_point]->down > y_point)
			{
			p_local_contour_x[x_point]->down = y_point;
			}
		else
			{
			if (p_local_contour_x[x_point]->up < y_point)
				{
				p_local_contour_x[x_point]->up = y_point;
				}
			}
		}
	if (p_local_contour_y[y_point]==NULL)
		{
		p_local_contour_y[y_point] = &local_contour_y[y_point];
		p_local_contour_y[y_point]->down = x_point;
		p_local_contour_y[y_point]->up = x_point;
		p_local_contour_y[y_point]->increas = NULL;
		}
	else
		{
		if ( p_local_contour_y[y_point]->down > x_point)
			{
			p_local_contour_y[y_point]->down = x_point;
			}
		else
			{
			if (p_local_contour_y[y_point]->up < x_point)
				{
				p_local_contour_y[y_point]->up = x_point;
				}
			}
		}
	}
/*---------------------------------------------------------------------*/
Hull2(int N,POINT2 b[],int *min_x,int *max_x,int *min_y,int *max_y)
 {
    int i;
    int maxx=0,maxy=0,minx=XMaxRES,miny=YMaxRES;

    for(i=0;i<N;i++)
       {
          if (b[i].x>maxx) maxx=b[i].x;
          if (b[i].x<minx) minx=b[i].x;
          if (b[i].y>maxy) maxy=b[i].y;
          if (b[i].y<miny) miny=b[i].y;
        }
    *min_x=minx;
    *min_y=miny;
    *max_x=maxx; 
    *max_y=maxy;
 }
/*---------------------------------------------------------------------*/
CU_Polygon3(int n,POINT2 bod[])
 {
	int min_x,max_x,min_y,max_y;
        int i;

	d_move((int)bod[0].x,(int)bod[0].y);
        for(i=1;i<n;i++) d_draw_c_a((int)bod[i].x,(int)bod[i].y);
	d_draw_c_a((int)bod[0].x,(int)bod[0].y);

        Hull2(n,bod,&min_x,&max_x,&min_y,&max_y);  

	global_contour_step(min_x,max_x,min_y,max_y);
	init_local_c_a(min_x,max_x,min_y,max_y);
  }

/*___________________________________________________________________*/
global_contour_step(min_x,max_x,min_y,max_y)
int min_x,max_x,min_y,max_y;
	{
	int i;
	int loc_up_y,loc_down_y,loc_down_x,loc_up_x;
	int fl_down_x, fl_up_x, fl_down_y, fl_up_y;

	for (i = min_x;i <= max_x;i++)
		{
        	loc_down_y = p_local_contour_x[i]->down;
		loc_up_y = p_local_contour_x[i]->up;
		contour_union(loc_down_y,loc_up_y,
                              &p_global_contour_x[i],&fl_down_x,&fl_up_x);
		if (!fl_down_x)	point_xy(i,loc_down_y);
		if (!fl_up_x) point_xy(i,loc_up_y);
		}

	for (i = min_y;i <= max_y;i++)
		{
		loc_down_x = p_local_contour_y[i]->down;  
         	loc_up_x = p_local_contour_y[i]->up;
		contour_union(loc_down_x,loc_up_x,
                              &p_global_contour_y[i],&fl_down_y,&fl_up_y);
		if ((p_local_contour_x[loc_down_x]->down < i)
                     && (i < p_local_contour_x[loc_down_x]->up)) 
			{
			if (!fl_down_y)	point_xy(loc_down_x,i);
			}
		if ((p_local_contour_x[loc_up_x]->down < i)
                     && (i < p_local_contour_x[loc_up_x]->up))  
			{
			if (!fl_up_y) point_xy(loc_up_x,i);
			}
		}
	}
/*------------------------------------------------------------------------
                           iunion.c
-------------------------------------------------------------------------*/
contour_union(loc_down,loc_up,pointer_start,fl_down,fl_up)
int loc_down,loc_up,*fl_down,*fl_up;
struct list_c **pointer_start;

{
struct p2_list_c down,up;
struct list_c *pointer_temp;
int del_to_start_fl = 0;

down = positon_dot(loc_down,pointer_start,fl_down);
up = positon_dot(loc_up,&down.ptr,fl_up);

if(down.ptr==up.ptr)
	{
	switch(*fl_down+*fl_up)
		{
		case 0:
			if(down.ptr == *pointer_start)
				{
           /* in this special case down.bck ( pointer to back element) 
              is NOT defined, so cannot be used in this path!! */
				pointer_temp = (struct list_c *)
                                               xalloc(sizeof(struct list_c));
				pointer_temp->increas = *pointer_start;
				*pointer_start = pointer_temp;
				pointer_temp->down = loc_down;
				pointer_temp->up = loc_up;
				}
			else
				{
				pointer_temp = (struct list_c *)
                                               xalloc(sizeof(struct list_c));
				pointer_temp->increas = down.bck->increas;
				down.bck->increas = pointer_temp;
				pointer_temp->down = loc_down;
				pointer_temp->up = loc_up;
				}
			break;

		case 1:
				down.ptr->down = loc_down;
			break;

		case 2:
			break;
		}
	}
else
	{
	if(*fl_down)
		{
		loc_down = down.ptr->down;
		}

	if ( down.ptr == *pointer_start)
		{
		/* in this special case down.bck ( pointer to back element)
                   is NOT defined, so cannot be used in this path!! */
		del_to_start_fl = 1;
		}

	if(*fl_up)
		{
		while(down.ptr != up.ptr)
			{
			if (del_to_start_fl)
				{
				*pointer_start = down.ptr->increas;
				free ( (char *) down.ptr);
				down.ptr = *pointer_start;
				}
			else
				{
				down.bck->increas = down.ptr->increas;
				free( (char *) down.ptr);
				down.ptr = down.bck->increas;
				}
			}
		down.ptr->down = loc_down;

		}
	else
		{
		while(down.ptr->increas != up.ptr)
			{
			if (del_to_start_fl)
				{
				*pointer_start = down.ptr->increas;
				free ( (char *) down.ptr);
				down.ptr = *pointer_start;
				}
			else
				{
				down.bck->increas = down.ptr->increas;
				free( (char *) down.ptr);
				down.ptr = down.bck->increas;
				}
			}
		down.ptr->down = loc_down;
		down.ptr->up = loc_up;
		}
	}
}

struct p2_list_c positon_dot(loc_dot,p_dot,fl_dot)
struct list_c **p_dot;
int *fl_dot;
int loc_dot;

{
struct p2_list_c rt;

*fl_dot = 0;

for(rt.ptr = *p_dot;rt.ptr != NULL;rt.ptr = rt.ptr->increas)
	{
	if(loc_dot<rt.ptr->down)
		{
		 *fl_dot = 0;
		break;
		}

	if(loc_dot <= rt.ptr->up)
		{
		 *fl_dot = 1;
		break;
		}
	rt.bck = rt.ptr;
	}

return (rt);
}
/*--------------------------------------------------------------------------*/
