/*
 *    Contour Union Alghorithm   c-union2.c
 *    (recursive algorithm, nonrecursive data structure)
 *    Copyright (c) 1993,1994 T.Hruz, I.Povazan, R.Gosiorovsky
 */

CHAR *I;          

CHAR **X = NULL;  
CHAR **Y = NULL;         

VOID close_CU2()
  {
     free(X);
     free(Y);
  }

VOID open_CU2(INT W,INT H)
  {
     INT i;

     X = (CHAR **)malloc(H*sizeof(CHAR *));
     for(i=0;i<H;i++) X[i] = (CHAR *)malloc(2*W*sizeof(CHAR));

     Y = (CHAR **)malloc(W*sizeof(CHAR *));
     for(i=0;i<W;i++) Y[i] = (CHAR *)malloc(2*H*sizeof(CHAR));

     for(i=15;i>0;i--) if (W&(1<<i)) { ux=i; break; }
     for(i=15;i>0;i--) if (H&(1<<i)) { uy=i; break; }

     ux= 1<<(ux+1);           /* universum x, must be number = 2^N */
     uy= 1<<(uy+1);
  }

VOID clear_CU2() 
  {
     INT x,y;   

     for(y = MinY; y<MaxY; y++) 
       for(x = MinX+1; x < (2*MaxX-1); x++) 
            X[y][x]= FALSE;

     for(x = MinX; x<MaxX; x++) 
       for(y = MinY+1; y < (2*MaxY-1); y++) 
            Y[x][y]= FALSE;
  }

CHAR spy_left2(INT A,INT B)      
 {
   if (I[A+B]) return(TRUE);
   if ( A+1 == B ) return(FALSE);
   return( spy_left2(A,(A+B)>>1) );
 }  

CHAR spy_right2(INT A,INT B)    
 {
   if (I[A+B]) return(TRUE);
   if ( A+1 == B ) return(FALSE);
   return( spy_right2((A+B)>>1,B) );
 }  

CHAR onion2(INT a,INT b,INT A,INT B)
 {
   INT center;
   CHAR L,R;

   if ( I[A+B] ) return( TRUE );

   if ((a<=A)&&(B<=b)) 
     {
       if (a==A) if (!spy_left2(A,B))   Point(XL,YL);
       if (b==B) if (!spy_right2(A,B))  Point(XR,YR);
       return( I[A+B] = TRUE ); 
     }
   else
     { 
        center = (A + B) >> 1 ;

        if (a<center)  L = onion2(a,b,A,center);
                else  L = I[A+center];

        if (b>center)  R = onion2(a,b,center,B);
                else  R = I[center+B];

        return( I[A+B] = (L&&R) );
     }
 }
/*------------------------------------------------------------------------*/

