/*
 *      Contour Union Alghorithm   c-union.c
 *      Copyright (c) 1994, 1995  T.Hruz, I.Povazan, R.Gosiorovsky
 */

#include "typy.h"  

INT XL,XR,YL,YR;  
INT ux,uy;         /* used for CU 2&4 only */

#include "c-union1.h"
#include "c-union2.h"
#include "c-union4.h"

/*
 *     polygon's hull
 */

VOID hull(INT N,POINT2 b[],INT *ixbot,INT *ixtop,INT *iybot,INT *iytop)
 {
    INT i;
    INT i_x_top=0,i_x_bot=0,i_y_top=0,i_y_bot=0;

    for(i=0;i<N;i++)
       {
          if (b[i].x>b[i_x_top].x) i_x_top=i;
          if (b[i].x<b[i_x_bot].x) i_x_bot=i;
          if (b[i].y>b[i_y_top].y) i_y_top=i;
          if (b[i].y<b[i_y_bot].y) i_y_bot=i;
        }
    *ixbot=i_x_bot;
    *ixtop=i_x_top;
    *iybot=i_y_bot;
    *iytop=i_y_top;
 }

/*
 *     line interpolator
 */

VOID Line_CU(INT x1,INT y1,INT x2,INT y2,INT *buf)
  {
     INT x,y,kx,ky;
           
     if (y1==y2) return; 

     if (y1>y2) { ky= -1; kx= ((x2-x1)<<10)/(y1-y2); }
           else { ky=  1; kx= ((x2-x1)<<10)/(y2-y1); }

     y=y1; x=x1<<10;
     buf[y1]=x1;
    
     while(y!=y2)
       {
          y+=ky;
          x+=kx;
          buf[y]=x>>10;  
       } 
  } 

/*
 *      draw poly with CU algorithm
 */

VOID CU_Polygon(INT N,POINT2 b[])     
  {
    INT i,j;
    INT AA[XMaxRES],BB[XMaxRES]; 
    INT ixtop,ixbot,iytop,iybot;
   
    hull(N,b,&ixbot,&ixtop,&iybot,&iytop);

    if (iytop==iybot) { AA[b[iytop].y]=b[ixbot].x;
                        BB[b[iytop].y]=b[ixtop].x; }
    else
      {
          i=iytop;
          while(i!=iybot)
           {
              Line_CU(b[i].x,b[i].y,b[(i+1)%N].x,b[(i+1)%N].y,AA); 
              i=(i+1)%N;
           }
          i=iybot;
          while(i!=iytop)
           {
             Line_CU(b[i].x,b[i].y,b[(i+1)%N].x,b[(i+1)%N].y,BB); 
             i=(i+1)%N;
           }
       }
    
    for(i=b[iybot].y; i<=b[iytop].y; i++)
      {
        YL=YR=i;
        if (BB[i]<AA[i]) { XR=AA[i]; XL=BB[i]; }
        if (BB[i]>AA[i]) { XR=BB[i]; XL=AA[i]; }
       
        if (AA[i]!=BB[i])
           switch(c->model)
             {
               case COU1: onion1(XL,XR,XI[i]);   break;
  	       case COU2: I= X[i]; onion2(XL,XR,0,ux); break;
	       case COU4: I= X[i]; onion4(XL,XR,0,ux); break;
             }
      }

  /*  also in x-direction  */

    if (ixtop==ixbot) { return;
                /*      AA[b[ixtop].x]=b[iybot].y;
                        BB[b[ixtop].x]=b[iytop].y; */   }
    else
      {
          i=ixtop;
          while(i!=ixbot)
           {
              Line_CU(b[i].y,b[i].x,b[(i+1)%N].y,b[(i+1)%N].x,AA); 
              i=(i+1)%N;
           }
          i=ixbot;
          while(i!=ixtop)
           {
             Line_CU(b[i].y,b[i].x,b[(i+1)%N].y,b[(i+1)%N].x,BB); 
             i=(i+1)%N;
           }
       }
    
    for(i=b[ixbot].x; i<=b[ixtop].x; i++)
      {
        XL=XR=i;
        if (AA[i]<BB[i]) { YR=BB[i]; YL=AA[i]; }
        if (AA[i]>BB[i]) { YR=AA[i]; YL=BB[i]; }

        if (AA[i]!=BB[i])
           switch(c->model)
             {
               case COU1: onion1(YL,YR,YI[i]);   break;
  	       case COU2: I= Y[i]; onion2(YL,YR,0,uy); break;
	       case COU4: I= Y[i]; onion4(YL,YR,0,uy); break;
             }
      }  
  }
/*---------------------------------------------------------------------*/
