/* tnpic
 * writejpeg.c - used by tnpic to write the resulting index file.
 */

#include <stdio.h>
#include <jpeglib.h>


extern int outwidth,outheight;
extern unsigned char *outimage;


GLOBAL void
write_JPEG_file(char *filename,int jpeg_qual)
{
struct jpeg_compress_struct cinfo;
struct jpeg_error_mgr jerr;

FILE *out;
JSAMPROW row_pointer[1];	/* pointer to JSAMPLE row[s] */
int row_stride;		/* physical row width in image buffer */

/* Step 1: allocate and initialize JPEG compression object */

cinfo.err = jpeg_std_error(&jerr);
jpeg_create_compress(&cinfo);

/* Step 2: specify data destination (eg, a file) */

if((out=fopen(filename,"wb"))==NULL)
  {
  fprintf(stderr,"can't open %s\n",filename);
  exit(1);
  }

jpeg_stdio_dest(&cinfo,out);

/* Step 3: set parameters for compression */

cinfo.image_width = outwidth; 	/* image width and height, in pixels */
cinfo.image_height = outheight;
cinfo.input_components = 3;		/* # of color components per pixel */
cinfo.in_color_space = JCS_RGB; 	/* colorspace of input image */
jpeg_set_defaults(&cinfo);
jpeg_set_quality(&cinfo,jpeg_qual,FALSE);

/* Step 4: Start compressor */

jpeg_start_compress(&cinfo,TRUE);

/* Step 5: while (scan lines remain to be written) */
/*           jpeg_write_scanlines(...); */

row_stride=outwidth*3;	/* JSAMPLEs per row in image_buffer */

while (cinfo.next_scanline < cinfo.image_height)
  {
  row_pointer[0]=&outimage[cinfo.next_scanline*row_stride];
  jpeg_write_scanlines(&cinfo,row_pointer,1);
  }

/* Step 6: Finish compression */

jpeg_finish_compress(&cinfo);

fclose(out);

/* Step 7: release JPEG compression object */

/* This is an important step since it will release a good deal of memory. */
jpeg_destroy_compress(&cinfo);
}
