/* Zgv v2.3 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993, 1994 Russell Marks. See README for license details.
 *
 * tnpic.c - picture indexer.
 *   XXX this is incredibly messy and should be made nicer! 
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/file.h>
#include "zgv.h"
#include "gifeng.h"
#include "usejpeg.h"
#include "resizepic.h"
#include "tnpicfont.h"


#define PICS_ACROSS 5        /* gives as 640 pixels across max. */
#define TEXTHI 22

int vkludge=1,pixelsize=1;
int idx_dark,idx_light,idx_black;	/* XXX ***KLUDGE*** */

int jpeg_quality=70;

byte *theimage,*palrgb,*redptr,*greenptr,*blueptr;
byte *outimage;
int outwidth,outheight;
int width,height,numcols;
int scrnwide=128,scrnhigh=96;


int readgiforjpg(char *,hffunc);



main(argc,argv)
int argc;
char **argv;
{
byte *resizedrgb;
char str[1024],*org;
int f,total,cx,cy,xsiz,ysiz;
int tmpw,tmph;
div_t cxy;

if(argc>=3)
  {
  if(!strcmp(argv[1],"-q"))
    {
    jpeg_quality=atoi(argv[2]);
    if((jpeg_quality<1)||(jpeg_quality>100))
      {
      printf("JPEG quality setting must be in the range 1 to 100.\n");
      exit(1);
      }
    argc-=2;
    argv+=2;
    }
  }

total=argc-2;
if(total<1)
  {
  printf("Usage: tnpic [-q nn] <JPEG collage file> GIF/JPEG_file_1 ... file_n\n\n"
         "where  -q nn    changes JPEG quality setting from 70 to specified level.\n\n"
  	 "For example, to create a thumbnail jpeg containing all gif and jpeg\n"
  	 "files in the current directory:\n"
  	 "  tnpic index.jpg *.gif *.jpg\n");
  exit(1);
  }
else
  {
  cxy=div(total,PICS_ACROSS);
  cx=cxy.rem;          /* so we have cx pics across, and cy down */
  xsiz=((cxy.quot+1)==1)?cx*scrnwide:(PICS_ACROSS*scrnwide);
  if(total>1) cxy=div(total-1,PICS_ACROSS);
  ysiz=(cy=cxy.quot+1)*(scrnhigh+TEXTHI);
  /* so now the big RGB collage will be xsiz by ysiz */
  if((outimage=malloc(xsiz*ysiz*3))==NULL)
    {
    printf("Not enough memory for collage image.\n");
    exit(1);
    }
  
  for(f=0;f<total;f++)
    {
    printf("Reading %s...\n",argv[f+2]);
    cxy=div(f,PICS_ACROSS);
    if(readgiforjpg(argv[f+2],NULL)!=_PIC_OK)
      {
      /* JPEG errors are reported automatically...
       * it'll be a GIF if we get here.
       */
      printf("Error reading GIF file.\n");
      exit(1);
      }
      
    tmpw=scrnwide; tmph=scrnhigh;
    resizedrgb=resizepic(theimage,palrgb,palrgb+256,palrgb+512,
    					width,height,&tmpw,&tmph);
    addpic(outimage,resizedrgb,(cxy.rem)*scrnwide,
    		(cxy.quot)*(scrnhigh+TEXTHI),xsiz);
    if(strrchr(argv[f+2],'/')!=NULL)
      org=strrchr(argv[f+2],'/')+1;
    else
      org=argv[f+2];
    strcpy(str,org);
    if(strlen(str)>16) str[16]=0;
    addtext(outimage,(cxy.rem)*scrnwide,
    		(cxy.quot)*(scrnhigh+TEXTHI)+scrnhigh+3,str,xsiz);
    sprintf(str,"%d x %d",width,height);
    addtext(outimage,(cxy.rem)*scrnwide,
    		(cxy.quot)*(scrnhigh+TEXTHI)+scrnhigh+10,str,xsiz);
    free(resizedrgb);
    free(theimage);
    free(palrgb);
    }
    
  outwidth=xsiz; outheight=ysiz; /* for JPEG writing routine */
  printf("Writing %s...\n",argv[1]);
  write_JPEG_file(argv[1],jpeg_quality);
  free(outimage);
  printf("Done.\n");
  exit(0);
  }
}

int getredbyte()
{
int v;
v=*redptr; redptr+=3;
return(v);
}

int getgreenbyte()
{
int v;
v=*greenptr; greenptr+=3;
return(v);
}

int getbluebyte()
{
int v;
v=*blueptr; blueptr+=3;
return(v);
}


addtext(outimage,xpos,ypos,str,xsiz)
byte *outimage;
int xpos,ypos;
char *str;
int xsiz;
{
int a,b,c,f,x,loc;

x=xpos;
for(f=0;f<strlen(str);f++)
  {
  c=toupper(str[f])-32;
  if((c<0)||(c>63))
    c='_'-32;
  for(b=0;b<5;b++)
    for(a=0;a<tnpicfont[LETTERSIZ*c];a++)
      if(tnpicfont[LETTERSIZ*c+1+b*8+a]=='x')
        {
        loc=3*((ypos+b)*xsiz+x+a);
        outimage[loc  ]=255;
        outimage[loc+1]=255;
        outimage[loc+2]=255;
        }
  x+=tnpicfont[LETTERSIZ*c]+1;
  }
}


addpic(outimage,inimage,xpos,ypos,xsiz)
byte *outimage,*inimage;
int xpos,ypos,xsiz;
{
int x,y;

for(y=0;y<scrnhigh;y++)
  for(x=0;x<scrnwide;x++)
    {
    *(outimage+3*((ypos+y)*xsiz+xpos+x)  )=*(inimage+3*(y*scrnwide+x)  );
    *(outimage+3*((ypos+y)*xsiz+xpos+x)+1)=*(inimage+3*(y*scrnwide+x)+1);
    *(outimage+3*((ypos+y)*xsiz+xpos+x)+2)=*(inimage+3*(y*scrnwide+x)+2);
    }
}


int readgiforjpg(giffn,howfarfunc)
char *giffn;
hffunc howfarfunc;
{
int result,isjpeg;
PICINFO ginfo;
byte *palette;

if(!strcmp(strrchr(giffn,'.'),".jpg"))
  {
  isjpeg=1;
  ginfo.numcols=256;
  theimage=NULL;
  result=read_JPEG_file(giffn,howfarfunc,&palette);
  if(theimage==NULL)
    result=_PICERR_CORRUPT;
  else
    if(result!=_PIC_OK) free(theimage);
  }
else
  {
  isjpeg=0;
  result=readgif(giffn,&theimage,&palette,howfarfunc);
  if(result==_PIC_OK)
    {
    getgifinfo(&ginfo);
    height=ginfo.height; width=ginfo.width;
    }
  else
    return(result);
  }
numcols=ginfo.numcols;
if(result==_PIC_OK)
  {
  palrgb=palette;
  /********** all memory still allocated **********/
  /* (we lose it later on) */
  }

return(result);
}
