/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  

#include <qapp.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpixmap.h>

#include "tappconfig.h"

#include "mainwidget.h"

#include "icon.xpm"

const char *options[] ={
   "#usage='Usage: %n [OPTIONS]\n'",
   "#trailer='\nX toolkit options (like -display, -geometry, -fg, -font ...) are also available\n\n%n version %v *** (C) 1997 by Johannes Overmann\ncomments, bugs and suggestions welcome: overmann@i6.informatik.rwth-aachen.de\n'",
   "name=verbose, type=switch, char=v, help=verbose execution, headline='common options:'",
     "EOL"
};


int main(int ac, char *av[]) {
   QApplication::setFont(QFont("helvetica", 12, QFont::Bold));
   QApplication qa(ac, av);
   TAppConfig ta(options, "options", ac, av, "QFRACT_OPT", "qfractrc", "0.0");

	MainWidget w;
  
   qa.setMainWidget(&w);
   TString capt(ta.getString("application-name")+" V"+ta.getString("application-version"));
   w.setCaption(capt);
	w.setIcon(QPixmap(icon_xpm));
   w.setMinimumSize(10,10);
   w.show();
   return qa.exec();
}













