/*GPL*START*
 * 
 * Copyright (C) 1998 by Johannes Overmann <overmann@iname.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * *GPL*END*/  

#include <stdlib.h>
#include <qapp.h>
#include <qkeycode.h>
#include <qpopmenu.h>
#include <qbttngrp.h>
#include <qmsgbox.h>
#include <qlabel.h>

#include "mainwidget.h"
#include "tappconfig.h"

static int iter_tab[]={10,20,50,100,200,500,1000,2000,5000,0};


MainWidget::MainWidget(QWidget *parent): QWidget(parent), oldjulposvalid(false) {
   int i;

   // setup menu
   menu = new QMenuBar(this);
   
   // file menu
   QPopupMenu *file = new QPopupMenu();
   file->insertItem("Quit", qApp, SLOT(quit()), ALT+Key_Q);
   
   // help
   QPopupMenu *help = new QPopupMenu;
   help->insertItem("Info", this, SLOT(info()));
   help->insertSeparator();
   help->insertItem("About " + tApp->getString("application-name"), this, SLOT(about()), CTRL+Key_H);
   help->insertItem("About Qt", this, SLOT(aboutQt()));
   
   // view
   view = new QPopupMenu;
   view->setCheckable(true);
   juliaId = view->insertItem("&Julia window", this, SLOT(tog_julia()), CTRL+Key_J);
   followId = view->insertItem("&Linked navigation", this, SLOT(tog_follow()), CTRL+Key_L);
   view->setItemChecked(juliaId, false);
   view->setItemChecked(followId, false);
   follow = false;
   
   view->insertSeparator();
   guessId = view->insertItem("&Super solid guessing", this, SLOT(tog_guess()), CTRL+Key_G);
   view->setItemChecked(guessId, true);
   guessdebId = view->insertItem("Sh&ow guessed area", this, SLOT(tog_guessdeb()), CTRL+Key_O);
   view->setItemChecked(guessdebId, false);
   asmId = view->insertItem("&Fast mode", this, SLOT(tog_asm()), CTRL+Key_F);
   view->setItemChecked(asmId, false);

   view->insertSeparator();
   crossId = view->insertItem("&Crosshairs", this, SLOT(tog_cross()), CTRL+Key_C);
   view->setItemChecked(crossId, true);
   altcolId = view->insertItem("&Alternating colors", this, SLOT(tog_altcol()), CTRL+Key_A);
   view->setItemChecked(altcolId, false);
   
   // iterations
   iter = new QPopupMenu;
   iter->setCheckable(true);
   for(i=0; iter_tab[i]; i++) 
     iter->insertItem(TString(iter_tab[i]), i);
   connect(iter, SIGNAL(activated(int)), this, SLOT(set_iter(int)));
   
   // menu bar
   menu->insertItem("&File", file);  
   menu->insertItem("&View", view);  
   menu->insertItem("&Iterations", iter);  
   menu->insertSeparator();
   menu->insertItem("&Help", help);  
   

   // setup screen
   QVBoxLayout *lay0 = new QVBoxLayout(this);
   QHBoxLayout *st_bar = new QHBoxLayout();
   lay0->setMenuBar(menu);

   // setup fract
   mand = new FractWid(this);
   jul = new FractWid(0, true);
   mand->setCrosshairs(view->isItemChecked(crossId));
   jul ->setCrosshairs(view->isItemChecked(crossId));
   
  lay0->addWidget(mand, 10);
  
  // status bar
  lay0->addLayout(st_bar,0);
  stat = new QLabel("toll", this);
  stat->setMinimumSize(stat->sizeHint());
  st_bar->addWidget(stat, 10);
  stat->setFrameStyle(QFrame::Sunken | QFrame::Panel);
  stat->setLineWidth(2);

  lay0->activate();
   
   
   // connections
   connect(mand, SIGNAL(posRotZoomChanged(double,double,double,double)),
	   this, SLOT(perhaps_mand_to_jul(double,double,double,double)));
   connect(jul,  SIGNAL(posRotZoomChanged(double,double,double,double)),
	   this, SLOT(perhaps_jul_to_mand(double,double,double,double)));
   connect(jul,  SIGNAL(midButtonPressed(QPoint)),
	   this, SLOT(hide_julia(QPoint)));
   connect(mand, SIGNAL(centerChanged(double,double)),
	   jul,   SLOT(setJuliaCoords(double,double)));
   connect(mand, SIGNAL(centerChanged(double,double)),
	   this,   SLOT(updateCenterStatus(double,double)));
   
   // end
   mand->forcePosRotZoomChanged();
   set_iter(1);
}


MainWidget::~MainWidget() {
  delete jul;
}

void MainWidget::hide_julia(QPoint) {
   view->setItemChecked(juliaId, false);
   oldjulpos = jul->geometry();
   oldjulposvalid = true;
   jul->hide();
}

void MainWidget::set_iter(int id) {
   int it = iter_tab[id];
   for(int i=0; iter_tab[i]; i++) {
      if(i==id) iter->setItemChecked(i, true);
      else      iter->setItemChecked(i, false);
   }
   mand->setMaxIter(it);
   jul ->setMaxIter(it);
}


void MainWidget::updateCenterStatus(double x, double y) {
   char buf[1000];
   sprintf(buf, "x = %.16f, y = %.16f", x, y);
   stat->setText(buf);
}


void MainWidget::tog_julia() {
   bool state = !view->isItemChecked(juliaId);
   view->setItemChecked(juliaId, state);
   if(state) {
      if(oldjulposvalid) jul->setGeometry(oldjulpos);
      jul->show();
   } else {
      oldjulpos = jul->geometry();
      oldjulposvalid=true;
      jul->hide();
   }
}


void MainWidget::tog_follow() {
   follow = !view->isItemChecked(followId);
   view->setItemChecked(followId, follow);
   if(follow) 
     mand->forcePosRotZoomChanged();
}


void MainWidget::tog_cross() {
   bool cross = !view->isItemChecked(crossId);
   view->setItemChecked(crossId, cross);
   mand->setCrosshairs(cross);
   jul ->setCrosshairs(cross);
}


void MainWidget::tog_guess() {
   bool guess = !view->isItemChecked(guessId);
   view->setItemChecked(guessId, guess);
   mand->setGuessing(guess);
   jul ->setGuessing(guess);
}


void MainWidget::tog_guessdeb() {
   bool guessdeb = !view->isItemChecked(guessdebId);
   view->setItemChecked(guessdebId, guessdeb);
   mand->setGuessDebug(guessdeb);
   jul ->setGuessDebug(guessdeb);
}


void MainWidget::tog_altcol() {
   bool altcol = !view->isItemChecked(altcolId);
   view->setItemChecked(altcolId, altcol);
   mand->setAltColors(altcol);
   jul ->setAltColors(altcol);
}


void MainWidget::tog_asm() {
   bool as = !view->isItemChecked(asmId);
   view->setItemChecked(asmId, as);
   mand->setAsm(as);
   jul ->setAsm(as);
}


void MainWidget::perhaps_mand_to_jul(double center_x, double center_y, double rotate, double zoom) {
   if(follow) 
     jul->setPosRotZoom(center_x, center_y, rotate, zoom);
}


void MainWidget::perhaps_jul_to_mand(double center_x, double center_y, double rotate, double zoom) {
   if(follow) 
     mand->setPosRotZoom(center_x, center_y, rotate, zoom);
}


void MainWidget::about() {
  QMessageBox::about(this, "About " + tApp->getString("application-name"), 
							tApp->getString("application-name") + " V" + 
							tApp->getString("application-version") + 
							"\n\n(C) 1997 by\n\nJohannes Overmann"); 
}


void MainWidget::aboutQt() {
  QMessageBox::aboutQt(this, "About Qt");
}


void MainWidget::info() {
   TString mes;
   
   mes = "toll";
   
   QMessageBox::information(0, "Info", mes, QMessageBox::Ok + QMessageBox::Default);
}
  

