/*
    pmosc - recreates an image out of smaller image tiles
    Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include<stdio.h>
#include<stdlib.h>
#include<errno.h>
#include"misc.h"

void *xcalloc(size_t nmemb,size_t size)
{
	void *ptr = calloc(nmemb,size);
	if(!ptr)
	{
		perror("calloc");
		exit(1);
	}
	return ptr;
}

void *xmalloc(size_t size)
{
	void *ptr = malloc(size);
	if(!ptr)
	{
		perror("malloc");
		exit(1);
	}
	return ptr;
}

void *xrealloc(void *ptr,size_t size)
{
	ptr = realloc(ptr,size);
	if(!ptr && size)
	{
		perror("realloc");
		exit(1);
	}
	return ptr;
}

FILE *xfopen(const char *path,const char *mode)
{
	FILE *stream = fopen(path,mode);
	if(!stream)
	{
		perror(path);
		exit(1);
	}
	return stream;
}

size_t xfread(void *ptr,size_t size,size_t nmemb,FILE *stream)
{
	size_t items;
	errno = 0;
	items = fread(ptr,size,nmemb,stream);
	if(items != nmemb)
	{
		if(errno) perror("fread");
		else fprintf(stderr,"fread: unexpected end of file\n");
		exit(1);
	}
	return items;
}

size_t xfwrite(void *ptr,size_t size,size_t nmemb,FILE *stream)
{
	size_t items = fwrite(ptr,size,nmemb,stream);
	if(items != nmemb)
	{
		perror("fwrite");
		exit(1);
	}
	return items;
}

int xfseek(FILE *stream,long offset,int whence)
{
	int err = fseek(stream,offset,whence);
	if(err)
	{
		perror("fseek");
		exit(1);
	}
	return err;
}

