/*
    pmosc - recreates an image out of smaller image tiles
    Copyright (C) 1998 Jens Vaasjo <jvaasjo@iname.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef IMAGE_H
#define IMAGE_H

typedef struct
{
	unsigned char r;
	unsigned char g;
	unsigned char b;
} rgb_t;

typedef struct
{
	unsigned long width;
	unsigned long height;
	rgb_t *data;
} image_t;

image_t *imageRead(const char *path);
void imageWrite(const char *path,const image_t *img);

void imageFree(image_t *img);
image_t *imageDup(const image_t *img);

image_t *imageScale(const image_t *img,unsigned long width,unsigned long height);
image_t *imageLoad(const char *path,unsigned long width,unsigned long height);

void imageCopy(image_t *dest,const image_t *src,
		unsigned long dx,unsigned long dy,
		unsigned long sx,unsigned long sy,
		unsigned long width,unsigned long height);

#endif /*ndef IMAGE_H*/
